/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.ridgenerator.service.impl;

import io.mosip.kernel.core.dataaccess.exception.DataAccessLayerException;
import io.mosip.kernel.core.util.MathUtils;
import io.mosip.kernel.ridgenerator.constant.RidGeneratorExceptionConstant;
import io.mosip.kernel.ridgenerator.constant.RidGeneratorPropertyConstant;
import io.mosip.kernel.ridgenerator.dto.RidGeneratorResponseDto;
import io.mosip.kernel.ridgenerator.entity.Rid;
import io.mosip.kernel.ridgenerator.exception.EmptyInputException;
import io.mosip.kernel.ridgenerator.exception.InputLengthException;
import io.mosip.kernel.ridgenerator.exception.RidException;
import io.mosip.kernel.ridgenerator.repository.RidRepository;
import io.mosip.kernel.ridgenerator.service.RidGeneratorService;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Service;

@Service
public class RidGeneratorServiceImpl
implements RidGeneratorService<RidGeneratorResponseDto> {
    @Value(value="${mosip.kernel.registrationcenterid.length:-1}")
    private int centerIdLength;
    @Value(value="${mosip.kernel.machineid.length:-1}")
    private int machineIdLength;
    @Value(value="${mosip.kernel.rid.sequence-length:-1}")
    private int sequenceLength;
    @Value(value="${mosip.kernel.rid.timestamp-length:-1}")
    private int timeStampLength;
    @Value(value="${mosip.kernel.rid.sequence-initial-value:1}")
    private int sequenceInitialValue;
    @Autowired
    private RidRepository repository;

    public RidGeneratorResponseDto generateRid(String centerId, String machineId) {
        this.validateInput(centerId, machineId, this.centerIdLength, this.machineIdLength);
        String randomDigitRid = this.sequenceNumberGenerator(centerId, machineId, this.sequenceLength);
        String rid = this.appendString(randomDigitRid, this.getcurrentTimeStamp(), centerId, machineId);
        RidGeneratorResponseDto response = new RidGeneratorResponseDto();
        response.setRid(rid);
        return response;
    }

    private String sequenceNumberGenerator(String centerId, String machineId, int sequenceLength) {
        int sequenceId = 0;
        Rid entity = null;
        int sequenceEndvalue = MathUtils.getPow((int)10, (int)sequenceLength) - 1;
        String sequenceFormat = "%0" + sequenceLength + "d";
        try {
            entity = this.repository.findRid(centerId, machineId);
        }
        catch (DataAccessLayerException | DataAccessException e) {
            throw new RidException(RidGeneratorExceptionConstant.RID_FETCH_EXCEPTION.getErrorCode(), RidGeneratorExceptionConstant.RID_FETCH_EXCEPTION.getErrorMessage(), e);
        }
        try {
            if (entity == null) {
                entity = new Rid();
                sequenceId = this.sequenceInitialValue;
                entity.setCurrentSequenceNo(this.sequenceInitialValue);
                entity.setMachineId(machineId);
                entity.setCenterId(centerId);
                entity.setCreatedBy("SYSTEM");
                entity.setCreatedDateTime(LocalDateTime.now(ZoneId.of("UTC")));
                this.repository.save((Object)entity);
            } else {
                entity.setUpdatedBy("SYSTEM");
                entity.setUpdatedDateTime(LocalDateTime.now(ZoneId.of("UTC")));
                sequenceId = entity.getCurrentSequenceNo() == sequenceEndvalue ? this.sequenceInitialValue : entity.getCurrentSequenceNo() + 1;
                this.repository.updateRid(sequenceId, centerId, machineId);
            }
        }
        catch (DataAccessLayerException | DataAccessException e) {
            throw new RidException(RidGeneratorExceptionConstant.RID_UPDATE_EXCEPTION.getErrorCode(), RidGeneratorExceptionConstant.RID_UPDATE_EXCEPTION.errorMessage, e);
        }
        return String.format(sequenceFormat, sequenceId);
    }

    private String getcurrentTimeStamp() {
        DateTimeFormatter format = DateTimeFormatter.ofPattern(RidGeneratorPropertyConstant.TIMESTAMP_FORMAT.getProperty());
        return LocalDateTime.now(ZoneId.of("UTC")).format(format);
    }

    private String appendString(String randomDigitRid, String currentTimeStamp, String centreId, String machineId) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(centreId).append(machineId).append(randomDigitRid).append(currentTimeStamp);
        return stringBuilder.toString().trim();
    }

    private void validateInput(String centreId, String machineId, int centerIdLength, int machineIdLength) {
        if (centreId.isEmpty() || machineId.isEmpty()) {
            throw new EmptyInputException(RidGeneratorExceptionConstant.EMPTY_INPUT_ERROR_CODE.getErrorCode(), RidGeneratorExceptionConstant.EMPTY_INPUT_ERROR_CODE.getErrorMessage());
        }
        if (centreId.length() != centerIdLength || machineId.length() != machineIdLength) {
            throw new InputLengthException(RidGeneratorExceptionConstant.INPUT_LENGTH_ERROR_CODE.getErrorCode(), RidGeneratorExceptionConstant.INPUT_LENGTH_ERROR_CODE.getErrorMessage());
        }
    }
}

