/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.ridgenerator.controller;

import io.mosip.kernel.core.http.ResponseFilter;
import io.mosip.kernel.core.http.ResponseWrapper;
import io.mosip.kernel.ridgenerator.dto.RidGeneratorResponseDto;
import io.mosip.kernel.ridgenerator.service.RidGeneratorService;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
public class RidGeneratorController {
    @Autowired
    private RidGeneratorService<RidGeneratorResponseDto> ridGeneratorService;

    @ResponseFilter
    @GetMapping(value={"/generate/rid/{centerid}/{machineid}"})
    @ApiOperation(value="Service to generate RID")
    @PreAuthorize(value="hasRole('REGISTRATION_PROCESSOR')")
    public ResponseWrapper<RidGeneratorResponseDto> generateRid(@PathVariable(value="centerid") String centerId, @PathVariable(value="machineid") String machineId) {
        ResponseWrapper responseWrapper = new ResponseWrapper();
        responseWrapper.setResponse(this.ridGeneratorService.generateRid(centerId.trim(), machineId.trim()));
        return responseWrapper;
    }
}

