/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.packetmanager.util;

import io.mosip.kernel.core.logger.spi.Logger;
import io.mosip.kernel.packetmanager.constants.LoggerFileConstant;
import io.mosip.kernel.packetmanager.logger.PacketUtilityLogger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;

public class ZipUtils {
    private static Logger packetUtilityLogger = PacketUtilityLogger.getLogger(ZipUtils.class);

    private ZipUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream unzipAndGetFile(InputStream packetStream, String file) throws IOException {
        packetUtilityLogger.debug(LoggerFileConstant.SESSIONID.toString(), LoggerFileConstant.REGISTRATIONID.toString(), "", "ZipUtils::unzipAndGetFile()::entry");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        boolean flag = false;
        byte[] buffer = new byte[2048];
        try (ZipInputStream zis = new ZipInputStream(packetStream);){
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                String fileName = ze.getName();
                String fileNameWithOutExt = FilenameUtils.removeExtension((String)fileName);
                if (FilenameUtils.equals((String)fileNameWithOutExt, (String)file, (boolean)true, (IOCase)IOCase.INSENSITIVE)) {
                    int len;
                    flag = true;
                    while ((len = zis.read(buffer)) > 0) {
                        out.write(buffer, 0, len);
                    }
                    break;
                }
                zis.closeEntry();
                ze = zis.getNextEntry();
            }
            zis.closeEntry();
        }
        finally {
            packetStream.close();
            out.close();
        }
        if (flag) {
            packetUtilityLogger.debug(LoggerFileConstant.SESSIONID.toString(), LoggerFileConstant.REGISTRATIONID.toString(), "", "ZipUtils::unzipAndGetFile()::exit");
            return new ByteArrayInputStream(out.toByteArray());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean unzipAndCheckIsFileExist(InputStream packetStream, String file) throws IOException {
        boolean isExist = false;
        packetUtilityLogger.debug(LoggerFileConstant.SESSIONID.toString(), LoggerFileConstant.REGISTRATIONID.toString(), "", "ZipUtils::unzipAndCheckIsFileExist()::entry");
        try (ZipInputStream zis = new ZipInputStream(packetStream);){
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                String fileName = ze.getName();
                String fileNameWithOutExt = FilenameUtils.removeExtension((String)fileName);
                if (FilenameUtils.equals((String)fileNameWithOutExt, (String)file, (boolean)true, (IOCase)IOCase.INSENSITIVE)) {
                    isExist = true;
                    break;
                }
                zis.closeEntry();
                ze = zis.getNextEntry();
            }
            zis.closeEntry();
        }
        finally {
            packetStream.close();
        }
        packetUtilityLogger.debug(LoggerFileConstant.SESSIONID.toString(), LoggerFileConstant.REGISTRATIONID.toString(), "", "ZipUtils::unzipAndCheckIsFileExist()::exit");
        return isExist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unZipFromInputStream(InputStream input, String desDir) throws IOException {
        byte[] buffer = new byte[1024];
        packetUtilityLogger.debug(LoggerFileConstant.SESSIONID.toString(), LoggerFileConstant.REGISTRATIONID.toString(), "", "ZipUtils::unZipFromInputStream()::entry");
        try (ZipInputStream zis = new ZipInputStream(input);){
            File folder = FileUtils.getFile((String[])new String[]{desDir});
            if (!folder.exists() && folder.mkdir()) {
                packetUtilityLogger.debug(LoggerFileConstant.SESSIONID.toString(), LoggerFileConstant.REGISTRATIONID.toString(), "", folder + "created");
            }
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                if (ze.isDirectory()) {
                    File file = FileUtils.getFile((String[])new String[]{desDir + ze.getName()});
                    if (file.mkdir()) {
                        packetUtilityLogger.debug(LoggerFileConstant.SESSIONID.toString(), LoggerFileConstant.REGISTRATIONID.toString(), "", file + "created");
                    }
                } else {
                    String fileName = ze.getName();
                    File newFile = FileUtils.getFile((String[])new String[]{desDir + File.separator + fileName});
                    if (FileUtils.getFile((String[])new String[]{newFile.getParent()}).mkdirs()) {
                        int len;
                        FileOutputStream fos = new FileOutputStream(newFile);
                        while ((len = zis.read(buffer)) > 0) {
                            fos.write(buffer, 0, len);
                        }
                        fos.close();
                    }
                }
                ze = zis.getNextEntry();
            }
            zis.closeEntry();
        }
        finally {
            input.close();
        }
        packetUtilityLogger.debug(LoggerFileConstant.SESSIONID.toString(), LoggerFileConstant.REGISTRATIONID.toString(), "", "ZipUtils::unZipFromInputStream()::exit");
    }
}

