/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.packetmanager.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.mosip.kernel.core.fsadapter.spi.FileSystemAdapter;
import io.mosip.kernel.core.logger.spi.Logger;
import io.mosip.kernel.packetmanager.constants.LoggerFileConstant;
import io.mosip.kernel.packetmanager.exception.ApiNotAccessibleException;
import io.mosip.kernel.packetmanager.exception.FileNotFoundInDestinationException;
import io.mosip.kernel.packetmanager.exception.PacketDecryptionFailureException;
import io.mosip.kernel.packetmanager.logger.PacketUtilityLogger;
import io.mosip.kernel.packetmanager.spi.PacketDecryptor;
import io.mosip.kernel.packetmanager.spi.PacketReaderService;
import io.mosip.kernel.packetmanager.util.ZipUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.json.JSONException;
import org.json.simple.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class PacketReaderServiceImpl
implements PacketReaderService {
    private static final String UTF_8 = "UTF-8";
    @Value(value="${packet.default.source}")
    private String defaultSource;
    @Autowired
    private FileSystemAdapter fileSystemAdapter;
    @Autowired
    private PacketDecryptor decryptor;
    private static Logger packetUtilityLogger = PacketUtilityLogger.getLogger(PacketReaderServiceImpl.class);
    private static final String PACKET_NOTAVAILABLE_ERROR_DESC = "the requested file is not found in the destination";
    private static final String IDENTITY = "identity";

    @Override
    public boolean checkFileExistence(String id, String fileName, String source) throws PacketDecryptionFailureException, IOException, ApiNotAccessibleException {
        packetUtilityLogger.debug(LoggerFileConstant.SESSIONID.toString(), LoggerFileConstant.REGISTRATIONID.toString(), id, "PacketReaderServiceImpl::checkFileExistence()::entry");
        InputStream decryptedData = this.getFile(id, source);
        packetUtilityLogger.debug(LoggerFileConstant.SESSIONID.toString(), LoggerFileConstant.REGISTRATIONID.toString(), id, "PacketReaderServiceImpl::checkFileExistence()::extractZip");
        return ZipUtils.unzipAndCheckIsFileExist(decryptedData, fileName);
    }

    @Override
    public InputStream getFile(String id, String fileName, String source) throws PacketDecryptionFailureException, IOException, ApiNotAccessibleException {
        packetUtilityLogger.debug(LoggerFileConstant.SESSIONID.toString(), LoggerFileConstant.REGISTRATIONID.toString(), id, "PacketReaderServiceImpl::getFile()::entry");
        InputStream decryptedData = this.getFile(id, source);
        packetUtilityLogger.debug(LoggerFileConstant.SESSIONID.toString(), LoggerFileConstant.REGISTRATIONID.toString(), id, "PacketReaderServiceImpl::getFile()::extractZip");
        return ZipUtils.unzipAndGetFile(decryptedData, fileName);
    }

    private InputStream getFile(String id, String source) throws PacketDecryptionFailureException, IOException, ApiNotAccessibleException {
        packetUtilityLogger.debug(LoggerFileConstant.SESSIONID.toString(), LoggerFileConstant.REGISTRATIONID.toString(), id, "PacketReaderServiceImpl::fileSystemAdapter.getPacket()");
        InputStream data = this.fileSystemAdapter.getPacket(id);
        if (data == null) {
            throw new FileNotFoundInDestinationException(PACKET_NOTAVAILABLE_ERROR_DESC);
        }
        packetUtilityLogger.debug(LoggerFileConstant.SESSIONID.toString(), LoggerFileConstant.REGISTRATIONID.toString(), id, "PacketReaderServiceImpl::getFile()::extractSubfolderZip");
        InputStream sourceFolderInputStream = ZipUtils.unzipAndGetFile(data, id + "_" + source);
        if (sourceFolderInputStream == null) {
            throw new FileNotFoundInDestinationException(PACKET_NOTAVAILABLE_ERROR_DESC);
        }
        packetUtilityLogger.debug(LoggerFileConstant.SESSIONID.toString(), LoggerFileConstant.REGISTRATIONID.toString(), id, "PacketReaderServiceImpl::getFile(regid)::decryptor");
        InputStream decryptedData = this.decryptor.decrypt(sourceFolderInputStream, id);
        if (decryptedData == null) {
            throw new PacketDecryptionFailureException();
        }
        return decryptedData;
    }

    @Override
    public InputStream getEncryptedSourcePacket(String rid, InputStream inputStream, String source) throws IOException {
        return ZipUtils.unzipAndGetFile(inputStream, rid + "_" + source);
    }

    @Override
    public Object getCompleteIdObject(String rid, String sourcepackets) throws PacketDecryptionFailureException, ApiNotAccessibleException, IOException {
        String[] sources = sourcepackets.split(",");
        JSONObject finalIdObject = null;
        for (String source : sources) {
            InputStream idJsonStream = ZipUtils.unzipAndGetFile(this.getFile(rid, source), "ID");
            if (idJsonStream == null) continue;
            byte[] bytearray = IOUtils.toByteArray((InputStream)idJsonStream);
            String jsonString = new String(bytearray);
            ObjectMapper mapper = new ObjectMapper();
            JSONObject idObject = (JSONObject)mapper.readValue(jsonString, JSONObject.class);
            if (finalIdObject == null) {
                finalIdObject = idObject;
                continue;
            }
            if (finalIdObject == null) continue;
            LinkedHashMap currentidentityMap = (LinkedHashMap)idObject.get((Object)IDENTITY);
            LinkedHashMap finalidMap = (LinkedHashMap)finalIdObject.get((Object)IDENTITY);
            LinkedHashMap finalidentityMap = new LinkedHashMap(finalidMap);
            for (Map.Entry entry : currentidentityMap.entrySet()) {
                if (!finalidentityMap.containsKey(entry.getKey())) {
                    finalidentityMap.put(entry.getKey(), entry.getValue());
                    continue;
                }
                if (!finalidentityMap.containsKey(entry.getKey()) || finalidentityMap.get(entry.getKey()) != null || entry.getValue() == null) continue;
                finalidentityMap.put(entry.getKey(), entry.getValue());
            }
            LinkedHashMap objectMap = new LinkedHashMap();
            objectMap.put(IDENTITY, finalidentityMap);
            finalIdObject = new JSONObject(objectMap);
        }
        return finalIdObject;
    }

    @Override
    public Double getIdSchemaVersionFromPacket(String rid) throws PacketDecryptionFailureException, ApiNotAccessibleException, IOException {
        Double idSchemaVesion = null;
        InputStream idobject = this.getFile(rid, "ID", this.defaultSource);
        String idJsonString = IOUtils.toString((InputStream)idobject, (String)UTF_8);
        try {
            org.json.JSONObject identityJson = new org.json.JSONObject(idJsonString);
            org.json.JSONObject jsonObject = identityJson != null ? (org.json.JSONObject)identityJson.get(IDENTITY) : null;
            idSchemaVesion = jsonObject != null ? (Double)jsonObject.get("IDSchemaVersion") : null;
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return idSchemaVesion;
    }
}

