/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.packetmanager.dto.metadata;

import io.mosip.kernel.packetmanager.datatype.SimpleType;
import io.mosip.kernel.packetmanager.dto.metadata.BiometricsException;
import io.mosip.kernel.packetmanager.dto.metadata.DeviceMetaInfo;
import io.mosip.kernel.packetmanager.dto.metadata.DocumentMetaInfo;
import io.mosip.kernel.packetmanager.dto.metadata.FieldValue;
import io.mosip.kernel.packetmanager.dto.metadata.HashSequenceMetaInfo;
import io.mosip.kernel.packetmanager.dto.metadata.ModalityInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class MetaInfo {
    private Map<String, Map<String, ModalityInfo>> biometrics;
    private List<BiometricsException> exceptionBiometrics;
    private List<DocumentMetaInfo> documents;
    private List<FieldValue> metaData = new ArrayList<FieldValue>();
    private List<FieldValue> operationsData = new ArrayList<FieldValue>();
    private List<HashSequenceMetaInfo> hashSequence1;
    private List<HashSequenceMetaInfo> hashSequence2;
    private List<DeviceMetaInfo> capturedRegisteredDevices;
    private List<FieldValue> capturedNonRegisteredDevices;
    private List<FieldValue> checkSum;
    private List<SimpleType> printingName;

    public MetaInfo() {
        this.biometrics = new HashMap<String, Map<String, ModalityInfo>>();
        this.exceptionBiometrics = new ArrayList<BiometricsException>();
        this.documents = new ArrayList<DocumentMetaInfo>();
        this.hashSequence1 = new LinkedList<HashSequenceMetaInfo>();
        this.hashSequence2 = new LinkedList<HashSequenceMetaInfo>();
        this.operationsData = new ArrayList<FieldValue>();
    }

    public void setBiometrics(String subType, String bioAttribute, ModalityInfo modalityInfo) {
        if (this.biometrics.containsKey(subType) && this.biometrics.get(subType) != null) {
            this.biometrics.get(subType).put(bioAttribute, modalityInfo);
        } else {
            HashMap<String, ModalityInfo> map = new HashMap<String, ModalityInfo>();
            map.put(bioAttribute, modalityInfo);
            this.biometrics.put(subType, map);
        }
    }

    public void setBiometricException(List<BiometricsException> modalityExceptions) {
        this.exceptionBiometrics.addAll(modalityExceptions);
    }

    public void addDocumentMetaInfo(DocumentMetaInfo documentMetaInfo) {
        this.documents.add(documentMetaInfo);
    }

    public void addMetaData(FieldValue fieldValue) {
        if (!this.metaData.contains(fieldValue)) {
            this.metaData.add(fieldValue);
        }
    }

    public void addOperationsData(FieldValue fieldValue) {
        if (!this.operationsData.contains(fieldValue)) {
            this.operationsData.add(fieldValue);
        }
    }

    public void addHashSequence1(HashSequenceMetaInfo hashSequenceMetaInfo) {
        this.hashSequence1.add(hashSequenceMetaInfo);
    }

    public void addHashSequence2(HashSequenceMetaInfo hashSequenceMetaInfo) {
        this.hashSequence2.add(hashSequenceMetaInfo);
    }

    @Generated
    public Map<String, Map<String, ModalityInfo>> getBiometrics() {
        return this.biometrics;
    }

    @Generated
    public List<BiometricsException> getExceptionBiometrics() {
        return this.exceptionBiometrics;
    }

    @Generated
    public List<DocumentMetaInfo> getDocuments() {
        return this.documents;
    }

    @Generated
    public List<FieldValue> getMetaData() {
        return this.metaData;
    }

    @Generated
    public List<FieldValue> getOperationsData() {
        return this.operationsData;
    }

    @Generated
    public List<HashSequenceMetaInfo> getHashSequence1() {
        return this.hashSequence1;
    }

    @Generated
    public List<HashSequenceMetaInfo> getHashSequence2() {
        return this.hashSequence2;
    }

    @Generated
    public List<DeviceMetaInfo> getCapturedRegisteredDevices() {
        return this.capturedRegisteredDevices;
    }

    @Generated
    public List<FieldValue> getCapturedNonRegisteredDevices() {
        return this.capturedNonRegisteredDevices;
    }

    @Generated
    public List<FieldValue> getCheckSum() {
        return this.checkSum;
    }

    @Generated
    public List<SimpleType> getPrintingName() {
        return this.printingName;
    }

    @Generated
    public void setBiometrics(Map<String, Map<String, ModalityInfo>> biometrics) {
        this.biometrics = biometrics;
    }

    @Generated
    public void setExceptionBiometrics(List<BiometricsException> exceptionBiometrics) {
        this.exceptionBiometrics = exceptionBiometrics;
    }

    @Generated
    public void setDocuments(List<DocumentMetaInfo> documents) {
        this.documents = documents;
    }

    @Generated
    public void setMetaData(List<FieldValue> metaData) {
        this.metaData = metaData;
    }

    @Generated
    public void setOperationsData(List<FieldValue> operationsData) {
        this.operationsData = operationsData;
    }

    @Generated
    public void setHashSequence1(List<HashSequenceMetaInfo> hashSequence1) {
        this.hashSequence1 = hashSequence1;
    }

    @Generated
    public void setHashSequence2(List<HashSequenceMetaInfo> hashSequence2) {
        this.hashSequence2 = hashSequence2;
    }

    @Generated
    public void setCapturedRegisteredDevices(List<DeviceMetaInfo> capturedRegisteredDevices) {
        this.capturedRegisteredDevices = capturedRegisteredDevices;
    }

    @Generated
    public void setCapturedNonRegisteredDevices(List<FieldValue> capturedNonRegisteredDevices) {
        this.capturedNonRegisteredDevices = capturedNonRegisteredDevices;
    }

    @Generated
    public void setCheckSum(List<FieldValue> checkSum) {
        this.checkSum = checkSum;
    }

    @Generated
    public void setPrintingName(List<SimpleType> printingName) {
        this.printingName = printingName;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetaInfo)) {
            return false;
        }
        MetaInfo other = (MetaInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, Map<String, ModalityInfo>> this$biometrics = this.getBiometrics();
        Map<String, Map<String, ModalityInfo>> other$biometrics = other.getBiometrics();
        if (this$biometrics == null ? other$biometrics != null : !((Object)this$biometrics).equals(other$biometrics)) {
            return false;
        }
        List<BiometricsException> this$exceptionBiometrics = this.getExceptionBiometrics();
        List<BiometricsException> other$exceptionBiometrics = other.getExceptionBiometrics();
        if (this$exceptionBiometrics == null ? other$exceptionBiometrics != null : !((Object)this$exceptionBiometrics).equals(other$exceptionBiometrics)) {
            return false;
        }
        List<DocumentMetaInfo> this$documents = this.getDocuments();
        List<DocumentMetaInfo> other$documents = other.getDocuments();
        if (this$documents == null ? other$documents != null : !((Object)this$documents).equals(other$documents)) {
            return false;
        }
        List<FieldValue> this$metaData = this.getMetaData();
        List<FieldValue> other$metaData = other.getMetaData();
        if (this$metaData == null ? other$metaData != null : !((Object)this$metaData).equals(other$metaData)) {
            return false;
        }
        List<FieldValue> this$operationsData = this.getOperationsData();
        List<FieldValue> other$operationsData = other.getOperationsData();
        if (this$operationsData == null ? other$operationsData != null : !((Object)this$operationsData).equals(other$operationsData)) {
            return false;
        }
        List<HashSequenceMetaInfo> this$hashSequence1 = this.getHashSequence1();
        List<HashSequenceMetaInfo> other$hashSequence1 = other.getHashSequence1();
        if (this$hashSequence1 == null ? other$hashSequence1 != null : !((Object)this$hashSequence1).equals(other$hashSequence1)) {
            return false;
        }
        List<HashSequenceMetaInfo> this$hashSequence2 = this.getHashSequence2();
        List<HashSequenceMetaInfo> other$hashSequence2 = other.getHashSequence2();
        if (this$hashSequence2 == null ? other$hashSequence2 != null : !((Object)this$hashSequence2).equals(other$hashSequence2)) {
            return false;
        }
        List<DeviceMetaInfo> this$capturedRegisteredDevices = this.getCapturedRegisteredDevices();
        List<DeviceMetaInfo> other$capturedRegisteredDevices = other.getCapturedRegisteredDevices();
        if (this$capturedRegisteredDevices == null ? other$capturedRegisteredDevices != null : !((Object)this$capturedRegisteredDevices).equals(other$capturedRegisteredDevices)) {
            return false;
        }
        List<FieldValue> this$capturedNonRegisteredDevices = this.getCapturedNonRegisteredDevices();
        List<FieldValue> other$capturedNonRegisteredDevices = other.getCapturedNonRegisteredDevices();
        if (this$capturedNonRegisteredDevices == null ? other$capturedNonRegisteredDevices != null : !((Object)this$capturedNonRegisteredDevices).equals(other$capturedNonRegisteredDevices)) {
            return false;
        }
        List<FieldValue> this$checkSum = this.getCheckSum();
        List<FieldValue> other$checkSum = other.getCheckSum();
        if (this$checkSum == null ? other$checkSum != null : !((Object)this$checkSum).equals(other$checkSum)) {
            return false;
        }
        List<SimpleType> this$printingName = this.getPrintingName();
        List<SimpleType> other$printingName = other.getPrintingName();
        return !(this$printingName == null ? other$printingName != null : !((Object)this$printingName).equals(other$printingName));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MetaInfo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Map<String, ModalityInfo>> $biometrics = this.getBiometrics();
        result = result * 59 + ($biometrics == null ? 43 : ((Object)$biometrics).hashCode());
        List<BiometricsException> $exceptionBiometrics = this.getExceptionBiometrics();
        result = result * 59 + ($exceptionBiometrics == null ? 43 : ((Object)$exceptionBiometrics).hashCode());
        List<DocumentMetaInfo> $documents = this.getDocuments();
        result = result * 59 + ($documents == null ? 43 : ((Object)$documents).hashCode());
        List<FieldValue> $metaData = this.getMetaData();
        result = result * 59 + ($metaData == null ? 43 : ((Object)$metaData).hashCode());
        List<FieldValue> $operationsData = this.getOperationsData();
        result = result * 59 + ($operationsData == null ? 43 : ((Object)$operationsData).hashCode());
        List<HashSequenceMetaInfo> $hashSequence1 = this.getHashSequence1();
        result = result * 59 + ($hashSequence1 == null ? 43 : ((Object)$hashSequence1).hashCode());
        List<HashSequenceMetaInfo> $hashSequence2 = this.getHashSequence2();
        result = result * 59 + ($hashSequence2 == null ? 43 : ((Object)$hashSequence2).hashCode());
        List<DeviceMetaInfo> $capturedRegisteredDevices = this.getCapturedRegisteredDevices();
        result = result * 59 + ($capturedRegisteredDevices == null ? 43 : ((Object)$capturedRegisteredDevices).hashCode());
        List<FieldValue> $capturedNonRegisteredDevices = this.getCapturedNonRegisteredDevices();
        result = result * 59 + ($capturedNonRegisteredDevices == null ? 43 : ((Object)$capturedNonRegisteredDevices).hashCode());
        List<FieldValue> $checkSum = this.getCheckSum();
        result = result * 59 + ($checkSum == null ? 43 : ((Object)$checkSum).hashCode());
        List<SimpleType> $printingName = this.getPrintingName();
        result = result * 59 + ($printingName == null ? 43 : ((Object)$printingName).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MetaInfo(biometrics=" + this.getBiometrics() + ", exceptionBiometrics=" + this.getExceptionBiometrics() + ", documents=" + this.getDocuments() + ", metaData=" + this.getMetaData() + ", operationsData=" + this.getOperationsData() + ", hashSequence1=" + this.getHashSequence1() + ", hashSequence2=" + this.getHashSequence2() + ", capturedRegisteredDevices=" + this.getCapturedRegisteredDevices() + ", capturedNonRegisteredDevices=" + this.getCapturedNonRegisteredDevices() + ", checkSum=" + this.getCheckSum() + ", printingName=" + this.getPrintingName() + ")";
    }
}

