/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.packetmanager.util;

import io.mosip.kernel.packetmanager.exception.ApiNotAccessibleException;
import io.mosip.kernel.packetmanager.util.RestUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

@Component
public class IdSchemaUtils {
    @Autowired
    private RestUtil restUtil;
    @Autowired
    private Environment env;
    private Map<Double, String> idschema = null;
    @Value(value="${packet.default.source}")
    private String defaultSource;
    @Value(value="${schema.default.fieldCategory}")
    private String defaultFieldCategory;

    public String getSource(String id, Double idschemaVersion) throws IOException, ApiNotAccessibleException {
        String idSchema = this.getIdSchema(idschemaVersion);
        JSONObject properties = this.getJSONObjFromStr(idSchema, "properties");
        JSONObject identity = this.getJSONObj(properties, "identity");
        JSONObject property = this.getJSONObj(identity, "properties");
        JSONObject value = this.getJSONObj(property, id);
        String fieldCategory = this.getFieldCategory(value);
        return fieldCategory;
    }

    public String getIdSchema(Double version) throws ApiNotAccessibleException, IOException {
        if (this.idschema != null && !this.idschema.isEmpty() && this.idschema.get(version) != null) {
            return this.idschema.get(version);
        }
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)this.env.getProperty("IDSCHEMA"));
        if (version != null) {
            builder.queryParam("schemaVersion", new Object[]{version});
        }
        UriComponents uriComponents = builder.build(false).encode();
        String response = (String)this.restUtil.getApi(uriComponents.toUri(), String.class);
        String responseString = null;
        try {
            JSONObject jsonObject = new JSONObject(response);
            JSONObject respObj = (JSONObject)jsonObject.get("response");
            responseString = respObj != null ? (String)respObj.get("schemaJson") : null;
        }
        catch (JSONException e) {
            throw new IOException(e);
        }
        if (responseString != null) {
            if (this.idschema == null) {
                this.idschema = new HashMap<Double, String>();
                this.idschema.put(version, responseString);
            } else {
                this.idschema.put(version, responseString);
            }
        } else {
            throw new ApiNotAccessibleException("Could not get id schema");
        }
        return this.idschema.get(version);
    }

    public static String getJson(String configServerFileStorageURL, String uri) {
        RestTemplate restTemplate = new RestTemplate();
        return (String)restTemplate.getForObject(configServerFileStorageURL + uri, String.class, new Object[0]);
    }

    private String getFieldCategory(JSONObject jsonObject) {
        Object[] defaultCategories;
        String fieldCategory = null;
        try {
            fieldCategory = jsonObject != null ? jsonObject.getString("fieldCategory") : null;
        }
        catch (JSONException e) {
            fieldCategory = null;
        }
        Object[] objectArray = defaultCategories = this.defaultFieldCategory != null ? this.defaultFieldCategory.split(",") : null;
        if (fieldCategory != null && defaultCategories != null && ArrayUtils.contains((Object[])defaultCategories, (Object)fieldCategory)) {
            fieldCategory = this.defaultSource;
        }
        return fieldCategory;
    }

    private JSONObject getJSONObj(JSONObject jsonObject, String id) {
        try {
            return jsonObject == null ? null : (JSONObject)jsonObject.get(id);
        }
        catch (JSONException e) {
            return null;
        }
    }

    private JSONObject getJSONObjFromStr(String jsonString, String id) {
        try {
            return jsonString == null ? null : (JSONObject)new JSONObject(jsonString).get(id);
        }
        catch (JSONException e) {
            return null;
        }
    }
}

