/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.packetmanager.dto;

import io.mosip.kernel.core.util.DateUtils;
import io.mosip.kernel.packetmanager.datatype.SimpleType;
import io.mosip.kernel.packetmanager.dto.AuditDto;
import io.mosip.kernel.packetmanager.dto.BiometricsDto;
import io.mosip.kernel.packetmanager.dto.DocumentDto;
import io.mosip.kernel.packetmanager.dto.SimpleDto;
import io.mosip.kernel.packetmanager.dto.metadata.BiometricsException;
import io.mosip.kernel.packetmanager.dto.metadata.DeviceMetaInfo;
import io.mosip.kernel.packetmanager.dto.metadata.FieldValue;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class PacketInfoDto {
    private String registrationId;
    private double idSchemaVersion;
    private String creationDate = DateUtils.formatToISOString((LocalDateTime)LocalDateTime.now());
    private Map<String, Object> demographics = new HashMap<String, Object>();
    private Map<String, DocumentDto> documents = new HashMap<String, DocumentDto>();
    private Map<String, List<BiometricsDto>> biometrics = new HashMap<String, List<BiometricsDto>>();
    private Map<String, List<BiometricsException>> exceptionBiometrics = new HashMap<String, List<BiometricsException>>();
    private List<FieldValue> metaData = new ArrayList<FieldValue>();
    private List<FieldValue> operationsData = new ArrayList<FieldValue>();
    private List<DeviceMetaInfo> capturedRegisteredDevices;
    private List<FieldValue> capturedNonRegisteredDevices;
    private List<FieldValue> checkSum = new ArrayList<FieldValue>();
    private List<SimpleType> printingName = new ArrayList<SimpleType>();
    private List<BiometricsDto> officerBiometrics;
    private List<BiometricsDto> supervisorBiometrics;
    private List<AuditDto> audits;
    private byte[] acknowledgeReceipt;
    private String acknowledgeReceiptName;

    public void setField(String fieldName, Object value) {
        this.demographics.put(fieldName, value);
    }

    public void setField(String fieldName, List<SimpleDto> value) {
        ArrayList<SimpleType> list = new ArrayList<SimpleType>();
        for (SimpleDto dto : value) {
            list.add(new SimpleType(dto.getLanguage(), dto.getValue()));
        }
        this.demographics.put(fieldName, list);
    }

    public void setBiometricField(String fieldName, List<BiometricsDto> list) {
        this.biometrics.put(fieldName, list);
    }

    public void setDocumentField(String fieldName, DocumentDto dto) {
        this.documents.put(fieldName, dto);
    }

    public void setExceptionBiometrics(String fieldName, List<BiometricsException> exceptionList) {
        this.exceptionBiometrics.put(fieldName, exceptionList);
    }

    public void setMetaData(String label, String value) {
        if (!this.metaData.contains(new FieldValue(label, value))) {
            this.metaData.add(new FieldValue(label, value));
        }
    }

    public void setMetaData(FieldValue fieldValue) {
        if (!this.metaData.contains(fieldValue)) {
            this.metaData.add(fieldValue);
        }
    }

    public void setOperationsData(String key, String value) {
        if (!this.operationsData.contains(new FieldValue(key, value))) {
            this.operationsData.add(new FieldValue(key, value));
        }
    }

    public void setChecksum(String key, String value) {
        if (!this.checkSum.contains(new FieldValue(key, value))) {
            this.checkSum.add(new FieldValue(key, value));
        }
    }

    public void setPrintingName(String language, String value) {
        this.getPrintingName().add(new SimpleType(language, value));
    }

    public Map<String, Object> getIdentityObject() {
        HashMap<String, Object> identityData = new HashMap<String, Object>();
        identityData.put("IDSchemaVersion", this.idSchemaVersion);
        identityData.putAll(this.demographics);
        this.documents.forEach((k, v) -> {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("value", (String)k);
            data.put("type", v.getType());
            data.put("format", v.getFormat());
            identityData.put((String)k, data);
        });
        this.biometrics.forEach((k, v) -> {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("value", String.format("%s_bio_CBEFF", k));
            data.put("version", 1.0);
            data.put("format", "cbeff");
            identityData.put((String)k, data);
        });
        HashMap<String, Object> idObject = new HashMap<String, Object>();
        idObject.put("identity", identityData);
        return idObject;
    }

    @Generated
    public String getRegistrationId() {
        return this.registrationId;
    }

    @Generated
    public double getIdSchemaVersion() {
        return this.idSchemaVersion;
    }

    @Generated
    public String getCreationDate() {
        return this.creationDate;
    }

    @Generated
    public Map<String, Object> getDemographics() {
        return this.demographics;
    }

    @Generated
    public Map<String, DocumentDto> getDocuments() {
        return this.documents;
    }

    @Generated
    public Map<String, List<BiometricsDto>> getBiometrics() {
        return this.biometrics;
    }

    @Generated
    public Map<String, List<BiometricsException>> getExceptionBiometrics() {
        return this.exceptionBiometrics;
    }

    @Generated
    public List<FieldValue> getMetaData() {
        return this.metaData;
    }

    @Generated
    public List<FieldValue> getOperationsData() {
        return this.operationsData;
    }

    @Generated
    public List<DeviceMetaInfo> getCapturedRegisteredDevices() {
        return this.capturedRegisteredDevices;
    }

    @Generated
    public List<FieldValue> getCapturedNonRegisteredDevices() {
        return this.capturedNonRegisteredDevices;
    }

    @Generated
    public List<FieldValue> getCheckSum() {
        return this.checkSum;
    }

    @Generated
    public List<SimpleType> getPrintingName() {
        return this.printingName;
    }

    @Generated
    public List<BiometricsDto> getOfficerBiometrics() {
        return this.officerBiometrics;
    }

    @Generated
    public List<BiometricsDto> getSupervisorBiometrics() {
        return this.supervisorBiometrics;
    }

    @Generated
    public List<AuditDto> getAudits() {
        return this.audits;
    }

    @Generated
    public byte[] getAcknowledgeReceipt() {
        return this.acknowledgeReceipt;
    }

    @Generated
    public String getAcknowledgeReceiptName() {
        return this.acknowledgeReceiptName;
    }

    @Generated
    public void setRegistrationId(String registrationId) {
        this.registrationId = registrationId;
    }

    @Generated
    public void setIdSchemaVersion(double idSchemaVersion) {
        this.idSchemaVersion = idSchemaVersion;
    }

    @Generated
    public void setCreationDate(String creationDate) {
        this.creationDate = creationDate;
    }

    @Generated
    public void setDemographics(Map<String, Object> demographics) {
        this.demographics = demographics;
    }

    @Generated
    public void setDocuments(Map<String, DocumentDto> documents) {
        this.documents = documents;
    }

    @Generated
    public void setBiometrics(Map<String, List<BiometricsDto>> biometrics) {
        this.biometrics = biometrics;
    }

    @Generated
    public void setExceptionBiometrics(Map<String, List<BiometricsException>> exceptionBiometrics) {
        this.exceptionBiometrics = exceptionBiometrics;
    }

    @Generated
    public void setOperationsData(List<FieldValue> operationsData) {
        this.operationsData = operationsData;
    }

    @Generated
    public void setCapturedRegisteredDevices(List<DeviceMetaInfo> capturedRegisteredDevices) {
        this.capturedRegisteredDevices = capturedRegisteredDevices;
    }

    @Generated
    public void setCapturedNonRegisteredDevices(List<FieldValue> capturedNonRegisteredDevices) {
        this.capturedNonRegisteredDevices = capturedNonRegisteredDevices;
    }

    @Generated
    public void setCheckSum(List<FieldValue> checkSum) {
        this.checkSum = checkSum;
    }

    @Generated
    public void setPrintingName(List<SimpleType> printingName) {
        this.printingName = printingName;
    }

    @Generated
    public void setOfficerBiometrics(List<BiometricsDto> officerBiometrics) {
        this.officerBiometrics = officerBiometrics;
    }

    @Generated
    public void setSupervisorBiometrics(List<BiometricsDto> supervisorBiometrics) {
        this.supervisorBiometrics = supervisorBiometrics;
    }

    @Generated
    public void setAudits(List<AuditDto> audits) {
        this.audits = audits;
    }

    @Generated
    public void setAcknowledgeReceipt(byte[] acknowledgeReceipt) {
        this.acknowledgeReceipt = acknowledgeReceipt;
    }

    @Generated
    public void setAcknowledgeReceiptName(String acknowledgeReceiptName) {
        this.acknowledgeReceiptName = acknowledgeReceiptName;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PacketInfoDto)) {
            return false;
        }
        PacketInfoDto other = (PacketInfoDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$registrationId = this.getRegistrationId();
        String other$registrationId = other.getRegistrationId();
        if (this$registrationId == null ? other$registrationId != null : !this$registrationId.equals(other$registrationId)) {
            return false;
        }
        if (Double.compare(this.getIdSchemaVersion(), other.getIdSchemaVersion()) != 0) {
            return false;
        }
        String this$creationDate = this.getCreationDate();
        String other$creationDate = other.getCreationDate();
        if (this$creationDate == null ? other$creationDate != null : !this$creationDate.equals(other$creationDate)) {
            return false;
        }
        Map<String, Object> this$demographics = this.getDemographics();
        Map<String, Object> other$demographics = other.getDemographics();
        if (this$demographics == null ? other$demographics != null : !((Object)this$demographics).equals(other$demographics)) {
            return false;
        }
        Map<String, DocumentDto> this$documents = this.getDocuments();
        Map<String, DocumentDto> other$documents = other.getDocuments();
        if (this$documents == null ? other$documents != null : !((Object)this$documents).equals(other$documents)) {
            return false;
        }
        Map<String, List<BiometricsDto>> this$biometrics = this.getBiometrics();
        Map<String, List<BiometricsDto>> other$biometrics = other.getBiometrics();
        if (this$biometrics == null ? other$biometrics != null : !((Object)this$biometrics).equals(other$biometrics)) {
            return false;
        }
        Map<String, List<BiometricsException>> this$exceptionBiometrics = this.getExceptionBiometrics();
        Map<String, List<BiometricsException>> other$exceptionBiometrics = other.getExceptionBiometrics();
        if (this$exceptionBiometrics == null ? other$exceptionBiometrics != null : !((Object)this$exceptionBiometrics).equals(other$exceptionBiometrics)) {
            return false;
        }
        List<FieldValue> this$metaData = this.getMetaData();
        List<FieldValue> other$metaData = other.getMetaData();
        if (this$metaData == null ? other$metaData != null : !((Object)this$metaData).equals(other$metaData)) {
            return false;
        }
        List<FieldValue> this$operationsData = this.getOperationsData();
        List<FieldValue> other$operationsData = other.getOperationsData();
        if (this$operationsData == null ? other$operationsData != null : !((Object)this$operationsData).equals(other$operationsData)) {
            return false;
        }
        List<DeviceMetaInfo> this$capturedRegisteredDevices = this.getCapturedRegisteredDevices();
        List<DeviceMetaInfo> other$capturedRegisteredDevices = other.getCapturedRegisteredDevices();
        if (this$capturedRegisteredDevices == null ? other$capturedRegisteredDevices != null : !((Object)this$capturedRegisteredDevices).equals(other$capturedRegisteredDevices)) {
            return false;
        }
        List<FieldValue> this$capturedNonRegisteredDevices = this.getCapturedNonRegisteredDevices();
        List<FieldValue> other$capturedNonRegisteredDevices = other.getCapturedNonRegisteredDevices();
        if (this$capturedNonRegisteredDevices == null ? other$capturedNonRegisteredDevices != null : !((Object)this$capturedNonRegisteredDevices).equals(other$capturedNonRegisteredDevices)) {
            return false;
        }
        List<FieldValue> this$checkSum = this.getCheckSum();
        List<FieldValue> other$checkSum = other.getCheckSum();
        if (this$checkSum == null ? other$checkSum != null : !((Object)this$checkSum).equals(other$checkSum)) {
            return false;
        }
        List<SimpleType> this$printingName = this.getPrintingName();
        List<SimpleType> other$printingName = other.getPrintingName();
        if (this$printingName == null ? other$printingName != null : !((Object)this$printingName).equals(other$printingName)) {
            return false;
        }
        List<BiometricsDto> this$officerBiometrics = this.getOfficerBiometrics();
        List<BiometricsDto> other$officerBiometrics = other.getOfficerBiometrics();
        if (this$officerBiometrics == null ? other$officerBiometrics != null : !((Object)this$officerBiometrics).equals(other$officerBiometrics)) {
            return false;
        }
        List<BiometricsDto> this$supervisorBiometrics = this.getSupervisorBiometrics();
        List<BiometricsDto> other$supervisorBiometrics = other.getSupervisorBiometrics();
        if (this$supervisorBiometrics == null ? other$supervisorBiometrics != null : !((Object)this$supervisorBiometrics).equals(other$supervisorBiometrics)) {
            return false;
        }
        List<AuditDto> this$audits = this.getAudits();
        List<AuditDto> other$audits = other.getAudits();
        if (this$audits == null ? other$audits != null : !((Object)this$audits).equals(other$audits)) {
            return false;
        }
        if (!Arrays.equals(this.getAcknowledgeReceipt(), other.getAcknowledgeReceipt())) {
            return false;
        }
        String this$acknowledgeReceiptName = this.getAcknowledgeReceiptName();
        String other$acknowledgeReceiptName = other.getAcknowledgeReceiptName();
        return !(this$acknowledgeReceiptName == null ? other$acknowledgeReceiptName != null : !this$acknowledgeReceiptName.equals(other$acknowledgeReceiptName));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PacketInfoDto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $registrationId = this.getRegistrationId();
        result = result * 59 + ($registrationId == null ? 43 : $registrationId.hashCode());
        long $idSchemaVersion = Double.doubleToLongBits(this.getIdSchemaVersion());
        result = result * 59 + (int)($idSchemaVersion >>> 32 ^ $idSchemaVersion);
        String $creationDate = this.getCreationDate();
        result = result * 59 + ($creationDate == null ? 43 : $creationDate.hashCode());
        Map<String, Object> $demographics = this.getDemographics();
        result = result * 59 + ($demographics == null ? 43 : ((Object)$demographics).hashCode());
        Map<String, DocumentDto> $documents = this.getDocuments();
        result = result * 59 + ($documents == null ? 43 : ((Object)$documents).hashCode());
        Map<String, List<BiometricsDto>> $biometrics = this.getBiometrics();
        result = result * 59 + ($biometrics == null ? 43 : ((Object)$biometrics).hashCode());
        Map<String, List<BiometricsException>> $exceptionBiometrics = this.getExceptionBiometrics();
        result = result * 59 + ($exceptionBiometrics == null ? 43 : ((Object)$exceptionBiometrics).hashCode());
        List<FieldValue> $metaData = this.getMetaData();
        result = result * 59 + ($metaData == null ? 43 : ((Object)$metaData).hashCode());
        List<FieldValue> $operationsData = this.getOperationsData();
        result = result * 59 + ($operationsData == null ? 43 : ((Object)$operationsData).hashCode());
        List<DeviceMetaInfo> $capturedRegisteredDevices = this.getCapturedRegisteredDevices();
        result = result * 59 + ($capturedRegisteredDevices == null ? 43 : ((Object)$capturedRegisteredDevices).hashCode());
        List<FieldValue> $capturedNonRegisteredDevices = this.getCapturedNonRegisteredDevices();
        result = result * 59 + ($capturedNonRegisteredDevices == null ? 43 : ((Object)$capturedNonRegisteredDevices).hashCode());
        List<FieldValue> $checkSum = this.getCheckSum();
        result = result * 59 + ($checkSum == null ? 43 : ((Object)$checkSum).hashCode());
        List<SimpleType> $printingName = this.getPrintingName();
        result = result * 59 + ($printingName == null ? 43 : ((Object)$printingName).hashCode());
        List<BiometricsDto> $officerBiometrics = this.getOfficerBiometrics();
        result = result * 59 + ($officerBiometrics == null ? 43 : ((Object)$officerBiometrics).hashCode());
        List<BiometricsDto> $supervisorBiometrics = this.getSupervisorBiometrics();
        result = result * 59 + ($supervisorBiometrics == null ? 43 : ((Object)$supervisorBiometrics).hashCode());
        List<AuditDto> $audits = this.getAudits();
        result = result * 59 + ($audits == null ? 43 : ((Object)$audits).hashCode());
        result = result * 59 + Arrays.hashCode(this.getAcknowledgeReceipt());
        String $acknowledgeReceiptName = this.getAcknowledgeReceiptName();
        result = result * 59 + ($acknowledgeReceiptName == null ? 43 : $acknowledgeReceiptName.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PacketInfoDto(registrationId=" + this.getRegistrationId() + ", idSchemaVersion=" + this.getIdSchemaVersion() + ", creationDate=" + this.getCreationDate() + ", demographics=" + this.getDemographics() + ", documents=" + this.getDocuments() + ", biometrics=" + this.getBiometrics() + ", exceptionBiometrics=" + this.getExceptionBiometrics() + ", metaData=" + this.getMetaData() + ", operationsData=" + this.getOperationsData() + ", capturedRegisteredDevices=" + this.getCapturedRegisteredDevices() + ", capturedNonRegisteredDevices=" + this.getCapturedNonRegisteredDevices() + ", checkSum=" + this.getCheckSum() + ", printingName=" + this.getPrintingName() + ", officerBiometrics=" + this.getOfficerBiometrics() + ", supervisorBiometrics=" + this.getSupervisorBiometrics() + ", audits=" + this.getAudits() + ", acknowledgeReceipt=" + Arrays.toString(this.getAcknowledgeReceipt()) + ", acknowledgeReceiptName=" + this.getAcknowledgeReceiptName() + ")";
    }
}

