/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.packetmanager.util;

import com.google.gson.Gson;
import io.mosip.kernel.core.util.DateUtils;
import io.mosip.kernel.core.util.StringUtils;
import io.mosip.kernel.core.util.TokenHandlerUtil;
import io.mosip.kernel.packetmanager.dto.Metadata;
import io.mosip.kernel.packetmanager.dto.PasswordRequest;
import io.mosip.kernel.packetmanager.dto.SecretKeyRequest;
import io.mosip.kernel.packetmanager.dto.TokenRequestDTO;
import io.mosip.kernel.packetmanager.exception.ApiNotAccessibleException;
import java.io.IOException;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class RestUtil {
    @Autowired
    private Environment environment;
    private static final String AUTHORIZATION = "Authorization=";

    public <T> T postApi(String uri, MediaType mediaType, Object requestType, Class<?> responseClass) throws ApiNotAccessibleException {
        Object result = null;
        try {
            RestTemplate restTemplate = this.getRestTemplate();
            result = restTemplate.postForObject(uri, this.setRequestHeader(requestType, mediaType), responseClass, new Object[0]);
        }
        catch (Exception e) {
            throw new ApiNotAccessibleException(e);
        }
        return (T)result;
    }

    public <T> T getApi(URI uri, Class<?> responseType) throws ApiNotAccessibleException {
        Object result = null;
        try {
            RestTemplate restTemplate = this.getRestTemplate();
            result = restTemplate.exchange(uri, HttpMethod.GET, this.setRequestHeader(null, null), responseType).getBody();
        }
        catch (Exception e) {
            throw new ApiNotAccessibleException(e);
        }
        return (T)result;
    }

    public RestTemplate getRestTemplate() throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException {
        TrustStrategy acceptingTrustStrategy = (chain, authType) -> true;
        SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(null, acceptingTrustStrategy).build();
        SSLConnectionSocketFactory csf = new SSLConnectionSocketFactory(sslContext);
        CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)csf).build();
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory();
        requestFactory.setHttpClient((HttpClient)httpClient);
        return new RestTemplate((ClientHttpRequestFactory)requestFactory);
    }

    private org.springframework.http.HttpEntity<Object> setRequestHeader(Object requestType, MediaType mediaType) throws IOException {
        LinkedMultiValueMap headers = new LinkedMultiValueMap();
        headers.add((Object)"Cookie", (Object)this.getToken());
        if (mediaType != null) {
            headers.add((Object)"Content-Type", (Object)mediaType.toString());
        }
        if (requestType != null) {
            try {
                org.springframework.http.HttpEntity httpEntity = (org.springframework.http.HttpEntity)requestType;
                HttpHeaders httpHeader = httpEntity.getHeaders();
                for (String key : httpHeader.keySet()) {
                    if (headers.containsKey((Object)"Content-Type") && key == "Content-Type") continue;
                    headers.add((Object)key, httpHeader.get((Object)key).get(0));
                }
                return new org.springframework.http.HttpEntity(httpEntity.getBody(), (MultiValueMap)headers);
            }
            catch (ClassCastException e) {
                return new org.springframework.http.HttpEntity(requestType, (MultiValueMap)headers);
            }
        }
        return new org.springframework.http.HttpEntity((MultiValueMap)headers);
    }

    public String getToken() throws IOException {
        String token = System.getProperty("token");
        boolean isValid = false;
        if (StringUtils.isNotEmpty((CharSequence)token)) {
            isValid = TokenHandlerUtil.isValidBearerToken((String)token, (String)this.environment.getProperty("token.request.issuerUrl"), (String)this.environment.getProperty("token.request.clientId"));
        }
        if (!isValid) {
            TokenRequestDTO<SecretKeyRequest> tokenRequestDTO = new TokenRequestDTO<SecretKeyRequest>();
            tokenRequestDTO.setId(this.environment.getProperty("token.request.id"));
            tokenRequestDTO.setMetadata(new Metadata());
            tokenRequestDTO.setRequesttime(DateUtils.getUTCCurrentDateTimeString());
            tokenRequestDTO.setRequest(this.setSecretKeyRequestDTO());
            tokenRequestDTO.setVersion(this.environment.getProperty("token.request.version"));
            Gson gson = new Gson();
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            HttpPost post = new HttpPost(this.environment.getProperty("KEYBASEDTOKENAPI"));
            StringEntity postingString = new StringEntity(gson.toJson(tokenRequestDTO));
            post.setEntity((HttpEntity)postingString);
            post.setHeader("Content-type", "application/json");
            HttpResponse response = httpClient.execute((HttpUriRequest)post);
            HttpEntity entity = response.getEntity();
            String responseBody = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            Header[] cookie = response.getHeaders("Set-Cookie");
            if (cookie.length == 0) {
                throw new IOException("cookie is empty. Could not generate new token.");
            }
            token = response.getHeaders("Set-Cookie")[0].getValue();
            System.setProperty("token", token.substring(14, token.indexOf(59)));
            return token.substring(0, token.indexOf(59));
        }
        return AUTHORIZATION + token;
    }

    private SecretKeyRequest setSecretKeyRequestDTO() {
        SecretKeyRequest request = new SecretKeyRequest();
        request.setAppId(this.environment.getProperty("token.request.appid"));
        request.setClientId(this.environment.getProperty("token.request.clientId"));
        request.setSecretKey(this.environment.getProperty("token.request.secretKey"));
        return request;
    }

    private PasswordRequest setPasswordRequestDTO() {
        PasswordRequest request = new PasswordRequest();
        request.setAppId(this.environment.getProperty("token.request.appid"));
        request.setPassword(this.environment.getProperty("token.request.password"));
        request.setUserName(this.environment.getProperty("token.request.username"));
        return request;
    }
}

