/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.packetmanager.util;

import io.mosip.kernel.cbeffutil.container.impl.CbeffContainerImpl;
import io.mosip.kernel.core.cbeffutil.common.CbeffValidator;
import io.mosip.kernel.core.cbeffutil.entity.BIR;
import io.mosip.kernel.core.cbeffutil.jaxbclasses.BIRType;
import io.mosip.kernel.core.util.HMACUtils;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.springframework.stereotype.Component;

@Component
public class PacketManagerHelper {
    public byte[] getXMLData(List<BIR> birs) throws Exception {
        byte[] xmlBytes = null;
        try (InputStream xsd = this.getClass().getClassLoader().getResourceAsStream("cbeff.xsd");){
            CbeffContainerImpl cbeffContainer = new CbeffContainerImpl();
            BIRType bir = cbeffContainer.createBIRType(birs);
            xmlBytes = CbeffValidator.createXMLBytes((BIRType)bir, (byte[])IOUtils.toByteArray((InputStream)xsd));
        }
        return xmlBytes;
    }

    public byte[] generateHash(List<String> order, Map<String, byte[]> data) {
        if (order != null && !order.isEmpty()) {
            for (String name : order) {
                HMACUtils.update((byte[])data.get(name));
            }
            return HMACUtils.digestAsPlainText((byte[])HMACUtils.updatedHash()).getBytes();
        }
        return null;
    }
}

