/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.packetmanager.util;

import io.mosip.kernel.core.crypto.spi.CryptoCoreSpec;
import io.mosip.kernel.core.exception.ExceptionUtils;
import io.mosip.kernel.core.util.CryptoUtil;
import io.mosip.kernel.keygenerator.bouncycastle.KeyGenerator;
import io.mosip.kernel.packetmanager.constants.ErrorCode;
import io.mosip.kernel.packetmanager.exception.PacketCreatorException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.SecretKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class PacketCryptoHelper {
    @Value(value="${mosip.kernel.data-key-splitter}")
    private String KEY_SPLITTER;
    @Autowired
    private KeyGenerator keyGenerator;
    @Autowired
    private CryptoCoreSpec<byte[], byte[], SecretKey, PublicKey, PrivateKey, String> cryptoCore;

    public byte[] encryptPacket(byte[] data, byte[] encryptionKey) throws PacketCreatorException {
        Security.setProperty("crypto.policy", "unlimited");
        SecretKey sessionKey = this.keyGenerator.getSymmetricKey();
        byte[] cipherText = (byte[])this.cryptoCore.symmetricEncrypt((Object)sessionKey, (Object)data, null);
        PublicKey publicKey = null;
        try {
            publicKey = KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(CryptoUtil.decodeBase64((String)new String(encryptionKey))));
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new PacketCreatorException(ErrorCode.PACKET_ENCRYPT_ERROR.getErrorCode(), ErrorCode.PACKET_ENCRYPT_ERROR.getErrorMessage().concat(ExceptionUtils.getStackTrace((Throwable)e)));
        }
        byte[] encryptedSessionKey = (byte[])this.cryptoCore.asymmetricEncrypt((Object)publicKey, (Object)sessionKey.getEncoded());
        return CryptoUtil.combineByteArray((byte[])cipherText, (byte[])encryptedSessionKey, (String)this.KEY_SPLITTER);
    }
}

