/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.packetmanager.impl;

import io.mosip.kernel.core.cbeffutil.entity.BIR;
import io.mosip.kernel.core.exception.ExceptionUtils;
import io.mosip.kernel.core.logger.spi.Logger;
import io.mosip.kernel.core.util.CryptoUtil;
import io.mosip.kernel.core.util.JsonUtils;
import io.mosip.kernel.core.util.exception.JsonProcessingException;
import io.mosip.kernel.packetmanager.constants.Biometric;
import io.mosip.kernel.packetmanager.constants.ErrorCode;
import io.mosip.kernel.packetmanager.constants.LoggerFileConstant;
import io.mosip.kernel.packetmanager.constants.PacketManagerConstants;
import io.mosip.kernel.packetmanager.datatype.BiometricsType;
import io.mosip.kernel.packetmanager.datatype.DocumentType;
import io.mosip.kernel.packetmanager.dto.AuditDto;
import io.mosip.kernel.packetmanager.dto.BiometricsDto;
import io.mosip.kernel.packetmanager.dto.DocumentDto;
import io.mosip.kernel.packetmanager.dto.PacketInfoDto;
import io.mosip.kernel.packetmanager.dto.SimpleDto;
import io.mosip.kernel.packetmanager.dto.metadata.BiometricsException;
import io.mosip.kernel.packetmanager.dto.metadata.DeviceMetaInfo;
import io.mosip.kernel.packetmanager.dto.metadata.DocumentMetaInfo;
import io.mosip.kernel.packetmanager.dto.metadata.FieldValue;
import io.mosip.kernel.packetmanager.dto.metadata.HashSequenceMetaInfo;
import io.mosip.kernel.packetmanager.dto.metadata.MetaInfo;
import io.mosip.kernel.packetmanager.dto.metadata.ModalityInfo;
import io.mosip.kernel.packetmanager.exception.PacketCreatorException;
import io.mosip.kernel.packetmanager.impl.CbeffBIRBuilder;
import io.mosip.kernel.packetmanager.logger.PacketUtilityLogger;
import io.mosip.kernel.packetmanager.spi.PacketCreator;
import io.mosip.kernel.packetmanager.spi.PacketSigner;
import io.mosip.kernel.packetmanager.util.PacketCryptoHelper;
import io.mosip.kernel.packetmanager.util.PacketManagerHelper;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class PacketCreatorImpl
implements PacketCreator {
    private static final Logger LOGGER = PacketUtilityLogger.getLogger(PacketCreatorImpl.class);
    private static Map<String, String> categorySubpacketMapping = new HashMap<String, String>();
    @Autowired
    private PacketManagerHelper helper;
    @Autowired
    private CbeffBIRBuilder cbeffBIRBuilder;
    @Autowired
    private PacketCryptoHelper packetCryptoHelper;
    @Value(value="${mosip.kernel.packetmanager.default_subpacket_name:id}")
    private String defaultSubpacketName;
    private PacketInfoDto packetInfoDto = null;

    @Override
    public void initialize() {
        this.packetInfoDto = new PacketInfoDto();
    }

    @Override
    public void setField(String fieldName, Object value) {
        this.packetInfoDto.setField(fieldName, value);
    }

    @Override
    public void setField(String fieldName, List<SimpleDto> value) {
        this.packetInfoDto.setField(fieldName, value);
    }

    @Override
    public void setBiometric(String fieldName, List<BiometricsDto> value) {
        this.packetInfoDto.setBiometricField(fieldName, value);
    }

    @Override
    public void setDocument(String fieldName, DocumentDto value) {
        this.packetInfoDto.setDocumentField(fieldName, value);
    }

    @Override
    public void setAudits(List<AuditDto> auditList) {
        this.packetInfoDto.setAudits(auditList);
    }

    @Override
    public void setMetaInfo(String label, String value) {
        this.packetInfoDto.setMetaData(label, value);
    }

    @Override
    public void setOperationsInfo(String label, String value) {
        this.packetInfoDto.setOperationsData(label, value);
    }

    @Override
    public void setBiometricException(String fieldName, List<BiometricsException> modalityExceptions) {
        this.packetInfoDto.setExceptionBiometrics(fieldName, modalityExceptions);
    }

    @Override
    public void setAcknowledgement(String acknowledgeReceiptName, byte[] acknowledgeReceipt) {
        this.packetInfoDto.setAcknowledgeReceipt(acknowledgeReceipt);
        this.packetInfoDto.setAcknowledgeReceiptName(acknowledgeReceiptName);
    }

    @Override
    public byte[] createPacket(String registrationId, double version, String schemaJson, Map<String, String> categoryPacketMapping, byte[] publicKey, PacketSigner signer) throws PacketCreatorException {
        LOGGER.info(LoggerFileConstant.SESSIONID.toString(), LoggerFileConstant.REGISTRATIONID.toString(), registrationId, "Started packet creation");
        if (this.packetInfoDto == null) {
            throw new PacketCreatorException(ErrorCode.INITIALIZATION_ERROR.getErrorCode(), ErrorCode.INITIALIZATION_ERROR.getErrorMessage());
        }
        Map<String, List<Object>> identityProperties = this.loadSchemaFields(schemaJson);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (ZipOutputStream packetZip = new ZipOutputStream(new BufferedOutputStream(out));){
            for (String subpacketName : identityProperties.keySet()) {
                LOGGER.info(LoggerFileConstant.SESSIONID.toString(), LoggerFileConstant.REGISTRATIONID.toString(), registrationId, "Started Subpacket: " + subpacketName);
                List<Object> schemaFields = identityProperties.get(subpacketName);
                byte[] subpacketBytes = this.createSubpacket(version, schemaFields, this.defaultSubpacketName.equalsIgnoreCase(subpacketName), registrationId);
                subpacketBytes = CryptoUtil.encodeBase64((byte[])this.packetCryptoHelper.encryptPacket(subpacketBytes, publicKey)).getBytes();
                this.addEntryToZip(String.format("%s_%s.zip", registrationId, subpacketName), subpacketBytes, packetZip);
                LOGGER.info(LoggerFileConstant.SESSIONID.toString(), LoggerFileConstant.REGISTRATIONID.toString(), registrationId, "Completed Subpacket: " + subpacketName);
            }
        }
        catch (IOException e) {
            throw new PacketCreatorException(ErrorCode.PKT_ZIP_ERROR.getErrorCode(), ErrorCode.PKT_ZIP_ERROR.getErrorMessage().concat(ExceptionUtils.getStackTrace((Throwable)e)));
        }
        finally {
            this.packetInfoDto = null;
        }
        LOGGER.info(LoggerFileConstant.SESSIONID.toString(), LoggerFileConstant.REGISTRATIONID.toString(), registrationId, "Exiting packet creation");
        return out.toByteArray();
    }

    private byte[] createSubpacket(double version, List<Object> schemaFields, boolean isDefault, String registrationId) throws PacketCreatorException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (ZipOutputStream subpacketZip = new ZipOutputStream(new BufferedOutputStream(out));){
            LOGGER.info(LoggerFileConstant.SESSIONID.toString(), LoggerFileConstant.REGISTRATIONID.toString(), registrationId, "Identified fields >>> " + schemaFields.size());
            HashMap<String, Object> identity = new HashMap<String, Object>();
            HashMap<String, HashSequenceMetaInfo> hashSequences = new HashMap<String, HashSequenceMetaInfo>();
            MetaInfo metaInfo = new MetaInfo();
            identity.put("IDSchemaVersion", version);
            metaInfo.addMetaData(new FieldValue("registrationId", registrationId));
            metaInfo.addMetaData(new FieldValue("creationDate", this.packetInfoDto.getCreationDate()));
            block20: for (Object obj : schemaFields) {
                Map field = (Map)obj;
                String fieldName = (String)field.get("id");
                LOGGER.info(LoggerFileConstant.SESSIONID.toString(), LoggerFileConstant.REGISTRATIONID.toString(), registrationId, "Adding field : " + fieldName);
                switch ((String)field.get("type")) {
                    case "#/definitions/biometricsType": {
                        if (this.packetInfoDto.getBiometrics().get(fieldName) == null) continue block20;
                        this.addBiometricDetailsToZip(fieldName, identity, metaInfo, subpacketZip, hashSequences);
                        continue block20;
                    }
                    case "#/definitions/documentType": {
                        if (this.packetInfoDto.getDocuments().get(fieldName) == null) continue block20;
                        this.addDocumentDetailsToZip(fieldName, identity, metaInfo, subpacketZip, hashSequences);
                        continue block20;
                    }
                }
                if (this.packetInfoDto.getDemographics().get(fieldName) == null) continue;
                identity.put(fieldName, this.packetInfoDto.getDemographics().get(fieldName));
            }
            byte[] identityBytes = this.getIdentity(identity).getBytes();
            this.addEntryToZip("ID.json", identityBytes, subpacketZip);
            this.addHashSequenceWithSource("demographicSequence", "ID", identityBytes, hashSequences);
            this.addOtherFilesToZip(isDefault, metaInfo, subpacketZip, hashSequences);
        }
        catch (JsonProcessingException e) {
            throw new PacketCreatorException(ErrorCode.OBJECT_TO_JSON_ERROR.getErrorCode(), ErrorCode.BIR_TO_XML_ERROR.getErrorMessage().concat(ExceptionUtils.getStackTrace((Throwable)e)));
        }
        catch (IOException e) {
            throw new PacketCreatorException(ErrorCode.PKT_ZIP_ERROR.getErrorCode(), ErrorCode.PKT_ZIP_ERROR.getErrorMessage().concat(ExceptionUtils.getStackTrace((Throwable)e)));
        }
        return out.toByteArray();
    }

    private void addDocumentDetailsToZip(String fieldName, Map<String, Object> identity, MetaInfo metaInfo, ZipOutputStream zipOutputStream, Map<String, HashSequenceMetaInfo> hashSequences) throws PacketCreatorException {
        DocumentDto dto = this.packetInfoDto.getDocuments().get(fieldName);
        identity.put(fieldName, new DocumentType(fieldName, dto.getType(), dto.getFormat()));
        String fileName = String.format("%s.%s", fieldName, dto.getFormat());
        this.addEntryToZip(fileName, dto.getDocument(), zipOutputStream);
        metaInfo.addDocumentMetaInfo(new DocumentMetaInfo(fieldName, dto.getCategory(), dto.getOwner(), dto.getType()));
        this.addHashSequenceWithSource("demographicSequence", fieldName, dto.getDocument(), hashSequences);
    }

    private void addBiometricDetailsToZip(String fieldName, Map<String, Object> identity, MetaInfo metaInfo, ZipOutputStream zipOutputStream, Map<String, HashSequenceMetaInfo> hashSequences) throws PacketCreatorException {
        List<BIR> birs = this.getSerializedBiometrics(this.packetInfoDto.getBiometrics().get(fieldName), metaInfo);
        if (!birs.isEmpty()) {
            byte[] xmlBytes;
            try {
                xmlBytes = this.helper.getXMLData(birs);
            }
            catch (Exception e) {
                throw new PacketCreatorException(ErrorCode.BIR_TO_XML_ERROR.getErrorCode(), ErrorCode.BIR_TO_XML_ERROR.getErrorMessage().concat(ExceptionUtils.getStackTrace((Throwable)e)));
            }
            this.addEntryToZip(String.format(PacketManagerConstants.CBEFF_FILENAME_WITH_EXT, fieldName), xmlBytes, zipOutputStream);
            identity.put(fieldName, new BiometricsType("cbeff", 1.0, String.format("%s_bio_CBEFF", fieldName)));
            this.addHashSequenceWithSource("biometricSequence", String.format("%s_bio_CBEFF", fieldName), xmlBytes, hashSequences);
        }
        if (this.packetInfoDto.getExceptionBiometrics().containsKey(fieldName)) {
            metaInfo.setBiometricException(this.packetInfoDto.getExceptionBiometrics().get(fieldName));
        }
    }

    private void addHashSequenceWithSource(String sequenceType, String name, byte[] bytes, Map<String, HashSequenceMetaInfo> hashSequences) {
        if (!hashSequences.containsKey(sequenceType)) {
            hashSequences.put(sequenceType, new HashSequenceMetaInfo(sequenceType));
        }
        hashSequences.get(sequenceType).addHashSource(name, bytes);
    }

    private void addOtherFilesToZip(boolean isDefault, MetaInfo metaInfo, ZipOutputStream zipOutputStream, Map<String, HashSequenceMetaInfo> hashSequences) throws JsonProcessingException, PacketCreatorException {
        if (isDefault) {
            this.fillAllMetaInfo(metaInfo);
            this.addOperationsBiometricsToZip(this.packetInfoDto.getOfficerBiometrics(), "officer", zipOutputStream, metaInfo, hashSequences);
            this.addOperationsBiometricsToZip(this.packetInfoDto.getSupervisorBiometrics(), "supervisor", zipOutputStream, metaInfo, hashSequences);
            if (this.packetInfoDto.getAudits() == null || this.packetInfoDto.getAudits().isEmpty()) {
                throw new PacketCreatorException(ErrorCode.AUDITS_REQUIRED.getErrorCode(), ErrorCode.AUDITS_REQUIRED.getErrorMessage());
            }
            byte[] auditBytes = JsonUtils.javaObjectToJsonString(this.packetInfoDto.getAudits()).getBytes();
            this.addEntryToZip("audit.json", auditBytes, zipOutputStream);
            this.addHashSequenceWithSource("otherFiles", "audit", auditBytes, hashSequences);
            HashSequenceMetaInfo hashSequenceMetaInfo = hashSequences.get("otherFiles");
            this.addEntryToZip("packet_operations_hash.txt", this.helper.generateHash(hashSequenceMetaInfo.getValue(), hashSequenceMetaInfo.getHashSource()), zipOutputStream);
            metaInfo.addHashSequence2(hashSequenceMetaInfo);
        }
        this.addPacketDataHash(hashSequences, metaInfo, zipOutputStream);
        this.addEntryToZip("packet_meta_info.json", this.getIdentity(metaInfo).getBytes(), zipOutputStream);
    }

    private void addPacketDataHash(Map<String, HashSequenceMetaInfo> hashSequences, MetaInfo metaInfo, ZipOutputStream zipOutputStream) throws PacketCreatorException {
        LinkedList<String> sequence = new LinkedList<String>();
        HashMap<String, byte[]> data = new HashMap<String, byte[]>();
        if (hashSequences.containsKey("biometricSequence")) {
            sequence.addAll(hashSequences.get("biometricSequence").getValue());
            data.putAll(hashSequences.get("biometricSequence").getHashSource());
            metaInfo.addHashSequence1(hashSequences.get("biometricSequence"));
        }
        if (hashSequences.containsKey("demographicSequence")) {
            sequence.addAll(hashSequences.get("demographicSequence").getValue());
            data.putAll(hashSequences.get("demographicSequence").getHashSource());
            metaInfo.addHashSequence1(hashSequences.get("demographicSequence"));
        }
        this.addEntryToZip("packet_data_hash.txt", this.helper.generateHash(sequence, data), zipOutputStream);
    }

    private void fillAllMetaInfo(MetaInfo metaInfo) {
        if (this.packetInfoDto.getMetaData() != null) {
            for (FieldValue fieldValue : this.packetInfoDto.getMetaData()) {
                metaInfo.addMetaData(fieldValue);
            }
        }
        if (this.packetInfoDto.getOperationsData() != null) {
            for (FieldValue fieldValue : this.packetInfoDto.getOperationsData()) {
                metaInfo.addOperationsData(fieldValue);
            }
        }
        metaInfo.setCapturedRegisteredDevices(this.packetInfoDto.getCapturedRegisteredDevices());
        metaInfo.setCapturedNonRegisteredDevices(this.packetInfoDto.getCapturedNonRegisteredDevices());
        metaInfo.setCheckSum(this.packetInfoDto.getCheckSum());
        metaInfo.setPrintingName(this.packetInfoDto.getPrintingName());
    }

    private void addOperationsBiometricsToZip(List<BiometricsDto> list, String operationType, ZipOutputStream zipOutputStream, MetaInfo metaInfo, Map<String, HashSequenceMetaInfo> hashSequences) throws PacketCreatorException {
        if (list != null && !list.isEmpty()) {
            byte[] xmlBytes;
            ArrayList<BIR> birs = new ArrayList<BIR>();
            for (BiometricsDto bioDto : list) {
                BIR bir = this.cbeffBIRBuilder.buildBIR(bioDto.getAttributeISO(), bioDto.getQualityScore(), Biometric.getSingleTypeByAttribute(bioDto.getBioAttribute()), bioDto.getBioAttribute());
                birs.add(bir);
            }
            try {
                xmlBytes = this.helper.getXMLData(birs);
            }
            catch (Exception e) {
                throw new PacketCreatorException(ErrorCode.BIR_TO_XML_ERROR.getErrorCode(), ErrorCode.BIR_TO_XML_ERROR.getErrorMessage().concat(ExceptionUtils.getStackTrace((Throwable)e)));
            }
            if (xmlBytes != null) {
                String fileName = String.format(PacketManagerConstants.CBEFF_FILENAME_WITH_EXT, operationType);
                this.addEntryToZip(fileName, xmlBytes, zipOutputStream);
                metaInfo.addOperationsData(new FieldValue(String.format("%sBiometricFileName", operationType), fileName));
                this.addHashSequenceWithSource("otherFiles", String.format("%s_bio_CBEFF", operationType), xmlBytes, hashSequences);
            }
        }
    }

    private Map<String, List<Object>> loadSchemaFields(String schemaJson) throws PacketCreatorException {
        HashMap<String, List<Object>> packetBasedMap = new HashMap<String, List<Object>>();
        try {
            JSONObject schema = new JSONObject(schemaJson);
            schema = schema.getJSONObject("properties");
            schema = schema.getJSONObject("identity");
            schema = schema.getJSONObject("properties");
            JSONArray fieldNames = schema.names();
            for (int i = 0; i < fieldNames.length(); ++i) {
                String[] packetNames;
                String fieldName = fieldNames.getString(i);
                JSONObject fieldDetail = schema.getJSONObject(fieldName);
                String fieldCategory = fieldDetail.has("fieldCategory") ? fieldDetail.getString("fieldCategory") : "none";
                String packets = categorySubpacketMapping.get(fieldCategory.toLowerCase());
                for (String packetName : packetNames = packets.split(",")) {
                    if (!packetBasedMap.containsKey(packetName)) {
                        packetBasedMap.put(packetName, new ArrayList());
                    }
                    HashMap<String, String> attributes = new HashMap<String, String>();
                    attributes.put("id", fieldName);
                    attributes.put("type", fieldDetail.has("$ref") ? fieldDetail.getString("$ref") : fieldDetail.getString("type"));
                    ((List)packetBasedMap.get(packetName)).add(attributes);
                }
            }
        }
        catch (JSONException e) {
            throw new PacketCreatorException(ErrorCode.JSON_PARSE_ERROR.getErrorCode(), ErrorCode.JSON_PARSE_ERROR.getErrorMessage().concat(ExceptionUtils.getStackTrace((Throwable)e)));
        }
        return packetBasedMap;
    }

    private List<BIR> getSerializedBiometrics(List<BiometricsDto> list, MetaInfo metaInfo) {
        ArrayList<BIR> birs = new ArrayList<BIR>();
        for (BiometricsDto bioDto : list) {
            BIR bir = this.cbeffBIRBuilder.buildBIR(bioDto.getAttributeISO(), bioDto.getQualityScore(), Biometric.getSingleTypeByAttribute(bioDto.getBioAttribute()), bioDto.getBioAttribute());
            birs.add(bir);
            metaInfo.setBiometrics(bioDto.getSubType(), bioDto.getBioAttribute(), new ModalityInfo(bir.getBdbInfo().getIndex(), bioDto.getNumOfRetries(), bioDto.isForceCaptured()));
        }
        return birs;
    }

    private void addEntryToZip(String fileName, byte[] data, ZipOutputStream zipOutputStream) throws PacketCreatorException {
        LOGGER.info(LoggerFileConstant.SESSIONID.toString(), LoggerFileConstant.REGISTRATIONID.toString(), this.packetInfoDto.getRegistrationId(), "Adding file : " + fileName);
        try {
            if (data != null) {
                ZipEntry zipEntry = new ZipEntry(fileName);
                zipOutputStream.putNextEntry(zipEntry);
                zipOutputStream.write(data);
            }
        }
        catch (IOException e) {
            throw new PacketCreatorException(ErrorCode.ADD_ZIP_ENTRY_ERROR.getErrorCode(), ErrorCode.ADD_ZIP_ENTRY_ERROR.getErrorMessage().concat(ExceptionUtils.getStackTrace((Throwable)e)));
        }
    }

    private String getIdentity(Object object) throws JsonProcessingException {
        return "{ \"identity\" : " + JsonUtils.javaObjectToJsonString((Object)object) + " } ";
    }

    @Override
    public void setChecksum(String key, String value) {
        this.packetInfoDto.setChecksum(key, value);
    }

    @Override
    public void setRegisteredDeviceDetails(List<DeviceMetaInfo> deviceDetails) {
        this.packetInfoDto.setCapturedRegisteredDevices(deviceDetails);
    }

    @Override
    public void setPrintingName(String langauge, String printingName) {
        this.packetInfoDto.setPrintingName(langauge, printingName);
    }

    @Override
    public Map<String, Object> getIdentityObject() {
        return this.packetInfoDto.getIdentityObject();
    }

    @Override
    public void setOfficerBiometric(String userId, String officerRole, List<BiometricsDto> value) {
        if (Objects.isNull(value)) {
            return;
        }
        switch (officerRole.toLowerCase()) {
            case "officer": {
                this.packetInfoDto.setOfficerBiometrics(value);
                break;
            }
            case "supervisor": {
                this.packetInfoDto.setSupervisorBiometrics(value);
            }
        }
    }

    static {
        categorySubpacketMapping.put("pvt", "id");
        categorySubpacketMapping.put("kyc", "id");
        categorySubpacketMapping.put("none", "id,evidence,optional");
        categorySubpacketMapping.put("evidence", "evidence");
        categorySubpacketMapping.put("optional", "optional");
    }
}

