/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.pinvalidator.impl;

import io.mosip.kernel.core.pinvalidator.exception.InvalidPinException;
import io.mosip.kernel.core.pinvalidator.spi.PinValidator;
import io.mosip.kernel.core.util.StringUtils;
import io.mosip.kernel.pinvalidator.constant.PinExceptionConstant;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class PinValidatorImpl
implements PinValidator<String> {
    @Value(value="${mosip.kernel.pin.length}")
    private int pinLength;
    private String numaricRegEx;

    @PostConstruct
    private void uinValidatorImplnumaricRegEx() {
        this.numaricRegEx = "\\d{" + this.pinLength + "}";
    }

    public boolean validatePin(String pin) {
        if (StringUtils.isEmpty((CharSequence)pin)) {
            throw new InvalidPinException(PinExceptionConstant.PIN_INVALID_NULL.getErrorCode(), PinExceptionConstant.PIN_INVALID_NULL.getErrorMessage());
        }
        if (pin.length() != this.pinLength) {
            throw new InvalidPinException(PinExceptionConstant.PIN_INVALID_LENGTH.getErrorCode(), PinExceptionConstant.PIN_INVALID_LENGTH.getErrorMessage() + this.pinLength);
        }
        if (!Pattern.matches(this.numaricRegEx, pin)) {
            throw new InvalidPinException(PinExceptionConstant.PIN_INVALID_CHAR.getErrorCode(), PinExceptionConstant.PIN_INVALID_CHAR.getErrorMessage());
        }
        return true;
    }
}

