/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.pdfgenerator.itext.impl;

import com.itextpdf.html2pdf.ConverterProperties;
import com.itextpdf.html2pdf.HtmlConverter;
import com.itextpdf.html2pdf.css.media.MediaDeviceDescription;
import com.itextpdf.html2pdf.css.media.MediaType;
import com.itextpdf.html2pdf.css.util.CssUtils;
import com.itextpdf.html2pdf.resolver.font.DefaultFontProvider;
import com.itextpdf.io.image.ImageDataFactory;
import com.itextpdf.kernel.geom.PageSize;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.layout.element.Image;
import com.itextpdf.layout.font.FontProvider;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfCopy;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfSignatureAppearance;
import com.itextpdf.text.pdf.PdfStamper;
import com.itextpdf.text.pdf.security.BouncyCastleDigest;
import com.itextpdf.text.pdf.security.CertificateUtil;
import com.itextpdf.text.pdf.security.CrlClientOnline;
import com.itextpdf.text.pdf.security.ExternalDigest;
import com.itextpdf.text.pdf.security.ExternalSignature;
import com.itextpdf.text.pdf.security.MakeSignature;
import com.itextpdf.text.pdf.security.OcspClient;
import com.itextpdf.text.pdf.security.OcspClientBouncyCastle;
import com.itextpdf.text.pdf.security.PrivateKeySignature;
import com.itextpdf.text.pdf.security.TSAClient;
import com.itextpdf.text.pdf.security.TSAClientBouncyCastle;
import io.mosip.kernel.core.keymanager.model.CertificateEntry;
import io.mosip.kernel.core.pdfgenerator.exception.PDFGeneratorException;
import io.mosip.kernel.core.pdfgenerator.spi.PDFGenerator;
import io.mosip.kernel.core.util.EmptyCheckUtils;
import io.mosip.kernel.pdfgenerator.itext.constant.PDFGeneratorExceptionCodeConstant;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class PDFGeneratorImpl
implements PDFGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(PDFGeneratorImpl.class);
    private static final String SHA256 = "SHA256";
    private static final String OUTPUT_FILE_EXTENSION = ".pdf";
    @Value(value="${mosip.kernel.pdf_owner_password}")
    private String pdfOwnerPassword;

    public OutputStream generate(InputStream is) throws IOException {
        this.isValidInputStream(is);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            HtmlConverter.convertToPdf((InputStream)is, (OutputStream)os);
        }
        catch (Exception e) {
            throw new PDFGeneratorException(PDFGeneratorExceptionCodeConstant.PDF_EXCEPTION.getErrorCode(), e.getMessage());
        }
        return os;
    }

    public OutputStream generate(String template) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            HtmlConverter.convertToPdf((String)template, (OutputStream)os);
        }
        catch (Exception e) {
            throw new PDFGeneratorException(PDFGeneratorExceptionCodeConstant.PDF_EXCEPTION.getErrorCode(), PDFGeneratorExceptionCodeConstant.PDF_EXCEPTION.getErrorMessage(), (Throwable)e);
        }
        return os;
    }

    public void generate(String templatePath, String outpuFilePath, String outputFileName) throws IOException {
        File outputFile = new File(outpuFilePath + outputFileName + OUTPUT_FILE_EXTENSION);
        try {
            HtmlConverter.convertToPdf((File)new File(templatePath), (File)outputFile);
        }
        catch (Exception e) {
            throw new PDFGeneratorException(PDFGeneratorExceptionCodeConstant.PDF_EXCEPTION.getErrorCode(), PDFGeneratorExceptionCodeConstant.PDF_EXCEPTION.getErrorMessage(), (Throwable)e);
        }
    }

    public OutputStream generate(InputStream is, String resourceLoc) throws IOException {
        this.isValidInputStream(is);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PdfWriter pdfWriter = new PdfWriter((OutputStream)os);
        PdfDocument pdfDoc = new PdfDocument(pdfWriter);
        ConverterProperties converterProperties = new ConverterProperties();
        pdfDoc.setTagged();
        PageSize pageSize = PageSize.A4.rotate();
        pdfDoc.setDefaultPageSize(pageSize);
        float screenWidth = CssUtils.parseAbsoluteLength((String)("" + pageSize.getWidth()));
        MediaDeviceDescription mediaDescription = new MediaDeviceDescription(MediaType.SCREEN);
        mediaDescription.setWidth(screenWidth);
        DefaultFontProvider dfp = new DefaultFontProvider(true, true, false);
        converterProperties.setMediaDeviceDescription(mediaDescription);
        converterProperties.setFontProvider((FontProvider)dfp);
        converterProperties.setBaseUri(resourceLoc);
        converterProperties.setCreateAcroForm(true);
        try {
            HtmlConverter.convertToPdf((InputStream)is, (PdfDocument)pdfDoc, (ConverterProperties)converterProperties);
        }
        catch (Exception e) {
            throw new PDFGeneratorException(PDFGeneratorExceptionCodeConstant.PDF_EXCEPTION.getErrorCode(), e.getMessage());
        }
        return os;
    }

    public byte[] asPDF(List<BufferedImage> bufferedImages) throws IOException {
        byte[] scannedPdfFile = null;
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            PdfWriter pdfWriter = new PdfWriter((OutputStream)byteArrayOutputStream);
            com.itextpdf.layout.Document document = new com.itextpdf.layout.Document(new PdfDocument(pdfWriter));
            for (BufferedImage bufferedImage : bufferedImages) {
                Image image = new Image(ImageDataFactory.create((byte[])this.getImageBytesFromBufferedImage(bufferedImage)));
                image.scaleToFit(600.0f, 750.0f);
                document.add(image);
            }
            document.close();
            pdfWriter.close();
            scannedPdfFile = byteArrayOutputStream.toByteArray();
        }
        catch (IOException e) {
            throw new PDFGeneratorException(PDFGeneratorExceptionCodeConstant.PDF_EXCEPTION.getErrorCode(), e.getMessage());
        }
        return scannedPdfFile;
    }

    private byte[] getImageBytesFromBufferedImage(BufferedImage bufferedImage) throws IOException {
        ByteArrayOutputStream imagebyteArray = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "jpg", imagebyteArray);
        imagebyteArray.flush();
        byte[] imageInByte = imagebyteArray.toByteArray();
        imagebyteArray.close();
        return imageInByte;
    }

    public byte[] mergePDF(List<URL> pdfFiles) throws IOException {
        Object object;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            Document document = new Document();
            PdfCopy pdfCopy = new PdfCopy(document, (OutputStream)byteArrayOutputStream);
            document.open();
            for (URL file : pdfFiles) {
                PdfReader reader = new PdfReader(file);
                pdfCopy.addDocument(reader);
                pdfCopy.freeReader(reader);
                reader.close();
            }
            document.close();
            object = byteArrayOutputStream.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    byteArrayOutputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (DocumentException | IOException e) {
                throw new PDFGeneratorException(PDFGeneratorExceptionCodeConstant.PDF_EXCEPTION.getErrorCode(), e.getMessage());
            }
        }
        byteArrayOutputStream.close();
        return object;
    }

    public OutputStream signAndEncryptPDF(byte[] pdf, io.mosip.kernel.core.pdfgenerator.model.Rectangle rectangle, String reason, int pageNumber, Provider provider, CertificateEntry<X509Certificate, PrivateKey> certificateEntry, String password) throws IOException, GeneralSecurityException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PdfReader pdfReader = null;
        PdfStamper pdfStamper = null;
        try {
            pdfReader = new PdfReader(pdf);
            pdfStamper = PdfStamper.createSignature((PdfReader)pdfReader, (OutputStream)outputStream, (char)'\u0000');
            LOGGER.debug("certificate entry {}", certificateEntry);
            LOGGER.info("provider {}", (Object)provider);
            if (password != null && !password.trim().isEmpty()) {
                pdfStamper.setEncryption(password.getBytes(), this.pdfOwnerPassword.getBytes(), 2052, 3);
            }
            PdfSignatureAppearance signAppearance = pdfStamper.getSignatureAppearance();
            signAppearance.setReason(reason);
            signAppearance.setVisibleSignature(new Rectangle(rectangle.getLlx(), rectangle.getLly(), rectangle.getUrx(), rectangle.getUry()), pageNumber, null);
            OcspClientBouncyCastle ocspClient = new OcspClientBouncyCastle(null);
            TSAClientBouncyCastle tsaClient = null;
            for (X509Certificate certificate : (X509Certificate[])certificateEntry.getChain()) {
                String tsaUrl = CertificateUtil.getTSAURL((X509Certificate)certificate);
                if (tsaUrl != null) {
                    tsaClient = new TSAClientBouncyCastle(tsaUrl);
                    break;
                }
                signAppearance.setCertificate((Certificate)certificate);
            }
            ArrayList<CrlClientOnline> crlList = new ArrayList<CrlClientOnline>();
            crlList.add(new CrlClientOnline((Certificate[])certificateEntry.getChain()));
            PrivateKeySignature pks = new PrivateKeySignature((PrivateKey)certificateEntry.getPrivateKey(), SHA256, provider.getName());
            BouncyCastleDigest digest = new BouncyCastleDigest();
            MakeSignature.signDetached((PdfSignatureAppearance)signAppearance, (ExternalDigest)digest, (ExternalSignature)pks, (Certificate[])((Certificate[])certificateEntry.getChain()), crlList, (OcspClient)ocspClient, (TSAClient)tsaClient, (int)0, (MakeSignature.CryptoStandard)MakeSignature.CryptoStandard.CMS);
        }
        catch (DocumentException e) {
            try {
                LOGGER.error("Document Exception occur {}", e.getCause());
                throw new PDFGeneratorException(PDFGeneratorExceptionCodeConstant.PDF_EXCEPTION.getErrorCode(), e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                ((OutputStream)outputStream).close();
                if (pdfStamper != null) {
                    this.closeQuietly(pdfStamper);
                }
                if (pdfReader != null) {
                    pdfReader.close();
                }
                throw throwable;
            }
        }
        ((OutputStream)outputStream).close();
        if (pdfStamper != null) {
            this.closeQuietly(pdfStamper);
        }
        if (pdfReader != null) {
            pdfReader.close();
        }
        return outputStream;
    }

    private void closeQuietly(PdfStamper pdfStamper) throws IOException {
        try {
            pdfStamper.close();
        }
        catch (DocumentException e) {
            throw new PDFGeneratorException(PDFGeneratorExceptionCodeConstant.PDF_EXCEPTION.getErrorCode(), e.getMessage(), (Throwable)e);
        }
    }

    private void isValidInputStream(InputStream dataInputStream) {
        if (EmptyCheckUtils.isNullEmpty((Object)dataInputStream)) {
            throw new PDFGeneratorException(PDFGeneratorExceptionCodeConstant.INPUTSTREAM_NULL_EMPTY_EXCEPTION.getErrorCode(), PDFGeneratorExceptionCodeConstant.INPUTSTREAM_NULL_EMPTY_EXCEPTION.getErrorMessage());
        }
    }
}

