/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.otpmanager.service.impl;

import io.mosip.kernel.core.otpmanager.spi.OtpGenerator;
import io.mosip.kernel.otpmanager.constant.OtpStatusConstants;
import io.mosip.kernel.otpmanager.dto.OtpGeneratorRequestDto;
import io.mosip.kernel.otpmanager.dto.OtpGeneratorResponseDto;
import io.mosip.kernel.otpmanager.entity.OtpEntity;
import io.mosip.kernel.otpmanager.repository.OtpRepository;
import io.mosip.kernel.otpmanager.util.OtpManagerUtils;
import io.mosip.kernel.otpmanager.util.OtpProvider;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;

@RefreshScope
@Service
public class OtpGeneratorServiceImpl
implements OtpGenerator<OtpGeneratorRequestDto, OtpGeneratorResponseDto> {
    @Autowired
    private OtpRepository otpRepository;
    @Autowired
    private OtpProvider otpProvider;
    @Value(value="${mosip.kernel.otp.key-freeze-time}")
    String keyFreezeTime;
    @Value(value="${mosip.kernel.otp.default-length}")
    int otpLength;
    @Value(value="${mosip.kernel.otp.mac-algorithm}")
    String macAlgorithm;
    @Value(value="${javax.persistence.jdbc.url}")
    String jdbcUrl;
    @Value(value="${spring.profiles.active}")
    String activeProfile;
    @Value(value="${mosip.kernel.auth.proxy-otp-value:111111}")
    String localOtp;
    @Value(value="${mosip.kernel.auth.proxy-otp}")
    private boolean isProxytrue;

    public OtpGeneratorResponseDto getOtp(OtpGeneratorRequestDto otpDto) {
        OtpGeneratorResponseDto response = new OtpGeneratorResponseDto();
        if (this.activeProfile.equalsIgnoreCase("local")) {
            response.setOtp(this.localOtp);
            response.setStatus(OtpStatusConstants.GENERATION_SUCCESSFUL.getProperty());
            return response;
        }
        String refIdHash = OtpManagerUtils.getHash((String)otpDto.getKey());
        Optional entityOpt = this.otpRepository.findFirstByRefIdOrderByGeneratedDtimesDesc(refIdHash);
        if (entityOpt.isPresent() && ((OtpEntity)entityOpt.get()).getStatusCode().equals(OtpStatusConstants.KEY_FREEZED.getProperty()) && OtpManagerUtils.timeDifferenceInSeconds((LocalDateTime)((OtpEntity)entityOpt.get()).getUpdatedDtimes(), (LocalDateTime)LocalDateTime.now(ZoneId.of("UTC"))) <= Integer.parseInt(this.keyFreezeTime)) {
            response.setOtp(OtpStatusConstants.SET_AS_NULL_IN_STRING.getProperty());
            response.setStatus(OtpStatusConstants.BLOCKED_USER.getProperty());
        } else {
            String generatedOtp = this.isProxytrue ? this.localOtp : this.otpProvider.computeOtp(otpDto.getKey(), this.otpLength, this.macAlgorithm);
            if (entityOpt.isPresent()) {
                this.otpRepository.delete((Object)((OtpEntity)entityOpt.get()));
            }
            OtpEntity otp = new OtpEntity();
            otp.setId(OtpManagerUtils.getKeyOtpHash((String)otpDto.getKey(), (String)generatedOtp));
            otp.setRefId(refIdHash);
            otp.setValidationRetryCount(0);
            this.otpRepository.save((Object)otp);
            response.setOtp(generatedOtp);
            response.setStatus(OtpStatusConstants.GENERATION_SUCCESSFUL.getProperty());
        }
        return response;
    }
}

