/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.otpmanager.entity;

import io.mosip.kernel.otpmanager.constant.OtpStatusConstants;
import java.time.LocalDateTime;
import java.time.ZoneId;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

@Entity
@Table(name="otp_transaction", schema="kernel")
public class OtpEntity {
    @Id
    @Column(name="id")
    private String id;
    @Column(name="upd_dtimes")
    private LocalDateTime updatedDtimes;
    @Column(name="otp", length=8)
    private String otp;
    @Column(name="validation_retry_count")
    private int validationRetryCount;
    @Column(name="generated_dtimes")
    private LocalDateTime generatedDtimes;
    @Column(name="status_code")
    private String statusCode;
    @Column(name="ref_id")
    private String refId;
    @Column(name="ref_id_type")
    private String refIdType;
    @Column(name="expiry_dtimes")
    private LocalDateTime expiryDTimes;
    @Column(name="lang_code", length=3)
    private String langCode;
    @Column(name="cr_by", length=256)
    private String createdBy;
    @Column(name="upd_by", length=256)
    private String updatedBy;
    @Column(name="cr_dtimes")
    private LocalDateTime crDtimes;
    @Column(name="del_dtimes")
    private LocalDateTime delDtimes;
    @Column(name="is_deleted")
    private boolean isDeleted;

    public OtpEntity() {
        this.updatedDtimes = this.generatedDtimes = LocalDateTime.now(ZoneId.of("UTC"));
        this.statusCode = OtpStatusConstants.UNUSED_OTP.getProperty();
    }

    public String getId() {
        return this.id;
    }

    public LocalDateTime getUpdatedDtimes() {
        return this.updatedDtimes;
    }

    public String getOtp() {
        return this.otp;
    }

    public int getValidationRetryCount() {
        return this.validationRetryCount;
    }

    public LocalDateTime getGeneratedDtimes() {
        return this.generatedDtimes;
    }

    public String getStatusCode() {
        return this.statusCode;
    }

    public String getRefId() {
        return this.refId;
    }

    public String getRefIdType() {
        return this.refIdType;
    }

    public LocalDateTime getExpiryDTimes() {
        return this.expiryDTimes;
    }

    public String getLangCode() {
        return this.langCode;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public String getUpdatedBy() {
        return this.updatedBy;
    }

    public LocalDateTime getCrDtimes() {
        return this.crDtimes;
    }

    public LocalDateTime getDelDtimes() {
        return this.delDtimes;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setUpdatedDtimes(LocalDateTime updatedDtimes) {
        this.updatedDtimes = updatedDtimes;
    }

    public void setOtp(String otp) {
        this.otp = otp;
    }

    public void setValidationRetryCount(int validationRetryCount) {
        this.validationRetryCount = validationRetryCount;
    }

    public void setGeneratedDtimes(LocalDateTime generatedDtimes) {
        this.generatedDtimes = generatedDtimes;
    }

    public void setStatusCode(String statusCode) {
        this.statusCode = statusCode;
    }

    public void setRefId(String refId) {
        this.refId = refId;
    }

    public void setRefIdType(String refIdType) {
        this.refIdType = refIdType;
    }

    public void setExpiryDTimes(LocalDateTime expiryDTimes) {
        this.expiryDTimes = expiryDTimes;
    }

    public void setLangCode(String langCode) {
        this.langCode = langCode;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public void setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
    }

    public void setCrDtimes(LocalDateTime crDtimes) {
        this.crDtimes = crDtimes;
    }

    public void setDelDtimes(LocalDateTime delDtimes) {
        this.delDtimes = delDtimes;
    }

    public void setDeleted(boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OtpEntity)) {
            return false;
        }
        OtpEntity other = (OtpEntity)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        LocalDateTime this$updatedDtimes = this.getUpdatedDtimes();
        LocalDateTime other$updatedDtimes = other.getUpdatedDtimes();
        if (this$updatedDtimes == null ? other$updatedDtimes != null : !((Object)this$updatedDtimes).equals(other$updatedDtimes)) {
            return false;
        }
        String this$otp = this.getOtp();
        String other$otp = other.getOtp();
        if (this$otp == null ? other$otp != null : !this$otp.equals(other$otp)) {
            return false;
        }
        if (this.getValidationRetryCount() != other.getValidationRetryCount()) {
            return false;
        }
        LocalDateTime this$generatedDtimes = this.getGeneratedDtimes();
        LocalDateTime other$generatedDtimes = other.getGeneratedDtimes();
        if (this$generatedDtimes == null ? other$generatedDtimes != null : !((Object)this$generatedDtimes).equals(other$generatedDtimes)) {
            return false;
        }
        String this$statusCode = this.getStatusCode();
        String other$statusCode = other.getStatusCode();
        if (this$statusCode == null ? other$statusCode != null : !this$statusCode.equals(other$statusCode)) {
            return false;
        }
        String this$refId = this.getRefId();
        String other$refId = other.getRefId();
        if (this$refId == null ? other$refId != null : !this$refId.equals(other$refId)) {
            return false;
        }
        String this$refIdType = this.getRefIdType();
        String other$refIdType = other.getRefIdType();
        if (this$refIdType == null ? other$refIdType != null : !this$refIdType.equals(other$refIdType)) {
            return false;
        }
        LocalDateTime this$expiryDTimes = this.getExpiryDTimes();
        LocalDateTime other$expiryDTimes = other.getExpiryDTimes();
        if (this$expiryDTimes == null ? other$expiryDTimes != null : !((Object)this$expiryDTimes).equals(other$expiryDTimes)) {
            return false;
        }
        String this$langCode = this.getLangCode();
        String other$langCode = other.getLangCode();
        if (this$langCode == null ? other$langCode != null : !this$langCode.equals(other$langCode)) {
            return false;
        }
        String this$createdBy = this.getCreatedBy();
        String other$createdBy = other.getCreatedBy();
        if (this$createdBy == null ? other$createdBy != null : !this$createdBy.equals(other$createdBy)) {
            return false;
        }
        String this$updatedBy = this.getUpdatedBy();
        String other$updatedBy = other.getUpdatedBy();
        if (this$updatedBy == null ? other$updatedBy != null : !this$updatedBy.equals(other$updatedBy)) {
            return false;
        }
        LocalDateTime this$crDtimes = this.getCrDtimes();
        LocalDateTime other$crDtimes = other.getCrDtimes();
        if (this$crDtimes == null ? other$crDtimes != null : !((Object)this$crDtimes).equals(other$crDtimes)) {
            return false;
        }
        LocalDateTime this$delDtimes = this.getDelDtimes();
        LocalDateTime other$delDtimes = other.getDelDtimes();
        if (this$delDtimes == null ? other$delDtimes != null : !((Object)this$delDtimes).equals(other$delDtimes)) {
            return false;
        }
        return this.isDeleted() == other.isDeleted();
    }

    protected boolean canEqual(Object other) {
        return other instanceof OtpEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        LocalDateTime $updatedDtimes = this.getUpdatedDtimes();
        result = result * 59 + ($updatedDtimes == null ? 43 : ((Object)$updatedDtimes).hashCode());
        String $otp = this.getOtp();
        result = result * 59 + ($otp == null ? 43 : $otp.hashCode());
        result = result * 59 + this.getValidationRetryCount();
        LocalDateTime $generatedDtimes = this.getGeneratedDtimes();
        result = result * 59 + ($generatedDtimes == null ? 43 : ((Object)$generatedDtimes).hashCode());
        String $statusCode = this.getStatusCode();
        result = result * 59 + ($statusCode == null ? 43 : $statusCode.hashCode());
        String $refId = this.getRefId();
        result = result * 59 + ($refId == null ? 43 : $refId.hashCode());
        String $refIdType = this.getRefIdType();
        result = result * 59 + ($refIdType == null ? 43 : $refIdType.hashCode());
        LocalDateTime $expiryDTimes = this.getExpiryDTimes();
        result = result * 59 + ($expiryDTimes == null ? 43 : ((Object)$expiryDTimes).hashCode());
        String $langCode = this.getLangCode();
        result = result * 59 + ($langCode == null ? 43 : $langCode.hashCode());
        String $createdBy = this.getCreatedBy();
        result = result * 59 + ($createdBy == null ? 43 : $createdBy.hashCode());
        String $updatedBy = this.getUpdatedBy();
        result = result * 59 + ($updatedBy == null ? 43 : $updatedBy.hashCode());
        LocalDateTime $crDtimes = this.getCrDtimes();
        result = result * 59 + ($crDtimes == null ? 43 : ((Object)$crDtimes).hashCode());
        LocalDateTime $delDtimes = this.getDelDtimes();
        result = result * 59 + ($delDtimes == null ? 43 : ((Object)$delDtimes).hashCode());
        result = result * 59 + (this.isDeleted() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "OtpEntity(id=" + this.getId() + ", updatedDtimes=" + this.getUpdatedDtimes() + ", otp=" + this.getOtp() + ", validationRetryCount=" + this.getValidationRetryCount() + ", generatedDtimes=" + this.getGeneratedDtimes() + ", statusCode=" + this.getStatusCode() + ", refId=" + this.getRefId() + ", refIdType=" + this.getRefIdType() + ", expiryDTimes=" + this.getExpiryDTimes() + ", langCode=" + this.getLangCode() + ", createdBy=" + this.getCreatedBy() + ", updatedBy=" + this.getUpdatedBy() + ", crDtimes=" + this.getCrDtimes() + ", delDtimes=" + this.getDelDtimes() + ", isDeleted=" + this.isDeleted() + ")";
    }
}

