/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.otpmanager.controller;

import io.mosip.kernel.core.http.ResponseFilter;
import io.mosip.kernel.core.http.ResponseWrapper;
import io.mosip.kernel.core.otpmanager.spi.OtpValidator;
import io.mosip.kernel.otpmanager.dto.OtpValidatorResponseDto;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="otpvalidator", description="Operation related to Otp validation")
public class OtpValidatorController {
    @Autowired
    OtpValidator<ResponseEntity<OtpValidatorResponseDto>> otpValidatorService;

    @ResponseFilter
    @Operation(summary="This endpoint validates the OTP against a key", description="This endpoint validates the OTP against a key", tags={"otpvalidator"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success or you may find errors in error array in response"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(hidden=true))})})
    @PreAuthorize(value="hasAnyRole(@authorizedRoles.getGetotpvalidate())")
    @GetMapping(value={"/otp/validate"})
    public ResponseWrapper<OtpValidatorResponseDto> validateOtp(@RequestParam String key, @RequestParam String otp) {
        ResponseWrapper responseWrapper = new ResponseWrapper();
        responseWrapper.setResponse((Object)((OtpValidatorResponseDto)((ResponseEntity)this.otpValidatorService.validateOtp(key, otp)).getBody()));
        return responseWrapper;
    }
}

