/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.otpmanager.util;

import io.mosip.kernel.otpmanager.constant.OtpErrorConstants;
import io.mosip.kernel.otpmanager.exception.OtpIOException;
import io.mosip.kernel.otpmanager.util.PasscodeGenerator;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;

public class PasscodeGenerator {
    private static final int[] DIGITS_POWER = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
    private final Signer signer;
    private final int codeLength;

    public PasscodeGenerator(Signer signer, int passCodeLength) {
        this.signer = signer;
        this.codeLength = passCodeLength;
    }

    private String padOutput(int value) {
        StringBuilder result = new StringBuilder(Integer.toString(value));
        for (int i = result.length(); i < this.codeLength; ++i) {
            result.insert(0, "0");
        }
        return result.toString();
    }

    public String generateResponseCode(long state) throws GeneralSecurityException {
        byte[] value = ByteBuffer.allocate(8).putLong(state).array();
        return this.generateResponseCode(value);
    }

    public String generateResponseCode(byte[] value) throws GeneralSecurityException {
        byte[] hash = this.signer.sign(value);
        int offset = hash[hash.length - 1] & 0xF;
        int truncatedHash = this.hashToInt(hash, offset) & Integer.MAX_VALUE;
        int pinValue = truncatedHash % DIGITS_POWER[this.codeLength];
        return this.padOutput(pinValue);
    }

    private int hashToInt(byte[] bytes, int start) {
        int val;
        DataInputStream input = new DataInputStream(new ByteArrayInputStream(bytes, start, bytes.length - start));
        try {
            val = input.readInt();
        }
        catch (IOException e) {
            throw new OtpIOException(OtpErrorConstants.OTP_GEN_IO_FAILURE.getErrorCode(), OtpErrorConstants.OTP_GEN_IO_FAILURE.getErrorMessage(), (Throwable)e);
        }
        return val;
    }
}

