/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.otpmanager.util;

import io.mosip.kernel.otpmanager.constant.OtpErrorConstants;
import io.mosip.kernel.otpmanager.exception.CryptoFailureException;
import io.mosip.kernel.otpmanager.exception.OtpServiceException;
import io.mosip.kernel.otpmanager.util.PasscodeGenerator;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class OtpProvider {
    public String computeOtp(String key, int otpLength, String macAlgorithm) {
        try {
            PasscodeGenerator pcg = new PasscodeGenerator(OtpProvider.getSigning((String)key, (String)macAlgorithm), otpLength);
            return pcg.generateResponseCode(System.currentTimeMillis());
        }
        catch (Exception e) {
            throw new CryptoFailureException(OtpErrorConstants.OTP_GEN_CRYPTO_FAILURE.getErrorCode(), OtpErrorConstants.OTP_GEN_CRYPTO_FAILURE.getErrorMessage(), (Throwable)e);
        }
    }

    static PasscodeGenerator.Signer getSigning(String secret, String macAlgo) {
        try {
            Mac mac = Mac.getInstance(macAlgo);
            mac.init(new SecretKeySpec(secret.getBytes(), ""));
            return data -> mac.doFinal(data);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException error) {
            throw new OtpServiceException(OtpErrorConstants.OTP_GEN_ALGO_FAILURE.getErrorCode(), OtpErrorConstants.OTP_GEN_ALGO_FAILURE.getErrorMessage(), (Throwable)error);
        }
    }
}

