/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.otpmanager.controller;

import io.mosip.kernel.core.http.ResponseFilter;
import io.mosip.kernel.core.http.ResponseWrapper;
import io.mosip.kernel.core.otpmanager.spi.OtpValidator;
import io.mosip.kernel.otpmanager.dto.OtpValidatorResponseDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
public class OtpValidatorController {
    @Autowired
    OtpValidator<ResponseEntity<OtpValidatorResponseDto>> otpValidatorService;

    @PreAuthorize(value="hasAnyRole('INDIVIDUAL','REGISTRATION_ADMIN','REGISTRATION_SUPERVISOR','REGISTRATION_OFFICER','ID_AUTHENTICATION','AUTH','RESIDENT')")
    @ResponseFilter
    @GetMapping(value={"/otp/validate"})
    public ResponseWrapper<OtpValidatorResponseDto> validateOtp(@RequestParam String key, @RequestParam String otp) {
        ResponseWrapper responseWrapper = new ResponseWrapper();
        responseWrapper.setResponse((Object)((OtpValidatorResponseDto)((ResponseEntity)this.otpValidatorService.validateOtp(key, otp)).getBody()));
        return responseWrapper;
    }
}

