/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.otpmanager.util;

import io.mosip.kernel.core.exception.ServiceError;
import io.mosip.kernel.core.util.StringUtils;
import io.mosip.kernel.otpmanager.constant.OtpErrorConstants;
import io.mosip.kernel.otpmanager.exception.OtpInvalidArgumentException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Component;

@RefreshScope
@Component
public class OtpManagerUtils {
    @Value(value="${mosip.kernel.otp.min-key-length}")
    String keyMinLength;
    @Value(value="${mosip.kernel.otp.max-key-length}")
    String keyMaxLength;

    public static int timeDifferenceInSeconds(LocalDateTime fromDateTime, LocalDateTime toDateTime) {
        return (int)fromDateTime.until(toDateTime, ChronoUnit.SECONDS);
    }

    public static LocalDateTime getCurrentLocalDateTime() {
        return LocalDateTime.now(ZoneId.of("UTC"));
    }

    public void validateOtpRequestArguments(String key, String otp) {
        ArrayList<ServiceError> validationErrorsList = new ArrayList<ServiceError>();
        if (key == null || key.isEmpty()) {
            validationErrorsList.add(new ServiceError(OtpErrorConstants.OTP_VAL_INVALID_KEY_INPUT.getErrorCode(), OtpErrorConstants.OTP_VAL_INVALID_KEY_INPUT.getErrorMessage()));
        } else if (key.length() < Integer.parseInt(this.keyMinLength) || key.length() > Integer.parseInt(this.keyMaxLength)) {
            validationErrorsList.add(new ServiceError(OtpErrorConstants.OTP_VAL_ILLEGAL_KEY_INPUT.getErrorCode(), OtpErrorConstants.OTP_VAL_ILLEGAL_KEY_INPUT.getErrorMessage()));
        }
        if (otp == null || otp.isEmpty()) {
            validationErrorsList.add(new ServiceError(OtpErrorConstants.OTP_VAL_INVALID_OTP_INPUT.getErrorCode(), OtpErrorConstants.OTP_VAL_INVALID_OTP_INPUT.getErrorMessage()));
        }
        if (otp != null && !StringUtils.isNumeric((CharSequence)otp)) {
            validationErrorsList.add(new ServiceError(OtpErrorConstants.OTP_VAL_ILLEGAL_OTP_INPUT.getErrorCode(), OtpErrorConstants.OTP_VAL_ILLEGAL_OTP_INPUT.getErrorMessage()));
        }
        if (!validationErrorsList.isEmpty()) {
            throw new OtpInvalidArgumentException(validationErrorsList);
        }
    }
}

