/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.otpmanager.service.impl;

import io.mosip.kernel.core.exception.ServiceError;
import io.mosip.kernel.core.otpmanager.spi.OtpValidator;
import io.mosip.kernel.otpmanager.constant.OtpErrorConstants;
import io.mosip.kernel.otpmanager.constant.OtpStatusConstants;
import io.mosip.kernel.otpmanager.constant.SqlQueryConstants;
import io.mosip.kernel.otpmanager.dto.OtpValidatorResponseDto;
import io.mosip.kernel.otpmanager.entity.OtpEntity;
import io.mosip.kernel.otpmanager.exception.RequiredKeyNotFoundException;
import io.mosip.kernel.otpmanager.repository.OtpRepository;
import io.mosip.kernel.otpmanager.util.OtpManagerUtils;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@RefreshScope
@Service
public class OtpValidatorServiceImpl
implements OtpValidator<ResponseEntity<OtpValidatorResponseDto>> {
    @Autowired
    OtpRepository otpRepository;
    @Autowired
    OtpManagerUtils otpUtils;
    @Value(value="${mosip.kernel.otp.validation-attempt-threshold}")
    String numberOfValidationAttemptsAllowed;
    @Value(value="${mosip.kernel.otp.key-freeze-time}")
    String keyFreezeDuration;
    @Value(value="${mosip.kernel.otp.expiry-time}")
    String otpExpiryLimit;
    @Value(value="${spring.profiles.active}")
    String activeProfile;
    @Value(value="${local.env.otp:111111}")
    String localOtp;
    @Value(value="${mosip.kernel.auth.proxy-otp}")
    private boolean proxyOtp;

    public ResponseEntity<OtpValidatorResponseDto> validateOtp(String key, String otp) {
        HashMap updateMap;
        String updateString;
        if (this.activeProfile.equalsIgnoreCase("local") || this.proxyOtp) {
            return this.proxyForLocalProfile(otp);
        }
        this.otpUtils.validateOtpRequestArguments(key, otp);
        OtpEntity otpResponse = (OtpEntity)this.otpRepository.findById(OtpEntity.class, (Object)key);
        OtpValidatorResponseDto responseDto = new OtpValidatorResponseDto();
        responseDto.setMessage(OtpStatusConstants.FAILURE_MESSAGE.getProperty());
        responseDto.setStatus(OtpStatusConstants.FAILURE_STATUS.getProperty());
        ResponseEntity validationResponseEntity = new ResponseEntity((Object)responseDto, HttpStatus.OK);
        this.requireKeyNotFound(otpResponse);
        int attemptCount = otpResponse.getValidationRetryCount();
        if (OtpManagerUtils.timeDifferenceInSeconds((LocalDateTime)otpResponse.getGeneratedDtimes(), (LocalDateTime)OtpManagerUtils.getCurrentLocalDateTime()) > Integer.parseInt(this.otpExpiryLimit)) {
            responseDto.setStatus(OtpStatusConstants.FAILURE_STATUS.getProperty());
            responseDto.setMessage(OtpStatusConstants.OTP_EXPIRED_STATUS.getProperty());
            return new ResponseEntity((Object)responseDto, HttpStatus.OK);
        }
        if (attemptCount < Integer.parseInt(this.numberOfValidationAttemptsAllowed) && otpResponse.getStatusCode().equals(OtpStatusConstants.UNUSED_OTP.getProperty())) {
            updateString = SqlQueryConstants.UPDATE.getProperty() + " " + OtpEntity.class.getSimpleName() + " SET validation_retry_count = :newNumOfAttempt,upd_dtimes = :newValidationTime WHERE id=:id";
            updateMap = this.createUpdateMap(key, null, Integer.valueOf(attemptCount + 1), LocalDateTime.now(ZoneId.of("UTC")));
            this.updateData(updateString, updateMap);
        }
        if (attemptCount == Integer.parseInt(this.numberOfValidationAttemptsAllowed) - 1 && !otp.equals(otpResponse.getOtp())) {
            updateString = SqlQueryConstants.UPDATE.getProperty() + " " + OtpEntity.class.getSimpleName() + " SET status_code = :newOtpStatus,upd_dtimes = :newValidationTime,validation_retry_count = :newNumOfAttempt WHERE id=:id";
            updateMap = this.createUpdateMap(key, OtpStatusConstants.KEY_FREEZED.getProperty(), Integer.valueOf(0), OtpManagerUtils.getCurrentLocalDateTime());
            this.updateData(updateString, updateMap);
            responseDto.setStatus(OtpStatusConstants.FAILURE_STATUS.getProperty());
            responseDto.setMessage(OtpStatusConstants.FAILURE_AND_FREEZED_MESSAGE.getProperty());
            validationResponseEntity = new ResponseEntity((Object)responseDto, HttpStatus.OK);
            return validationResponseEntity;
        }
        validationResponseEntity = this.unFreezeKey(key, otp, otpResponse, attemptCount, responseDto, validationResponseEntity);
        if (otpResponse.getOtp().equals(otp) && otpResponse.getStatusCode().equals(OtpStatusConstants.UNUSED_OTP.getProperty()) && OtpManagerUtils.timeDifferenceInSeconds((LocalDateTime)otpResponse.getGeneratedDtimes(), (LocalDateTime)OtpManagerUtils.getCurrentLocalDateTime()) <= Integer.parseInt(this.otpExpiryLimit)) {
            responseDto.setStatus(OtpStatusConstants.SUCCESS_STATUS.getProperty());
            responseDto.setMessage(OtpStatusConstants.SUCCESS_MESSAGE.getProperty());
            this.otpRepository.deleteById((Object)key);
            return new ResponseEntity((Object)responseDto, HttpStatus.OK);
        }
        return validationResponseEntity;
    }

    private void requireKeyNotFound(OtpEntity otpResponse) {
        if (otpResponse == null) {
            ArrayList<ServiceError> validationErrorsList = new ArrayList<ServiceError>();
            validationErrorsList.add(new ServiceError(OtpErrorConstants.OTP_VAL_KEY_NOT_FOUND.getErrorCode(), OtpErrorConstants.OTP_VAL_KEY_NOT_FOUND.getErrorMessage()));
            throw new RequiredKeyNotFoundException(validationErrorsList);
        }
    }

    private ResponseEntity<OtpValidatorResponseDto> proxyForLocalProfile(String otp) {
        OtpValidatorResponseDto responseDto = new OtpValidatorResponseDto();
        if (otp.equalsIgnoreCase(this.localOtp)) {
            responseDto.setStatus(OtpStatusConstants.SUCCESS_STATUS.getProperty());
            responseDto.setMessage(OtpStatusConstants.SUCCESS_MESSAGE.getProperty());
            ResponseEntity validationResponseEntity = new ResponseEntity((Object)responseDto, HttpStatus.OK);
            return validationResponseEntity;
        }
        responseDto.setStatus(OtpStatusConstants.FAILURE_STATUS.getProperty());
        responseDto.setMessage(OtpStatusConstants.FAILURE_MESSAGE.getProperty());
        ResponseEntity validationResponseEntity = new ResponseEntity((Object)responseDto, HttpStatus.OK);
        return validationResponseEntity;
    }

    private ResponseEntity<OtpValidatorResponseDto> unFreezeKey(String key, String otp, OtpEntity otpResponse, int attemptCount, OtpValidatorResponseDto responseDto, ResponseEntity<OtpValidatorResponseDto> validationResponseEntity) {
        if (otpResponse.getStatusCode().equals(OtpStatusConstants.KEY_FREEZED.getProperty())) {
            if (OtpManagerUtils.timeDifferenceInSeconds((LocalDateTime)otpResponse.getUpdatedDtimes(), (LocalDateTime)OtpManagerUtils.getCurrentLocalDateTime()) > Integer.parseInt(this.keyFreezeDuration)) {
                String updateString = SqlQueryConstants.UPDATE.getProperty() + " " + OtpEntity.class.getSimpleName() + " SET status_code = :newOtpStatus, validation_retry_count = :newNumOfAttempt, upd_dtimes = :newValidationTime WHERE id=:id";
                HashMap updateMap = this.createUpdateMap(key, OtpStatusConstants.UNUSED_OTP.getProperty(), Integer.valueOf(attemptCount + 1), OtpManagerUtils.getCurrentLocalDateTime());
                if (otp.equals(otpResponse.getOtp())) {
                    responseDto.setStatus(OtpStatusConstants.SUCCESS_STATUS.getProperty());
                    responseDto.setMessage(OtpStatusConstants.SUCCESS_MESSAGE.getProperty());
                    validationResponseEntity = new ResponseEntity((Object)responseDto, HttpStatus.OK);
                    this.otpRepository.deleteById((Object)key);
                } else {
                    this.updateData(updateString, updateMap);
                }
            } else {
                responseDto.setMessage(OtpStatusConstants.FAILURE_AND_FREEZED_MESSAGE.getProperty());
                validationResponseEntity = new ResponseEntity((Object)responseDto, HttpStatus.OK);
            }
        }
        return validationResponseEntity;
    }

    private HashMap<String, Object> createUpdateMap(String key, String status, Integer newNumberOfAttempt, LocalDateTime localDateTime) {
        HashMap<String, Object> updateMap = new HashMap<String, Object>();
        if (key != null) {
            updateMap.put(SqlQueryConstants.ID.getProperty(), key);
        }
        if (status != null) {
            updateMap.put(SqlQueryConstants.NEW_OTP_STATUS.getProperty(), status);
        }
        if (newNumberOfAttempt != null) {
            updateMap.put(SqlQueryConstants.NEW_NUM_OF_ATTEMPT.getProperty(), newNumberOfAttempt);
        }
        if (localDateTime != null) {
            updateMap.put(SqlQueryConstants.NEW_VALIDATION_TIME.getProperty(), localDateTime);
        }
        return updateMap;
    }

    private void updateData(String updateString, HashMap<String, Object> updateMap) {
        this.otpRepository.createQueryUpdateOrDelete(updateString, updateMap);
    }
}

