/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.otpmanager.controller;

import io.mosip.kernel.core.http.RequestWrapper;
import io.mosip.kernel.core.http.ResponseFilter;
import io.mosip.kernel.core.http.ResponseWrapper;
import io.mosip.kernel.core.otpmanager.spi.OtpGenerator;
import io.mosip.kernel.otpmanager.dto.GenerationDTOValidationLevels;
import io.mosip.kernel.otpmanager.dto.OtpGeneratorRequestDto;
import io.mosip.kernel.otpmanager.dto.OtpGeneratorResponseDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
public class OtpGeneratorController {
    @Autowired
    OtpGenerator<OtpGeneratorRequestDto, OtpGeneratorResponseDto> otpGeneratorService;

    @PreAuthorize(value="hasAnyRole('INDIVIDUAL','REGISTRATION_ADMIN','REGISTRATION_SUPERVISOR','REGISTRATION_OFFICER','ID_AUTHENTICATION','AUTH')")
    @ResponseFilter
    @PostMapping(value={"/otp/generate"})
    public ResponseWrapper<OtpGeneratorResponseDto> generateOtp(@Validated(value={GenerationDTOValidationLevels.ValidationLevel.class}) @RequestBody RequestWrapper<OtpGeneratorRequestDto> otpDto) {
        ResponseWrapper responseWrapper = new ResponseWrapper();
        responseWrapper.setResponse(this.otpGeneratorService.getOtp(otpDto.getRequest()));
        return responseWrapper;
    }
}

