/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.otpmanager.service.impl;

import io.mosip.kernel.core.otpmanager.spi.OtpGenerator;
import io.mosip.kernel.otpmanager.constant.OtpStatusConstants;
import io.mosip.kernel.otpmanager.dto.OtpGeneratorRequestDto;
import io.mosip.kernel.otpmanager.dto.OtpGeneratorResponseDto;
import io.mosip.kernel.otpmanager.entity.OtpEntity;
import io.mosip.kernel.otpmanager.repository.OtpRepository;
import io.mosip.kernel.otpmanager.util.OtpManagerUtils;
import io.mosip.kernel.otpmanager.util.OtpProvider;
import java.time.LocalDateTime;
import java.time.ZoneId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;

@RefreshScope
@Service
public class OtpGeneratorServiceImpl
implements OtpGenerator<OtpGeneratorRequestDto, OtpGeneratorResponseDto> {
    @Autowired
    private OtpRepository otpRepository;
    @Autowired
    private OtpProvider otpProvider;
    @Value(value="${mosip.kernel.otp.key-freeze-time}")
    String keyFreezeTime;
    @Value(value="${mosip.kernel.otp.default-length}")
    int otpLength;
    @Value(value="${mosip.kernel.otp.mac-algorithm}")
    String macAlgorithm;
    @Value(value="${javax.persistence.jdbc.url}")
    String jdbcUrl;

    public OtpGeneratorResponseDto getOtp(OtpGeneratorRequestDto otpDto) {
        OtpGeneratorResponseDto response = new OtpGeneratorResponseDto();
        OtpEntity keyCheck = (OtpEntity)this.otpRepository.findById(OtpEntity.class, (Object)otpDto.getKey());
        if (keyCheck != null && keyCheck.getStatusCode().equals(OtpStatusConstants.KEY_FREEZED.getProperty()) && OtpManagerUtils.timeDifferenceInSeconds((LocalDateTime)keyCheck.getUpdatedDtimes(), (LocalDateTime)LocalDateTime.now(ZoneId.of("UTC"))) <= Integer.parseInt(this.keyFreezeTime)) {
            response.setOtp(OtpStatusConstants.SET_AS_NULL_IN_STRING.getProperty());
            response.setStatus(OtpStatusConstants.BLOCKED_USER.getProperty());
        } else {
            String generatedOtp = this.otpProvider.computeOtp(otpDto.getKey(), this.otpLength, this.macAlgorithm);
            OtpEntity otp = new OtpEntity();
            otp.setId(otpDto.getKey());
            otp.setValidationRetryCount(0);
            otp.setOtp(generatedOtp);
            this.otpRepository.save((Object)otp);
            response.setOtp(generatedOtp);
            response.setStatus(OtpStatusConstants.GENERATION_SUCCESSFUL.getProperty());
        }
        return response;
    }
}

