/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.openid.bridge.dto;

import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotBlank;

public class JWSSignatureRequestDto {
    @NotBlank
    @ApiModelProperty(notes="Base64 encoded JSON Data to sign", example="ewogICAiYW55S2V5IjogIlRlc3QgSnNvbiIKfQ", required=true)
    private String dataToSign;
    @ApiModelProperty(notes="Application id to be used for signing", example="KERNEL", required=false)
    private String applicationId;
    @ApiModelProperty(notes="Refrence Id", example="SIGN", required=false)
    private String referenceId;
    @ApiModelProperty(notes="Flag to include payload in  JWT Signature Header.", example="false", required=false)
    private Boolean includePayload;
    @ApiModelProperty(notes="Flag to include certificate in  JWT Signature Header.", example="false", required=false)
    private Boolean includeCertificate;
    @ApiModelProperty(notes="Flag to include certificate hash(sha256) in  JWT Signature Header.", example="false", required=false)
    private Boolean includeCertHash;
    @ApiModelProperty(notes="Flag to include certificate URL in  JWT Signature Header.", required=false)
    private String certificateUrl;
    @ApiModelProperty(notes="Flag to validate inputted JSON to be a valid JSON.", required=false)
    private Boolean validateJson;
    @ApiModelProperty(notes="Flag to determine the inputted data to be Base64URL encoded in signature process", required=false)
    private Boolean b64JWSHeaderParam;
    @ApiModelProperty(notes="JWS Algorithm to use for data signing. Current supported Algorithm PS256.", required=false)
    private String signAlgorithm;

    public String getDataToSign() {
        return this.dataToSign;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    public Boolean getIncludePayload() {
        return this.includePayload;
    }

    public Boolean getIncludeCertificate() {
        return this.includeCertificate;
    }

    public Boolean getIncludeCertHash() {
        return this.includeCertHash;
    }

    public String getCertificateUrl() {
        return this.certificateUrl;
    }

    public Boolean getValidateJson() {
        return this.validateJson;
    }

    public Boolean getB64JWSHeaderParam() {
        return this.b64JWSHeaderParam;
    }

    public String getSignAlgorithm() {
        return this.signAlgorithm;
    }

    public void setDataToSign(String dataToSign) {
        this.dataToSign = dataToSign;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    public void setIncludePayload(Boolean includePayload) {
        this.includePayload = includePayload;
    }

    public void setIncludeCertificate(Boolean includeCertificate) {
        this.includeCertificate = includeCertificate;
    }

    public void setIncludeCertHash(Boolean includeCertHash) {
        this.includeCertHash = includeCertHash;
    }

    public void setCertificateUrl(String certificateUrl) {
        this.certificateUrl = certificateUrl;
    }

    public void setValidateJson(Boolean validateJson) {
        this.validateJson = validateJson;
    }

    public void setB64JWSHeaderParam(Boolean b64JWSHeaderParam) {
        this.b64JWSHeaderParam = b64JWSHeaderParam;
    }

    public void setSignAlgorithm(String signAlgorithm) {
        this.signAlgorithm = signAlgorithm;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JWSSignatureRequestDto)) {
            return false;
        }
        JWSSignatureRequestDto other = (JWSSignatureRequestDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$dataToSign = this.getDataToSign();
        String other$dataToSign = other.getDataToSign();
        if (this$dataToSign == null ? other$dataToSign != null : !this$dataToSign.equals(other$dataToSign)) {
            return false;
        }
        String this$applicationId = this.getApplicationId();
        String other$applicationId = other.getApplicationId();
        if (this$applicationId == null ? other$applicationId != null : !this$applicationId.equals(other$applicationId)) {
            return false;
        }
        String this$referenceId = this.getReferenceId();
        String other$referenceId = other.getReferenceId();
        if (this$referenceId == null ? other$referenceId != null : !this$referenceId.equals(other$referenceId)) {
            return false;
        }
        Boolean this$includePayload = this.getIncludePayload();
        Boolean other$includePayload = other.getIncludePayload();
        if (this$includePayload == null ? other$includePayload != null : !((Object)this$includePayload).equals(other$includePayload)) {
            return false;
        }
        Boolean this$includeCertificate = this.getIncludeCertificate();
        Boolean other$includeCertificate = other.getIncludeCertificate();
        if (this$includeCertificate == null ? other$includeCertificate != null : !((Object)this$includeCertificate).equals(other$includeCertificate)) {
            return false;
        }
        Boolean this$includeCertHash = this.getIncludeCertHash();
        Boolean other$includeCertHash = other.getIncludeCertHash();
        if (this$includeCertHash == null ? other$includeCertHash != null : !((Object)this$includeCertHash).equals(other$includeCertHash)) {
            return false;
        }
        String this$certificateUrl = this.getCertificateUrl();
        String other$certificateUrl = other.getCertificateUrl();
        if (this$certificateUrl == null ? other$certificateUrl != null : !this$certificateUrl.equals(other$certificateUrl)) {
            return false;
        }
        Boolean this$validateJson = this.getValidateJson();
        Boolean other$validateJson = other.getValidateJson();
        if (this$validateJson == null ? other$validateJson != null : !((Object)this$validateJson).equals(other$validateJson)) {
            return false;
        }
        Boolean this$b64JWSHeaderParam = this.getB64JWSHeaderParam();
        Boolean other$b64JWSHeaderParam = other.getB64JWSHeaderParam();
        if (this$b64JWSHeaderParam == null ? other$b64JWSHeaderParam != null : !((Object)this$b64JWSHeaderParam).equals(other$b64JWSHeaderParam)) {
            return false;
        }
        String this$signAlgorithm = this.getSignAlgorithm();
        String other$signAlgorithm = other.getSignAlgorithm();
        return !(this$signAlgorithm == null ? other$signAlgorithm != null : !this$signAlgorithm.equals(other$signAlgorithm));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JWSSignatureRequestDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $dataToSign = this.getDataToSign();
        result = result * 59 + ($dataToSign == null ? 43 : $dataToSign.hashCode());
        String $applicationId = this.getApplicationId();
        result = result * 59 + ($applicationId == null ? 43 : $applicationId.hashCode());
        String $referenceId = this.getReferenceId();
        result = result * 59 + ($referenceId == null ? 43 : $referenceId.hashCode());
        Boolean $includePayload = this.getIncludePayload();
        result = result * 59 + ($includePayload == null ? 43 : ((Object)$includePayload).hashCode());
        Boolean $includeCertificate = this.getIncludeCertificate();
        result = result * 59 + ($includeCertificate == null ? 43 : ((Object)$includeCertificate).hashCode());
        Boolean $includeCertHash = this.getIncludeCertHash();
        result = result * 59 + ($includeCertHash == null ? 43 : ((Object)$includeCertHash).hashCode());
        String $certificateUrl = this.getCertificateUrl();
        result = result * 59 + ($certificateUrl == null ? 43 : $certificateUrl.hashCode());
        Boolean $validateJson = this.getValidateJson();
        result = result * 59 + ($validateJson == null ? 43 : ((Object)$validateJson).hashCode());
        Boolean $b64JWSHeaderParam = this.getB64JWSHeaderParam();
        result = result * 59 + ($b64JWSHeaderParam == null ? 43 : ((Object)$b64JWSHeaderParam).hashCode());
        String $signAlgorithm = this.getSignAlgorithm();
        result = result * 59 + ($signAlgorithm == null ? 43 : $signAlgorithm.hashCode());
        return result;
    }

    public String toString() {
        return "JWSSignatureRequestDto(dataToSign=" + this.getDataToSign() + ", applicationId=" + this.getApplicationId() + ", referenceId=" + this.getReferenceId() + ", includePayload=" + this.getIncludePayload() + ", includeCertificate=" + this.getIncludeCertificate() + ", includeCertHash=" + this.getIncludeCertHash() + ", certificateUrl=" + this.getCertificateUrl() + ", validateJson=" + this.getValidateJson() + ", b64JWSHeaderParam=" + this.getB64JWSHeaderParam() + ", signAlgorithm=" + this.getSignAlgorithm() + ")";
    }

    public JWSSignatureRequestDto() {
    }

    public JWSSignatureRequestDto(String dataToSign, String applicationId, String referenceId, Boolean includePayload, Boolean includeCertificate, Boolean includeCertHash, String certificateUrl, Boolean validateJson, Boolean b64JWSHeaderParam, String signAlgorithm) {
        this.dataToSign = dataToSign;
        this.applicationId = applicationId;
        this.referenceId = referenceId;
        this.includePayload = includePayload;
        this.includeCertificate = includeCertificate;
        this.includeCertHash = includeCertHash;
        this.certificateUrl = certificateUrl;
        this.validateJson = validateJson;
        this.b64JWSHeaderParam = b64JWSHeaderParam;
        this.signAlgorithm = signAlgorithm;
    }
}

