/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.lkeymanager.exception;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.mosip.kernel.core.exception.ServiceError;
import io.mosip.kernel.core.http.ResponseWrapper;
import io.mosip.kernel.core.util.EmptyCheckUtils;
import io.mosip.kernel.lkeymanager.constant.LicenseKeyManagerErrorCodes;
import io.mosip.kernel.lkeymanager.exception.InvalidArgumentsException;
import io.mosip.kernel.lkeymanager.exception.LicenseKeyServiceException;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.util.ContentCachingRequestWrapper;

@RestControllerAdvice
public class LicenseKeyControllerAdvice {
    @Autowired
    private ObjectMapper objectMapper;

    @ExceptionHandler(value={InvalidArgumentsException.class})
    public ResponseEntity<ResponseWrapper<ServiceError>> validateInputArguments(HttpServletRequest httpServletRequest, InvalidArgumentsException exception) throws IOException {
        ResponseWrapper errorResponse = this.setErrors(httpServletRequest);
        errorResponse.getErrors().addAll(exception.getList());
        return new ResponseEntity((Object)errorResponse, HttpStatus.OK);
    }

    @ExceptionHandler(value={LicenseKeyServiceException.class})
    public ResponseEntity<ResponseWrapper<ServiceError>> handleServiceException(HttpServletRequest httpServletRequest, LicenseKeyServiceException exception) throws IOException {
        ResponseWrapper errorResponse = this.setErrors(httpServletRequest);
        errorResponse.getErrors().addAll(exception.getList());
        return new ResponseEntity((Object)errorResponse, HttpStatus.OK);
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public ResponseEntity<ResponseWrapper<ServiceError>> onHttpMessageNotReadable(HttpServletRequest httpServletRequest, HttpMessageNotReadableException exception) throws IOException {
        ResponseWrapper responseWrapper = this.setErrors(httpServletRequest);
        ServiceError error = new ServiceError(LicenseKeyManagerErrorCodes.HTTP_MESSAGE_NOT_READABLE.getErrorCode(), exception.getMessage());
        responseWrapper.getErrors().add(error);
        return new ResponseEntity((Object)responseWrapper, HttpStatus.OK);
    }

    @ExceptionHandler(value={Exception.class, RuntimeException.class})
    public ResponseEntity<ResponseWrapper<ServiceError>> defaultErrorHandler(HttpServletRequest httpServletRequest, Exception exception) throws IOException {
        ResponseWrapper errorResponse = this.setErrors(httpServletRequest);
        ServiceError error = new ServiceError(LicenseKeyManagerErrorCodes.RUNTIME_EXCEPTION.getErrorCode(), exception.getMessage());
        errorResponse.getErrors().add(error);
        return new ResponseEntity((Object)errorResponse, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    private ResponseWrapper<ServiceError> setErrors(HttpServletRequest httpServletRequest) throws IOException {
        ResponseWrapper responseWrapper = new ResponseWrapper();
        String requestBody = null;
        if (httpServletRequest instanceof ContentCachingRequestWrapper) {
            requestBody = new String(((ContentCachingRequestWrapper)httpServletRequest).getContentAsByteArray());
        }
        if (EmptyCheckUtils.isNullEmpty(requestBody)) {
            return responseWrapper;
        }
        this.objectMapper.registerModule((Module)new JavaTimeModule());
        JsonNode reqNode = this.objectMapper.readTree(requestBody);
        responseWrapper.setId(reqNode.path("id").asText());
        responseWrapper.setVersion(reqNode.path("version").asText());
        return responseWrapper;
    }
}

