/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.keymanager.softhsm.util;

import io.mosip.kernel.core.keymanager.exception.KeystoreProcessingException;
import io.mosip.kernel.keymanager.softhsm.constant.KeymanagerErrorCode;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import sun.security.x509.AlgorithmId;
import sun.security.x509.CertificateAlgorithmId;
import sun.security.x509.CertificateSerialNumber;
import sun.security.x509.CertificateValidity;
import sun.security.x509.CertificateVersion;
import sun.security.x509.CertificateX509Key;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;

public class CertificateUtility {
    private CertificateUtility() {
    }

    public static X509Certificate generateX509Certificate(KeyPair keyPair, String commonName, String organizationalUnit, String organization, String country, LocalDateTime validityFrom, LocalDateTime validityTo) {
        X509CertImpl cert = null;
        try {
            X500Name distinguishedName = new X500Name(commonName, organizationalUnit, organization, country);
            PrivateKey privkey = keyPair.getPrivate();
            X509CertInfo info = new X509CertInfo();
            CertificateValidity interval = CertificateUtility.setCertificateValidity(validityFrom, validityTo);
            BigInteger sn = new BigInteger(64, new SecureRandom());
            info.set("validity", interval);
            info.set("serialNumber", new CertificateSerialNumber(sn));
            info.set("subject", distinguishedName);
            info.set("issuer", distinguishedName);
            info.set("key", new CertificateX509Key(keyPair.getPublic()));
            info.set("version", new CertificateVersion(2));
            AlgorithmId algo = new AlgorithmId(AlgorithmId.md5WithRSAEncryption_oid);
            info.set("algorithmID", new CertificateAlgorithmId(algo));
            cert = CertificateUtility.signCertificate(privkey, info);
            algo = (AlgorithmId)cert.get("x509.algorithm");
            info.set("algorithmID.algorithm", algo);
            cert = CertificateUtility.signCertificate(privkey, info);
        }
        catch (IOException | CertificateException e) {
            throw new KeystoreProcessingException(KeymanagerErrorCode.CERTIFICATE_PROCESSING_ERROR.getErrorCode(), KeymanagerErrorCode.CERTIFICATE_PROCESSING_ERROR.getErrorMessage() + e.getMessage(), (Throwable)e);
        }
        return cert;
    }

    private static X509CertImpl signCertificate(PrivateKey privkey, X509CertInfo info) {
        X509CertImpl cert = new X509CertImpl(info);
        try {
            cert.sign(privkey, "SHA1withRSA");
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | CertificateException e) {
            throw new KeystoreProcessingException(KeymanagerErrorCode.CERTIFICATE_PROCESSING_ERROR.getErrorCode(), KeymanagerErrorCode.CERTIFICATE_PROCESSING_ERROR.getErrorMessage() + e.getMessage(), (Throwable)e);
        }
        return cert;
    }

    private static CertificateValidity setCertificateValidity(LocalDateTime validityFrom, LocalDateTime validityTo) {
        return new CertificateValidity(Timestamp.valueOf(validityFrom), Timestamp.valueOf(validityTo));
    }
}

