/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.keymanager.softhsm.impl;

import io.mosip.kernel.core.keymanager.exception.KeystoreProcessingException;
import io.mosip.kernel.core.keymanager.exception.NoSuchSecurityProviderException;
import io.mosip.kernel.keymanager.softhsm.constant.KeymanagerErrorCode;
import io.mosip.kernel.keymanager.softhsm.util.CertificateUtility;
import java.io.IOException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.Security;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.crypto.SecretKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import sun.security.pkcs11.SunPKCS11;

@Component
public class KeyStoreImpl
implements io.mosip.kernel.core.keymanager.spi.KeyStore,
InitializingBean {
    @Value(value="${mosip.kernel.keymanager.softhsm.certificate.common-name}")
    private String commonName;
    @Value(value="${mosip.kernel.keymanager.softhsm.certificate.organizational-unit}")
    private String organizationalUnit;
    @Value(value="${mosip.kernel.keymanager.softhsm.certificate.organization}")
    private String organization;
    @Value(value="${mosip.kernel.keymanager.softhsm.certificate.country}")
    private String country;
    @Value(value="${mosip.kernel.keymanager.softhsm.config-path}")
    private String configPath;
    @Value(value="${mosip.kernel.keymanager.softhsm.keystore-type}")
    private String keystoreType;
    @Value(value="${mosip.kernel.keymanager.softhsm.keystore-pass}")
    private String keystorePass;
    private KeyStore keyStore;

    public void afterPropertiesSet() throws Exception {
        Provider provider = this.setupProvider(this.configPath);
        this.addProvider(provider);
        BouncyCastleProvider bouncyCastleProvider = new BouncyCastleProvider();
        Security.addProvider((Provider)bouncyCastleProvider);
        this.keyStore = this.getKeystoreInstance(this.keystoreType, provider);
        this.loadKeystore();
    }

    private Provider setupProvider(String configPath) {
        SunPKCS11 provider = null;
        try {
            provider = new SunPKCS11(configPath);
        }
        catch (ProviderException providerException) {
            throw new NoSuchSecurityProviderException(KeymanagerErrorCode.INVALID_CONFIG_FILE.getErrorCode(), KeymanagerErrorCode.INVALID_CONFIG_FILE.getErrorMessage(), (Throwable)providerException);
        }
        return provider;
    }

    private void addProvider(Provider provider) {
        if (-1 == Security.addProvider(provider)) {
            throw new NoSuchSecurityProviderException(KeymanagerErrorCode.NO_SUCH_SECURITY_PROVIDER.getErrorCode(), KeymanagerErrorCode.NO_SUCH_SECURITY_PROVIDER.getErrorMessage());
        }
    }

    private KeyStore getKeystoreInstance(String keystoreType, Provider provider) {
        KeyStore mosipKeyStore = null;
        try {
            mosipKeyStore = KeyStore.getInstance(keystoreType, provider);
        }
        catch (KeyStoreException e) {
            throw new KeystoreProcessingException(KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorCode(), KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorMessage() + e.getMessage(), (Throwable)e);
        }
        return mosipKeyStore;
    }

    private void loadKeystore() {
        try {
            this.keyStore.load(null, this.keystorePass.toCharArray());
        }
        catch (IOException | NoSuchAlgorithmException | CertificateException e) {
            throw new KeystoreProcessingException(KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorCode(), KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorMessage() + e.getMessage(), (Throwable)e);
        }
    }

    public List<String> getAllAlias() {
        Enumeration<String> enumeration = null;
        try {
            enumeration = this.keyStore.aliases();
        }
        catch (KeyStoreException e) {
            throw new KeystoreProcessingException(KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorCode(), KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorMessage() + e.getMessage(), (Throwable)e);
        }
        return Collections.list(enumeration);
    }

    public Key getKey(String alias) {
        Key key = null;
        try {
            key = this.keyStore.getKey(alias, this.keystorePass.toCharArray());
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new KeystoreProcessingException(KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorCode(), KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorMessage() + e.getMessage(), (Throwable)e);
        }
        return key;
    }

    public KeyStore.PrivateKeyEntry getAsymmetricKey(String alias) {
        KeyStore.PrivateKeyEntry privateKeyEntry = null;
        try {
            if (!this.keyStore.entryInstanceOf(alias, KeyStore.PrivateKeyEntry.class)) {
                throw new NoSuchSecurityProviderException(KeymanagerErrorCode.NO_SUCH_ALIAS.getErrorCode(), KeymanagerErrorCode.NO_SUCH_ALIAS.getErrorMessage() + alias);
            }
            KeyStore.PasswordProtection password = new KeyStore.PasswordProtection(this.keystorePass.toCharArray());
            privateKeyEntry = (KeyStore.PrivateKeyEntry)this.keyStore.getEntry(alias, password);
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableEntryException e) {
            throw new KeystoreProcessingException(KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorCode(), KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorMessage() + e.getMessage(), (Throwable)e);
        }
        return privateKeyEntry;
    }

    public PrivateKey getPrivateKey(String alias) {
        KeyStore.PrivateKeyEntry privateKeyEntry = this.getAsymmetricKey(alias);
        return privateKeyEntry.getPrivateKey();
    }

    public PublicKey getPublicKey(String alias) {
        KeyStore.PrivateKeyEntry privateKeyEntry = this.getAsymmetricKey(alias);
        Certificate[] certificates = privateKeyEntry.getCertificateChain();
        return certificates[0].getPublicKey();
    }

    public X509Certificate getCertificate(String alias) {
        KeyStore.PrivateKeyEntry privateKeyEntry = this.getAsymmetricKey(alias);
        X509Certificate[] certificates = (X509Certificate[])privateKeyEntry.getCertificateChain();
        return certificates[0];
    }

    public void storeAsymmetricKey(KeyPair keyPair, String alias, LocalDateTime validityFrom, LocalDateTime validityTo) {
        Certificate[] chain = new X509Certificate[]{CertificateUtility.generateX509Certificate(keyPair, this.commonName, this.organizationalUnit, this.organization, this.country, validityFrom, validityTo)};
        this.storeCertificate(alias, chain, keyPair.getPrivate());
    }

    public SecretKey getSymmetricKey(String alias) {
        SecretKey secretKey = null;
        try {
            if (!this.keyStore.entryInstanceOf(alias, KeyStore.SecretKeyEntry.class)) {
                throw new NoSuchSecurityProviderException(KeymanagerErrorCode.NO_SUCH_ALIAS.getErrorCode(), KeymanagerErrorCode.NO_SUCH_ALIAS.getErrorMessage() + alias);
            }
            KeyStore.PasswordProtection password = new KeyStore.PasswordProtection(this.keystorePass.toCharArray());
            KeyStore.SecretKeyEntry retrivedSecret = (KeyStore.SecretKeyEntry)this.keyStore.getEntry(alias, password);
            secretKey = retrivedSecret.getSecretKey();
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableEntryException e) {
            throw new KeystoreProcessingException(KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorCode(), KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorMessage() + e.getMessage(), (Throwable)e);
        }
        return secretKey;
    }

    public void storeSymmetricKey(SecretKey secretKey, String alias) {
        KeyStore.SecretKeyEntry secret = new KeyStore.SecretKeyEntry(secretKey);
        KeyStore.PasswordProtection password = new KeyStore.PasswordProtection(this.keystorePass.toCharArray());
        try {
            this.keyStore.setEntry(alias, secret, password);
            this.keyStore.store(null, this.keystorePass.toCharArray());
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new KeystoreProcessingException(KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorCode(), KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorMessage() + e.getMessage(), (Throwable)e);
        }
    }

    public void deleteKey(String alias) {
        try {
            this.keyStore.deleteEntry(alias);
        }
        catch (KeyStoreException e) {
            throw new KeystoreProcessingException(KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorCode(), KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorMessage() + e.getMessage(), (Throwable)e);
        }
    }

    public void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    public void storeCertificate(String alias, Certificate[] chain, PrivateKey privateKey) {
        KeyStore.PrivateKeyEntry privateKeyEntry = new KeyStore.PrivateKeyEntry(privateKey, chain);
        KeyStore.PasswordProtection password = new KeyStore.PasswordProtection(this.keystorePass.toCharArray());
        try {
            this.keyStore.setEntry(alias, privateKeyEntry, password);
            this.keyStore.store(null, this.keystorePass.toCharArray());
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new KeystoreProcessingException(KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorCode(), KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorMessage() + e.getMessage());
        }
    }
}

