/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.zkcryptoservice.controller;

import io.mosip.kernel.core.http.RequestWrapper;
import io.mosip.kernel.core.http.ResponseFilter;
import io.mosip.kernel.core.http.ResponseWrapper;
import io.mosip.kernel.zkcryptoservice.dto.ReEncryptRandomKeyResponseDto;
import io.mosip.kernel.zkcryptoservice.dto.ZKCryptoRequestDto;
import io.mosip.kernel.zkcryptoservice.dto.ZKCryptoResponseDto;
import io.mosip.kernel.zkcryptoservice.service.spi.ZKCryptoManagerService;
import io.swagger.annotations.ApiParam;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin
@RestController
@Tag(name="zkcryptomanager", description="Operation related to Zero Knowledge Encryption and Decryption")
public class ZKCryptoManagerController {
    @Autowired
    ZKCryptoManagerService zkCryptoManagerService;

    @Operation(summary="Endpoint for Encrypt the data", description="Endpoint for Encrypt the data", tags={"zkcryptomanager"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success or you may find errors in error array in response"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(hidden=true))})})
    @PreAuthorize(value="hasAnyRole(@zkAuthRoles.getPostzkencrypt())")
    @ResponseFilter
    @PostMapping(value={"/zkEncrypt"}, produces={"application/json"})
    public ResponseWrapper<ZKCryptoResponseDto> zkEncrypt(@ApiParam(value="List of ZK Data Attributes to Encrypt.") @RequestBody @Valid RequestWrapper<ZKCryptoRequestDto> zkCryptoRequestDto) {
        ResponseWrapper response = new ResponseWrapper();
        response.setResponse((Object)this.zkCryptoManagerService.zkEncrypt((ZKCryptoRequestDto)zkCryptoRequestDto.getRequest()));
        return response;
    }

    @Operation(summary="Endpoint for Decrypt the data", description="Endpoint for Decrypt the data", tags={"zkcryptomanager"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success or you may find errors in error array in response"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(hidden=true))})})
    @PreAuthorize(value="hasAnyRole(@zkAuthRoles.getPostzkdecrypt())")
    @ResponseFilter
    @PostMapping(value={"/zkDecrypt"}, produces={"application/json"})
    public ResponseWrapper<ZKCryptoResponseDto> zkDecrypt(@ApiParam(value="List of ZK Data Attributes to Decrypt.") @RequestBody @Valid RequestWrapper<ZKCryptoRequestDto> zkCryptoRequestDto) {
        ResponseWrapper response = new ResponseWrapper();
        response.setResponse((Object)this.zkCryptoManagerService.zkDecrypt((ZKCryptoRequestDto)zkCryptoRequestDto.getRequest()));
        return response;
    }

    @Operation(summary="Endpoint for Decrypt the data", description="Endpoint for Decrypt the data", tags={"zkcryptomanager"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success or you may find errors in error array in response"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(hidden=true))})})
    @PreAuthorize(value="hasAnyRole(@zkAuthRoles.getPostzkreencryptrandomkey())")
    @ResponseFilter
    @PostMapping(value={"/zkReEncryptRandomKey"}, produces={"application/json"})
    public ResponseWrapper<ReEncryptRandomKeyResponseDto> zkReEncryptRandomKey(@ApiParam(value="Random key to re-encrypt") @RequestParam(value="encryptedKey") String encryptedKey) {
        ResponseWrapper response = new ResponseWrapper();
        response.setResponse((Object)this.zkCryptoManagerService.zkReEncryptRandomKey(encryptedKey));
        return response;
    }
}

