/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.tokenidgenerator.controller;

import io.mosip.kernel.core.http.ResponseFilter;
import io.mosip.kernel.core.http.ResponseWrapper;
import io.mosip.kernel.tokenidgenerator.dto.TokenIDResponseDto;
import io.mosip.kernel.tokenidgenerator.service.TokenIDGeneratorService;
import io.swagger.annotations.ApiParam;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin
@RestController
@Tag(name="tokenidgenerator", description="Operation related to tokenid generator")
public class TokenIDGeneratorController {
    @Autowired
    private TokenIDGeneratorService tokenIDGeneratorService;

    @Operation(summary="Function to generate token id", description="Function to generate token id", tags={"tokenidgenerator"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success or you may find errors in error array in response"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(hidden=true))})})
    @ResponseFilter
    @GetMapping(value={"/tokenid/{uin}/{partnercode}"})
    @PreAuthorize(value="hasAnyRole(@tokenAuthRoles.getGetuinpartnercode())")
    public ResponseWrapper<TokenIDResponseDto> generateTokenID(@ApiParam(value="uin of user") @PathVariable(value="uin") String uin, @ApiParam(value="Partner Code") @PathVariable(value="partnercode") String partnerCode) {
        ResponseWrapper response = new ResponseWrapper();
        response.setResponse((Object)this.tokenIDGeneratorService.generateTokenID(uin.trim(), partnerCode.trim()));
        return response;
    }
}

