/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.signature.util;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.module.afterburner.AfterburnerModule;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.util.Base64;
import com.nimbusds.jose.util.Base64URL;
import io.mosip.kernel.core.logger.spi.Logger;
import io.mosip.kernel.core.util.CryptoUtil;
import io.mosip.kernel.core.util.DateUtils;
import io.mosip.kernel.core.util.HMACUtils2;
import io.mosip.kernel.keymanagerservice.logger.KeymanagerLogger;
import io.mosip.kernel.signature.constant.SignatureConstant;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;

public class SignatureUtil {
    private static final Logger LOGGER = KeymanagerLogger.getLogger(SignatureUtil.class);
    private static ObjectMapper mapper = ((JsonMapper.Builder)JsonMapper.builder().addModule((Module)new AfterburnerModule())).build();

    public static boolean isDataValid(String anyData) {
        return anyData != null && !anyData.trim().isEmpty();
    }

    public static boolean isJsonValid(String jsonInString) {
        try {
            mapper.readTree(jsonInString);
            return true;
        }
        catch (IOException e) {
            LOGGER.error("SignatureSessionId", "JWTSignature", "", "Provided JSON Data to sign is invalid.");
            return false;
        }
    }

    public static boolean isIncludeAttrsValid(Boolean includes) {
        if (Objects.isNull(includes)) {
            return SignatureConstant.DEFAULT_INCLUDES;
        }
        return includes;
    }

    public static boolean isCertificateDatesValid(X509Certificate x509Cert) {
        try {
            Date currentDate = Date.from(DateUtils.getUTCCurrentDateTime().atZone(ZoneId.systemDefault()).toInstant());
            x509Cert.checkValidity(currentDate);
            return true;
        }
        catch (CertificateExpiredException | CertificateNotYetValidException exp) {
            LOGGER.warn("SignatureSessionId", "JWTSignature", "", "Warning thrown when certificate dates are not valid.");
            try {
                x509Cert.checkValidity();
                return true;
            }
            catch (CertificateExpiredException | CertificateNotYetValidException exp2) {
                LOGGER.warn("SignatureSessionId", "JWTSignature", "", "Warning thrown when certificate dates are not valid.");
                return false;
            }
        }
    }

    public static JWSHeader getJWSHeader(String signAlgorithm, boolean b64JWSHeaderParam, boolean includeCertificate, boolean includeCertHash, String certificateUrl, X509Certificate x509Certificate, String uniqueIdentifier, boolean includeKeyId) {
        JWSAlgorithm jwsAlgorithm;
        switch (signAlgorithm) {
            case "RS256": {
                jwsAlgorithm = JWSAlgorithm.RS256;
                break;
            }
            case "PS256": {
                jwsAlgorithm = JWSAlgorithm.PS256;
                break;
            }
            default: {
                jwsAlgorithm = JWSAlgorithm.PS256;
            }
        }
        JWSHeader.Builder jwsHeaderBuilder = new JWSHeader.Builder(jwsAlgorithm);
        if (!b64JWSHeaderParam) {
            jwsHeaderBuilder = jwsHeaderBuilder.base64URLEncodePayload(false).criticalParams(Collections.singleton("b64"));
        }
        if (includeCertificate) {
            try {
                Base64 signCert = Base64.encode((byte[])x509Certificate.getEncoded());
                ArrayList<Base64> x5c = new ArrayList<Base64>();
                x5c.add(signCert);
                jwsHeaderBuilder = jwsHeaderBuilder.x509CertChain(x5c);
            }
            catch (CertificateEncodingException e) {
                LOGGER.warn("SignatureSessionId", "JWSSignature", "", "Warning thrown when certificate not able to parse while adding to jws header.");
            }
        }
        if (includeCertHash) {
            try {
                jwsHeaderBuilder = jwsHeaderBuilder.x509CertSHA256Thumbprint(Base64URL.encode((byte[])DigestUtils.sha256((byte[])x509Certificate.getEncoded())));
            }
            catch (CertificateEncodingException e) {
                LOGGER.warn("SignatureSessionId", "JWSSignature", "", "Warning thrown when certificate not able to parse while adding to jws header.");
            }
        }
        if (Objects.nonNull(certificateUrl)) {
            try {
                jwsHeaderBuilder.x509CertURL(new URI(certificateUrl));
            }
            catch (URISyntaxException e) {
                LOGGER.warn("SignatureSessionId", "JWSSignature", "", "Warning thrown when certificate URI not able to parse while adding to jws header.");
            }
        }
        String keyId = SignatureUtil.convertHexToBase64(uniqueIdentifier);
        if (includeKeyId && Objects.nonNull(keyId)) {
            jwsHeaderBuilder.keyID(keyId);
        }
        return jwsHeaderBuilder.build();
    }

    public static byte[] buildSignData(JWSHeader jwsHeader, byte[] actualDataToSign) {
        byte[] jwsHeaderBytes = jwsHeader.toBase64URL().toString().getBytes(StandardCharsets.UTF_8);
        byte[] jwsSignData = new byte[jwsHeaderBytes.length + actualDataToSign.length + 1];
        System.arraycopy(jwsHeaderBytes, 0, jwsSignData, 0, jwsHeaderBytes.length);
        jwsSignData[jwsHeaderBytes.length] = 46;
        System.arraycopy(actualDataToSign, 0, jwsSignData, jwsHeaderBytes.length + 1, actualDataToSign.length);
        return jwsSignData;
    }

    public static String convertHexToBase64(String anyHexString) {
        try {
            return CryptoUtil.encodeToURLSafeBase64((byte[])HMACUtils2.generateHash((byte[])Hex.decodeHex((String)anyHexString)));
        }
        catch (NoSuchAlgorithmException | DecoderException e) {
            LOGGER.warn("SignatureSessionId", "JWSSignature", "", "Warning thrown when converting hex data to base64 encoded data.");
            return null;
        }
    }
}

