/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.signature.service.impl;

import io.mosip.kernel.core.logger.spi.Logger;
import io.mosip.kernel.core.util.CryptoUtil;
import io.mosip.kernel.keymanagerservice.logger.KeymanagerLogger;
import io.mosip.kernel.signature.constant.SignatureErrorCode;
import io.mosip.kernel.signature.exception.SignatureFailureException;
import io.mosip.kernel.signature.service.SignatureProvider;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;

public class PS256SIgnatureProviderImpl
implements SignatureProvider {
    private static final Logger LOGGER = KeymanagerLogger.getLogger(PS256SIgnatureProviderImpl.class);

    @Override
    public String sign(PrivateKey privateKey, byte[] signData, String providerName) {
        try {
            Signature signatureObj = Signature.getInstance("RSASSA-PSS", providerName);
            PSSParameterSpec pssParamSpec = new PSSParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA256, 32, 1);
            signatureObj.setParameter(pssParamSpec);
            signatureObj.initSign(privateKey);
            signatureObj.update(signData);
            return CryptoUtil.encodeToURLSafeBase64((byte[])signatureObj.sign());
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException e) {
            LOGGER.error("SignatureSessionId", "JWSSignature", "", "Error while signing the data.");
            throw new SignatureFailureException(SignatureErrorCode.SIGN_ERROR.getErrorCode(), SignatureErrorCode.SIGN_ERROR.getErrorMessage(), e);
        }
    }
}

