/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.partnercertservice.service.impl;

import io.mosip.kernel.core.keymanager.model.CertificateParameters;
import io.mosip.kernel.core.keymanager.spi.KeyStore;
import io.mosip.kernel.core.logger.spi.Logger;
import io.mosip.kernel.core.util.CryptoUtil;
import io.mosip.kernel.core.util.DateUtils;
import io.mosip.kernel.cryptomanager.util.CryptomanagerUtils;
import io.mosip.kernel.keymanager.hsm.util.CertificateUtility;
import io.mosip.kernel.keymanagerservice.dto.SignatureCertificate;
import io.mosip.kernel.keymanagerservice.entity.PartnerCertificateStore;
import io.mosip.kernel.keymanagerservice.exception.KeymanagerServiceException;
import io.mosip.kernel.keymanagerservice.logger.KeymanagerLogger;
import io.mosip.kernel.keymanagerservice.service.KeymanagerService;
import io.mosip.kernel.keymanagerservice.util.KeymanagerUtil;
import io.mosip.kernel.partnercertservice.constant.PartnerCertManagerErrorConstants;
import io.mosip.kernel.partnercertservice.dto.CACertificateRequestDto;
import io.mosip.kernel.partnercertservice.dto.CACertificateResponseDto;
import io.mosip.kernel.partnercertservice.dto.CertificateTrustRequestDto;
import io.mosip.kernel.partnercertservice.dto.CertificateTrustResponeDto;
import io.mosip.kernel.partnercertservice.dto.PartnerCertDownloadRequestDto;
import io.mosip.kernel.partnercertservice.dto.PartnerCertDownloadResponeDto;
import io.mosip.kernel.partnercertservice.dto.PartnerCertificateRequestDto;
import io.mosip.kernel.partnercertservice.dto.PartnerCertificateResponseDto;
import io.mosip.kernel.partnercertservice.dto.PartnerSignedCertDownloadResponseDto;
import io.mosip.kernel.partnercertservice.exception.PartnerCertManagerException;
import io.mosip.kernel.partnercertservice.helper.PartnerCertManagerDBHelper;
import io.mosip.kernel.partnercertservice.service.spi.PartnerCertificateManagerService;
import io.mosip.kernel.partnercertservice.util.PartnerCertificateManagerUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.security.auth.x500.X500Principal;
import org.cache2k.Cache;
import org.cache2k.Cache2kBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class PartnerCertificateManagerServiceImpl
implements PartnerCertificateManagerService {
    private static final Logger LOGGER = KeymanagerLogger.getLogger(PartnerCertificateManagerServiceImpl.class);
    @Value(value="${mosip.kernel.partner.sign.masterkey.application.id}")
    private String masterSignKeyAppId;
    @Value(value="${mosip.kernel.partner.allowed.domains}")
    private String partnerAllowedDomains;
    @Value(value="${mosip.kernel.certificate.sign.algorithm:SHA256withRSA}")
    private String signAlgorithm;
    @Value(value="${mosip.kernel.partner.issuer.certificate.duration.years:1}")
    private int issuerCertDuration;
    @Value(value="${mosip.kernel.partner.issuer.certificate.allowed.grace.duration:30}")
    private int gracePeriod;
    @Value(value="${mosip.kernel.partner.truststore.cache.expire.inMins:120}")
    private long cacheExpireInMins;
    @Value(value="${mosip.kernel.partner.resign.ftm.domain.certs:false}")
    private boolean resignFTMDomainCerts;
    @Value(value="${mosip.kernel.partner.truststore.cache.disable:false}")
    private boolean disableTrustStoreCache;
    @Autowired
    KeymanagerUtil keymanagerUtil;
    @Autowired
    PartnerCertManagerDBHelper certDBHelper;
    @Autowired
    private KeyStore keyStore;
    @Autowired
    private KeymanagerService keymanagerService;
    private Cache<String, Object> caCertTrustStore = null;
    @Autowired
    CryptomanagerUtils cryptomanagerUtil;

    @PostConstruct
    public void init() {
        if (!this.disableTrustStoreCache) {
            this.caCertTrustStore = new Cache2kBuilder<String, Object>(){}.name("caCertTrustStore-" + this.hashCode()).expireAfterWrite(this.cacheExpireInMins, TimeUnit.MINUTES).entryCapacity(10L).refreshAhead(true).loaderThreadCount(1).loader(partnerDomain -> {
                LOGGER.info("pcSessionId", "", "", "Loading CA TrustStore Cache for partnerDomain: " + partnerDomain);
                return this.certDBHelper.getTrustAnchors((String)partnerDomain);
            }).build();
        }
    }

    @Override
    public CACertificateResponseDto uploadCACertificate(CACertificateRequestDto caCertRequestDto) {
        LOGGER.info("pcSessionId", "UploadCACertificate", "", "Uploading CA/Sub-CA Certificate.");
        String certificateData = caCertRequestDto.getCertificateData();
        if (!this.keymanagerUtil.isValidCertificateData(certificateData)) {
            LOGGER.error("pcSessionId", "UploadCACertificate", "", "Invalid Certificate Data provided to upload the ca/sub-ca certificate.");
            throw new PartnerCertManagerException(PartnerCertManagerErrorConstants.INVALID_CERTIFICATE.getErrorCode(), PartnerCertManagerErrorConstants.INVALID_CERTIFICATE.getErrorMessage());
        }
        List<Certificate> certList = this.parseCertificateData(certificateData);
        int certsCount = certList.size();
        LOGGER.info("pcSessionId", "UploadCACertificate", "", "Number of Certificates inputed: " + certsCount);
        String partnerDomain = this.validateAllowedDomains(caCertRequestDto.getPartnerDomain());
        boolean foundError = false;
        boolean uploadedCert = false;
        for (Certificate cert : certList) {
            X509Certificate reqX509Cert = (X509Certificate)cert;
            String certThumbprint = PartnerCertificateManagerUtil.getCertificateThumbprint(reqX509Cert);
            boolean certExist = this.certDBHelper.isCertificateExist(certThumbprint, partnerDomain);
            if (certExist) {
                LOGGER.info("pcSessionId", "UploadCACertificate", "", "CA/sub-CA certificate already exists in Store.");
                if (certsCount == 1) {
                    throw new PartnerCertManagerException(PartnerCertManagerErrorConstants.CERTIFICATE_EXIST_ERROR.getErrorCode(), PartnerCertManagerErrorConstants.CERTIFICATE_EXIST_ERROR.getErrorMessage());
                }
                foundError = true;
                continue;
            }
            boolean validDates = PartnerCertificateManagerUtil.isCertificateDatesValid(reqX509Cert);
            if (!validDates) {
                LOGGER.info("pcSessionId", "UploadCACertificate", "", "Certificate Dates are not valid.");
                if (certsCount == 1) {
                    throw new PartnerCertManagerException(PartnerCertManagerErrorConstants.CERTIFICATE_DATES_NOT_VALID.getErrorCode(), PartnerCertManagerErrorConstants.CERTIFICATE_DATES_NOT_VALID.getErrorMessage());
                }
                foundError = true;
                continue;
            }
            String certSubject = PartnerCertificateManagerUtil.formatCertificateDN(reqX509Cert.getSubjectX500Principal().getName());
            String certIssuer = PartnerCertificateManagerUtil.formatCertificateDN(reqX509Cert.getIssuerX500Principal().getName());
            boolean selfSigned = PartnerCertificateManagerUtil.isSelfSignedCertificate(reqX509Cert);
            if (selfSigned) {
                LOGGER.info("pcSessionId", "UploadCACertificate", "", "Adding Self-signed Certificate in store.");
                String certId = UUID.randomUUID().toString();
                this.certDBHelper.storeCACertificate(certId, certSubject, certIssuer, certId, reqX509Cert, certThumbprint, partnerDomain);
                uploadedCert = true;
            } else {
                LOGGER.info("pcSessionId", "UploadCACertificate", "", "Adding Intermediate Certificates in store.");
                boolean certValid = this.validateCertificatePath(reqX509Cert, partnerDomain);
                if (!certValid) {
                    LOGGER.info("pcSessionId", "UploadCACertificate", "", "Sub-CA Certificate not allowed to upload as root CA is not available.");
                    if (certsCount == 1) {
                        throw new PartnerCertManagerException(PartnerCertManagerErrorConstants.ROOT_CA_NOT_FOUND.getErrorCode(), PartnerCertManagerErrorConstants.ROOT_CA_NOT_FOUND.getErrorMessage());
                    }
                    foundError = true;
                    continue;
                }
                String issuerId = this.certDBHelper.getIssuerCertId(certIssuer);
                String certId = UUID.randomUUID().toString();
                this.certDBHelper.storeCACertificate(certId, certSubject, certIssuer, issuerId, reqX509Cert, certThumbprint, partnerDomain);
                uploadedCert = true;
            }
            this.purgeCache(partnerDomain);
        }
        CACertificateResponseDto responseDto = new CACertificateResponseDto();
        if (uploadedCert && (certsCount == 1 || !foundError)) {
            responseDto.setStatus("Upload Success.");
        } else if (uploadedCert && foundError) {
            responseDto.setStatus("Partial Upload Success.");
        } else {
            responseDto.setStatus("Upload Failed.");
        }
        responseDto.setTimestamp(DateUtils.getUTCCurrentDateTime());
        return responseDto;
    }

    private List<Certificate> parseCertificateData(String certificateData) {
        ArrayList<Certificate> certList = new ArrayList<Certificate>();
        try {
            X509Certificate reqX509Cert = (X509Certificate)this.keymanagerUtil.convertToCertificate(certificateData);
            certList.add(reqX509Cert);
            return certList;
        }
        catch (KeymanagerServiceException kse) {
            ArrayList<Certificate> arrayList;
            LOGGER.info("pcSessionId", "UploadCACertificate", "", "Ignore this exception, the exception thrown when certificate is not able to parse, may be p7b certificate data inputed.");
            byte[] p7bBytes = CryptoUtil.decodeURLSafeBase64((String)certificateData);
            ByteArrayInputStream certStream = new ByteArrayInputStream(p7bBytes);
            try {
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                Collection<? extends Certificate> p7bCertList = cf.generateCertificates(certStream);
                p7bCertList.forEach(cert -> certList.add((Certificate)cert));
                Collections.reverse(certList);
                arrayList = certList;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        certStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException | CertificateException exp) {
                    LOGGER.error("pcSessionId", new Object[]{"UploadCACertificate", "", "Error Parsing P7B Certificate data.", exp});
                    throw new PartnerCertManagerException(PartnerCertManagerErrorConstants.INVALID_CERTIFICATE.getErrorCode(), PartnerCertManagerErrorConstants.INVALID_CERTIFICATE.getErrorMessage());
                }
            }
            certStream.close();
            return arrayList;
        }
    }

    private String validateAllowedDomains(String partnerDomain) {
        String validPartnerDomain = Stream.of(this.partnerAllowedDomains.split(",")).map(String::trim).filter(allowedDomain -> allowedDomain.equalsIgnoreCase(partnerDomain)).findFirst().orElseThrow(() -> new PartnerCertManagerException(PartnerCertManagerErrorConstants.INVALID_PARTNER_DOMAIN.getErrorCode(), PartnerCertManagerErrorConstants.INVALID_PARTNER_DOMAIN.getErrorMessage()));
        return validPartnerDomain.toUpperCase();
    }

    private List<? extends Certificate> getCertificateTrustPath(X509Certificate reqX509Cert, String partnerDomain) {
        try {
            Map trustStoreMap = !this.disableTrustStoreCache ? (Map)this.caCertTrustStore.get((Object)partnerDomain) : this.certDBHelper.getTrustAnchors(partnerDomain);
            Set rootTrustAnchors = (Set)trustStoreMap.get("TrustRoot");
            Set interCerts = (Set)trustStoreMap.get("TrustInter");
            LOGGER.info("pcSessionId", "CertTrustPathValidation", "", "Certificate Trust Path Validation for domain: " + partnerDomain);
            LOGGER.info("pcSessionId", "CertTrustPathValidation", "", "Total Number of ROOT Trust Found: " + rootTrustAnchors.size());
            LOGGER.info("pcSessionId", "CertTrustPathValidation", "", "Total Number of INTERMEDIATE Trust Found: " + interCerts.size());
            X509CertSelector certToVerify = new X509CertSelector();
            certToVerify.setCertificate(reqX509Cert);
            PKIXBuilderParameters pkixBuilderParams = new PKIXBuilderParameters(rootTrustAnchors, (CertSelector)certToVerify);
            pkixBuilderParams.setRevocationEnabled(false);
            CertStore interCertStore = CertStore.getInstance("Collection", new CollectionCertStoreParameters(interCerts));
            pkixBuilderParams.addCertStore(interCertStore);
            CertPathBuilder certPathBuilder = CertPathBuilder.getInstance("PKIX");
            PKIXCertPathBuilderResult result = (PKIXCertPathBuilderResult)certPathBuilder.build(pkixBuilderParams);
            X509Certificate rootCert = result.getTrustAnchor().getTrustedCert();
            List<? extends Certificate> certList = result.getCertPath().getCertificates();
            ArrayList<X509Certificate> trustCertList = new ArrayList<X509Certificate>();
            certList.stream().forEach(cert -> trustCertList.add((X509Certificate)cert));
            trustCertList.add(rootCert);
            return trustCertList;
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | CertPathBuilderException exp) {
            LOGGER.debug("pcSessionId", "UploadCACertificate", "", "Ignore this exception, the exception thrown when trust validation failed.");
            return null;
        }
    }

    private boolean validateCertificatePath(X509Certificate reqX509Cert, String partnerDomain) {
        List<? extends Certificate> certList = this.getCertificateTrustPath(reqX509Cert, partnerDomain);
        return Objects.nonNull(certList);
    }

    @Override
    public PartnerCertificateResponseDto uploadPartnerCertificate(PartnerCertificateRequestDto partnerCertRequesteDto) {
        LOGGER.info("pcSessionId", "UploadPartnerCertificate", "", "Uploading Partner Certificate.");
        String certificateData = partnerCertRequesteDto.getCertificateData();
        if (!this.keymanagerUtil.isValidCertificateData(certificateData)) {
            LOGGER.error("pcSessionId", "UploadPartnerCertificate", "", "Invalid Certificate Data provided to upload the partner certificate.");
            throw new PartnerCertManagerException(PartnerCertManagerErrorConstants.INVALID_CERTIFICATE.getErrorCode(), PartnerCertManagerErrorConstants.INVALID_CERTIFICATE.getErrorMessage());
        }
        X509Certificate reqX509Cert = (X509Certificate)this.keymanagerUtil.convertToCertificate(certificateData);
        String certThumbprint = PartnerCertificateManagerUtil.getCertificateThumbprint(reqX509Cert);
        String reqOrgName = partnerCertRequesteDto.getOrganizationName();
        String partnerDomain = this.validateAllowedDomains(partnerCertRequesteDto.getPartnerDomain());
        LOGGER.info("pcSessionId", "UploadPartnerCertificate", "", "Partner certificate upload for domain: " + partnerDomain);
        this.validateBasicPartnerCertParams(reqX509Cert, certThumbprint, reqOrgName, partnerDomain);
        List<? extends Certificate> certList = this.getCertificateTrustPath(reqX509Cert, partnerDomain);
        if (Objects.isNull(certList)) {
            LOGGER.error("pcSessionId", "UploadPartnerCertificate", "", "Partner Certificate not allowed to upload as root CA/Intermediate CAs are not found in trust cert path.");
            throw new PartnerCertManagerException(PartnerCertManagerErrorConstants.ROOT_INTER_CA_NOT_FOUND.getErrorCode(), PartnerCertManagerErrorConstants.ROOT_INTER_CA_NOT_FOUND.getErrorMessage());
        }
        this.validateOtherPartnerCertParams(reqX509Cert, reqOrgName);
        String certSubject = PartnerCertificateManagerUtil.formatCertificateDN(reqX509Cert.getSubjectX500Principal().getName());
        String certIssuer = PartnerCertificateManagerUtil.formatCertificateDN(reqX509Cert.getIssuerX500Principal().getName());
        String issuerId = this.certDBHelper.getIssuerCertId(certIssuer);
        String certId = UUID.randomUUID().toString();
        X509Certificate rootCert = (X509Certificate)this.keymanagerUtil.convertToCertificate(this.keymanagerService.getCertificate("ROOT", Optional.of("")).getCertificate());
        String timestamp = DateUtils.getUTCCurrentDateTimeString();
        SignatureCertificate certificateResponse = this.keymanagerService.getSignatureCertificate(this.masterSignKeyAppId, Optional.of(""), timestamp);
        X509Certificate pmsCert = ((X509Certificate[])certificateResponse.getCertificateEntry().getChain())[0];
        X509Certificate resignedCert = this.reSignPartnerKey(reqX509Cert, certificateResponse, partnerDomain);
        String signedCertData = this.keymanagerUtil.getPEMFormatedData(resignedCert);
        this.certDBHelper.storePartnerCertificate(certId, certSubject, certIssuer, issuerId, reqX509Cert, certThumbprint, reqOrgName, partnerDomain, signedCertData);
        String p7bCertChain = PartnerCertificateManagerUtil.buildP7BCertificateChain(certList, resignedCert, partnerDomain, this.resignFTMDomainCerts, rootCert, pmsCert);
        CACertificateRequestDto caCertReqDto = new CACertificateRequestDto();
        caCertReqDto.setCertificateData(p7bCertChain);
        caCertReqDto.setPartnerDomain(partnerDomain);
        CACertificateResponseDto uploadResponseDto = this.uploadCACertificate(caCertReqDto);
        LOGGER.info("pcSessionId", "UploadPartnerCertificate", "Chain Upload Status: ", uploadResponseDto.getStatus());
        PartnerCertificateResponseDto responseDto = new PartnerCertificateResponseDto();
        responseDto.setCertificateId(certId);
        responseDto.setSignedCertificateData(p7bCertChain);
        responseDto.setTimestamp(DateUtils.getUTCCurrentDateTime());
        return responseDto;
    }

    private void validateBasicPartnerCertParams(X509Certificate reqX509Cert, String certThumbprint, String reqOrgName, String partnerDomain) {
        boolean validDates;
        boolean certExist = this.certDBHelper.isPartnerCertificateExist(certThumbprint, partnerDomain);
        if (certExist) {
            LOGGER.info("pcSessionId", "UploadPartnerCertificate", "", "Partner certificate already exists in Store.");
        }
        if (!(validDates = PartnerCertificateManagerUtil.isCertificateDatesValid(reqX509Cert))) {
            LOGGER.error("pcSessionId", "UploadPartnerCertificate", "", "Certificate Dates are not valid.");
            throw new PartnerCertManagerException(PartnerCertManagerErrorConstants.CERTIFICATE_DATES_NOT_VALID.getErrorCode(), PartnerCertManagerErrorConstants.CERTIFICATE_DATES_NOT_VALID.getErrorMessage());
        }
        boolean validDuration = PartnerCertificateManagerUtil.isCertificateValidForDuration(reqX509Cert, this.issuerCertDuration, this.gracePeriod);
        if (!validDuration) {
            LOGGER.error("pcSessionId", "UploadPartnerCertificate", "", "Certificate Dates are not in allowed range.");
            throw new PartnerCertManagerException(PartnerCertManagerErrorConstants.CERTIFICATE_DATES_NOT_VALID.getErrorCode(), PartnerCertManagerErrorConstants.CERTIFICATE_DATES_NOT_VALID.getErrorMessage());
        }
        boolean selfSigned = PartnerCertificateManagerUtil.isSelfSignedCertificate(reqX509Cert);
        if (selfSigned) {
            LOGGER.error("pcSessionId", "UploadPartnerCertificate", "", "Self Signed Certificate are not in allowed as Partner.");
            throw new PartnerCertManagerException(PartnerCertManagerErrorConstants.SELF_SIGNED_CERT_NOT_ALLOWED.getErrorCode(), PartnerCertManagerErrorConstants.SELF_SIGNED_CERT_NOT_ALLOWED.getErrorMessage());
        }
    }

    private void validateOtherPartnerCertParams(X509Certificate reqX509Cert, String reqOrgName) {
        int keySize;
        int certVersion = reqX509Cert.getVersion();
        if (certVersion != 3) {
            LOGGER.error("pcSessionId", "UploadPartnerCertificate", "", "Partner Certificate version not valid, the version has to be V3");
            throw new PartnerCertManagerException(PartnerCertManagerErrorConstants.INVALID_CERT_VERSION.getErrorCode(), PartnerCertManagerErrorConstants.INVALID_CERT_VERSION.getErrorMessage());
        }
        String certOrgName = PartnerCertificateManagerUtil.getCertificateOrgName(reqX509Cert.getSubjectX500Principal());
        if (certOrgName.equals("")) {
            LOGGER.error("pcSessionId", "UploadPartnerCertificate", "", "Partner Certificate Organization is not available/empty input certificate.");
            throw new PartnerCertManagerException(PartnerCertManagerErrorConstants.PARTNER_ORG_NOT_MATCH.getErrorCode(), PartnerCertManagerErrorConstants.PARTNER_ORG_NOT_MATCH.getErrorMessage());
        }
        if (!certOrgName.equals(reqOrgName)) {
            LOGGER.error("pcSessionId", "UploadPartnerCertificate", "", "Partner Certificate Organization and Partner Organization Name not matching.");
            throw new PartnerCertManagerException(PartnerCertManagerErrorConstants.PARTNER_ORG_NOT_MATCH.getErrorCode(), PartnerCertManagerErrorConstants.PARTNER_ORG_NOT_MATCH.getErrorMessage());
        }
        String keyAlgorithm = reqX509Cert.getPublicKey().getAlgorithm();
        if (keyAlgorithm.equalsIgnoreCase("RSA") && (keySize = ((RSAPublicKey)reqX509Cert.getPublicKey()).getModulus().bitLength()) < 2048) {
            LOGGER.error("pcSessionId", "UploadPartnerCertificate", "", "Partner Certificate key is less than allowed size.");
            throw new PartnerCertManagerException(PartnerCertManagerErrorConstants.CERT_KEY_NOT_ALLOWED.getErrorCode(), PartnerCertManagerErrorConstants.CERT_KEY_NOT_ALLOWED.getErrorMessage());
        }
        String signatureAlgorithm = reqX509Cert.getSigAlgName();
        if (!signatureAlgorithm.toUpperCase().startsWith("SHA2")) {
            LOGGER.error("pcSessionId", "UploadPartnerCertificate", "", "Signature Algorithm not supported.");
            throw new PartnerCertManagerException(PartnerCertManagerErrorConstants.CERT_SIGNATURE_ALGO_NOT_ALLOWED.getErrorCode(), PartnerCertManagerErrorConstants.CERT_SIGNATURE_ALGO_NOT_ALLOWED.getErrorMessage());
        }
    }

    private X509Certificate reSignPartnerKey(X509Certificate reqX509Cert, SignatureCertificate certificateResponse, String partnerDomain) {
        LOGGER.info("pcSessionId", "UploadPartnerCertificate", "KeyAlias", "Found Master Key Alias: " + certificateResponse.getAlias());
        boolean hasAcccess = this.cryptomanagerUtil.hasKeyAccess(this.masterSignKeyAppId);
        if (!hasAcccess) {
            LOGGER.error("pcSessionId", "UploadPartnerCertificate", "", "Signing Certifiate is not allowed for the authenticated user for the provided application id.");
            throw new PartnerCertManagerException(PartnerCertManagerErrorConstants.SIGN_CERT_NOT_ALLOWED.getErrorCode(), PartnerCertManagerErrorConstants.SIGN_CERT_NOT_ALLOWED.getErrorMessage());
        }
        PrivateKey signPrivateKey = (PrivateKey)certificateResponse.getCertificateEntry().getPrivateKey();
        X509Certificate signCert = ((X509Certificate[])certificateResponse.getCertificateEntry().getChain())[0];
        X500Principal signerPrincipal = signCert.getSubjectX500Principal();
        X500Principal subjectPrincipal = reqX509Cert.getSubjectX500Principal();
        PublicKey partnerPublicKey = reqX509Cert.getPublicKey();
        int noOfDays = 365 * this.issuerCertDuration;
        LOGGER.info("pcSessionId", "UploadPartnerCertificate", "Cert Duration", "Calculated Signed Certficiate Number of Days for expire: " + noOfDays);
        LocalDateTime notBeforeDate = DateUtils.getUTCCurrentDateTime();
        LocalDateTime notAfterDate = notBeforeDate.plus(noOfDays, ChronoUnit.DAYS);
        CertificateParameters certParams = PartnerCertificateManagerUtil.getCertificateParameters(subjectPrincipal, notBeforeDate, notAfterDate);
        boolean encKeyUsage = partnerDomain.equalsIgnoreCase("AUTH");
        return CertificateUtility.generateX509Certificate(signPrivateKey, partnerPublicKey, certParams, signerPrincipal, this.signAlgorithm, this.keyStore.getKeystoreProviderName(), encKeyUsage);
    }

    @Override
    public PartnerCertDownloadResponeDto getPartnerCertificate(PartnerCertDownloadRequestDto certDownloadRequestDto) {
        LOGGER.info("pcSessionId", "GetPartnerCertificate", "", "Get Partner Certificate Request.");
        String partnetCertId = certDownloadRequestDto.getPartnerCertId();
        PartnerCertificateStore partnerCertStore = this.getPartnerCertificate(partnetCertId);
        PartnerCertDownloadResponeDto responseDto = new PartnerCertDownloadResponeDto();
        responseDto.setCertificateData(partnerCertStore.getSignedCertData());
        responseDto.setTimestamp(DateUtils.getUTCCurrentDateTime());
        return responseDto;
    }

    @Override
    public CertificateTrustResponeDto verifyCertificateTrust(CertificateTrustRequestDto certificateTrustRequestDto) {
        LOGGER.info("pcSessionId", "CertTrustPathValidation", "", "Certificate Trust Path Validation.");
        String certificateData = certificateTrustRequestDto.getCertificateData();
        if (!this.keymanagerUtil.isValidCertificateData(certificateData)) {
            LOGGER.error("pcSessionId", "UploadPartnerCertificate", "", "Invalid Certificate Data provided to verify partner certificate trust.");
            throw new PartnerCertManagerException(PartnerCertManagerErrorConstants.INVALID_CERTIFICATE.getErrorCode(), PartnerCertManagerErrorConstants.INVALID_CERTIFICATE.getErrorMessage());
        }
        X509Certificate reqX509Cert = (X509Certificate)this.keymanagerUtil.convertToCertificate(certificateData);
        String partnerDomain = this.validateAllowedDomains(certificateTrustRequestDto.getPartnerDomain());
        LOGGER.info("pcSessionId", "CertTrustPathValidation", "", "Certificate Trust Path Validation for domain: " + partnerDomain);
        boolean certValid = this.validateCertificatePath(reqX509Cert, partnerDomain);
        CertificateTrustResponeDto responseDto = new CertificateTrustResponeDto();
        responseDto.setStatus(certValid);
        return responseDto;
    }

    @Override
    public void purgeTrustStoreCache(String partnerDomain) {
        this.purgeCache(partnerDomain);
        LOGGER.info("pcSessionId", "UploadPartnerCertificate", "", "Trust Store Cache Purge for partner domain " + partnerDomain);
    }

    private void purgeCache(String partnerDomain) {
        if (!this.disableTrustStoreCache) {
            this.caCertTrustStore.expireAt((Object)partnerDomain, 0L);
        }
    }

    @Override
    public PartnerSignedCertDownloadResponseDto getPartnerSignedCertificate(PartnerCertDownloadRequestDto certDownloadRequestDto) {
        LOGGER.info("pcSessionId", "GetPartnerCertificate", "", "Get Partner CA Signed Certificate & Mosip Signed Certificate Request.");
        String partnetCertId = certDownloadRequestDto.getPartnerCertId();
        PartnerCertificateStore partnerCertStore = this.getPartnerCertificate(partnetCertId);
        PartnerSignedCertDownloadResponseDto responseDto = new PartnerSignedCertDownloadResponseDto();
        responseDto.setMosipSignedCertificateData(partnerCertStore.getSignedCertData());
        responseDto.setCaSignedCertificateData(partnerCertStore.getCertData());
        responseDto.setTimestamp(DateUtils.getUTCCurrentDateTime());
        LOGGER.info("pcSessionId", "GetPartnerCertificate", "", "Get Partner CA Signed Certificate & Mosip Signed Certificate Request. - Completed");
        return responseDto;
    }

    private PartnerCertificateStore getPartnerCertificate(String partnetCertId) {
        LOGGER.info("pcSessionId", "GetPartnerCertificate", "", "Request to get Certificate for partnerId: " + partnetCertId);
        if (!PartnerCertificateManagerUtil.isValidCertificateID(partnetCertId)) {
            LOGGER.error("pcSessionId", "UploadPartnerCertificate", "", "Invalid Certificate ID provided to get the partner certificate.");
            throw new PartnerCertManagerException(PartnerCertManagerErrorConstants.INVALID_CERTIFICATE_ID.getErrorCode(), PartnerCertManagerErrorConstants.INVALID_CERTIFICATE_ID.getErrorMessage());
        }
        PartnerCertificateStore partnerCertStore = this.certDBHelper.getPartnerCert(partnetCertId);
        if (Objects.isNull(partnerCertStore)) {
            LOGGER.error("pcSessionId", "UploadPartnerCertificate", "", "Partner Certificate not found for the provided ID.");
            throw new PartnerCertManagerException(PartnerCertManagerErrorConstants.PARTNER_CERT_ID_NOT_FOUND.getErrorCode(), PartnerCertManagerErrorConstants.PARTNER_CERT_ID_NOT_FOUND.getErrorMessage());
        }
        return partnerCertStore;
    }
}

