/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.partnercertservice.controller;

import io.mosip.kernel.core.http.RequestWrapper;
import io.mosip.kernel.core.http.ResponseFilter;
import io.mosip.kernel.core.http.ResponseWrapper;
import io.mosip.kernel.partnercertservice.dto.CACertificateRequestDto;
import io.mosip.kernel.partnercertservice.dto.CACertificateResponseDto;
import io.mosip.kernel.partnercertservice.dto.CertificateTrustRequestDto;
import io.mosip.kernel.partnercertservice.dto.CertificateTrustResponeDto;
import io.mosip.kernel.partnercertservice.dto.PartnerCertDownloadRequestDto;
import io.mosip.kernel.partnercertservice.dto.PartnerCertDownloadResponeDto;
import io.mosip.kernel.partnercertservice.dto.PartnerCertificateRequestDto;
import io.mosip.kernel.partnercertservice.dto.PartnerCertificateResponseDto;
import io.mosip.kernel.partnercertservice.dto.PartnerSignedCertDownloadResponseDto;
import io.mosip.kernel.partnercertservice.service.spi.PartnerCertificateManagerService;
import io.swagger.annotations.ApiParam;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin
@RestController
@Tag(name="partnercertmanager", description="Operation related to partner certificate management")
public class PartnerCertManagerController {
    @Autowired
    PartnerCertificateManagerService partnerCertManagerService;

    @Operation(summary="To Upload CA/Sub-CA certificates", description="To Upload CA/Sub-CA certificates", tags={"partnercertmanager"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success or you may find errors in error array in response"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(hidden=true))})})
    @PreAuthorize(value="hasAnyRole(@keyManAuthRoles.getPostuploadcacertificate())")
    @ResponseFilter
    @PostMapping(value={"/uploadCACertificate"}, produces={"application/json"})
    public ResponseWrapper<CACertificateResponseDto> uploadCACertificate(@ApiParam(value="Upload CA/Sub-CA certificates.") @RequestBody @Valid RequestWrapper<CACertificateRequestDto> caCertRequestDto) {
        ResponseWrapper response = new ResponseWrapper();
        response.setResponse((Object)this.partnerCertManagerService.uploadCACertificate((CACertificateRequestDto)caCertRequestDto.getRequest()));
        return response;
    }

    @Operation(summary="To Upload Partner Certificate", description="To Upload Partner Certificate", tags={"partnercertmanager"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success or you may find errors in error array in response"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(hidden=true))})})
    @PreAuthorize(value="hasAnyRole(@keyManAuthRoles.getPostuploadpartnercertificate())")
    @ResponseFilter
    @PostMapping(value={"/uploadPartnerCertificate"}, produces={"application/json"})
    public ResponseWrapper<PartnerCertificateResponseDto> uploadPartnerCertificate(@ApiParam(value="Upload Partner Certificates.") @RequestBody @Valid RequestWrapper<PartnerCertificateRequestDto> partnerCertRequestDto) {
        ResponseWrapper response = new ResponseWrapper();
        response.setResponse((Object)this.partnerCertManagerService.uploadPartnerCertificate((PartnerCertificateRequestDto)partnerCertRequestDto.getRequest()));
        return response;
    }

    @Operation(summary="To Download Partner MOSIP CA Signed Certificate", description="To Download Partner MOSIP CA Signed Certificate", tags={"partnercertmanager"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success or you may find errors in error array in response"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(hidden=true))})})
    @ResponseFilter
    @PreAuthorize(value="hasAnyRole(@keyManAuthRoles.getGetgetpartnercertificatepartnercertid())")
    @GetMapping(value={"/getPartnerCertificate/{partnerCertId}"})
    public ResponseWrapper<PartnerCertDownloadResponeDto> getPartnerCertificate(@ApiParam(value="To download re-signed partner certificate.") @PathVariable(value="partnerCertId") String partnerCertId) {
        PartnerCertDownloadRequestDto certDownloadRequestDto = new PartnerCertDownloadRequestDto();
        certDownloadRequestDto.setPartnerCertId(partnerCertId);
        ResponseWrapper response = new ResponseWrapper();
        response.setResponse((Object)this.partnerCertManagerService.getPartnerCertificate(certDownloadRequestDto));
        return response;
    }

    @Operation(summary="To Upload Partner Certificate", description="To Upload Partner Certificate", tags={"partnercertmanager"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success or you may find errors in error array in response"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(hidden=true))})})
    @ResponseFilter
    @PreAuthorize(value="hasAnyRole(@keyManAuthRoles.getPostverifycertificatetrust())")
    @PostMapping(value={"/verifyCertificateTrust"}, produces={"application/json"})
    public ResponseWrapper<CertificateTrustResponeDto> verifyCertificateTrust(@ApiParam(value="Upload Partner Certificates.") @RequestBody @Valid RequestWrapper<CertificateTrustRequestDto> certificateTrustRequestDto) {
        ResponseWrapper response = new ResponseWrapper();
        response.setResponse((Object)this.partnerCertManagerService.verifyCertificateTrust((CertificateTrustRequestDto)certificateTrustRequestDto.getRequest()));
        return response;
    }

    @Operation(summary="To Download Partner CA Signed Certificate & MOSIP CA Signed Certificate.", description="To Download Partner CA Signed Certificate & MOSIP CA Signed Certificate.", tags={"partnercertmanager"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success or you may find errors in error array in response"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(hidden=true))})})
    @ResponseFilter
    @PreAuthorize(value="hasAnyRole(@keyManAuthRoles.getGetgetpartnersignedcertificatepartnercertid())")
    @GetMapping(value={"/getPartnerSignedCertificate/{partnerCertId}"})
    public ResponseWrapper<PartnerSignedCertDownloadResponseDto> getPartnerSignedCertificate(@ApiParam(value="To download CA Signed partner certificate.") @PathVariable(value="partnerCertId") String partnerCertId) {
        PartnerCertDownloadRequestDto certDownloadRequestDto = new PartnerCertDownloadRequestDto();
        certDownloadRequestDto.setPartnerCertId(partnerCertId);
        ResponseWrapper response = new ResponseWrapper();
        response.setResponse((Object)this.partnerCertManagerService.getPartnerSignedCertificate(certDownloadRequestDto));
        return response;
    }
}

