/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.lkeymanager.service.impl;

import io.mosip.kernel.core.exception.ServiceError;
import io.mosip.kernel.core.licensekeymanager.spi.LicenseKeyManagerService;
import io.mosip.kernel.lkeymanager.constant.LicenseKeyManagerExceptionConstants;
import io.mosip.kernel.lkeymanager.constant.LicenseKeyManagerPropertyConstants;
import io.mosip.kernel.lkeymanager.dto.LicenseKeyGenerationDto;
import io.mosip.kernel.lkeymanager.dto.LicenseKeyMappingDto;
import io.mosip.kernel.lkeymanager.entity.LicenseKeyList;
import io.mosip.kernel.lkeymanager.entity.LicenseKeyPermission;
import io.mosip.kernel.lkeymanager.entity.LicenseKeyTspMap;
import io.mosip.kernel.lkeymanager.exception.InvalidArgumentsException;
import io.mosip.kernel.lkeymanager.exception.LicenseKeyServiceException;
import io.mosip.kernel.lkeymanager.repository.LicenseKeyListRepository;
import io.mosip.kernel.lkeymanager.repository.LicenseKeyPermissionRepository;
import io.mosip.kernel.lkeymanager.repository.LicenseKeyTspMapRepository;
import io.mosip.kernel.lkeymanager.util.LicenseKeyManagerUtil;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class LicenseKeyManagerServiceImpl
implements LicenseKeyManagerService<String, LicenseKeyGenerationDto, LicenseKeyMappingDto> {
    @Autowired
    LicenseKeyManagerUtil licenseKeyManagerUtil;
    @Autowired
    LicenseKeyListRepository licenseKeyListRepository;
    @Autowired
    LicenseKeyPermissionRepository licenseKeyPermissionsRepository;
    @Autowired
    LicenseKeyTspMapRepository licenseKeyTspMapRepository;

    public String generateLicenseKey(LicenseKeyGenerationDto licenseKeyGenerationDto) {
        this.licenseKeyManagerUtil.validateTSP(licenseKeyGenerationDto.getTspId());
        if (licenseKeyGenerationDto.getLicenseExpiryTime().isBefore(LocalDateTime.now(ZoneId.of("UTC")))) {
            ArrayList<ServiceError> errorList = new ArrayList<ServiceError>();
            errorList.add(new ServiceError(LicenseKeyManagerExceptionConstants.DATE_EXPIRED.getErrorCode(), LicenseKeyManagerExceptionConstants.DATE_EXPIRED.getErrorMessage()));
            throw new InvalidArgumentsException(errorList);
        }
        String generatedLicense = this.licenseKeyManagerUtil.generateLicense();
        LicenseKeyList licenseKeyListEntity = new LicenseKeyList();
        LicenseKeyTspMap licenseKeyTspMapEntity = new LicenseKeyTspMap();
        licenseKeyListEntity.setLicenseKey(generatedLicense);
        licenseKeyListEntity.setActive(true);
        licenseKeyListEntity.setCreatedAt(this.licenseKeyManagerUtil.getCurrentTimeInUTCTimeZone());
        licenseKeyListEntity.setExpiryDateTimes(licenseKeyGenerationDto.getLicenseExpiryTime());
        licenseKeyListEntity.setCreatedBy(LicenseKeyManagerPropertyConstants.DEFAULT_CREATED_BY.getValue());
        licenseKeyListEntity.setCreatedDateTimes(this.licenseKeyManagerUtil.getCurrentTimeInUTCTimeZone());
        licenseKeyTspMapEntity.setTspId(licenseKeyGenerationDto.getTspId());
        licenseKeyTspMapEntity.setLKey(generatedLicense);
        licenseKeyTspMapEntity.setActive(true);
        licenseKeyTspMapEntity.setCreatedDateTimes(this.licenseKeyManagerUtil.getCurrentTimeInUTCTimeZone());
        licenseKeyTspMapEntity.setCreatedBy("SYSTEM");
        this.licenseKeyListRepository.saveAndFlush(licenseKeyListEntity);
        this.licenseKeyTspMapRepository.saveAndFlush(licenseKeyTspMapEntity);
        return generatedLicense;
    }

    @Transactional
    public String mapLicenseKey(LicenseKeyMappingDto licenseKeyMappingDto) {
        this.licenseKeyManagerUtil.validateRequestParameters(licenseKeyMappingDto.getTspId(), licenseKeyMappingDto.getLicenseKey(), licenseKeyMappingDto.getPermissions());
        if (this.licenseKeyTspMapRepository.findByLKeyAndTspId(licenseKeyMappingDto.getLicenseKey(), licenseKeyMappingDto.getTspId()) == null) {
            ArrayList<ServiceError> errorList = new ArrayList<ServiceError>();
            errorList.add(new ServiceError(LicenseKeyManagerExceptionConstants.LICENSEKEY_NOT_FOUND.getErrorCode(), LicenseKeyManagerExceptionConstants.LICENSEKEY_NOT_FOUND.getErrorMessage()));
            throw new LicenseKeyServiceException(errorList);
        }
        this.licenseKeyManagerUtil.areValidPermissions(licenseKeyMappingDto.getPermissions());
        LicenseKeyPermission licenseKeyPermissionEntity = new LicenseKeyPermission();
        licenseKeyPermissionEntity.setLKey(licenseKeyMappingDto.getLicenseKey());
        licenseKeyPermissionEntity.setActive(true);
        licenseKeyPermissionEntity.setCreatedDateTimes(this.licenseKeyManagerUtil.getCurrentTimeInUTCTimeZone());
        licenseKeyPermissionEntity.setCreatedBy(LicenseKeyManagerPropertyConstants.DEFAULT_CREATED_BY.getValue());
        LicenseKeyPermission licenseKeyPermission = this.licenseKeyPermissionsRepository.findByLKey(licenseKeyMappingDto.getLicenseKey());
        if (licenseKeyPermission == null) {
            licenseKeyPermissionEntity.setPermission(this.licenseKeyManagerUtil.concatPermissionsIntoASingleRow(licenseKeyMappingDto.getPermissions()));
            this.licenseKeyPermissionsRepository.saveAndFlush(licenseKeyPermissionEntity);
        } else {
            licenseKeyMappingDto.getPermissions().add(licenseKeyPermission.getPermission());
            licenseKeyPermissionEntity.setPermission(this.licenseKeyManagerUtil.concatPermissionsIntoASingleRow(licenseKeyMappingDto.getPermissions()));
            this.licenseKeyPermissionsRepository.updatePermissionList(this.licenseKeyManagerUtil.concatPermissionsIntoASingleRow(licenseKeyMappingDto.getPermissions()), licenseKeyMappingDto.getLicenseKey(), this.licenseKeyManagerUtil.getCurrentTimeInUTCTimeZone(), LicenseKeyManagerPropertyConstants.DEFAULT_CREATED_BY.getValue());
        }
        return LicenseKeyManagerPropertyConstants.MAPPED_STATUS.getValue();
    }

    public List<String> fetchLicenseKeyPermissions(String tspID, String licenseKey) {
        this.licenseKeyManagerUtil.validateTSPAndLicenseKey(tspID, licenseKey);
        if (this.licenseKeyTspMapRepository.findByLKeyAndTspId(licenseKey, tspID) == null) {
            ArrayList<ServiceError> errorList = new ArrayList<ServiceError>();
            errorList.add(new ServiceError(LicenseKeyManagerExceptionConstants.LICENSEKEY_NOT_FOUND.getErrorCode(), LicenseKeyManagerExceptionConstants.LICENSEKEY_NOT_FOUND.getErrorMessage()));
            throw new LicenseKeyServiceException(errorList);
        }
        if (this.licenseKeyManagerUtil.getCurrentTimeInUTCTimeZone().isAfter(this.licenseKeyListRepository.findByLicenseKey(licenseKey).getExpiryDateTimes())) {
            ArrayList<ServiceError> errorList = new ArrayList<ServiceError>();
            errorList.add(new ServiceError(LicenseKeyManagerExceptionConstants.LICENSEKEY_EXPIRED.getErrorCode(), LicenseKeyManagerExceptionConstants.LICENSEKEY_EXPIRED.getErrorMessage()));
            throw new LicenseKeyServiceException(errorList);
        }
        LicenseKeyPermission licenseKeyPermissions = this.licenseKeyPermissionsRepository.findByLKey(licenseKey);
        if (licenseKeyPermissions == null) {
            ArrayList<ServiceError> errorList = new ArrayList<ServiceError>();
            errorList.add(new ServiceError(LicenseKeyManagerExceptionConstants.NO_PERMISSIONS_MAPPED.getErrorCode(), LicenseKeyManagerExceptionConstants.NO_PERMISSIONS_MAPPED.getErrorMessage()));
            throw new LicenseKeyServiceException(errorList);
        }
        return Arrays.asList(licenseKeyPermissions.getPermission().split(","));
    }
}

