/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.lkeymanager.controller;

import io.mosip.kernel.core.http.RequestWrapper;
import io.mosip.kernel.core.http.ResponseFilter;
import io.mosip.kernel.core.http.ResponseWrapper;
import io.mosip.kernel.core.licensekeymanager.spi.LicenseKeyManagerService;
import io.mosip.kernel.lkeymanager.dto.LicenseKeyFetchResponseDto;
import io.mosip.kernel.lkeymanager.dto.LicenseKeyGenerationDto;
import io.mosip.kernel.lkeymanager.dto.LicenseKeyGenerationResponseDto;
import io.mosip.kernel.lkeymanager.dto.LicenseKeyMappingDto;
import io.mosip.kernel.lkeymanager.dto.LicenseKeyMappingResponseDto;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="licensekey", description="Operation related to License Key Management")
public class LicenseKeyController {
    @Autowired
    LicenseKeyManagerService<String, LicenseKeyGenerationDto, LicenseKeyMappingDto> licenseKeyManagerService;

    @Operation(summary="This method will generate license key against a certain TSP ID", description="Endpoint for Encrypt the data", tags={"licensekey"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success or you may find errors in error array in response"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(hidden=true))})})
    @PreAuthorize(value="hasAnyRole(@lkeyAuthRoles.getPostlicensegenerate())")
    @ResponseFilter
    @PostMapping(value={"/license/generate"})
    public ResponseWrapper<LicenseKeyGenerationResponseDto> generateLicenseKey(@RequestBody RequestWrapper<LicenseKeyGenerationDto> licenseKeyGenerationDto) {
        LicenseKeyGenerationResponseDto licenseKeyGenerationResponseDto = new LicenseKeyGenerationResponseDto();
        ResponseWrapper responseWrapper = new ResponseWrapper();
        licenseKeyGenerationResponseDto.setLicenseKey((String)this.licenseKeyManagerService.generateLicenseKey((Object)((LicenseKeyGenerationDto)licenseKeyGenerationDto.getRequest())));
        responseWrapper.setResponse((Object)licenseKeyGenerationResponseDto);
        return responseWrapper;
    }

    @Operation(summary="This method will map license key to several permissions. The permissions provided must be present in the master list", description="Endpoint for Encrypt the data", tags={"licensekey"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success or you may find errors in error array in response"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(hidden=true))})})
    @ResponseFilter
    @PostMapping(value={"/license/permission"})
    public ResponseWrapper<LicenseKeyMappingResponseDto> mapLicenseKey(@RequestBody RequestWrapper<LicenseKeyMappingDto> licenseKeyMappingDto) {
        LicenseKeyMappingResponseDto licenseKeyMappingResponseDto = new LicenseKeyMappingResponseDto();
        ResponseWrapper responseWrapper = new ResponseWrapper();
        licenseKeyMappingResponseDto.setStatus((String)this.licenseKeyManagerService.mapLicenseKey((Object)((LicenseKeyMappingDto)licenseKeyMappingDto.getRequest())));
        responseWrapper.setResponse((Object)licenseKeyMappingResponseDto);
        return responseWrapper;
    }

    @Operation(summary="This method will fetch the mapped permissions for a license key", description="Endpoint for Encrypt the data", tags={"licensekey"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success or you may find errors in error array in response"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(hidden=true))})})
    @ResponseFilter
    @GetMapping(value={"/license/permission"})
    public ResponseWrapper<LicenseKeyFetchResponseDto> fetchLicenseKeyPermissions(@RequestParam(value="tspId") String tspId, @RequestParam(value="licenseKey") String licenseKey) {
        LicenseKeyFetchResponseDto licenseKeyFetchResponseDto = new LicenseKeyFetchResponseDto();
        ResponseWrapper responseWrapper = new ResponseWrapper();
        licenseKeyFetchResponseDto.setPermissions(this.licenseKeyManagerService.fetchLicenseKeyPermissions((Object)tspId, (Object)licenseKey));
        responseWrapper.setResponse((Object)licenseKeyFetchResponseDto);
        return responseWrapper;
    }
}

