/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.keymigrate.service.impl;

import io.mosip.kernel.core.crypto.exception.InvalidDataException;
import io.mosip.kernel.core.crypto.spi.CryptoCoreSpec;
import io.mosip.kernel.core.keymanager.model.CertificateParameters;
import io.mosip.kernel.core.keymanager.spi.KeyStore;
import io.mosip.kernel.core.logger.spi.Logger;
import io.mosip.kernel.core.util.CryptoUtil;
import io.mosip.kernel.core.util.DateUtils;
import io.mosip.kernel.cryptomanager.util.CryptomanagerUtils;
import io.mosip.kernel.keymanagerservice.constant.KeymanagerConstant;
import io.mosip.kernel.keymanagerservice.constant.KeymanagerErrorConstant;
import io.mosip.kernel.keymanagerservice.entity.DataEncryptKeystore;
import io.mosip.kernel.keymanagerservice.entity.KeyAlias;
import io.mosip.kernel.keymanagerservice.exception.NoUniqueAliasException;
import io.mosip.kernel.keymanagerservice.helper.KeymanagerDBHelper;
import io.mosip.kernel.keymanagerservice.logger.KeymanagerLogger;
import io.mosip.kernel.keymanagerservice.repository.DataEncryptKeystoreRepository;
import io.mosip.kernel.keymanagerservice.util.KeymanagerUtil;
import io.mosip.kernel.keymigrate.dto.KeyMigrateBaseKeyRequestDto;
import io.mosip.kernel.keymigrate.dto.KeyMigrateBaseKeyResponseDto;
import io.mosip.kernel.keymigrate.dto.ZKKeyMigrateCertficateResponseDto;
import io.mosip.kernel.keymigrate.dto.ZKKeyMigrateRequestDto;
import io.mosip.kernel.keymigrate.dto.ZKKeyMigrateResponseDto;
import io.mosip.kernel.keymigrate.dto.ZKKeyResponseDto;
import io.mosip.kernel.keymigrate.service.spi.KeyMigratorService;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Stream;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Lazy
@Service
@Transactional
public class KeyMigratorServiceImpl
implements KeyMigratorService {
    private static final Logger LOGGER = KeymanagerLogger.getLogger(KeyMigratorServiceImpl.class);
    private static final String CREATED_BY = "System-Migrator";
    @Value(value="${mosip.kernel.partner.sign.masterkey.application.id:PMS}")
    private String pmsSignAppId;
    @Value(value="${mosip.kernel.certificate.sign.algorithm:SHA256withRSA}")
    private String signAlgorithm;
    @Value(value="${mosip.kernel.zkcrypto.masterkey.application.id:KERNEL}")
    private String masterKeyAppId;
    @Value(value="${mosip.kernel.zkcrypto.masterkey.reference.id:IDENTITY_CACHE}")
    private String masterKeyRefId;
    @Value(value="${mosip.kernel.zkcrypto.wrap.algorithm-name:AES/ECB/NoPadding}")
    private String aesECBTransformation;
    @Autowired
    private KeymanagerDBHelper dbHelper;
    @Autowired
    KeymanagerUtil keymanagerUtil;
    @Autowired
    private KeyStore keyStore;
    @Autowired
    private CryptoCoreSpec<byte[], byte[], SecretKey, PublicKey, PrivateKey, String> cryptoCore;
    @Autowired
    DataEncryptKeystoreRepository dataEncryptKeystoreRepository;
    @Autowired
    CryptomanagerUtils cryptomanagerUtil;

    @Override
    public KeyMigrateBaseKeyResponseDto migrateBaseKey(KeyMigrateBaseKeyRequestDto baseKeyMigrateRequest) {
        LOGGER.info("keyMigrateSessionID", "BASE_KEY", "", "Base Key Migration Migration.");
        String appId = baseKeyMigrateRequest.getApplicationId();
        String refId = baseKeyMigrateRequest.getReferenceId();
        String encryptedPrivateKey = baseKeyMigrateRequest.getEncryptedKeyData();
        String certificateData = baseKeyMigrateRequest.getCertificateData();
        LocalDateTime notBefore = baseKeyMigrateRequest.getNotBefore();
        LocalDateTime notAfter = baseKeyMigrateRequest.getNotAfter();
        LocalDateTime localDateTimeStamp = DateUtils.getUTCCurrentDateTime();
        Map<String, List<KeyAlias>> keyAliasMap = this.dbHelper.getKeyAliases(appId, "", localDateTimeStamp);
        List<KeyAlias> currentKeyAlias = keyAliasMap.get("currentKeyAlias");
        if (currentKeyAlias.isEmpty() && !appId.equals("PARTNER")) {
            LOGGER.error("keyMigrateSessionID", "currentKeyAlias", String.valueOf(currentKeyAlias.size()), "No CurrentKeyAlias found Throwing exception");
            throw new NoUniqueAliasException(KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorCode(), KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorMessage());
        }
        if (this.isValidKeyExists(appId, refId, notBefore, notAfter, localDateTimeStamp)) {
            LOGGER.error("keyMigrateSessionID", "", "", "Valid Key Already exists, not allowed to migrate.");
            KeyMigrateBaseKeyResponseDto responseDto = new KeyMigrateBaseKeyResponseDto();
            responseDto.setStatus("Migration Not Allowed. Valid Key Exists.");
            responseDto.setTimestamp(localDateTimeStamp);
            return responseDto;
        }
        String baseKeyAlias = UUID.randomUUID().toString();
        String masterKeyAlias = currentKeyAlias.isEmpty() ? baseKeyAlias : currentKeyAlias.get(0).getAlias();
        X509Certificate reqX509Cert = (X509Certificate)this.keymanagerUtil.convertToCertificate(certificateData);
        String certThumbprint = this.cryptomanagerUtil.getCertificateThumbprintInHex(reqX509Cert);
        this.dbHelper.storeKeyInDBStore(baseKeyAlias, masterKeyAlias, certificateData, encryptedPrivateKey);
        String uniqueValue = appId + "_" + refId + "_" + notBefore.format(KeymanagerConstant.DATE_FORMATTER);
        LOGGER.info("sessionId", "", "", "Unique Value formatter: " + uniqueValue);
        String uniqueIdentifier = this.keymanagerUtil.getUniqueIdentifier(uniqueValue);
        this.dbHelper.storeKeyInAlias(appId, notBefore, refId, baseKeyAlias, notAfter, certThumbprint, uniqueIdentifier);
        LOGGER.info("keyMigrateSessionID", "BASE_KEY", "", "Migration Completed for App Id:" + appId + ", Ref Id: " + refId + ", Inserted UUID: " + baseKeyAlias);
        KeyMigrateBaseKeyResponseDto responseDto = new KeyMigrateBaseKeyResponseDto();
        responseDto.setStatus("Migration Success");
        responseDto.setTimestamp(localDateTimeStamp);
        return responseDto;
    }

    private boolean isValidKeyExists(String applicationId, String referenceId, LocalDateTime notBefore, LocalDateTime notAfter, LocalDateTime localDateTimeStamp) {
        Map<String, List<KeyAlias>> keyAliasMap = this.dbHelper.getKeyAliases(applicationId, referenceId, localDateTimeStamp);
        List<KeyAlias> currentKeyAlias = keyAliasMap.get("currentKeyAlias");
        if (currentKeyAlias.isEmpty()) {
            return false;
        }
        return localDateTimeStamp.isEqual(notBefore) || localDateTimeStamp.isEqual(notAfter) || localDateTimeStamp.isAfter(notBefore) && localDateTimeStamp.isBefore(notAfter);
    }

    @Override
    public ZKKeyMigrateCertficateResponseDto getZKTempCertificate() {
        String alias;
        LOGGER.info("keyMigrateSessionID", "ZK_KEYS", "", "Get Temporary Certificate for ZK keys migration.");
        LocalDateTime localDateTimeStamp = DateUtils.getUTCCurrentDateTime();
        Map<String, List<KeyAlias>> keyAliasMap = this.dbHelper.getKeyAliases("KEY_MIGRATE", "ZK_TEMP_KEY", localDateTimeStamp);
        List<KeyAlias> KeyAlias2 = keyAliasMap.get("keyAlias");
        List<KeyAlias> currentKeyAlias = keyAliasMap.get("currentKeyAlias");
        ZKKeyMigrateCertficateResponseDto responseDto = new ZKKeyMigrateCertficateResponseDto();
        if (currentKeyAlias.isEmpty() && KeyAlias2.size() > 0) {
            LOGGER.info("keyMigrateSessionID", "ZK_KEYS", String.valueOf(KeyAlias2.size()), "Key Exists but expired, so removing the key and generating new key.");
            alias = KeyAlias2.get(KeyAlias2.size() - 1).getAlias();
            LOGGER.info("keyMigrateSessionID", "ZK_KEYS", "", "Found Alias to delete key. Alias: " + alias);
            this.keyStore.deleteKey(alias);
            this.dbHelper.storeKeyInAlias("KEY_MIGRATE", localDateTimeStamp, "ZK_TEMP_KEY", alias, localDateTimeStamp, null, null);
        } else {
            if (currentKeyAlias.size() == 1) {
                LOGGER.info("keyMigrateSessionID", "ZK_KEYS", String.valueOf(currentKeyAlias.size()), "currentKeyAlias size is one, returning the certificate.");
                String alias2 = currentKeyAlias.get(0).getAlias();
                String certificateData = this.keymanagerUtil.getPEMFormatedData(this.keyStore.getCertificate(alias2));
                responseDto.setCertificate(certificateData);
                responseDto.setTimestamp(localDateTimeStamp);
                return responseDto;
            }
            if (currentKeyAlias.size() > 1) {
                LOGGER.error("keyMigrateSessionID", "ZK_KEYS", String.valueOf(currentKeyAlias.size()), "No CurrentKeyAlias found Throwing exception");
                throw new NoUniqueAliasException(KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorCode(), KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorMessage());
            }
        }
        alias = UUID.randomUUID().toString();
        LocalDateTime expiryDateTime = localDateTimeStamp.plusDays(1L);
        CertificateParameters certParams = this.keymanagerUtil.getCertificateParameters("ZKKeysSelfSignedKey", localDateTimeStamp, expiryDateTime);
        this.keyStore.generateAndStoreAsymmetricKey(alias, null, certParams);
        X509Certificate x509Cert = (X509Certificate)this.keyStore.getCertificate(alias);
        String certThumbprint = this.cryptomanagerUtil.getCertificateThumbprintInHex(x509Cert);
        String uniqueValue = "KEY_MIGRATE_ZK_TEMP_KEY_" + certThumbprint;
        LOGGER.info("sessionId", "", "", "Unique Value formatter: " + uniqueValue);
        String uniqueIdentifier = this.keymanagerUtil.getUniqueIdentifier(uniqueValue);
        this.dbHelper.storeKeyInAlias("KEY_MIGRATE", localDateTimeStamp, "ZK_TEMP_KEY", alias, expiryDateTime, certThumbprint, uniqueIdentifier);
        String certificateData = this.keymanagerUtil.getPEMFormatedData(this.keyStore.getCertificate(alias));
        responseDto.setCertificate(certificateData);
        responseDto.setTimestamp(localDateTimeStamp);
        return responseDto;
    }

    @Override
    public ZKKeyMigrateResponseDto migrateZKKeys(ZKKeyMigrateRequestDto migrateZKKeysRequestDto) {
        LOGGER.info("keyMigrateSessionID", "ZK_KEYS", "", "ZK keys migration request.");
        LocalDateTime localDateTimeStamp = DateUtils.getUTCCurrentDateTime();
        Stream encryptedKeyList = migrateZKKeysRequestDto.getZkEncryptedDataList().stream();
        boolean purgeKeyFlag = migrateZKKeysRequestDto.getPurgeTempKeyFlag() == null ? false : migrateZKKeysRequestDto.getPurgeTempKeyFlag();
        LOGGER.info("keyMigrateSessionID", "ZK_KEYS", "", "ZK migration keys list size: " + migrateZKKeysRequestDto.getZkEncryptedDataList().size());
        String tempKeyAlias = this.getKeyAlias("KEY_MIGRATE", "ZK_TEMP_KEY", localDateTimeStamp);
        String zkMasterKeyAlias = this.getKeyAlias(this.masterKeyAppId, this.masterKeyRefId, localDateTimeStamp);
        KeyStore.PrivateKeyEntry keyEntry = this.keyStore.getAsymmetricKey(tempKeyAlias);
        PrivateKey tempPrivateKey = keyEntry.getPrivateKey();
        PublicKey tempPublicKey = keyEntry.getCertificate().getPublicKey();
        SecretKey zkMasterKey = this.keyStore.getSymmetricKey(zkMasterKeyAlias);
        ArrayList<ZKKeyResponseDto> keyResponseList = new ArrayList<ZKKeyResponseDto>();
        encryptedKeyList.forEach(encryptedKey -> {
            byte[] encryptedKeyBytes = CryptoUtil.decodeURLSafeBase64((String)encryptedKey.getEncryptedKeyData());
            int keyIndex = encryptedKey.getKeyIndex();
            ZKKeyResponseDto keyResponseDto = new ZKKeyResponseDto();
            keyResponseDto.setKeyIndex(keyIndex);
            if (!this.isKeyIndexExist(keyIndex)) {
                byte[] encryptedSessionKey = this.encryptRandomKey(encryptedKeyBytes, zkMasterKey, tempPrivateKey, tempPublicKey);
                if (encryptedSessionKey != null) {
                    String encodedKey = Base64.getEncoder().encodeToString(encryptedSessionKey);
                    this.insertKey(keyIndex, encodedKey, "Active");
                    keyResponseDto.setStatusMessage("Migration Success");
                } else {
                    keyResponseDto.setStatusMessage("Error in Migration");
                }
            } else {
                keyResponseDto.setStatusMessage("Migration Not Allowed. Valid Key Exists.");
            }
            keyResponseList.add(keyResponseDto);
        });
        LOGGER.info("keyMigrateSessionID", "ZK_KEYS", "", "Purge Flag Value: " + purgeKeyFlag);
        if (purgeKeyFlag) {
            this.keyStore.deleteKey(tempKeyAlias);
            LOGGER.info("keyMigrateSessionID", "ZK_KEYS", "", "Key Purged from Store. Key Alias: " + tempKeyAlias);
            this.dbHelper.storeKeyInAlias("KEY_MIGRATE", localDateTimeStamp, "ZK_TEMP_KEY", tempKeyAlias, localDateTimeStamp, null, null);
        }
        ZKKeyMigrateResponseDto responseDto = new ZKKeyMigrateResponseDto();
        responseDto.setZkEncryptedDataList(keyResponseList);
        return responseDto;
    }

    private String getKeyAlias(String keyAppId, String keyRefId, LocalDateTime localDateTimeStamp) {
        LOGGER.info("keyMigrateSessionID", "ZK_KEYS", "", "Retrieve Master Key Alias from DB. AppId: " + keyAppId);
        Map<String, List<KeyAlias>> keyAliasMap = this.dbHelper.getKeyAliases(keyAppId, keyRefId, localDateTimeStamp);
        List<KeyAlias> currentKeyAliases = keyAliasMap.get("currentKeyAlias");
        if (!currentKeyAliases.isEmpty() && currentKeyAliases.size() == 1) {
            LOGGER.info("keyMigrateSessionID", "ZK_KEYS", "getKeyAlias", "CurrentKeyAlias size is one. return the current key alias.");
            return currentKeyAliases.get(0).getAlias();
        }
        LOGGER.error("keyMigrateSessionID", "ZK_KEYS", "", "CurrentKeyAlias is not unique. KeyAlias count: " + currentKeyAliases.size());
        throw new NoUniqueAliasException(KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorCode(), KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorMessage());
    }

    private byte[] encryptRandomKey(byte[] encryptedKeyBytes, Key zkMasterKey, PrivateKey tempPrivateKey, PublicKey tempPublicKey) {
        try {
            byte[] secretDataBytes = (byte[])this.cryptoCore.asymmetricDecrypt((Object)tempPrivateKey, (Object)tempPublicKey, (Object)encryptedKeyBytes);
            Cipher cipher = Cipher.getInstance(this.aesECBTransformation);
            cipher.init(1, zkMasterKey);
            return cipher.doFinal(secretDataBytes, 0, secretDataBytes.length);
        }
        catch (InvalidDataException | io.mosip.kernel.core.crypto.exception.InvalidKeyException | IllegalArgumentException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            LOGGER.error("keyMigrateSessionID", new Object[]{"ZK_KEYS", "", "Error in encrypting random Key in key migration process.", e});
            return null;
        }
    }

    private boolean isKeyIndexExist(int keyIdx) {
        return Objects.nonNull(this.dataEncryptKeystoreRepository.findKeyById(keyIdx));
    }

    private void insertKey(int id, String secretData, String status) {
        DataEncryptKeystore data = new DataEncryptKeystore();
        data.setId(id);
        data.setKey(secretData);
        data.setKeyStatus(status);
        data.setCrBy(CREATED_BY);
        data.setCrDTimes(LocalDateTime.now());
        this.dataEncryptKeystoreRepository.save(data);
    }
}

