/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.keymigrate.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDateTime;
import javax.validation.constraints.NotBlank;
import lombok.Generated;

@ApiModel(description="Model representing a base key migration from one HSM to another")
public class KeyMigrateBaseKeyRequestDto {
    @ApiModelProperty(notes="Application ID", example="REGISTRATION", required=true)
    @NotBlank(message="should not be null or empty")
    private @NotBlank(message="should not be null or empty") String applicationId;
    @ApiModelProperty(notes="Reference ID", example="", required=true)
    @NotBlank(message="should not be null or empty")
    private @NotBlank(message="should not be null or empty") String referenceId;
    @ApiModelProperty(notes="Encrypted Private Key Data", example=" ", required=true)
    @NotBlank(message="should not be null or empty")
    private @NotBlank(message="should not be null or empty") String encryptedKeyData;
    @ApiModelProperty(notes="Certificate Data", example="", required=true)
    @NotBlank(message="should not be null or empty")
    private @NotBlank(message="should not be null or empty") String certificateData;
    @ApiModelProperty(notes="Timestamp of start key validity", example="2021-01-01T00:00:00.000Z", required=true)
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")
    private LocalDateTime notBefore;
    @ApiModelProperty(notes="Timestamp of end key validity", example="2023-01-01T00:00:00.000Z", required=true)
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")
    private LocalDateTime notAfter;

    @Generated
    public String getApplicationId() {
        return this.applicationId;
    }

    @Generated
    public String getReferenceId() {
        return this.referenceId;
    }

    @Generated
    public String getEncryptedKeyData() {
        return this.encryptedKeyData;
    }

    @Generated
    public String getCertificateData() {
        return this.certificateData;
    }

    @Generated
    public LocalDateTime getNotBefore() {
        return this.notBefore;
    }

    @Generated
    public LocalDateTime getNotAfter() {
        return this.notAfter;
    }

    @Generated
    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    @Generated
    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    @Generated
    public void setEncryptedKeyData(String encryptedKeyData) {
        this.encryptedKeyData = encryptedKeyData;
    }

    @Generated
    public void setCertificateData(String certificateData) {
        this.certificateData = certificateData;
    }

    @Generated
    public void setNotBefore(LocalDateTime notBefore) {
        this.notBefore = notBefore;
    }

    @Generated
    public void setNotAfter(LocalDateTime notAfter) {
        this.notAfter = notAfter;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeyMigrateBaseKeyRequestDto)) {
            return false;
        }
        KeyMigrateBaseKeyRequestDto other = (KeyMigrateBaseKeyRequestDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$applicationId = this.getApplicationId();
        String other$applicationId = other.getApplicationId();
        if (this$applicationId == null ? other$applicationId != null : !this$applicationId.equals(other$applicationId)) {
            return false;
        }
        String this$referenceId = this.getReferenceId();
        String other$referenceId = other.getReferenceId();
        if (this$referenceId == null ? other$referenceId != null : !this$referenceId.equals(other$referenceId)) {
            return false;
        }
        String this$encryptedKeyData = this.getEncryptedKeyData();
        String other$encryptedKeyData = other.getEncryptedKeyData();
        if (this$encryptedKeyData == null ? other$encryptedKeyData != null : !this$encryptedKeyData.equals(other$encryptedKeyData)) {
            return false;
        }
        String this$certificateData = this.getCertificateData();
        String other$certificateData = other.getCertificateData();
        if (this$certificateData == null ? other$certificateData != null : !this$certificateData.equals(other$certificateData)) {
            return false;
        }
        LocalDateTime this$notBefore = this.getNotBefore();
        LocalDateTime other$notBefore = other.getNotBefore();
        if (this$notBefore == null ? other$notBefore != null : !((Object)this$notBefore).equals(other$notBefore)) {
            return false;
        }
        LocalDateTime this$notAfter = this.getNotAfter();
        LocalDateTime other$notAfter = other.getNotAfter();
        return !(this$notAfter == null ? other$notAfter != null : !((Object)this$notAfter).equals(other$notAfter));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof KeyMigrateBaseKeyRequestDto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $applicationId = this.getApplicationId();
        result = result * 59 + ($applicationId == null ? 43 : $applicationId.hashCode());
        String $referenceId = this.getReferenceId();
        result = result * 59 + ($referenceId == null ? 43 : $referenceId.hashCode());
        String $encryptedKeyData = this.getEncryptedKeyData();
        result = result * 59 + ($encryptedKeyData == null ? 43 : $encryptedKeyData.hashCode());
        String $certificateData = this.getCertificateData();
        result = result * 59 + ($certificateData == null ? 43 : $certificateData.hashCode());
        LocalDateTime $notBefore = this.getNotBefore();
        result = result * 59 + ($notBefore == null ? 43 : ((Object)$notBefore).hashCode());
        LocalDateTime $notAfter = this.getNotAfter();
        result = result * 59 + ($notAfter == null ? 43 : ((Object)$notAfter).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "KeyMigrateBaseKeyRequestDto(applicationId=" + this.getApplicationId() + ", referenceId=" + this.getReferenceId() + ", encryptedKeyData=" + this.getEncryptedKeyData() + ", certificateData=" + this.getCertificateData() + ", notBefore=" + this.getNotBefore() + ", notAfter=" + this.getNotAfter() + ")";
    }

    @Generated
    public KeyMigrateBaseKeyRequestDto(String applicationId, String referenceId, String encryptedKeyData, String certificateData, LocalDateTime notBefore, LocalDateTime notAfter) {
        this.applicationId = applicationId;
        this.referenceId = referenceId;
        this.encryptedKeyData = encryptedKeyData;
        this.certificateData = certificateData;
        this.notBefore = notBefore;
        this.notAfter = notAfter;
    }

    @Generated
    public KeyMigrateBaseKeyRequestDto() {
    }
}

