/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.keymigrate.controller;

import io.mosip.kernel.core.http.RequestWrapper;
import io.mosip.kernel.core.http.ResponseFilter;
import io.mosip.kernel.core.http.ResponseWrapper;
import io.mosip.kernel.keymigrate.dto.KeyMigrateBaseKeyRequestDto;
import io.mosip.kernel.keymigrate.dto.KeyMigrateBaseKeyResponseDto;
import io.mosip.kernel.keymigrate.dto.ZKKeyMigrateCertficateResponseDto;
import io.mosip.kernel.keymigrate.dto.ZKKeyMigrateRequestDto;
import io.mosip.kernel.keymigrate.dto.ZKKeyMigrateResponseDto;
import io.mosip.kernel.keymigrate.service.spi.KeyMigratorService;
import io.swagger.annotations.ApiParam;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@Lazy
@CrossOrigin
@RestController
@Tag(name="keymigrator", description="Operation related to Key Migration from one HSM to another HSM")
public class KeyMigratorController {
    @Autowired
    KeyMigratorService keyMigratorService;

    @Operation(summary="Controller for migrating base key", description="Controller for migrating base key", tags={"keymigrator"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success or you may find errors in error array in response"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(hidden=true))})})
    @PreAuthorize(value="hasAnyRole(@KeymigrateAuthRoles.getPostmigratebasekey())")
    @ResponseFilter
    @PostMapping(value={"/migrateBaseKey"}, produces={"application/json"})
    public ResponseWrapper<KeyMigrateBaseKeyResponseDto> migrateBaseKey(@ApiParam(value="Base Key Migrate Attributes.") @RequestBody @Valid RequestWrapper<KeyMigrateBaseKeyRequestDto> migrateBaseKeyRequestDto) {
        ResponseWrapper response = new ResponseWrapper();
        response.setResponse((Object)this.keyMigratorService.migrateBaseKey((KeyMigrateBaseKeyRequestDto)migrateBaseKeyRequestDto.getRequest()));
        return response;
    }

    @Operation(summary="Controller to get the certificate for migrating ZK keys", description="Controller to get the certificate for migrating ZK keys", tags={"keymigrator"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success or you may find errors in error array in response"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(hidden=true))})})
    @PreAuthorize(value="hasAnyRole(@KeymigrateAuthRoles.getGetzktempcertificate())")
    @ResponseFilter
    @GetMapping(value={"/getZKTempCertificate"}, produces={"application/json"})
    public ResponseWrapper<ZKKeyMigrateCertficateResponseDto> getZKTempCertificate() {
        ResponseWrapper response = new ResponseWrapper();
        response.setResponse((Object)this.keyMigratorService.getZKTempCertificate());
        return response;
    }

    @Operation(summary="Controller for migrating ZK keys", description="Controller for migrating ZK keys", tags={"keymigrator"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success or you may find errors in error array in response"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(hidden=true))})})
    @PreAuthorize(value="hasAnyRole(@KeymigrateAuthRoles.getPostmigratezkkeys())")
    @ResponseFilter
    @PostMapping(value={"/migrateZKKeys"}, produces={"application/json"})
    public ResponseWrapper<ZKKeyMigrateResponseDto> migrateZKKeys(@ApiParam(value="ZK Keys Migrate Attributes.") @RequestBody @Valid RequestWrapper<ZKKeyMigrateRequestDto> migrateZKKeysRequestDto) {
        ResponseWrapper response = new ResponseWrapper();
        response.setResponse((Object)this.keyMigratorService.migrateZKKeys((ZKKeyMigrateRequestDto)migrateZKKeysRequestDto.getRequest()));
        return response;
    }
}

