/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.keymanagerservice.util;

import io.mosip.kernel.core.crypto.spi.CryptoCoreSpec;
import io.mosip.kernel.core.keymanager.exception.KeystoreProcessingException;
import io.mosip.kernel.core.keymanager.model.CertificateEntry;
import io.mosip.kernel.core.keymanager.model.CertificateParameters;
import io.mosip.kernel.core.logger.spi.Logger;
import io.mosip.kernel.core.util.CryptoUtil;
import io.mosip.kernel.core.util.DateUtils;
import io.mosip.kernel.keygenerator.bouncycastle.KeyGenerator;
import io.mosip.kernel.keymanager.hsm.constant.KeymanagerErrorCode;
import io.mosip.kernel.keymanagerservice.constant.KeymanagerErrorConstant;
import io.mosip.kernel.keymanagerservice.dto.CSRGenerateRequestDto;
import io.mosip.kernel.keymanagerservice.dto.KeyPairGenerateRequestDto;
import io.mosip.kernel.keymanagerservice.entity.BaseEntity;
import io.mosip.kernel.keymanagerservice.entity.KeyAlias;
import io.mosip.kernel.keymanagerservice.exception.KeymanagerServiceException;
import io.mosip.kernel.keymanagerservice.logger.KeymanagerLogger;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Date;
import java.util.Objects;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class KeymanagerUtil {
    private static final Logger LOGGER = KeymanagerLogger.getLogger(KeymanagerUtil.class);
    private static final String UTC_DATETIME_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    @Value(value="${mosip.kernel.keygenerator.asymmetric-algorithm-name}")
    private String asymmetricAlgorithmName;
    @Value(value="${mosip.kernel.data-key-splitter}")
    private String keySplitter;
    @Value(value="${mosip.kernel.keymanager.certificate.default.common-name}")
    private String commonName;
    @Value(value="${mosip.kernel.keymanager.certificate.default.organizational-unit}")
    private String organizationUnit;
    @Value(value="${mosip.kernel.keymanager.certificate.default.organization}")
    private String organization;
    @Value(value="${mosip.kernel.keymanager.certificate.default.location}")
    private String location;
    @Value(value="${mosip.kernel.keymanager.certificate.default.state}")
    private String state;
    @Value(value="${mosip.kernel.keymanager.certificate.default.country}")
    private String country;
    @Value(value="${mosip.kernel.crypto.symmetric-algorithm-name}")
    private String symmetricAlgorithmName;
    @Value(value="${mosip.kernel.certificate.sign.algorithm:SHA256withRSA}")
    private String signAlgorithm;
    @Autowired
    KeyGenerator keyGenerator;
    @Autowired
    private CryptoCoreSpec<byte[], byte[], SecretKey, PublicKey, PrivateKey, String> cryptoCore;

    public boolean isValidTimestamp(LocalDateTime timeStamp, KeyAlias keyAlias, int preExpireDays) {
        return timeStamp.isEqual(keyAlias.getKeyGenerationTime()) || timeStamp.isEqual(keyAlias.getKeyExpiryTime()) || timeStamp.isAfter(keyAlias.getKeyGenerationTime()) && timeStamp.isBefore(keyAlias.getKeyExpiryTime().minusDays(preExpireDays));
    }

    public boolean isOverlapping(LocalDateTime timeStamp, LocalDateTime policyExpiryTime, LocalDateTime keyGenerationTime, LocalDateTime keyExpiryTime) {
        return !timeStamp.isAfter(keyExpiryTime) && !keyGenerationTime.isAfter(policyExpiryTime);
    }

    public boolean isValidReferenceId(String referenceId) {
        return referenceId != null && !referenceId.trim().isEmpty();
    }

    public <T extends BaseEntity> T setMetaData(T entity) {
        String contextUser = "SYSTEM";
        LocalDateTime time = LocalDateTime.now(ZoneId.of("UTC"));
        entity.setCreatedBy(contextUser);
        entity.setCreatedtimes(time);
        entity.setIsDeleted(false);
        return entity;
    }

    public byte[] encryptKey(PrivateKey privateKey, PublicKey masterKey) {
        SecretKey symmetricKey = this.keyGenerator.getSymmetricKey();
        byte[] encryptedPrivateKey = (byte[])this.cryptoCore.symmetricEncrypt((Object)symmetricKey, (Object)privateKey.getEncoded(), null);
        byte[] encryptedSymmetricKey = (byte[])this.cryptoCore.asymmetricEncrypt((Object)masterKey, (Object)symmetricKey.getEncoded());
        return CryptoUtil.combineByteArray((byte[])encryptedPrivateKey, (byte[])encryptedSymmetricKey, (String)this.keySplitter);
    }

    public byte[] decryptKey(byte[] key, PrivateKey privateKey, PublicKey publicKey) {
        return this.decryptKey(key, privateKey, publicKey, null);
    }

    public byte[] decryptKey(byte[] key, PrivateKey privateKey, PublicKey publicKey, String keystoreType) {
        int keyDemiliterIndex = 0;
        int cipherKeyandDataLength = key.length;
        int keySplitterLength = this.keySplitter.length();
        keyDemiliterIndex = CryptoUtil.getSplitterIndex((byte[])key, (int)keyDemiliterIndex, (String)this.keySplitter);
        byte[] encryptedKey = Arrays.copyOfRange(key, 0, keyDemiliterIndex);
        byte[] encryptedData = Arrays.copyOfRange(key, keyDemiliterIndex + keySplitterLength, cipherKeyandDataLength);
        byte[] decryptedSymmetricKey = (byte[])this.cryptoCore.asymmetricDecrypt((Object)privateKey, (Object)publicKey, (Object)encryptedKey, keystoreType);
        SecretKeySpec symmetricKey = new SecretKeySpec(decryptedSymmetricKey, 0, decryptedSymmetricKey.length, this.symmetricAlgorithmName);
        return (byte[])this.cryptoCore.symmetricDecrypt((Object)symmetricKey, (Object)encryptedData, null);
    }

    public LocalDateTime parseToLocalDateTime(String dateTime) {
        return LocalDateTime.parse(dateTime, DateTimeFormatter.ofPattern(UTC_DATETIME_PATTERN));
    }

    public void isCertificateValid(CertificateEntry<X509Certificate, PrivateKey> certificateEntry, Date inputDate) {
        try {
            ((X509Certificate[])certificateEntry.getChain())[0].checkValidity(inputDate);
        }
        catch (CertificateExpiredException | CertificateNotYetValidException e) {
            throw new KeystoreProcessingException(KeymanagerErrorCode.CERTIFICATE_PROCESSING_ERROR.getErrorCode(), KeymanagerErrorCode.CERTIFICATE_PROCESSING_ERROR.getErrorMessage() + e.getMessage());
        }
    }

    public PrivateKey privateKeyExtractor(InputStream privateKeyInputStream) {
        KeyFactory kf = null;
        PKCS8EncodedKeySpec keySpec = null;
        PrivateKey privateKey = null;
        try {
            StringWriter stringWriter = new StringWriter();
            IOUtils.copy((InputStream)privateKeyInputStream, (Writer)stringWriter, (Charset)StandardCharsets.UTF_8);
            String privateKeyPEMString = stringWriter.toString();
            byte[] decodedKey = Base64.decodeBase64((String)privateKeyPEMString);
            kf = KeyFactory.getInstance(this.asymmetricAlgorithmName);
            keySpec = new PKCS8EncodedKeySpec(decodedKey);
            privateKey = kf.generatePrivate(keySpec);
        }
        catch (IOException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new KeystoreProcessingException(KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorCode(), KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorMessage() + e.getMessage());
        }
        return privateKey;
    }

    public boolean isValidResponseType(String responseType) {
        return responseType != null && !responseType.trim().isEmpty();
    }

    public boolean isValidApplicationId(String appId) {
        return appId != null && !appId.trim().isEmpty();
    }

    public boolean isValidCertificateData(String certData) {
        return certData != null && !certData.trim().isEmpty();
    }

    public Certificate convertToCertificate(String certData) {
        try {
            StringReader strReader = new StringReader(certData);
            PemReader pemReader = new PemReader((Reader)strReader);
            PemObject pemObject = pemReader.readPemObject();
            if (Objects.isNull(pemObject)) {
                LOGGER.error("sessionId", "CERTIFICATE_PARSE", "CERTIFICATE_PARSE", "Error Parsing Certificate.");
                throw new KeymanagerServiceException(KeymanagerErrorConstant.CERTIFICATE_PARSING_ERROR.getErrorCode(), KeymanagerErrorConstant.CERTIFICATE_PARSING_ERROR.getErrorMessage());
            }
            byte[] certBytes = pemObject.getContent();
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            return certFactory.generateCertificate(new ByteArrayInputStream(certBytes));
        }
        catch (IOException | CertificateException e) {
            throw new KeymanagerServiceException(KeymanagerErrorConstant.CERTIFICATE_PARSING_ERROR.getErrorCode(), KeymanagerErrorConstant.CERTIFICATE_PARSING_ERROR.getErrorMessage() + e.getMessage());
        }
    }

    public Certificate convertToCertificate(byte[] certDataBytes) {
        try {
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            return certFactory.generateCertificate(new ByteArrayInputStream(certDataBytes));
        }
        catch (CertificateException e) {
            throw new KeymanagerServiceException(KeymanagerErrorConstant.CERTIFICATE_PARSING_ERROR.getErrorCode(), KeymanagerErrorConstant.CERTIFICATE_PARSING_ERROR.getErrorMessage() + e.getMessage());
        }
    }

    public String getPEMFormatedData(Object anyObject) {
        String string;
        StringWriter stringWriter = new StringWriter();
        JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)stringWriter);
        try {
            pemWriter.writeObject(anyObject);
            pemWriter.flush();
            string = stringWriter.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    pemWriter.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioExp) {
                throw new KeymanagerServiceException(KeymanagerErrorConstant.INTERNAL_SERVER_ERROR.getErrorCode(), KeymanagerErrorConstant.INTERNAL_SERVER_ERROR.getErrorMessage(), ioExp);
            }
        }
        pemWriter.close();
        return string;
    }

    public CertificateParameters getCertificateParameters(X500Principal latestCertPrincipal, LocalDateTime notBefore, LocalDateTime notAfter) {
        CertificateParameters certParams = new CertificateParameters();
        X500Name x500Name = new X500Name(latestCertPrincipal.getName());
        certParams.setCommonName(IETFUtils.valueToString((ASN1Encodable)x500Name.getRDNs(BCStyle.CN)[0].getFirst().getValue()));
        certParams.setOrganizationUnit(this.getParamValue(KeymanagerUtil.getAttributeIfExist(x500Name, BCStyle.OU), this.organizationUnit));
        certParams.setOrganization(this.getParamValue(KeymanagerUtil.getAttributeIfExist(x500Name, BCStyle.O), this.organization));
        certParams.setLocation(this.getParamValue(KeymanagerUtil.getAttributeIfExist(x500Name, BCStyle.L), this.location));
        certParams.setState(this.getParamValue(KeymanagerUtil.getAttributeIfExist(x500Name, BCStyle.ST), this.state));
        certParams.setCountry(this.getParamValue(KeymanagerUtil.getAttributeIfExist(x500Name, BCStyle.C), this.country));
        certParams.setNotBefore(notBefore);
        certParams.setNotAfter(notAfter);
        return certParams;
    }

    private static String getAttributeIfExist(X500Name x500Name, ASN1ObjectIdentifier identifier) {
        RDN[] rdns = x500Name.getRDNs(identifier);
        if (rdns.length == 0) {
            return "";
        }
        return IETFUtils.valueToString((ASN1Encodable)rdns[0].getFirst().getValue());
    }

    public CertificateParameters getCertificateParameters(KeyPairGenerateRequestDto request, LocalDateTime notBefore, LocalDateTime notAfter, String appId) {
        CertificateParameters certParams = new CertificateParameters();
        String appIdCommonName = this.commonName + " (" + appId.toUpperCase() + ")";
        certParams.setCommonName(this.getParamValue(request.getCommonName(), appIdCommonName));
        certParams.setOrganizationUnit(this.getParamValue(request.getOrganizationUnit(), this.organizationUnit));
        certParams.setOrganization(this.getParamValue(request.getOrganization(), this.organization));
        certParams.setLocation(this.getParamValue(request.getLocation(), this.location));
        certParams.setState(this.getParamValue(request.getState(), this.state));
        certParams.setCountry(this.getParamValue(request.getCountry(), this.country));
        certParams.setNotBefore(notBefore);
        certParams.setNotAfter(notAfter);
        return certParams;
    }

    public CertificateParameters getCertificateParameters(CSRGenerateRequestDto request, LocalDateTime notBefore, LocalDateTime notAfter) {
        CertificateParameters certParams = new CertificateParameters();
        certParams.setCommonName(this.getParamValue(request.getCommonName(), this.commonName));
        certParams.setOrganizationUnit(this.getParamValue(request.getOrganizationUnit(), this.organizationUnit));
        certParams.setOrganization(this.getParamValue(request.getOrganization(), this.organization));
        certParams.setLocation(this.getParamValue(request.getLocation(), this.location));
        certParams.setState(this.getParamValue(request.getState(), this.state));
        certParams.setCountry(this.getParamValue(request.getCountry(), this.country));
        certParams.setNotBefore(notBefore);
        certParams.setNotAfter(notAfter);
        return certParams;
    }

    public CertificateParameters getCertificateParameters(String cName, LocalDateTime notBefore, LocalDateTime notAfter) {
        CertificateParameters certParams = new CertificateParameters();
        certParams.setCommonName(this.getParamValue(cName, this.commonName));
        certParams.setOrganizationUnit(this.getParamValue("", this.organizationUnit));
        certParams.setOrganization(this.getParamValue("", this.organization));
        certParams.setLocation(this.getParamValue("", this.location));
        certParams.setState(this.getParamValue("", this.state));
        certParams.setCountry(this.getParamValue("", this.country));
        certParams.setNotBefore(notBefore);
        certParams.setNotAfter(notAfter);
        return certParams;
    }

    private String getParamValue(String value, String defaultValue) {
        if (Objects.nonNull(value) && !value.trim().isEmpty()) {
            return value;
        }
        return defaultValue;
    }

    public String getCSR(PrivateKey privateKey, PublicKey publicKey, CertificateParameters certParams) {
        try {
            X500Principal csrSubject = new X500Principal("CN=" + certParams.getCommonName() + ", OU=" + certParams.getOrganizationUnit() + ", O=" + certParams.getOrganization() + ", L=" + certParams.getLocation() + ", S=" + certParams.getState() + ", C=" + certParams.getCountry());
            ContentSigner contentSigner = new JcaContentSignerBuilder(this.signAlgorithm).build(privateKey);
            JcaPKCS10CertificationRequestBuilder pcks10Builder = new JcaPKCS10CertificationRequestBuilder(csrSubject, publicKey);
            PKCS10CertificationRequest csrObject = pcks10Builder.build(contentSigner);
            return this.getPEMFormatedData(csrObject);
        }
        catch (OperatorCreationException exp) {
            throw new KeymanagerServiceException(KeymanagerErrorConstant.INTERNAL_SERVER_ERROR.getErrorCode(), KeymanagerErrorConstant.INTERNAL_SERVER_ERROR.getErrorMessage(), exp);
        }
    }

    public void destoryKey(PrivateKey privateKey) {
        try {
            privateKey.destroy();
        }
        catch (DestroyFailedException e) {
            LOGGER.warn("sessionId", "", "", "Warning - while destorying Private Key Object.");
        }
        privateKey = null;
    }

    public void destoryKey(SecretKey secretKey) {
        try {
            secretKey.destroy();
        }
        catch (DestroyFailedException e) {
            LOGGER.warn("sessionId", "", "", "Warning - while destorying Secret Key Object.");
        }
        secretKey = null;
    }

    public LocalDateTime convertToUTC(Date anyDate) {
        LocalDateTime ldTime = DateUtils.parseDateToLocalDateTime((Date)anyDate);
        ZonedDateTime zonedtime = ldTime.atZone(ZoneId.systemDefault());
        ZonedDateTime converted = zonedtime.withZoneSameInstant(ZoneOffset.UTC);
        return converted.toLocalDateTime();
    }

    public String getUniqueIdentifier(String inputStr) {
        return Hex.toHexString((byte[])DigestUtils.sha1((String)inputStr)).toUpperCase();
    }
}

