/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.keymanagerservice.service.impl;

import io.mosip.kernel.core.crypto.exception.InvalidDataException;
import io.mosip.kernel.core.crypto.exception.InvalidKeyException;
import io.mosip.kernel.core.crypto.exception.NullDataException;
import io.mosip.kernel.core.crypto.exception.NullKeyException;
import io.mosip.kernel.core.crypto.exception.NullMethodException;
import io.mosip.kernel.core.keymanager.exception.KeystoreProcessingException;
import io.mosip.kernel.core.keymanager.exception.NoSuchSecurityProviderException;
import io.mosip.kernel.core.keymanager.model.CertificateEntry;
import io.mosip.kernel.core.keymanager.model.CertificateParameters;
import io.mosip.kernel.core.keymanager.spi.KeyStore;
import io.mosip.kernel.core.logger.spi.Logger;
import io.mosip.kernel.core.util.CryptoUtil;
import io.mosip.kernel.core.util.DateUtils;
import io.mosip.kernel.cryptomanager.util.CryptomanagerUtils;
import io.mosip.kernel.keygenerator.bouncycastle.KeyGenerator;
import io.mosip.kernel.keymanager.hsm.util.CertificateUtility;
import io.mosip.kernel.keymanagerservice.constant.KeymanagerConstant;
import io.mosip.kernel.keymanagerservice.constant.KeymanagerErrorConstant;
import io.mosip.kernel.keymanagerservice.dto.AllCertificatesDataResponseDto;
import io.mosip.kernel.keymanagerservice.dto.CSRGenerateRequestDto;
import io.mosip.kernel.keymanagerservice.dto.CertificateDataResponseDto;
import io.mosip.kernel.keymanagerservice.dto.CertificateInfo;
import io.mosip.kernel.keymanagerservice.dto.KeyPairGenerateRequestDto;
import io.mosip.kernel.keymanagerservice.dto.KeyPairGenerateResponseDto;
import io.mosip.kernel.keymanagerservice.dto.PublicKeyResponse;
import io.mosip.kernel.keymanagerservice.dto.RevokeKeyRequestDto;
import io.mosip.kernel.keymanagerservice.dto.RevokeKeyResponseDto;
import io.mosip.kernel.keymanagerservice.dto.SignatureCertificate;
import io.mosip.kernel.keymanagerservice.dto.SymmetricKeyGenerateRequestDto;
import io.mosip.kernel.keymanagerservice.dto.SymmetricKeyGenerateResponseDto;
import io.mosip.kernel.keymanagerservice.dto.SymmetricKeyRequestDto;
import io.mosip.kernel.keymanagerservice.dto.SymmetricKeyResponseDto;
import io.mosip.kernel.keymanagerservice.dto.UploadCertificateRequestDto;
import io.mosip.kernel.keymanagerservice.dto.UploadCertificateResponseDto;
import io.mosip.kernel.keymanagerservice.entity.KeyAlias;
import io.mosip.kernel.keymanagerservice.entity.KeyPolicy;
import io.mosip.kernel.keymanagerservice.exception.CryptoException;
import io.mosip.kernel.keymanagerservice.exception.InvalidResponseObjectTypeException;
import io.mosip.kernel.keymanagerservice.exception.KeymanagerServiceException;
import io.mosip.kernel.keymanagerservice.exception.NoUniqueAliasException;
import io.mosip.kernel.keymanagerservice.helper.KeymanagerDBHelper;
import io.mosip.kernel.keymanagerservice.helper.SessionKeyDecrytorHelper;
import io.mosip.kernel.keymanagerservice.logger.KeymanagerLogger;
import io.mosip.kernel.keymanagerservice.service.KeymanagerService;
import io.mosip.kernel.keymanagerservice.util.KeymanagerUtil;
import io.mosip.kernel.signature.util.SignatureUtil;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class KeymanagerServiceImpl
implements KeymanagerService {
    private static final String VALID_REFERENCE_ID_GETTING_KEY_ALIAS_WITH_REFERENCE_ID = "Valid reference Id. Getting key alias with referenceId";
    private static final String NOT_A_VALID_REFERENCE_ID_GETTING_KEY_ALIAS_WITHOUT_REFERENCE_ID = "Not a valid reference Id. Getting key alias without referenceId";
    private static final Logger LOGGER = KeymanagerLogger.getLogger(KeymanagerServiceImpl.class);
    @Value(value="${mosip.root.key.applicationid:ROOT}")
    private String rootKeyApplicationId;
    @Value(value="${mosip.sign-certificate-refid:SIGN}")
    private String certificateSignRefID;
    @Value(value="${mosip.sign.applicationid:KERNEL}")
    private String signApplicationid;
    @Value(value="${mosip.kernel.certificate.sign.algorithm:SHA256withRSA}")
    private String signAlgorithm;
    @Value(value="${mosip.kernel.keymanager.113nothumbprint.support:false}")
    private boolean noThumbprint;
    @Autowired
    private KeyStore keyStore;
    @Autowired
    private KeyGenerator keyGenerator;
    @Autowired
    KeymanagerUtil keymanagerUtil;
    @Autowired
    private KeymanagerDBHelper dbHelper;
    @Autowired
    CryptomanagerUtils cryptomanagerUtil;
    @Autowired
    SessionKeyDecrytorHelper keyDecryptorHelper;

    private CertificateInfo<X509Certificate> getCertificateFromHSM(String applicationId, LocalDateTime timeStamp, String referenceId) {
        LOGGER.info("sessionId", "applicationId", applicationId, "Getting Certificate from KeyStore.");
        LOGGER.info("sessionId", "timestamp", timeStamp.toString(), "Getting Certificate from KeyStore.");
        String alias = null;
        Optional<KeyPolicy> keyPolicy = this.dbHelper.getKeyPolicy(applicationId);
        Map<String, List<KeyAlias>> keyAliasMap = this.dbHelper.getKeyAliases(applicationId, referenceId, timeStamp);
        List<KeyAlias> currentKeyAlias = keyAliasMap.get("currentKeyAlias");
        List<KeyAlias> keyAlias = keyAliasMap.get("keyAlias");
        if (keyAlias.isEmpty()) {
            LOGGER.error("sessionId", "keyAlias", String.valueOf(keyAlias.size()), "Initial Key generation process not completed.");
            throw new KeymanagerServiceException(KeymanagerErrorConstant.KEY_GENERATION_NOT_DONE.getErrorCode(), KeymanagerErrorConstant.KEY_GENERATION_NOT_DONE.getErrorMessage());
        }
        X509Certificate x509Cert = null;
        if (currentKeyAlias.size() > 1) {
            LOGGER.info("sessionId", "currentKeyAlias", String.valueOf(currentKeyAlias.size()), "CurrentKeyAlias size more than one Throwing exception");
            throw new NoUniqueAliasException(KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorCode(), KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorMessage());
        }
        if (currentKeyAlias.size() == 1) {
            LOGGER.info("sessionId", "currentKeyAlias", currentKeyAlias.get(0).getAlias(), "CurrentKeyAlias size is one fetching keypair using this alias");
            KeyAlias fetchedKeyAlias = currentKeyAlias.get(0);
            alias = fetchedKeyAlias.getAlias();
            x509Cert = (X509Certificate)this.keyStore.getCertificate(alias);
        } else if (currentKeyAlias.isEmpty()) {
            LOGGER.info("sessionId", "currentKeyAlias", String.valueOf(currentKeyAlias.size()), "CurrentKeyAlias size is zero. Will create new Keypair for this applicationId and timestamp");
            alias = UUID.randomUUID().toString();
            ImmutablePair<String, X509Certificate> immPair = this.generateKeyPairInHSM(alias, applicationId, referenceId, timeStamp, keyAlias);
            x509Cert = (X509Certificate)immPair.getRight();
        }
        return new CertificateInfo<Object>(alias, x509Cert);
    }

    private ImmutablePair<String, X509Certificate> generateKeyPairInHSM(String alias, String applicationId, String referenceId, LocalDateTime timeStamp, List<KeyAlias> keyAlias) {
        LocalDateTime generationDateTime = timeStamp;
        LocalDateTime expiryDateTime = this.dbHelper.getExpiryPolicy(applicationId, generationDateTime, keyAlias);
        String rootKeyAlias = this.getRootKeyAlias(applicationId, timeStamp);
        X500Principal latestCertPrincipal = this.getLatestCertPrincipal(keyAlias);
        CertificateParameters certParams = this.keymanagerUtil.getCertificateParameters(latestCertPrincipal, generationDateTime, expiryDateTime);
        this.keyStore.generateAndStoreAsymmetricKey(alias, rootKeyAlias, certParams);
        X509Certificate x509Cert = (X509Certificate)this.keyStore.getCertificate(alias);
        String certThumbprint = this.cryptomanagerUtil.getCertificateThumbprintInHex(x509Cert);
        String uniqueValue = applicationId + "_" + referenceId + "_" + timeStamp.format(KeymanagerConstant.DATE_FORMATTER);
        LOGGER.info("sessionId", "", "", "Unique Value formatter: " + uniqueValue);
        String uniqueIdentifier = this.keymanagerUtil.getUniqueIdentifier(uniqueValue);
        this.dbHelper.storeKeyInAlias(applicationId, generationDateTime, referenceId, alias, expiryDateTime, certThumbprint, uniqueIdentifier);
        ImmutablePair immPair = ImmutablePair.of((Object)uniqueIdentifier, (Object)x509Cert);
        return immPair;
    }

    private X500Principal getLatestCertPrincipal(List<KeyAlias> keyAlias) {
        KeyAlias latestKeyAlias = keyAlias.get(0);
        String alias = latestKeyAlias.getAlias();
        X509Certificate signCert = (X509Certificate)this.keyStore.getCertificate(alias);
        return signCert.getSubjectX500Principal();
    }

    private CertificateInfo<X509Certificate> getCertificateFromDBStore(String applicationId, LocalDateTime timeStamp, String referenceId) {
        LOGGER.info("sessionId", "applicationId", applicationId, "Getting public key from DB Store");
        LOGGER.info("sessionId", "timestamp", timeStamp.toString(), "Getting public key from DB Store");
        LOGGER.info("sessionId", "referenceId", referenceId, "Getting public key from DB Store");
        String alias = null;
        X509Certificate x509Cert = null;
        Map<String, List<KeyAlias>> keyAliasMap = this.dbHelper.getKeyAliases(applicationId, referenceId, timeStamp);
        List<KeyAlias> currentKeyAlias = keyAliasMap.get("currentKeyAlias");
        if (currentKeyAlias.size() > 1) {
            LOGGER.info("sessionId", "currentKeyAlias", String.valueOf(currentKeyAlias.size()), "CurrentKeyAlias size more than one. Throwing exception");
            throw new NoUniqueAliasException(KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorCode(), KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorMessage());
        }
        if (currentKeyAlias.size() == 1) {
            LOGGER.info("sessionId", "currentKeyAlias", currentKeyAlias.get(0).getAlias(), "CurrentKeyAlias size is one. Will fetch keypair using this alias");
            Optional<io.mosip.kernel.keymanagerservice.entity.KeyStore> keyFromDBStore = this.dbHelper.getKeyStoreFromDB(currentKeyAlias.get(0).getAlias());
            if (!keyFromDBStore.isPresent()) {
                LOGGER.info("sessionId", "keyFromDBStore", keyFromDBStore.toString(), "Key in DBStore does not exist for this alias. Throwing exception");
                throw new NoUniqueAliasException(KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorCode(), KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorMessage());
            }
            LOGGER.info("sessionId", "keyFromDBStore", currentKeyAlias.get(0).getAlias(), "Key in DBStore exists for this alias. Fetching Certificate.");
            KeyAlias fetchedKeyAlias = currentKeyAlias.get(0);
            alias = fetchedKeyAlias.getAlias();
            String certificateData = keyFromDBStore.get().getCertificateData();
            x509Cert = (X509Certificate)this.keymanagerUtil.convertToCertificate(certificateData);
        } else if (currentKeyAlias.isEmpty()) {
            String encryptedPrivateKey;
            LOGGER.info("sessionId", "currentKeyAlias", String.valueOf(currentKeyAlias.size()), "CurrentKeyAlias size is zero. Will create new Keypair for this applicationId, referenceId and timestamp");
            List<KeyAlias> keyAlias = keyAliasMap.get("keyAlias");
            if (!keyAlias.isEmpty()) {
                keyAlias.forEach(innerAlias -> {
                    String ksAlias = innerAlias.getAlias();
                    Optional<io.mosip.kernel.keymanagerservice.entity.KeyStore> keyFromDBStore = this.dbHelper.getKeyStoreFromDB(ksAlias);
                    String masterKeyAlias = keyFromDBStore.get().getMasterAlias();
                    String privateKeyObj = keyFromDBStore.get().getPrivateKey();
                    if (ksAlias.equals(masterKeyAlias) || privateKeyObj.equals("NA")) {
                        LOGGER.error("sessionId", "applicationId", null, "Not Allowed to generate New Key Pair for other domains (Partner Certificate might have expired).");
                        throw new KeymanagerServiceException(KeymanagerErrorConstant.GENERATION_NOT_ALLOWED.getErrorCode(), KeymanagerErrorConstant.GENERATION_NOT_ALLOWED.getErrorMessage());
                    }
                });
            }
            if (applicationId.equalsIgnoreCase("ROOT")) {
                LOGGER.error("sessionId", "applicationId", null, "Not Allowed to generate Base Key for Root Key.");
                throw new KeymanagerServiceException(KeymanagerErrorConstant.GENERATION_NOT_ALLOWED.getErrorCode(), KeymanagerErrorConstant.GENERATION_NOT_ALLOWED.getErrorMessage());
            }
            if (applicationId.equalsIgnoreCase("KERNEL")) {
                LOGGER.error("sessionId", "KERNEL", null, "Not Allowed to generate Base Key for Kernel App Id.");
                throw new KeymanagerServiceException(KeymanagerErrorConstant.GENERATION_NOT_ALLOWED.getErrorCode(), KeymanagerErrorConstant.GENERATION_NOT_ALLOWED.getErrorMessage());
            }
            if (applicationId.equalsIgnoreCase("PARTNER")) {
                LOGGER.error("sessionId", "KERNEL", null, "Not Allowed to generate Keys for PARTNER App Id.");
                throw new KeymanagerServiceException(KeymanagerErrorConstant.GENERATION_NOT_ALLOWED.getErrorCode(), KeymanagerErrorConstant.GENERATION_NOT_ALLOWED.getErrorMessage());
            }
            Optional<KeyPolicy> keyPolicy = this.dbHelper.getKeyPolicy(applicationId);
            alias = UUID.randomUUID().toString();
            KeyPair keypair = this.keyGenerator.getAsymmetricKey();
            PrivateKey privateKey = keypair.getPrivate();
            CertificateInfo<X509Certificate> certInfo = this.getCertificateFromHSM(applicationId, timeStamp, "");
            X509Certificate hsmX509Cert = certInfo.getCertificate();
            PublicKey masterPublicKey = hsmX509Cert.getPublicKey();
            String masterAlias = certInfo.getAlias();
            LocalDateTime generationDateTime = timeStamp;
            LocalDateTime expiryDateTime = this.dbHelper.getExpiryPolicy("BASE", generationDateTime, keyAliasMap.get("keyAlias"));
            try {
                encryptedPrivateKey = CryptoUtil.encodeToURLSafeBase64((byte[])this.keymanagerUtil.encryptKey(privateKey, masterPublicKey));
            }
            catch (InvalidDataException | InvalidKeyException | NullDataException | NullKeyException | NullMethodException e) {
                throw new CryptoException(KeymanagerErrorConstant.CRYPTO_EXCEPTION.getErrorCode(), KeymanagerErrorConstant.CRYPTO_EXCEPTION.getErrorMessage() + e.getErrorText());
            }
            KeyStore.PrivateKeyEntry signKeyEntry = this.keyStore.getAsymmetricKey(masterAlias);
            PrivateKey signPrivateKey = signKeyEntry.getPrivateKey();
            X509Certificate signCert = (X509Certificate)signKeyEntry.getCertificate();
            X500Principal signerPrincipal = signCert.getSubjectX500Principal();
            CertificateParameters certParams = this.keymanagerUtil.getCertificateParameters(signerPrincipal, generationDateTime, expiryDateTime);
            certParams.setCommonName(applicationId + "-" + referenceId);
            x509Cert = CertificateUtility.generateX509Certificate(signPrivateKey, keypair.getPublic(), certParams, signerPrincipal, this.signAlgorithm, this.keyStore.getKeystoreProviderName(), "EncryptionKey");
            String certificateData = this.keymanagerUtil.getPEMFormatedData(x509Cert);
            this.dbHelper.storeKeyInDBStore(alias, masterAlias, certificateData, encryptedPrivateKey);
            String certThumbprint = this.cryptomanagerUtil.getCertificateThumbprintInHex(x509Cert);
            String uniqueValue = applicationId + "_" + referenceId + "_" + timeStamp.format(KeymanagerConstant.DATE_FORMATTER);
            LOGGER.info("sessionId", "", "", "Unique Value formatter: " + uniqueValue);
            String uniqueIdentifier = this.keymanagerUtil.getUniqueIdentifier(uniqueValue);
            this.dbHelper.storeKeyInAlias(applicationId, generationDateTime, referenceId, alias, expiryDateTime, certThumbprint, uniqueIdentifier);
            this.keymanagerUtil.destoryKey(privateKey);
        }
        return new CertificateInfo<Object>(alias, x509Cert);
    }

    @Override
    public SymmetricKeyResponseDto decryptSymmetricKey(SymmetricKeyRequestDto symmetricKeyRequestDto) {
        return this.keyDecryptorHelper.decryptSessionKey(symmetricKeyRequestDto);
    }

    @Override
    public SignatureCertificate getSignatureCertificate(String applicationId, Optional<String> referenceId, String timestamp) {
        return this.getSigningCertificate(applicationId, referenceId, timestamp, true);
    }

    private SignatureCertificate getSigningCertificate(String applicationId, Optional<String> referenceId, String timestamp, boolean isPrivateRequired) {
        String alias = null;
        List<KeyAlias> currentKeyAlias = null;
        Map<String, List<KeyAlias>> keyAliasMap = null;
        LocalDateTime generationDateTime = null;
        LocalDateTime expiryDateTime = null;
        CertificateEntry<X509Certificate, PrivateKey> certificateEntry = null;
        LocalDateTime localDateTimeStamp = DateUtils.getUTCCurrentDateTime();
        String refId = null;
        String uniqueIdentifier = null;
        if (!referenceId.isPresent() || referenceId.get().trim().isEmpty()) {
            LOGGER.info("sessionId", "", "", NOT_A_VALID_REFERENCE_ID_GETTING_KEY_ALIAS_WITHOUT_REFERENCE_ID);
            keyAliasMap = this.dbHelper.getKeyAliases(applicationId, "", localDateTimeStamp);
            refId = "";
        } else if (applicationId.equalsIgnoreCase(this.signApplicationid) && referenceId.isPresent() && referenceId.get().equals(this.certificateSignRefID)) {
            LOGGER.info("sessionId", applicationId, referenceId.get(), VALID_REFERENCE_ID_GETTING_KEY_ALIAS_WITH_REFERENCE_ID);
            keyAliasMap = this.dbHelper.getKeyAliases(applicationId, referenceId.get(), localDateTimeStamp);
            refId = referenceId.get();
        } else {
            LOGGER.error("sessionId", applicationId, referenceId.get(), "Signing operation not allowed for the provided application Id & reference Id.");
            throw new KeymanagerServiceException(KeymanagerErrorConstant.NOT_VALID_SIGNATURE_KEY.getErrorCode(), KeymanagerErrorConstant.NOT_VALID_SIGNATURE_KEY.getErrorMessage());
        }
        List<KeyAlias> keyAlias = keyAliasMap.get("keyAlias");
        currentKeyAlias = keyAliasMap.get("currentKeyAlias");
        if (currentKeyAlias.size() > 1) {
            LOGGER.info("sessionId", "currentKeyAlias", String.valueOf(currentKeyAlias.size()), "CurrentKeyAlias size more than one. Throwing exception");
            throw new NoUniqueAliasException(KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorCode(), KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorMessage());
        }
        if (currentKeyAlias.size() == 1) {
            LOGGER.info("sessionId", "currentKeyAlias", currentKeyAlias.get(0).getAlias(), "CurrentKeyAlias size is one. Will fetch keypair using this alias");
            KeyAlias fetchedKeyAlias = currentKeyAlias.get(0);
            alias = fetchedKeyAlias.getAlias();
            certificateEntry = this.getCertificateEntry(alias, isPrivateRequired);
            generationDateTime = fetchedKeyAlias.getKeyGenerationTime();
            expiryDateTime = fetchedKeyAlias.getKeyExpiryTime();
            uniqueIdentifier = fetchedKeyAlias.getUniqueIdentifier();
        } else if (currentKeyAlias.isEmpty() && keyAlias.size() > 0) {
            LOGGER.info("sessionId", "keyAlias", keyAlias.get(0).getAlias(), "CurrentKeyAlias size is zero. Key got expired, generating new keypair using this App Id & Ref Id");
            alias = UUID.randomUUID().toString();
            ImmutablePair<String, X509Certificate> immPair = this.generateKeyPairInHSM(alias, applicationId, refId, localDateTimeStamp, keyAlias);
            certificateEntry = this.getCertificateEntry(alias, isPrivateRequired);
            generationDateTime = localDateTimeStamp;
            expiryDateTime = this.dbHelper.getExpiryPolicy(applicationId, generationDateTime, keyAlias);
            uniqueIdentifier = (String)immPair.getLeft();
        } else {
            LOGGER.error("sessionId", "keyAlias", String.valueOf(keyAlias.size()), "Initial Key generation process not completed.");
            throw new KeymanagerServiceException(KeymanagerErrorConstant.KEY_GENERATION_NOT_DONE.getErrorCode(), KeymanagerErrorConstant.KEY_GENERATION_NOT_DONE.getErrorMessage());
        }
        String providerName = this.keyStore.getKeystoreProviderName();
        return new SignatureCertificate(alias, certificateEntry, generationDateTime, expiryDateTime, providerName, uniqueIdentifier);
    }

    private CertificateEntry<X509Certificate, PrivateKey> getCertificateEntry(String alias, boolean isPrivateRequired) {
        Throwable exception = null;
        try {
            KeyStore.PrivateKeyEntry privateKeyEntry = this.keyStore.getAsymmetricKey(alias);
            return new CertificateEntry((Object[])((X509Certificate[])privateKeyEntry.getCertificateChain()), (Object)privateKeyEntry.getPrivateKey());
        }
        catch (KeystoreProcessingException | NoSuchSecurityProviderException kpe) {
            LOGGER.error("sessionId", "currentKeyAlias", "Error", "Key Not found in HSM, keystore might have loaded as offline." + kpe.getMessage());
            exception = kpe;
            if (!isPrivateRequired) {
                Optional<io.mosip.kernel.keymanagerservice.entity.KeyStore> keyFromDBStore = this.dbHelper.getKeyStoreFromDB(alias);
                if (!keyFromDBStore.isPresent()) {
                    LOGGER.error("sessionId", "currentKeyAlias", "", "Certificate Not found in keystore table.");
                    throw new KeymanagerServiceException(KeymanagerErrorConstant.CERTIFICATE_NOT_FOUND.getErrorCode(), KeymanagerErrorConstant.CERTIFICATE_NOT_FOUND.getErrorMessage());
                }
                String certificateData = keyFromDBStore.get().getCertificateData();
                X509Certificate reqX509Cert = (X509Certificate)this.keymanagerUtil.convertToCertificate(certificateData);
                return new CertificateEntry((Object[])new X509Certificate[]{reqX509Cert}, null);
            }
            throw exception;
        }
    }

    @Override
    public PublicKeyResponse<String> getSignPublicKey(String applicationId, String timestamp, Optional<String> referenceId) {
        String localDateTimeStamp = DateUtils.getUTCCurrentDateTimeString();
        SignatureCertificate certificateResponse = this.getSigningCertificate(applicationId, referenceId, localDateTimeStamp, false);
        return new PublicKeyResponse<String>(certificateResponse.getAlias(), CryptoUtil.encodeToURLSafeBase64((byte[])((X509Certificate[])certificateResponse.getCertificateEntry().getChain())[0].getPublicKey().getEncoded()), certificateResponse.getIssuedAt(), certificateResponse.getExpiryAt());
    }

    @Override
    public KeyPairGenerateResponseDto generateMasterKey(String responseObjectType, KeyPairGenerateRequestDto request) {
        String applicationId = request.getApplicationId();
        String refId = request.getReferenceId() == null ? "" : request.getReferenceId();
        Boolean forceFlag = request.getForce() == null ? Boolean.FALSE : request.getForce();
        Optional<KeyPolicy> keyPolicy = this.dbHelper.getKeyPolicy(applicationId);
        if (this.keymanagerUtil.isValidReferenceId(refId) && (refId.equals(this.certificateSignRefID) && !applicationId.equals(this.signApplicationid) || !refId.equals(this.certificateSignRefID))) {
            LOGGER.error("sessionId", "keyPolicy", keyPolicy.toString(), "Reference Id not supported for the provided application Id.");
            throw new KeymanagerServiceException(KeymanagerErrorConstant.REFERENCE_ID_NOT_SUPPORTED.getErrorCode(), KeymanagerErrorConstant.REFERENCE_ID_NOT_SUPPORTED.getErrorMessage());
        }
        if (!this.keymanagerUtil.isValidResponseType(responseObjectType)) {
            LOGGER.error("sessionId", "Response Object Type", null, "Invalid Response Object type provided for the key generation request.");
            throw new KeymanagerServiceException(KeymanagerErrorConstant.INVALID_REQUEST.getErrorCode(), KeymanagerErrorConstant.INVALID_REQUEST.getErrorMessage());
        }
        LOGGER.info("sessionId", "applicationId", "", "Request for Master Key Generation");
        return this.generateKey(responseObjectType, applicationId, refId, forceFlag, request);
    }

    private KeyPairGenerateResponseDto generateKey(String responseObjectType, String appId, String refId, Boolean forceFlag, KeyPairGenerateRequestDto request) {
        LOGGER.info("sessionId", "applicationId", appId, "Generate Key for application ID: " + appId + ", RefId: " + refId + ", force flag: " + forceFlag.toString());
        LocalDateTime timestamp = DateUtils.getUTCCurrentDateTime();
        Map<String, List<KeyAlias>> keyAliasMap = this.dbHelper.getKeyAliases(appId, refId, timestamp);
        List<KeyAlias> currentKeyAlias = keyAliasMap.get("currentKeyAlias");
        if (forceFlag.booleanValue()) {
            LOGGER.debug("sessionId", "applicationId", appId, "Force Flag is True, invalidating all the existing keys and generating new key pair.");
            LocalDateTime expireTime = timestamp.minusMinutes(1L);
            currentKeyAlias.forEach(alias -> this.dbHelper.storeKeyInAlias(appId, alias.getKeyGenerationTime(), refId, alias.getAlias(), expireTime, alias.getCertThumbprint(), alias.getUniqueIdentifier()));
            return this.generateAndBuildResponse(responseObjectType, appId, refId, timestamp, keyAliasMap, request);
        }
        if (currentKeyAlias.size() > 1) {
            LOGGER.error("sessionId", "currentKeyAlias", String.valueOf(currentKeyAlias.size()), "CurrentKeyAlias size more than one");
            throw new NoUniqueAliasException(KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorCode(), KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorMessage());
        }
        if (currentKeyAlias.isEmpty()) {
            LOGGER.info("sessionId", "currentKeyAlias", String.valueOf(currentKeyAlias.size()), "CurrentKeyAlias size is zero. Will create new Keypair for this applicationId and timestamp");
            return this.generateAndBuildResponse(responseObjectType, appId, refId, timestamp, keyAliasMap, request);
        }
        LOGGER.info("sessionId", "currentKeyAlias", String.valueOf(currentKeyAlias.size()), "key details present in DB" + currentKeyAlias.get(0));
        KeyAlias fetchedKeyAlias = currentKeyAlias.get(0);
        return this.buildResponseObject(responseObjectType, appId, refId, timestamp, fetchedKeyAlias.getAlias(), fetchedKeyAlias.getKeyGenerationTime(), fetchedKeyAlias.getKeyExpiryTime(), request);
    }

    private KeyPairGenerateResponseDto generateAndBuildResponse(String responseObjectType, String appId, String refId, LocalDateTime timestamp, Map<String, List<KeyAlias>> keyAliasMap, KeyPairGenerateRequestDto request) {
        String alias = UUID.randomUUID().toString();
        LocalDateTime generationDateTime = timestamp;
        LocalDateTime expiryDateTime = this.dbHelper.getExpiryPolicy(appId, generationDateTime, keyAliasMap.get("keyAlias"));
        String rootKeyAlias = this.getRootKeyAlias(appId, timestamp);
        CertificateParameters certParams = this.keymanagerUtil.getCertificateParameters(request, generationDateTime, expiryDateTime, appId);
        this.keyStore.generateAndStoreAsymmetricKey(alias, rootKeyAlias, certParams);
        X509Certificate x509Cert = (X509Certificate)this.keyStore.getCertificate(alias);
        String certThumbprint = this.cryptomanagerUtil.getCertificateThumbprintInHex(x509Cert);
        String uniqueValue = appId + "_" + refId + "_" + timestamp.format(KeymanagerConstant.DATE_FORMATTER);
        LOGGER.info("sessionId", "", "", "Unique Value formatter: " + uniqueValue);
        String uniqueIdentifier = this.keymanagerUtil.getUniqueIdentifier(uniqueValue);
        this.dbHelper.storeKeyInAlias(appId, generationDateTime, refId, alias, expiryDateTime, certThumbprint, uniqueIdentifier);
        return this.buildResponseObject(responseObjectType, appId, refId, timestamp, alias, generationDateTime, expiryDateTime, request);
    }

    private String getRootKeyAlias(String appId, LocalDateTime timestamp) {
        Map<String, List<KeyAlias>> rootKeyAliasMap = this.dbHelper.getKeyAliases(this.rootKeyApplicationId, "", timestamp);
        List<KeyAlias> rootCurrentKeyAlias = rootKeyAliasMap.get("currentKeyAlias");
        String rootKeyAlias = null;
        if (rootCurrentKeyAlias.size() > 1) {
            LOGGER.error("sessionId", "currentKeyAlias", String.valueOf(rootCurrentKeyAlias.size()), "CurrentKeyAlias size more than one for ROOT Key");
            throw new NoUniqueAliasException(KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorCode(), KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorMessage());
        }
        if (rootCurrentKeyAlias.size() == 1) {
            LOGGER.info("sessionId", "currentKeyAlias", String.valueOf(rootCurrentKeyAlias.size()), "CurrentKeyAlias size is one. Use the current root key alias as key to sign the key.");
            rootKeyAlias = rootCurrentKeyAlias.get(0).getAlias();
        }
        LOGGER.info("sessionId", "Root Key", "Found Root Key.", "Root Key for signing the new generated key: " + rootKeyAlias);
        if (Objects.isNull(rootKeyAlias) && !appId.equals(this.rootKeyApplicationId)) {
            LOGGER.error("sessionId", "Root Key", "Root Key Error", "ROOT Key not available to sign the new generated key.");
            throw new KeymanagerServiceException(KeymanagerErrorConstant.ROOT_KEY_NOT_FOUND.getErrorCode(), KeymanagerErrorConstant.ROOT_KEY_NOT_FOUND.getErrorMessage());
        }
        return rootKeyAlias;
    }

    private KeyPairGenerateResponseDto buildResponseObject(String responseObjectType, String appId, String refId, LocalDateTime timestamp, String keyAlias, LocalDateTime generationDateTime, LocalDateTime expiryDateTime, KeyPairGenerateRequestDto request) {
        if (responseObjectType.toUpperCase().equals("CERTIFICATE")) {
            LOGGER.info("sessionId", "applicationId", appId, "Getting Key Certificate for application ID: " + appId + ", RefId: " + refId);
            X509Certificate x509Cert = (X509Certificate)this.keyStore.getCertificate(keyAlias);
            KeyPairGenerateResponseDto responseDto = new KeyPairGenerateResponseDto();
            responseDto.setCertificate(this.keymanagerUtil.getPEMFormatedData(x509Cert));
            responseDto.setExpiryAt(DateUtils.parseDateToLocalDateTime((Date)x509Cert.getNotAfter()));
            responseDto.setIssuedAt(DateUtils.parseDateToLocalDateTime((Date)x509Cert.getNotBefore()));
            responseDto.setTimestamp(timestamp);
            return responseDto;
        }
        if (responseObjectType.toUpperCase().equals("CSR")) {
            LOGGER.info("sessionId", "applicationId", appId, "Getting Key CSR for application ID: " + appId + ", RefId: " + refId);
            PublicKey publicKey = ((X509Certificate)this.keyStore.getCertificate(keyAlias)).getPublicKey();
            PrivateKey privateKey = this.keyStore.getPrivateKey(keyAlias);
            KeyPairGenerateResponseDto responseDto = new KeyPairGenerateResponseDto();
            CertificateParameters certParams = this.keymanagerUtil.getCertificateParameters(request, generationDateTime, expiryDateTime, appId);
            responseDto.setCertSignRequest(this.keymanagerUtil.getCSR(privateKey, publicKey, certParams));
            responseDto.setExpiryAt(expiryDateTime);
            responseDto.setIssuedAt(generationDateTime);
            responseDto.setTimestamp(timestamp);
            return responseDto;
        }
        LOGGER.error("sessionId", "Response Object Type", null, "Invalid Response Object type provided for the key pair");
        throw new InvalidResponseObjectTypeException(KeymanagerErrorConstant.INVALID_RESPONSE_TYPE.getErrorCode(), KeymanagerErrorConstant.INVALID_RESPONSE_TYPE.getErrorMessage());
    }

    @Override
    public KeyPairGenerateResponseDto getCertificate(String appId, Optional<String> refId) {
        LOGGER.info("sessionId", "applicationId", appId, "Request received to getCertificate");
        LOGGER.info("sessionId", "referenceId", refId.toString(), "Request received to getCertificate");
        LocalDateTime localDateTimeStamp = DateUtils.getUTCCurrentDateTime();
        CertificateInfo<X509Certificate> certificateData = null;
        if (!refId.isPresent() || refId.get().trim().isEmpty()) {
            LOGGER.info("sessionId", "", "", "Reference Id is not present. Will get Certificate from HSM");
            certificateData = this.getCertificateFromHSM(appId, localDateTimeStamp, "");
        } else if (appId.equalsIgnoreCase(this.signApplicationid) && refId.isPresent() && refId.get().equals(this.certificateSignRefID)) {
            LOGGER.info("sessionId", "", "", "Reference Id is present and it is SIGN reference. Will get Certificate from HSM");
            certificateData = this.getCertificateFromHSM(appId, localDateTimeStamp, refId.get());
        } else {
            LOGGER.info("sessionId", "", "", "Reference Id is present. Will get Certificate from DB store");
            certificateData = this.getCertificateFromDBStore(appId, localDateTimeStamp, refId.get());
        }
        X509Certificate x509Cert = certificateData.getCertificate();
        KeyPairGenerateResponseDto responseDto = new KeyPairGenerateResponseDto();
        responseDto.setCertificate(this.keymanagerUtil.getPEMFormatedData(x509Cert));
        responseDto.setExpiryAt(DateUtils.parseDateToLocalDateTime((Date)x509Cert.getNotAfter()));
        responseDto.setIssuedAt(DateUtils.parseDateToLocalDateTime((Date)x509Cert.getNotBefore()));
        responseDto.setTimestamp(localDateTimeStamp);
        return responseDto;
    }

    @Override
    public KeyPairGenerateResponseDto generateCSR(CSRGenerateRequestDto csrGenRequestDto) {
        String appId = csrGenRequestDto.getApplicationId();
        Optional<String> refId = Optional.ofNullable(csrGenRequestDto.getReferenceId());
        LocalDateTime localDateTimeStamp = DateUtils.getUTCCurrentDateTime();
        this.dbHelper.getKeyPolicy(appId);
        CertificateInfo<X509Certificate> certificateData = null;
        if (!refId.isPresent() || refId.get().trim().isEmpty()) {
            LOGGER.info("sessionId", "", "", "Reference Id is not present. Will get Certificate from HSM");
            certificateData = this.getCertificateFromHSM(appId, localDateTimeStamp, "");
        } else {
            if (appId.equalsIgnoreCase("KERNEL") && refId.isPresent() && refId.get().equalsIgnoreCase("IDENTITY_CACHE")) {
                LOGGER.error("sessionId", "KERNEL", "", "Reference Id is present and it is IDENTITY_CACHE reference id. CSR generation not possible.");
                throw new KeymanagerServiceException(KeymanagerErrorConstant.GENERATION_CSR_ALLOWED.getErrorCode(), KeymanagerErrorConstant.GENERATION_CSR_ALLOWED.getErrorMessage());
            }
            if (appId.equalsIgnoreCase(this.signApplicationid) && refId.isPresent() && refId.get().equals(this.certificateSignRefID)) {
                LOGGER.info("sessionId", "", "", "Reference Id is present and it is SIGN reference. Will get Certificate from HSM");
                certificateData = this.getCertificateFromHSM(appId, localDateTimeStamp, refId.get());
            } else {
                LOGGER.info("sessionId", "", "", "Reference Id is present. Will get Certificate from DB store");
                certificateData = this.getCertificateFromDBStore(appId, localDateTimeStamp, refId.get());
            }
        }
        String keyAlias = certificateData.getAlias();
        Optional<io.mosip.kernel.keymanagerservice.entity.KeyStore> keyFromDBStore = this.dbHelper.getKeyStoreFromDB(keyAlias);
        Object[] keyDetailsArr = this.getKeyDetails(keyFromDBStore, keyAlias);
        PrivateKey signPrivateKey = (PrivateKey)keyDetailsArr[0];
        X509Certificate x509Cert = (X509Certificate)keyDetailsArr[1];
        LocalDateTime generationDateTime = DateUtils.parseDateToLocalDateTime((Date)x509Cert.getNotBefore());
        LocalDateTime expiryDateTime = DateUtils.parseDateToLocalDateTime((Date)x509Cert.getNotAfter());
        CertificateParameters certParams = this.keymanagerUtil.getCertificateParameters(csrGenRequestDto, generationDateTime, expiryDateTime);
        KeyPairGenerateResponseDto responseDto = new KeyPairGenerateResponseDto();
        responseDto.setCertSignRequest(this.keymanagerUtil.getCSR(signPrivateKey, x509Cert.getPublicKey(), certParams));
        responseDto.setExpiryAt(expiryDateTime);
        responseDto.setIssuedAt(generationDateTime);
        responseDto.setTimestamp(localDateTimeStamp);
        if (!(!refId.isPresent() && refId.get().trim().isEmpty() || appId.equalsIgnoreCase(this.signApplicationid) || refId.get().equals(this.certificateSignRefID))) {
            this.keymanagerUtil.destoryKey(signPrivateKey);
        }
        return responseDto;
    }

    private KeyAlias getKeyAlias(String appId, String refId) {
        if (!this.keymanagerUtil.isValidApplicationId(appId)) {
            LOGGER.error("sessionId", "applicationId", null, "Invalid application ID provided to get Object details.");
            throw new KeymanagerServiceException(KeymanagerErrorConstant.INVALID_REQUEST.getErrorCode(), KeymanagerErrorConstant.INVALID_REQUEST.getErrorMessage());
        }
        LOGGER.info("sessionId", "applicationId", appId, "to get KeyInfo for application ID: " + appId + ", RefId: " + refId);
        Optional<KeyPolicy> keyPolicy = this.dbHelper.getKeyPolicy(appId);
        LocalDateTime timestamp = DateUtils.getUTCCurrentDateTime();
        Map<String, List<KeyAlias>> keyAliasMap = this.dbHelper.getKeyAliases(appId, refId, timestamp);
        List<KeyAlias> currentKeyAlias = keyAliasMap.get("currentKeyAlias");
        if (currentKeyAlias.size() > 1) {
            LOGGER.error("sessionId", "currentKeyAlias", String.valueOf(currentKeyAlias.size()), "CurrentKeyAlias size more than one");
            throw new NoUniqueAliasException(KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorCode(), KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorMessage());
        }
        if (currentKeyAlias.isEmpty()) {
            LOGGER.info("sessionId", "currentKeyAlias", String.valueOf(currentKeyAlias.size()), "CurrentKeyAlias size is zero for this applicationId and timestamp");
            throw new NoUniqueAliasException(KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorCode(), KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorMessage());
        }
        LOGGER.info("sessionId", "currentKeyAlias", String.valueOf(currentKeyAlias.size()), "key details present in DB: " + currentKeyAlias.get(0));
        KeyAlias fetchedKeyAlias = currentKeyAlias.get(0);
        return fetchedKeyAlias;
    }

    private Object[] getKeyDetails(Optional<io.mosip.kernel.keymanagerservice.entity.KeyStore> keyFromDBStore, String keyAlias) {
        if (!keyFromDBStore.isPresent()) {
            LOGGER.info("sessionId", "keyFromDBStore", keyFromDBStore.toString(), "Key in DBStore does not exist for this alias. So fetching the certificate from HSM.");
            KeyStore.PrivateKeyEntry signKeyEntry = this.keyStore.getAsymmetricKey(keyAlias);
            PrivateKey signPrivateKey = signKeyEntry.getPrivateKey();
            X509Certificate x509Cert = (X509Certificate)signKeyEntry.getCertificate();
            return new Object[]{signPrivateKey, x509Cert};
        }
        KeyStore.PrivateKeyEntry masterKeyEntry = this.keyStore.getAsymmetricKey(keyFromDBStore.get().getMasterAlias());
        PrivateKey masterPrivateKey = masterKeyEntry.getPrivateKey();
        PublicKey masterPublicKey = masterKeyEntry.getCertificate().getPublicKey();
        try {
            byte[] decryptedPrivateKey = this.keymanagerUtil.decryptKey(CryptoUtil.decodeURLSafeBase64((String)keyFromDBStore.get().getPrivateKey()), masterPrivateKey, masterPublicKey, this.keyStore.getKeystoreProviderName());
            PrivateKey signPrivateKey = KeyFactory.getInstance("RSA").generatePrivate(new PKCS8EncodedKeySpec(decryptedPrivateKey));
            X509Certificate x509Cert = (X509Certificate)this.keymanagerUtil.convertToCertificate(keyFromDBStore.get().getCertificateData());
            return new Object[]{signPrivateKey, x509Cert};
        }
        catch (InvalidDataException | InvalidKeyException | NullDataException | NullKeyException | NullMethodException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new CryptoException(KeymanagerErrorConstant.CRYPTO_EXCEPTION.getErrorCode(), KeymanagerErrorConstant.CRYPTO_EXCEPTION.getErrorMessage() + e.getMessage(), e);
        }
    }

    @Override
    public UploadCertificateResponseDto uploadCertificate(UploadCertificateRequestDto uploadCertRequestDto) {
        String appId = uploadCertRequestDto.getApplicationId();
        String refId = uploadCertRequestDto.getReferenceId();
        String certificateData = uploadCertRequestDto.getCertificateData();
        if (!this.keymanagerUtil.isValidCertificateData(certificateData)) {
            LOGGER.error("sessionId", "applicationId", null, "Invalid Certificate Data provided to upload the certificate.");
            throw new KeymanagerServiceException(KeymanagerErrorConstant.INVALID_REQUEST.getErrorCode(), KeymanagerErrorConstant.INVALID_REQUEST.getErrorMessage());
        }
        LocalDateTime timestamp = DateUtils.getUTCCurrentDateTime();
        KeyAlias currentKeyAlias = this.getKeyAlias(appId, refId);
        String keyAlias = currentKeyAlias.getAlias();
        Optional<io.mosip.kernel.keymanagerservice.entity.KeyStore> keyFromDBStore = this.dbHelper.getKeyStoreFromDB(keyAlias);
        Object[] keyDetailsArr = this.getKeyDetails(keyFromDBStore, keyAlias);
        PrivateKey privateKey = (PrivateKey)keyDetailsArr[0];
        X509Certificate x509Cert = (X509Certificate)keyDetailsArr[1];
        X509Certificate reqX509Cert = (X509Certificate)this.keymanagerUtil.convertToCertificate(certificateData);
        if (!Arrays.equals(x509Cert.getPublicKey().getEncoded(), reqX509Cert.getPublicKey().getEncoded())) {
            LOGGER.error("sessionId", "applicationId", null, "Certificate Key is not matching with the available key.");
            throw new KeymanagerServiceException(KeymanagerErrorConstant.KEY_NOT_MATCHING.getErrorCode(), KeymanagerErrorConstant.KEY_NOT_MATCHING.getErrorMessage());
        }
        LocalDateTime notBeforeDate = this.keymanagerUtil.convertToUTC(reqX509Cert.getNotBefore());
        LocalDateTime notAfterDate = this.keymanagerUtil.convertToUTC(reqX509Cert.getNotAfter());
        if (!keyFromDBStore.isPresent()) {
            this.keyStore.storeCertificate(keyAlias, privateKey, (Certificate)reqX509Cert);
        } else {
            this.dbHelper.storeKeyInDBStore(keyAlias, keyFromDBStore.get().getMasterAlias(), this.keymanagerUtil.getPEMFormatedData(reqX509Cert), keyFromDBStore.get().getPrivateKey());
        }
        String certThumbprint = this.cryptomanagerUtil.getCertificateThumbprintInHex(reqX509Cert);
        String uniqueValue = appId + "_" + refId + "_" + timestamp.format(KeymanagerConstant.DATE_FORMATTER);
        LOGGER.info("sessionId", "", "", "Unique Value formatter: " + uniqueValue);
        String uniqueIdentifier = this.keymanagerUtil.getUniqueIdentifier(uniqueValue);
        this.dbHelper.storeKeyInAlias(appId, notBeforeDate, refId, keyAlias, notAfterDate, certThumbprint, uniqueIdentifier);
        UploadCertificateResponseDto responseDto = new UploadCertificateResponseDto();
        responseDto.setStatus("Upload Success");
        responseDto.setTimestamp(timestamp);
        return responseDto;
    }

    @Override
    public UploadCertificateResponseDto uploadOtherDomainCertificate(UploadCertificateRequestDto uploadCertRequestDto) {
        String appId = uploadCertRequestDto.getApplicationId();
        String refId = uploadCertRequestDto.getReferenceId();
        String certificateData = uploadCertRequestDto.getCertificateData();
        if (!(this.keymanagerUtil.isValidCertificateData(certificateData) && this.keymanagerUtil.isValidReferenceId(refId) && this.keymanagerUtil.isValidApplicationId(appId))) {
            LOGGER.error("sessionId", "applicationId", null, "Invalid Data provided to upload other domain certificate.");
            throw new KeymanagerServiceException(KeymanagerErrorConstant.INVALID_REQUEST.getErrorCode(), KeymanagerErrorConstant.INVALID_REQUEST.getErrorMessage());
        }
        if (appId.equalsIgnoreCase(this.signApplicationid) && refId.equalsIgnoreCase(this.certificateSignRefID)) {
            LOGGER.error("sessionId", "applicationId", null, "Not allowed to upload other domain certificate with AppId: " + this.signApplicationid + " & RefId: SIGN.");
            throw new KeymanagerServiceException(KeymanagerErrorConstant.UPLOAD_NOT_ALLOWED.getErrorCode(), KeymanagerErrorConstant.UPLOAD_NOT_ALLOWED.getErrorMessage());
        }
        LOGGER.info("sessionId", "applicationId", appId, "to get KeyInfo for application ID: " + appId + ", RefId: " + refId);
        LocalDateTime timestamp = DateUtils.getUTCCurrentDateTime();
        Map<String, List<KeyAlias>> keyAliasMap = this.dbHelper.getKeyAliases(appId, refId, timestamp);
        List<KeyAlias> currentKeyAlias = keyAliasMap.get("currentKeyAlias");
        if (currentKeyAlias.size() > 1) {
            LOGGER.error("sessionId", "currentKeyAlias", String.valueOf(currentKeyAlias.size()), "CurrentKeyAlias size more than one");
            throw new NoUniqueAliasException(KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorCode(), KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorMessage());
        }
        List<KeyAlias> keyAliasList = keyAliasMap.get("keyAlias");
        X509Certificate reqX509Cert = (X509Certificate)this.keymanagerUtil.convertToCertificate(certificateData);
        String certThumbprint = this.cryptomanagerUtil.getCertificateThumbprintInHex(reqX509Cert);
        LocalDateTime notBeforeDate = this.keymanagerUtil.convertToUTC(reqX509Cert.getNotBefore());
        LocalDateTime notAfterDate = this.keymanagerUtil.convertToUTC(reqX509Cert.getNotAfter());
        if (currentKeyAlias.isEmpty() && keyAliasList.isEmpty()) {
            return this.storeAndBuildResponse(appId, refId, reqX509Cert, notBeforeDate, notAfterDate, certThumbprint);
        }
        if (currentKeyAlias.isEmpty() && keyAliasList.size() > 0) {
            String keyAlias = keyAliasList.get(0).getAlias();
            Optional<io.mosip.kernel.keymanagerservice.entity.KeyStore> keyFromDBStore = this.dbHelper.getKeyStoreFromDB(keyAlias);
            if (!keyFromDBStore.isPresent()) {
                LOGGER.error("sessionId", "", "", "Other valid key is available, so not allowed to upload certificate.");
                throw new KeymanagerServiceException(KeymanagerErrorConstant.UPLOAD_NOT_ALLOWED.getErrorCode(), KeymanagerErrorConstant.UPLOAD_NOT_ALLOWED.getErrorMessage());
            }
            return this.storeAndBuildResponse(appId, refId, reqX509Cert, notBeforeDate, notAfterDate, certThumbprint);
        }
        String keyAlias = currentKeyAlias.get(0).getAlias();
        Optional<io.mosip.kernel.keymanagerservice.entity.KeyStore> keyFromDBStore = this.dbHelper.getKeyStoreFromDB(keyAlias);
        if (!keyFromDBStore.isPresent() && currentKeyAlias.size() == 1) {
            LOGGER.error("sessionId", "", "", "Other domain valid key is not available in key store, so not allowed to upload certificate.");
            throw new KeymanagerServiceException(KeymanagerErrorConstant.UPLOAD_NOT_ALLOWED.getErrorCode(), KeymanagerErrorConstant.UPLOAD_NOT_ALLOWED.getErrorMessage());
        }
        String masterKeyAlias = keyFromDBStore.get().getMasterAlias();
        String privateKeyObj = keyFromDBStore.get().getPrivateKey();
        if (!keyAlias.equals(masterKeyAlias) || !privateKeyObj.equals("NA")) {
            LOGGER.error("sessionId", "applicationId", null, "Not Allowed to update certificate for other domains if private key available.");
            throw new KeymanagerServiceException(KeymanagerErrorConstant.UPLOAD_NOT_ALLOWED.getErrorCode(), KeymanagerErrorConstant.UPLOAD_NOT_ALLOWED.getErrorMessage());
        }
        if (currentKeyAlias.get(0).getCertThumbprint().equals(certThumbprint)) {
            LOGGER.error("sessionId", "applicationId", null, "Not Allowed to upload same certificate for other domains. Current available certificate thumbprint matching with input certificate thumbprint.");
            throw new KeymanagerServiceException(KeymanagerErrorConstant.UPLOAD_NOT_ALLOWED.getErrorCode(), KeymanagerErrorConstant.UPLOAD_NOT_ALLOWED.getErrorMessage());
        }
        LocalDateTime expireTime = timestamp.minusMinutes(1L);
        this.dbHelper.storeKeyInAlias(appId, currentKeyAlias.get(0).getKeyGenerationTime(), refId, keyAlias, expireTime, currentKeyAlias.get(0).getCertThumbprint(), currentKeyAlias.get(0).getUniqueIdentifier());
        return this.storeAndBuildResponse(appId, refId, reqX509Cert, notBeforeDate, notAfterDate, certThumbprint);
    }

    private UploadCertificateResponseDto storeAndBuildResponse(String appId, String refId, X509Certificate reqX509Cert, LocalDateTime notBeforeDate, LocalDateTime notAfterDate, String certThumbprint) {
        String alias = UUID.randomUUID().toString();
        this.dbHelper.storeKeyInDBStore(alias, alias, this.keymanagerUtil.getPEMFormatedData(reqX509Cert), "NA");
        String uniqueValue = appId + "_" + refId + "_" + certThumbprint;
        LOGGER.info("sessionId", "", "", "Unique Value formatter: " + uniqueValue);
        String uniqueIdentifier = this.keymanagerUtil.getUniqueIdentifier(uniqueValue);
        this.dbHelper.storeKeyInAlias(appId, notBeforeDate, refId, alias, notAfterDate, certThumbprint, uniqueIdentifier);
        UploadCertificateResponseDto responseDto = new UploadCertificateResponseDto();
        responseDto.setStatus("Upload Success");
        responseDto.setTimestamp(DateUtils.getUTCCurrentDateTime());
        return responseDto;
    }

    @Override
    public SymmetricKeyGenerateResponseDto generateSymmetricKey(SymmetricKeyGenerateRequestDto symGenRequestDto) {
        String appId = symGenRequestDto.getApplicationId();
        String refId = symGenRequestDto.getReferenceId();
        LOGGER.info("sessionId", "applicationId", appId, "Request for Symmetric Key Generation.");
        if (!this.keymanagerUtil.isValidReferenceId(refId) || !this.keymanagerUtil.isValidApplicationId(appId)) {
            LOGGER.error("sessionId", "applicationId", null, "Invalid Data provided to generate symmetric key.");
            throw new KeymanagerServiceException(KeymanagerErrorConstant.INVALID_REQUEST.getErrorCode(), KeymanagerErrorConstant.INVALID_REQUEST.getErrorMessage());
        }
        LOGGER.info("sessionId", "applicationId", appId, "to get KeyInfo for application ID: " + appId + ", RefId: " + refId);
        LocalDateTime timestamp = DateUtils.getUTCCurrentDateTime();
        Map<String, List<KeyAlias>> keyAliasMap = this.dbHelper.getKeyAliases(appId, refId, timestamp);
        List<KeyAlias> currentKeyAlias = keyAliasMap.get("currentKeyAlias");
        if (currentKeyAlias.size() > 1) {
            LOGGER.error("sessionId", "currentKeyAlias", String.valueOf(currentKeyAlias.size()), "CurrentKeyAlias size more than one");
            throw new NoUniqueAliasException(KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorCode(), KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorMessage());
        }
        Boolean forceFlag = symGenRequestDto.getForce();
        if (forceFlag.booleanValue()) {
            LOGGER.debug("sessionId", "applicationId", appId, "Force Flag is True, Invalidating the existing key and generating new key.");
            LocalDateTime expireTime = timestamp.minusMinutes(1L);
            currentKeyAlias.forEach(alias -> this.dbHelper.storeKeyInAlias(appId, alias.getKeyGenerationTime(), refId, alias.getAlias(), expireTime, null, null));
            return this.generateAndBuildResponse(appId, refId, timestamp);
        }
        if (currentKeyAlias.size() == 1) {
            return this.buildSymGenKeyRespObject(timestamp, "Key Exists.");
        }
        return this.generateAndBuildResponse(appId, refId, timestamp);
    }

    private SymmetricKeyGenerateResponseDto generateAndBuildResponse(String appId, String refId, LocalDateTime timestamp) {
        String alias = UUID.randomUUID().toString();
        LocalDateTime expiryDateTime = timestamp.plusDays(3650L);
        this.keyStore.generateAndStoreSymmetricKey(alias);
        this.dbHelper.storeKeyInAlias(appId, timestamp, refId, alias, expiryDateTime, null, null);
        return this.buildSymGenKeyRespObject(timestamp, "Generation Success");
    }

    private SymmetricKeyGenerateResponseDto buildSymGenKeyRespObject(LocalDateTime timestamp, String status) {
        SymmetricKeyGenerateResponseDto responseDto = new SymmetricKeyGenerateResponseDto();
        responseDto.setStatus(status);
        responseDto.setTimestamp(timestamp);
        return responseDto;
    }

    @Override
    public RevokeKeyResponseDto revokeKey(RevokeKeyRequestDto revokeKeyRequest) {
        String appId = revokeKeyRequest.getApplicationId();
        String refId = revokeKeyRequest.getReferenceId();
        Boolean disableAutoGen = revokeKeyRequest.getDisableAutoGen() == null ? Boolean.FALSE : revokeKeyRequest.getDisableAutoGen();
        LOGGER.info("sessionId", appId, refId, "Request for key revocation.");
        LOGGER.info("sessionId", "applicationId", appId, "Request for key revocation." + disableAutoGen);
        if (!this.keymanagerUtil.isValidReferenceId(refId) || !this.keymanagerUtil.isValidApplicationId(appId)) {
            LOGGER.error("sessionId", "applicationId", null, "Invalid Data provided to revoke key.");
            throw new KeymanagerServiceException(KeymanagerErrorConstant.INVALID_REQUEST.getErrorCode(), KeymanagerErrorConstant.INVALID_REQUEST.getErrorMessage());
        }
        if (appId.equalsIgnoreCase(this.signApplicationid) && refId.equalsIgnoreCase(this.certificateSignRefID)) {
            LOGGER.error("sessionId", "applicationId", null, "Not allowed to revoke key. AppId: KERNEL & RefId: SIGN.");
            throw new KeymanagerServiceException(KeymanagerErrorConstant.REVOKE_NOT_ALLOWED.getErrorCode(), KeymanagerErrorConstant.REVOKE_NOT_ALLOWED.getErrorMessage());
        }
        LocalDateTime timestamp = DateUtils.getUTCCurrentDateTime();
        Map<String, List<KeyAlias>> keyAliasMap = this.dbHelper.getKeyAliases(appId, refId, timestamp);
        List<KeyAlias> currentKeyAlias = keyAliasMap.get("currentKeyAlias");
        if (currentKeyAlias.isEmpty() || currentKeyAlias.size() > 1) {
            LOGGER.error("sessionId", "currentKeyAlias", String.valueOf(currentKeyAlias.size()), "CurrentKeyAlias size more than one");
            throw new NoUniqueAliasException(KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorCode(), KeymanagerErrorConstant.NO_UNIQUE_ALIAS.getErrorMessage());
        }
        LOGGER.debug("sessionId", appId, refId, "Invalidating the current valid key.");
        LocalDateTime expireTime = timestamp.minusMinutes(1L);
        KeyAlias currentAlias = currentKeyAlias.get(0);
        this.dbHelper.storeKeyInAlias(appId, currentAlias.getKeyGenerationTime(), refId, currentAlias.getAlias(), expireTime, currentAlias.getCertThumbprint(), currentAlias.getUniqueIdentifier());
        RevokeKeyResponseDto responseDto = new RevokeKeyResponseDto();
        responseDto.setStatus("Key Revoked");
        responseDto.setTimestamp(timestamp);
        return responseDto;
    }

    @Override
    public AllCertificatesDataResponseDto getAllCertificates(String appId, Optional<String> refId) {
        LOGGER.info("sessionId", "applicationId", appId, "Request received to get all the Certificates");
        LOGGER.info("sessionId", "referenceId", refId.toString(), "Request received to get all the Certificates");
        LocalDateTime localDateTimeStamp = DateUtils.getUTCCurrentDateTime();
        CertificateDataResponseDto[] certificateDataList = null;
        if (!refId.isPresent() || refId.get().trim().isEmpty()) {
            LOGGER.info("sessionId", "", "", "Reference Id is not present. Will get All Certificates from HSM");
            certificateDataList = this.getAllCertificatesFromHSM(appId, localDateTimeStamp, "");
        } else if (appId.equalsIgnoreCase(this.signApplicationid) && refId.isPresent() && refId.get().equals(this.certificateSignRefID)) {
            LOGGER.info("sessionId", "", "", "Reference Id is present and it is SIGN reference. Will get all certificates from HSM");
            certificateDataList = this.getAllCertificatesFromHSM(appId, localDateTimeStamp, "");
        } else {
            LOGGER.info("sessionId", "", "", "Reference Id is present. Will get Certificate from DB store");
            certificateDataList = this.getAllCertificatesFromDBStore(appId, localDateTimeStamp, refId.get());
        }
        LOGGER.info("sessionId", "", "", "Total Number of certificates found:" + certificateDataList.length);
        AllCertificatesDataResponseDto allCertificatesDataResponseDto = new AllCertificatesDataResponseDto();
        allCertificatesDataResponseDto.setAllCertificates(certificateDataList);
        return allCertificatesDataResponseDto;
    }

    private CertificateDataResponseDto[] getAllCertificatesFromHSM(String applicationId, LocalDateTime timeStamp, String referenceId) {
        Map<String, List<KeyAlias>> keyAliasMap = this.dbHelper.getKeyAliases(applicationId, referenceId, timeStamp);
        List<KeyAlias> keyAliases = keyAliasMap.get("keyAlias");
        ArrayList<CertificateDataResponseDto> certDataRespList = new ArrayList<CertificateDataResponseDto>();
        for (KeyAlias keyAlias : keyAliases) {
            X509Certificate x509Cert = (X509Certificate)this.keyStore.getCertificate(keyAlias.getAlias());
            String pemFormatCert = this.keymanagerUtil.getPEMFormatedData(x509Cert);
            LocalDateTime issuedAt = keyAlias.getKeyGenerationTime();
            LocalDateTime expiryAt = keyAlias.getKeyExpiryTime();
            String keyId = SignatureUtil.convertHexToBase64(keyAlias.getUniqueIdentifier());
            certDataRespList.add(new CertificateDataResponseDto(pemFormatCert, issuedAt, expiryAt, keyId));
        }
        return certDataRespList.toArray(new CertificateDataResponseDto[0]);
    }

    private CertificateDataResponseDto[] getAllCertificatesFromDBStore(String applicationId, LocalDateTime timeStamp, String referenceId) {
        Map<String, List<KeyAlias>> keyAliasMap = this.dbHelper.getKeyAliases(applicationId, referenceId, timeStamp);
        List<KeyAlias> keyAliases = keyAliasMap.get("keyAlias");
        ArrayList<CertificateDataResponseDto> certDataRespList = new ArrayList<CertificateDataResponseDto>();
        for (KeyAlias keyAlias : keyAliases) {
            Optional<io.mosip.kernel.keymanagerservice.entity.KeyStore> keyFromDBStore = this.dbHelper.getKeyStoreFromDB(keyAlias.getAlias());
            if (!keyFromDBStore.isPresent()) continue;
            String certificateData = keyFromDBStore.get().getCertificateData();
            X509Certificate x509Cert = (X509Certificate)this.keymanagerUtil.convertToCertificate(certificateData);
            String pemFormatCert = this.keymanagerUtil.getPEMFormatedData(x509Cert);
            LocalDateTime issuedAt = keyAlias.getKeyGenerationTime();
            LocalDateTime expiryAt = keyAlias.getKeyExpiryTime();
            String keyId = SignatureUtil.convertHexToBase64(keyAlias.getUniqueIdentifier());
            certDataRespList.add(new CertificateDataResponseDto(pemFormatCert, issuedAt, expiryAt, keyId));
        }
        return certDataRespList.toArray(new CertificateDataResponseDto[0]);
    }
}

