/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.keymanagerservice.helper;

import io.mosip.kernel.core.crypto.exception.InvalidDataException;
import io.mosip.kernel.core.crypto.exception.InvalidKeyException;
import io.mosip.kernel.core.crypto.exception.NullDataException;
import io.mosip.kernel.core.crypto.exception.NullKeyException;
import io.mosip.kernel.core.crypto.exception.NullMethodException;
import io.mosip.kernel.core.keymanager.spi.KeyStore;
import io.mosip.kernel.core.logger.spi.Logger;
import io.mosip.kernel.core.util.CryptoUtil;
import io.mosip.kernel.keymanagerservice.constant.KeymanagerErrorConstant;
import io.mosip.kernel.keymanagerservice.exception.CryptoException;
import io.mosip.kernel.keymanagerservice.exception.KeymanagerServiceException;
import io.mosip.kernel.keymanagerservice.helper.KeymanagerDBHelper;
import io.mosip.kernel.keymanagerservice.logger.KeymanagerLogger;
import io.mosip.kernel.keymanagerservice.util.KeymanagerUtil;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PrivateKeyDecryptorHelper {
    private static final Logger LOGGER = KeymanagerLogger.getLogger(PrivateKeyDecryptorHelper.class);
    private Map<String, io.mosip.kernel.keymanagerservice.entity.KeyStore> cacheKeyStore = new ConcurrentHashMap<String, io.mosip.kernel.keymanagerservice.entity.KeyStore>();
    private Map<String, String> cacheReferenceIds = new ConcurrentHashMap<String, String>();
    @Autowired
    KeymanagerUtil keymanagerUtil;
    @Autowired
    private KeymanagerDBHelper dbHelper;
    @Autowired
    private KeyStore keyStore;

    public io.mosip.kernel.keymanagerservice.entity.KeyStore getDBKeyStoreData(String certThumbprintHex, String applicationId, String referenceId) {
        String cachedRefId;
        io.mosip.kernel.keymanagerservice.entity.KeyStore dbKeyStore = this.cacheKeyStore.getOrDefault(certThumbprintHex, null);
        String appIdRefIdKey = applicationId + "-" + referenceId;
        String compMasterKeyRefId = applicationId + "-COMP_MASTER";
        if (Objects.isNull(dbKeyStore)) {
            dbKeyStore = this.dbHelper.getKeyAlias(certThumbprintHex, appIdRefIdKey, applicationId, referenceId);
            this.cacheKeyStore.put(certThumbprintHex, dbKeyStore);
            if (Objects.isNull(dbKeyStore.getPrivateKey())) {
                this.cacheReferenceIds.put(certThumbprintHex, compMasterKeyRefId);
            } else {
                this.cacheReferenceIds.put(certThumbprintHex, appIdRefIdKey);
            }
        }
        if (!appIdRefIdKey.equals(cachedRefId = (String)this.cacheReferenceIds.getOrDefault(certThumbprintHex, null)) && !compMasterKeyRefId.equals(cachedRefId)) {
            LOGGER.error("sessionId", this.getClass().getSimpleName(), "", "Application Id & Reference ID not matching with the input thumbprint value(decrypt).");
            throw new KeymanagerServiceException(KeymanagerErrorConstant.APP_ID_REFERENCE_ID_NOT_MATCHING.getErrorCode(), KeymanagerErrorConstant.APP_ID_REFERENCE_ID_NOT_MATCHING.getErrorMessage());
        }
        return dbKeyStore;
    }

    public Object[] getKeyObjects(io.mosip.kernel.keymanagerservice.entity.KeyStore dbKeyStore, boolean fetchMasterKey) {
        String ksAlias = dbKeyStore.getAlias();
        String privateKeyObj = dbKeyStore.getPrivateKey();
        if (Objects.isNull(privateKeyObj)) {
            if (!fetchMasterKey) {
                LOGGER.error("sessionId", "applicationId", null, "Not Allowed to perform decryption with the master key.");
                throw new KeymanagerServiceException(KeymanagerErrorConstant.DECRYPTION_NOT_ALLOWED.getErrorCode(), KeymanagerErrorConstant.DECRYPTION_NOT_ALLOWED.getErrorMessage());
            }
            LOGGER.info("sessionId", "", "", "Private not found in key store. Getting private key from HSM.");
            KeyStore.PrivateKeyEntry masterKeyEntry = this.keyStore.getAsymmetricKey(ksAlias);
            PrivateKey masterPrivateKey = masterKeyEntry.getPrivateKey();
            Certificate masterCert = masterKeyEntry.getCertificate();
            return new Object[]{masterPrivateKey, masterCert};
        }
        String masterKeyAlias = dbKeyStore.getMasterAlias();
        if (ksAlias.equals(masterKeyAlias) || privateKeyObj.equals("NA")) {
            LOGGER.error("sessionId", "applicationId", null, "Not Allowed to perform decryption with other domain key.");
            throw new KeymanagerServiceException(KeymanagerErrorConstant.DECRYPTION_NOT_ALLOWED.getErrorCode(), KeymanagerErrorConstant.DECRYPTION_NOT_ALLOWED.getErrorMessage());
        }
        KeyStore.PrivateKeyEntry masterKeyEntry = this.keyStore.getAsymmetricKey(dbKeyStore.getMasterAlias());
        PrivateKey masterPrivateKey = masterKeyEntry.getPrivateKey();
        PublicKey masterPublicKey = masterKeyEntry.getCertificate().getPublicKey();
        try {
            byte[] decryptedPrivateKey = this.keymanagerUtil.decryptKey(CryptoUtil.decodeURLSafeBase64((String)dbKeyStore.getPrivateKey()), masterPrivateKey, masterPublicKey);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PrivateKey privateKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(decryptedPrivateKey));
            Certificate certificate = this.keymanagerUtil.convertToCertificate(dbKeyStore.getCertificateData());
            return new Object[]{privateKey, certificate};
        }
        catch (InvalidDataException | InvalidKeyException | NullDataException | NullKeyException | NullMethodException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new CryptoException(KeymanagerErrorConstant.CRYPTO_EXCEPTION.getErrorCode(), KeymanagerErrorConstant.CRYPTO_EXCEPTION.getErrorMessage() + e.getMessage(), e);
        }
    }
}

