/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.keymanagerservice.helper;

import io.mosip.kernel.core.keymanager.spi.KeyStore;
import io.mosip.kernel.core.logger.spi.Logger;
import io.mosip.kernel.cryptomanager.util.CryptomanagerUtils;
import io.mosip.kernel.keymanagerservice.constant.KeymanagerConstant;
import io.mosip.kernel.keymanagerservice.constant.KeymanagerErrorConstant;
import io.mosip.kernel.keymanagerservice.entity.KeyAlias;
import io.mosip.kernel.keymanagerservice.entity.KeyPolicy;
import io.mosip.kernel.keymanagerservice.exception.InvalidApplicationIdException;
import io.mosip.kernel.keymanagerservice.exception.KeymanagerServiceException;
import io.mosip.kernel.keymanagerservice.logger.KeymanagerLogger;
import io.mosip.kernel.keymanagerservice.repository.KeyAliasRepository;
import io.mosip.kernel.keymanagerservice.repository.KeyPolicyRepository;
import io.mosip.kernel.keymanagerservice.repository.KeyStoreRepository;
import io.mosip.kernel.keymanagerservice.util.KeymanagerUtil;
import java.security.cert.X509Certificate;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.cache2k.Cache;
import org.cache2k.Cache2kBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class KeymanagerDBHelper {
    private static final Logger LOGGER = KeymanagerLogger.getLogger(KeymanagerDBHelper.class);
    @Value(value="${mosip.sign.applicationid:KERNEL}")
    private String signApplicationId;
    @Value(value="${mosip.sign-certificate-refid:SIGN}")
    private String signRefId;
    @Value(value="${mosip.kernel.keymanager.unique.identifier.autoupdate:true}")
    private boolean autoUpdate;
    @Value(value="${mosip.kernel.keymanager.key.cache.expire.inMins:1440}")
    private long cacheExpireInMins;
    @Autowired
    KeyAliasRepository keyAliasRepository;
    @Autowired
    KeyPolicyRepository keyPolicyRepository;
    @Autowired
    KeyStoreRepository keyStoreRepository;
    @Autowired
    KeymanagerUtil keymanagerUtil;
    @Autowired
    KeyStore keyStore;
    @Autowired
    CryptomanagerUtils cryptomanagerUtil;
    private Cache<String, Optional<KeyPolicy>> keyPolicyCache = null;
    private Cache<String, List<KeyAlias>> keyAliasCache = null;

    @PostConstruct
    public void init() {
        if (this.autoUpdate) {
            LOGGER.info("sessionId", "", "", "Updating the thumbprint & key unique identifer completed.");
            this.addCertificateThumbprints();
            this.addKeyUniqueIdentifier();
            LOGGER.info("sessionId", "", "", "Updating the thumbprint & key unique identifer completed.");
        }
        LOGGER.info("sessionId", "", "", "Creating Cache object for key policy & Key Alias.");
        this.createCacheObject();
        this.createKeyAliasCacheObject();
        LOGGER.info("sessionId", "", "", "Cache object for key policy & Key Alias creation completed.");
    }

    private void createCacheObject() {
        this.keyPolicyCache = new Cache2kBuilder<String, Optional<KeyPolicy>>(){}.name("keyPolicyCache-" + this.hashCode()).eternal(true).entryCapacity(20L).loaderThreadCount(1).loader(keyPolicyName -> {
            LOGGER.info("sessionId", "", "", "Fetching Key Policy for keyPolicyName(Cache): " + keyPolicyName);
            return this.keyPolicyRepository.findByApplicationId((String)keyPolicyName);
        }).build();
    }

    private void createKeyAliasCacheObject() {
        this.keyAliasCache = new Cache2kBuilder<String, List<KeyAlias>>(){}.name("keyAliasCache-" + this.hashCode()).expireAfterWrite(this.cacheExpireInMins, TimeUnit.MINUTES).entryCapacity(500L).refreshAhead(true).loaderThreadCount(1).loader(appIdRefId -> {
            LOGGER.info("sessionId", "", "", "Fetching Key Alias for Application Id & Reference Id (Cache): " + appIdRefId);
            String[] appIdRefIdArr = appIdRefId.split("#", -1);
            LOGGER.info("sessionId", "", "", "Key Alias for Application Id: " + appIdRefIdArr[0] + ", Reference Id (Cache): " + appIdRefIdArr[1]);
            return this.keyAliasRepository.findByApplicationIdAndReferenceId(appIdRefIdArr[0], appIdRefIdArr[1]);
        }).build();
    }

    public void storeKeyInAlias(String applicationId, LocalDateTime timeStamp, String referenceId, String alias, LocalDateTime expiryDateTime, String certThumbprint, String uniqueIdentifier) {
        LOGGER.info("sessionId", "", "", "Storing key in KeyAlias");
        KeyAlias keyAlias = new KeyAlias();
        keyAlias.setAlias(alias);
        keyAlias.setApplicationId(applicationId);
        keyAlias.setReferenceId(referenceId);
        keyAlias.setKeyGenerationTime(timeStamp);
        keyAlias.setKeyExpiryTime(expiryDateTime);
        keyAlias.setCertThumbprint(certThumbprint);
        keyAlias.setUniqueIdentifier(uniqueIdentifier);
        this.keyAliasRepository.saveAndFlush(this.keymanagerUtil.setMetaData(keyAlias));
        this.purgeKeyAliasCache(applicationId, referenceId);
    }

    public void storeKeyInDBStore(String alias, String masterAlias, String certificateData, String encryptedPrivateKey) {
        io.mosip.kernel.keymanagerservice.entity.KeyStore dbKeyStore = new io.mosip.kernel.keymanagerservice.entity.KeyStore();
        LOGGER.info("sessionId", "", "", "Storing key in dbKeyStore");
        dbKeyStore.setAlias(alias);
        dbKeyStore.setMasterAlias(masterAlias);
        dbKeyStore.setCertificateData(certificateData);
        dbKeyStore.setPrivateKey(encryptedPrivateKey);
        this.keyStoreRepository.saveAndFlush(this.keymanagerUtil.setMetaData(dbKeyStore));
    }

    public Map<String, List<KeyAlias>> getKeyAliases(String applicationId, String referenceId, LocalDateTime timeStamp) {
        LOGGER.info("sessionId", "", "", "Getting key alias");
        HashMap<String, List<KeyAlias>> hashmap = new HashMap<String, List<KeyAlias>>();
        List keyAliases = null;
        if (!applicationId.equals("PARTNER")) {
            String appIdRefIdKey = applicationId + "#" + referenceId;
            keyAliases = ((List)this.keyAliasCache.get((Object)appIdRefIdKey)).stream().sorted((alias1, alias2) -> alias1.getKeyGenerationTime().compareTo(alias2.getKeyGenerationTime())).collect(Collectors.toList());
            if (keyAliases.isEmpty()) {
                LOGGER.info("sessionId", applicationId, referenceId, "Removing from Cache because empty keyAlias are getting added in Cache.");
                this.keyAliasCache.expireAt((Object)appIdRefIdKey, 0L);
            }
        } else {
            keyAliases = this.keyAliasRepository.findByApplicationIdAndReferenceId(applicationId, referenceId).stream().sorted((alias1, alias2) -> alias1.getKeyGenerationTime().compareTo(alias2.getKeyGenerationTime())).collect(Collectors.toList());
        }
        int preExpireDays = this.getPreExpireDays(applicationId, referenceId);
        LOGGER.info("sessionId", applicationId, referenceId, "PreExpireDays found as key policy:" + preExpireDays);
        List currentKeyAliases = keyAliases.stream().filter(keyAlias -> this.keymanagerUtil.isValidTimestamp(timeStamp, (KeyAlias)keyAlias, preExpireDays)).collect(Collectors.toList());
        LOGGER.info("sessionId", "keyAlias", Arrays.toString(keyAliases.toArray()), "keyAlias");
        LOGGER.info("sessionId", "currentKeyAlias", Arrays.toString(currentKeyAliases.toArray()), "currentKeyAlias");
        hashmap.put("keyAlias", keyAliases);
        hashmap.put("currentKeyAlias", currentKeyAliases);
        return hashmap;
    }

    public LocalDateTime getExpiryPolicy(String applicationId, LocalDateTime timeStamp, List<KeyAlias> keyAlias) {
        LOGGER.info("sessionId", "applicationId", applicationId, "Getting expiry policy");
        Optional<KeyPolicy> keyPolicy = this.getKeyPolicyFromCache(applicationId);
        if (!keyPolicy.isPresent()) {
            LOGGER.info("sessionId", "keyPolicy", keyPolicy.toString(), "Key Policy not found for this application Id. Throwing exception");
            throw new InvalidApplicationIdException(KeymanagerErrorConstant.APPLICATIONID_NOT_VALID.getErrorCode(), KeymanagerErrorConstant.APPLICATIONID_NOT_VALID.getErrorMessage());
        }
        LocalDateTime policyExpiryTime = timeStamp.plusDays(keyPolicy.get().getValidityInDays());
        return policyExpiryTime;
    }

    public Optional<io.mosip.kernel.keymanagerservice.entity.KeyStore> getKeyStoreFromDB(String keyAlias) {
        Optional<io.mosip.kernel.keymanagerservice.entity.KeyStore> dbKeyStore = this.keyStoreRepository.findByAlias(keyAlias);
        return dbKeyStore;
    }

    public Optional<KeyPolicy> getKeyPolicy(String applicationId) {
        Optional<KeyPolicy> keyPolicy = this.getKeyPolicyFromCache(applicationId);
        if (!keyPolicy.isPresent() || !keyPolicy.get().isActive()) {
            LOGGER.error("sessionId", "keyPolicy", keyPolicy.toString(), "Key Policy not found for this application Id. Key/CSR generation not allowed.");
            throw new InvalidApplicationIdException(KeymanagerErrorConstant.APPLICATIONID_NOT_VALID.getErrorCode(), KeymanagerErrorConstant.APPLICATIONID_NOT_VALID.getErrorMessage());
        }
        return keyPolicy;
    }

    public Optional<KeyPolicy> getKeyPolicyFromCache(String applicationId) {
        if (Objects.isNull(this.keyPolicyCache)) {
            this.createCacheObject();
        }
        return (Optional)this.keyPolicyCache.get((Object)applicationId);
    }

    public io.mosip.kernel.keymanagerservice.entity.KeyStore getKeyAlias(String certThumbprint, String appIdRefIdKey, String applicationId, String referenceId) {
        List<KeyAlias> keyAliases = this.keyAliasRepository.findByCertThumbprint(certThumbprint);
        if (keyAliases.isEmpty()) {
            LOGGER.info("sessionId", "", "", "key alias not found for the provided thumbprint, may be cert thumbprint is not updated. Adding thumbprint(s) now.");
            this.addCertificateThumbprints();
            keyAliases = this.keyAliasRepository.findByCertThumbprint(certThumbprint);
        }
        if (keyAliases.isEmpty()) {
            LOGGER.error("sessionId", "", "", "no key alias found for the provided thumbprint after updating the thumbprints in DB. TP: " + certThumbprint);
            throw new KeymanagerServiceException(KeymanagerErrorConstant.KEY_NOT_FOUND_BY_THUMBPRINT.getErrorCode(), KeymanagerErrorConstant.KEY_NOT_FOUND_BY_THUMBPRINT.getErrorMessage());
        }
        KeyAlias foundKeyAlias = keyAliases.get(0);
        if (keyAliases.size() > 1) {
            List<KeyAlias> keyAliasesWithAppId = this.keyAliasRepository.findByApplicationIdAndReferenceIdAndCertThumbprint(applicationId, referenceId, certThumbprint);
            if (keyAliasesWithAppId.size() > 1) {
                LOGGER.error("sessionId", "", "", "More than one key alias found for the provided thumbprint.");
                throw new KeymanagerServiceException(KeymanagerErrorConstant.MORE_THAN_ONE_KEY_FOUND.getErrorCode(), KeymanagerErrorConstant.MORE_THAN_ONE_KEY_FOUND.getErrorMessage());
            }
            foundKeyAlias = keyAliasesWithAppId.get(0);
        }
        String foundDBAppIdRefId = foundKeyAlias.getApplicationId() + "-" + foundKeyAlias.getReferenceId();
        String foundDBAppId = foundKeyAlias.getApplicationId();
        if (!foundDBAppIdRefId.equals(appIdRefIdKey) && !foundDBAppId.equals(applicationId)) {
            LOGGER.error("sessionId", "", "", "AppId & Reference Id not matching with the input thumbprint value(helper).");
            throw new KeymanagerServiceException(KeymanagerErrorConstant.APP_ID_REFERENCE_ID_NOT_MATCHING.getErrorCode(), KeymanagerErrorConstant.APP_ID_REFERENCE_ID_NOT_MATCHING.getErrorMessage());
        }
        Optional<io.mosip.kernel.keymanagerservice.entity.KeyStore> keyFromDBStore = this.getKeyStoreFromDB(foundKeyAlias.getAlias());
        if (!keyFromDBStore.isPresent()) {
            LOGGER.info("sessionId", "", "", "Key not found in key store for the matched thumbprint. Might has used master key during encryption.");
            return new io.mosip.kernel.keymanagerservice.entity.KeyStore(foundKeyAlias.getAlias(), null, null, null);
        }
        if (Objects.isNull(foundKeyAlias.getUniqueIdentifier())) {
            LOGGER.info("sessionId", "", "", "Key Unique identifier not found for the provided key, may be unique identifier is not updated. Adding Unique Identifier(s) now.");
            this.addKeyUniqueIdentifier();
        }
        return keyFromDBStore.get();
    }

    private synchronized void addCertificateThumbprints() {
        List<KeyAlias> allKeyAliases = this.keyAliasRepository.findByCertThumbprintIsNull();
        allKeyAliases.stream().filter(keyAlias -> (Objects.isNull(keyAlias.getCertThumbprint()) || keyAlias.getCertThumbprint().equals("")) && !keyAlias.getApplicationId().equals(this.signApplicationId) && !keyAlias.getReferenceId().equals("IDENTITY_CACHE")).forEach(keyAlias -> {
            try {
                Optional<io.mosip.kernel.keymanagerservice.entity.KeyStore> keyFromDBStore;
                String certThumbprint;
                X509Certificate x509Cert;
                if (keyAlias.getReferenceId().isEmpty() || keyAlias.getApplicationId().equals(this.signApplicationId) && keyAlias.getReferenceId().equals(this.signRefId)) {
                    String uniqueValue = keyAlias.getApplicationId() + "_" + keyAlias.getReferenceId() + "_" + keyAlias.getKeyGenerationTime().format(KeymanagerConstant.DATE_FORMATTER);
                    String uniqueIdentifier = this.keymanagerUtil.getUniqueIdentifier(uniqueValue);
                    x509Cert = (X509Certificate)this.keyStore.getCertificate(keyAlias.getAlias());
                    certThumbprint = this.cryptomanagerUtil.getCertificateThumbprintInHex(x509Cert);
                    this.storeKeyInAlias(keyAlias.getApplicationId(), keyAlias.getKeyGenerationTime(), keyAlias.getReferenceId(), keyAlias.getAlias(), keyAlias.getKeyExpiryTime(), certThumbprint, uniqueIdentifier);
                    LOGGER.info("sessionId", "", "", "Thumbprint added for the key alias: " + keyAlias.getAlias());
                }
                if (!keyAlias.getReferenceId().isEmpty() && (keyFromDBStore = this.getKeyStoreFromDB(keyAlias.getAlias())).isPresent()) {
                    String certificateData = keyFromDBStore.get().getCertificateData();
                    x509Cert = (X509Certificate)this.keymanagerUtil.convertToCertificate(certificateData);
                    certThumbprint = this.cryptomanagerUtil.getCertificateThumbprintInHex(x509Cert);
                    String uniqueValue = keyAlias.getApplicationId() + "_" + keyAlias.getReferenceId() + "_";
                    Optional<KeyPolicy> keyPolicy = this.getKeyPolicyFromCache(keyAlias.getApplicationId());
                    uniqueValue = uniqueValue + (keyPolicy.isPresent() ? keyAlias.getKeyGenerationTime().format(KeymanagerConstant.DATE_FORMATTER) : certThumbprint);
                    String uniqueIdentifier = this.keymanagerUtil.getUniqueIdentifier(uniqueValue);
                    this.storeKeyInAlias(keyAlias.getApplicationId(), keyAlias.getKeyGenerationTime(), keyAlias.getReferenceId(), keyAlias.getAlias(), keyAlias.getKeyExpiryTime(), certThumbprint, uniqueIdentifier);
                    LOGGER.info("sessionId", "", "", "Thumbprint added for the key alias: " + keyAlias.getAlias());
                }
            }
            catch (Throwable t) {
                LOGGER.debug("sessionId", "", "", "Error Adding Thumbprint for the key alias: " + keyAlias.getAlias());
            }
        });
    }

    private synchronized void addKeyUniqueIdentifier() {
        List<KeyAlias> allKeyAliases = this.keyAliasRepository.findByUniqueIdentifierIsNull();
        allKeyAliases.stream().filter(keyAlias -> (Objects.isNull(keyAlias.getUniqueIdentifier()) || keyAlias.getUniqueIdentifier().equals("")) && !keyAlias.getApplicationId().equals(this.signApplicationId) && !keyAlias.getReferenceId().equals("IDENTITY_CACHE")).forEach(keyAlias -> {
            try {
                Optional<io.mosip.kernel.keymanagerservice.entity.KeyStore> keyFromDBStore;
                if (keyAlias.getReferenceId().isEmpty() || keyAlias.getApplicationId().equals(this.signApplicationId) && keyAlias.getReferenceId().equals(this.signRefId)) {
                    String uniqueValue = keyAlias.getApplicationId() + "_" + keyAlias.getReferenceId() + "_" + keyAlias.getKeyGenerationTime().format(KeymanagerConstant.DATE_FORMATTER);
                    String uniqueIdentifier = this.keymanagerUtil.getUniqueIdentifier(uniqueValue);
                    this.storeKeyInAlias(keyAlias.getApplicationId(), keyAlias.getKeyGenerationTime(), keyAlias.getReferenceId(), keyAlias.getAlias(), keyAlias.getKeyExpiryTime(), keyAlias.getCertThumbprint(), uniqueIdentifier);
                    LOGGER.info("sessionId", "", "", "Unique Identifier added for the key alias: " + keyAlias.getAlias());
                }
                if (!keyAlias.getReferenceId().isEmpty() && (keyFromDBStore = this.getKeyStoreFromDB(keyAlias.getAlias())).isPresent()) {
                    String uniqueValue = keyAlias.getApplicationId() + "_" + keyAlias.getReferenceId() + "_";
                    Optional<KeyPolicy> keyPolicy = this.getKeyPolicyFromCache(keyAlias.getApplicationId());
                    uniqueValue = uniqueValue + (keyPolicy.isPresent() ? keyAlias.getKeyGenerationTime().format(KeymanagerConstant.DATE_FORMATTER) : keyAlias.getCertThumbprint());
                    if (this.signApplicationId.equals("KERNEL") && (keyAlias.getApplicationId().equals("IDA") || keyAlias.getApplicationId().equals("PARTNER"))) {
                        uniqueValue = uniqueValue + keyAlias.getAlias();
                    }
                    String uniqueIdentifier = this.keymanagerUtil.getUniqueIdentifier(uniqueValue);
                    this.storeKeyInAlias(keyAlias.getApplicationId(), keyAlias.getKeyGenerationTime(), keyAlias.getReferenceId(), keyAlias.getAlias(), keyAlias.getKeyExpiryTime(), keyAlias.getCertThumbprint(), uniqueIdentifier);
                }
                LOGGER.info("sessionId", "", "", "Unique Identifier added for the key alias: " + keyAlias.getAlias());
            }
            catch (Throwable t) {
                LOGGER.debug("sessionId", "", "", "Error Adding Unique Identifier for the key alias: " + keyAlias.getAlias());
            }
        });
    }

    private int getPreExpireDays(String applicationId, String referenceId) {
        Optional<KeyPolicy> keyPolicy = this.getKeyPolicyFromCache(applicationId);
        if (!keyPolicy.isPresent()) {
            return 0;
        }
        if (referenceId.isEmpty() || applicationId.equals(this.signApplicationId) && (referenceId.equals(this.signRefId) || referenceId.equals("IDENTITY_CACHE"))) {
            return keyPolicy.get().getPreExpireDays();
        }
        Optional<KeyPolicy> encKeyPolicy = this.getKeyPolicyFromCache("BASE");
        if (!encKeyPolicy.isPresent()) {
            return 30;
        }
        return encKeyPolicy.get().getPreExpireDays();
    }

    private void purgeKeyAliasCache(String applicationId, String referenceId) {
        String appIdRefIdKey = applicationId + "#" + referenceId;
        LOGGER.info("sessionId", applicationId, referenceId, "Purging from Cache because new key generated or new certificate uploaded.AppId & RefId: " + appIdRefIdKey);
        this.keyAliasCache.expireAt((Object)appIdRefIdKey, 0L);
    }
}

