/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.keymanagerservice.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDateTime;
import lombok.Generated;

@ApiModel(description="Class representing a Certificate Data Response")
public class CertificateDataResponseDto {
    @ApiModelProperty(notes="X509 certificate", required=true)
    private String certificateData;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")
    @ApiModelProperty(notes="Timestamp of issuance of certificate", required=true)
    private LocalDateTime issuedAt;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")
    @ApiModelProperty(notes="Timestamp of expiry of certificate", required=true)
    private LocalDateTime expiryAt;
    @ApiModelProperty(notes="Unique Identifier of the key", required=true)
    private String keyId;

    @Generated
    public String getCertificateData() {
        return this.certificateData;
    }

    @Generated
    public LocalDateTime getIssuedAt() {
        return this.issuedAt;
    }

    @Generated
    public LocalDateTime getExpiryAt() {
        return this.expiryAt;
    }

    @Generated
    public String getKeyId() {
        return this.keyId;
    }

    @Generated
    public void setCertificateData(String certificateData) {
        this.certificateData = certificateData;
    }

    @Generated
    public void setIssuedAt(LocalDateTime issuedAt) {
        this.issuedAt = issuedAt;
    }

    @Generated
    public void setExpiryAt(LocalDateTime expiryAt) {
        this.expiryAt = expiryAt;
    }

    @Generated
    public void setKeyId(String keyId) {
        this.keyId = keyId;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CertificateDataResponseDto)) {
            return false;
        }
        CertificateDataResponseDto other = (CertificateDataResponseDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$certificateData = this.getCertificateData();
        String other$certificateData = other.getCertificateData();
        if (this$certificateData == null ? other$certificateData != null : !this$certificateData.equals(other$certificateData)) {
            return false;
        }
        LocalDateTime this$issuedAt = this.getIssuedAt();
        LocalDateTime other$issuedAt = other.getIssuedAt();
        if (this$issuedAt == null ? other$issuedAt != null : !((Object)this$issuedAt).equals(other$issuedAt)) {
            return false;
        }
        LocalDateTime this$expiryAt = this.getExpiryAt();
        LocalDateTime other$expiryAt = other.getExpiryAt();
        if (this$expiryAt == null ? other$expiryAt != null : !((Object)this$expiryAt).equals(other$expiryAt)) {
            return false;
        }
        String this$keyId = this.getKeyId();
        String other$keyId = other.getKeyId();
        return !(this$keyId == null ? other$keyId != null : !this$keyId.equals(other$keyId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CertificateDataResponseDto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $certificateData = this.getCertificateData();
        result = result * 59 + ($certificateData == null ? 43 : $certificateData.hashCode());
        LocalDateTime $issuedAt = this.getIssuedAt();
        result = result * 59 + ($issuedAt == null ? 43 : ((Object)$issuedAt).hashCode());
        LocalDateTime $expiryAt = this.getExpiryAt();
        result = result * 59 + ($expiryAt == null ? 43 : ((Object)$expiryAt).hashCode());
        String $keyId = this.getKeyId();
        result = result * 59 + ($keyId == null ? 43 : $keyId.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CertificateDataResponseDto(certificateData=" + this.getCertificateData() + ", issuedAt=" + this.getIssuedAt() + ", expiryAt=" + this.getExpiryAt() + ", keyId=" + this.getKeyId() + ")";
    }

    @Generated
    public CertificateDataResponseDto(String certificateData, LocalDateTime issuedAt, LocalDateTime expiryAt, String keyId) {
        this.certificateData = certificateData;
        this.issuedAt = issuedAt;
        this.expiryAt = expiryAt;
        this.keyId = keyId;
    }

    @Generated
    public CertificateDataResponseDto() {
    }
}

