/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.keymanagerservice.controller;

import io.mosip.kernel.core.http.RequestWrapper;
import io.mosip.kernel.core.http.ResponseFilter;
import io.mosip.kernel.core.http.ResponseWrapper;
import io.mosip.kernel.keymanagerservice.dto.AllCertificatesDataResponseDto;
import io.mosip.kernel.keymanagerservice.dto.CSRGenerateRequestDto;
import io.mosip.kernel.keymanagerservice.dto.KeyPairGenerateRequestDto;
import io.mosip.kernel.keymanagerservice.dto.KeyPairGenerateResponseDto;
import io.mosip.kernel.keymanagerservice.dto.RevokeKeyRequestDto;
import io.mosip.kernel.keymanagerservice.dto.RevokeKeyResponseDto;
import io.mosip.kernel.keymanagerservice.dto.SymmetricKeyGenerateRequestDto;
import io.mosip.kernel.keymanagerservice.dto.SymmetricKeyGenerateResponseDto;
import io.mosip.kernel.keymanagerservice.dto.UploadCertificateRequestDto;
import io.mosip.kernel.keymanagerservice.dto.UploadCertificateResponseDto;
import io.mosip.kernel.keymanagerservice.service.KeymanagerService;
import io.swagger.annotations.ApiParam;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Optional;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin
@RestController
@Tag(name="keymanager", description="Operation related to Keymanagement")
public class KeymanagerController {
    @Autowired
    KeymanagerService keymanagerService;

    @Operation(summary="Generate Master Key for the provided APP ID", description="Generate Master Key for the provided APP ID", tags={"keymanager"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success or you may find errors in error array in response"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(hidden=true))})})
    @PreAuthorize(value="hasAnyRole(@KeyManagerAuthRoles.getPostgeneratemasterkeyobjecttype())")
    @ResponseFilter
    @PostMapping(value={"/generateMasterKey/{objectType}"})
    public ResponseWrapper<KeyPairGenerateResponseDto> generateMasterKey(@ApiParam(value="Response Type CERTIFICATE/CSR") @PathVariable(value="objectType") String objectType, @RequestBody @Valid RequestWrapper<KeyPairGenerateRequestDto> keyPairGenRequestDto) {
        ResponseWrapper response = new ResponseWrapper();
        response.setResponse((Object)this.keymanagerService.generateMasterKey(objectType, (KeyPairGenerateRequestDto)keyPairGenRequestDto.getRequest()));
        return response;
    }

    @Operation(summary="Request to get Certificate for the Provided APP ID & REF ID", description="Request to get Certificate for the Provided APP ID & REF ID", tags={"keymanager"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success or you may find errors in error array in response"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(hidden=true))})})
    @PreAuthorize(value="hasAnyRole(@KeyManagerAuthRoles.getGetgetcertificate())")
    @ResponseFilter
    @GetMapping(value={"/getCertificate"})
    public ResponseWrapper<KeyPairGenerateResponseDto> getCertificate(@ApiParam(value="Id of application") @RequestParam(value="applicationId") String applicationId, @ApiParam(value="Refrence Id as metadata") @RequestParam(value="referenceId") Optional<String> referenceId) {
        ResponseWrapper response = new ResponseWrapper();
        response.setResponse((Object)this.keymanagerService.getCertificate(applicationId, referenceId));
        return response;
    }

    @Operation(summary="Request to Generate CSR for the provided APP ID & REF ID along with other certificate params", description="Request to Generate CSR for the provided APP ID & REF ID along with other certificate params", tags={"keymanager"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success or you may find errors in error array in response"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(hidden=true))})})
    @PreAuthorize(value="hasAnyRole(@KeyManagerAuthRoles.getPostgeneratecsr())")
    @ResponseFilter
    @PostMapping(value={"/generateCSR"})
    public ResponseWrapper<KeyPairGenerateResponseDto> generateCSR(@RequestBody @Valid RequestWrapper<CSRGenerateRequestDto> csrGenRequestDto) {
        ResponseWrapper response = new ResponseWrapper();
        response.setResponse((Object)this.keymanagerService.generateCSR((CSRGenerateRequestDto)csrGenRequestDto.getRequest()));
        return response;
    }

    @Operation(summary="Update signed certificate for the provided APP ID & REF ID", description="Update signed certificate for the provided APP ID & REF ID", tags={"keymanager"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success or you may find errors in error array in response"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(hidden=true))})})
    @ResponseFilter
    @PreAuthorize(value="hasAnyRole(@KeyManagerAuthRoles.getPostuploadcertificate())")
    @PostMapping(value={"/uploadCertificate"})
    public ResponseWrapper<UploadCertificateResponseDto> uploadCertificate(@RequestBody @Valid RequestWrapper<UploadCertificateRequestDto> uploadCertRequestDto) {
        ResponseWrapper response = new ResponseWrapper();
        response.setResponse((Object)this.keymanagerService.uploadCertificate((UploadCertificateRequestDto)uploadCertRequestDto.getRequest()));
        return response;
    }

    @Operation(summary="Update signed certificate for the provided APP ID & REF ID for other domains", description="Update signed certificate for the provided APP ID & REF ID for other domains", tags={"keymanager"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success or you may find errors in error array in response"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(hidden=true))})})
    @PreAuthorize(value="hasAnyRole(@KeyManagerAuthRoles.getPostuploadotherdomaincertificate())")
    @ResponseFilter
    @PostMapping(value={"/uploadOtherDomainCertificate"})
    public ResponseWrapper<UploadCertificateResponseDto> uploadOtherDomainCertificate(@RequestBody @Valid RequestWrapper<UploadCertificateRequestDto> uploadCertRequestDto) {
        ResponseWrapper response = new ResponseWrapper();
        response.setResponse((Object)this.keymanagerService.uploadOtherDomainCertificate((UploadCertificateRequestDto)uploadCertRequestDto.getRequest()));
        return response;
    }

    @Operation(summary="Request to Generate Symmetric key for the provided APP ID & REF ID", description="Request to Generate Symmetric key for the provided APP ID & REF ID", tags={"keymanager"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success or you may find errors in error array in response"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(hidden=true))})})
    @PreAuthorize(value="hasAnyRole(@KeyManagerAuthRoles.getPostgeneratesymmetrickey())")
    @ResponseFilter
    @PostMapping(value={"/generateSymmetricKey"})
    public ResponseWrapper<SymmetricKeyGenerateResponseDto> generateSymmetricKey(@RequestBody @Valid RequestWrapper<SymmetricKeyGenerateRequestDto> symGenRequestDto) {
        ResponseWrapper response = new ResponseWrapper();
        response.setResponse((Object)this.keymanagerService.generateSymmetricKey((SymmetricKeyGenerateRequestDto)symGenRequestDto.getRequest()));
        return response;
    }

    @Operation(summary="Request to Revoke Base Key for the provided APP ID & REF ID", description="Request to Revoke Base Key for the provided APP ID & REF ID", tags={"keymanager"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success or you may find errors in error array in response"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(hidden=true))})})
    @PreAuthorize(value="hasAnyRole(@KeyManagerAuthRoles.getPutrevokekey())")
    @ResponseFilter
    @PutMapping(value={"/revokeKey"})
    public ResponseWrapper<RevokeKeyResponseDto> revokeKey(@RequestBody @Valid RequestWrapper<RevokeKeyRequestDto> revokeKeyRequestDto) {
        ResponseWrapper response = new ResponseWrapper();
        response.setResponse((Object)this.keymanagerService.revokeKey((RevokeKeyRequestDto)revokeKeyRequestDto.getRequest()));
        return response;
    }

    @Operation(summary="Request to get all the certificates for the Provided APP ID & REF ID", description="Request to get all the certificates for the Provided APP ID & REF ID", tags={"keymanager"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success or you may find errors in error array in response"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(hidden=true))})})
    @PreAuthorize(value="hasAnyRole(@KeyManagerAuthRoles.getGetgetcertificate())")
    @ResponseFilter
    @GetMapping(value={"/getAllCertificates"})
    public ResponseWrapper<AllCertificatesDataResponseDto> getAllCertificates(@ApiParam(value="Id of application") @RequestParam(value="applicationId") String applicationId, @ApiParam(value="Refrence Id as metadata") @RequestParam(value="referenceId") Optional<String> referenceId) {
        ResponseWrapper response = new ResponseWrapper();
        response.setResponse((Object)this.keymanagerService.getAllCertificates(applicationId, referenceId));
        return response;
    }
}

