/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.keymanagerservice.config;

import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import io.swagger.v3.oas.models.servers.Server;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SwaggerConfig {
    @Value(value="${openapi.info.title:Key Manager Service}")
    private String title;
    @Value(value="${openapi.info.version:1.0}")
    private String version;
    @Value(value="${openapi.info.description:Rest Endpoints for operations related to key management and crypto operations}")
    private String description;
    @Value(value="${openapi.info.license.name:Mosip}")
    private String licenseName;
    @Value(value="${openapi.info.license.url:https://docs.mosip.io/platform/license}")
    private String licenseUrl;
    @Value(value="${openapi.service.server.url:http://localhost:8088/v1/keymanager}")
    private String serverUrl;
    @Value(value="${openapi.service.server.description:Key Manager Service}")
    private String serverDesc;

    @Bean
    public OpenAPI openApi() {
        OpenAPI api = new OpenAPI().components(new Components()).info(new Info().title(this.title).version(this.version).description(this.description).license(new License().name(this.licenseName).url(this.licenseUrl)));
        api.addServersItem(new Server().description(this.serverDesc).url(this.serverUrl));
        return api;
    }
}

