/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.keymanager.hsm.impl.pkcs;

import io.mosip.kernel.core.exception.NoSuchAlgorithmException;
import io.mosip.kernel.core.keymanager.exception.KeystoreProcessingException;
import io.mosip.kernel.core.keymanager.exception.NoSuchSecurityProviderException;
import io.mosip.kernel.core.keymanager.model.CertificateParameters;
import io.mosip.kernel.core.logger.spi.Logger;
import io.mosip.kernel.core.util.DateUtils;
import io.mosip.kernel.keygenerator.bouncycastle.constant.KeyGeneratorExceptionConstant;
import io.mosip.kernel.keymanager.hsm.constant.KeymanagerErrorCode;
import io.mosip.kernel.keymanager.hsm.util.CertificateUtility;
import io.mosip.kernel.keymanagerservice.logger.KeymanagerLogger;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.security.auth.x500.X500Principal;

public class PKCS11KeyStoreImpl
implements io.mosip.kernel.core.keymanager.spi.KeyStore {
    private static final Logger LOGGER = KeymanagerLogger.getLogger(PKCS11KeyStoreImpl.class);
    private String keystoreType = "PKCS11";
    private String configPath;
    private String keystorePass;
    private String symmetricKeyAlgorithm;
    private int symmetricKeyLength;
    private String asymmetricKeyAlgorithm;
    private int asymmetricKeyLength;
    private String signAlgorithm;
    private boolean enableKeyReferenceCache;
    private Map<String, KeyStore.PrivateKeyEntry> privateKeyReferenceCache;
    private Map<String, SecretKey> secretKeyReferenceCache;
    private KeyStore keyStore;
    private Provider provider = null;
    private LocalDateTime lastProviderLoadedTime;
    private static final int PROVIDER_ALLOWED_RELOAD_INTERVEL_IN_SECONDS = 60;
    private static final int NO_OF_RETRIES = 3;
    private char[] keystorePwdCharArr = null;

    public PKCS11KeyStoreImpl(Map<String, String> params) throws Exception {
        this.configPath = params.get("CONFIG_FILE_PATH");
        this.keystorePass = params.get("PKCS11_KEYSTORE_PASSWORD");
        this.symmetricKeyAlgorithm = params.get("SYM_KEY_ALGORITHM");
        this.symmetricKeyLength = Integer.valueOf(params.get("SYM_KEY_SIZE"));
        this.asymmetricKeyAlgorithm = params.get("ASYM_KEY_ALGORITHM");
        this.asymmetricKeyLength = Integer.valueOf(params.get("ASYM_KEY_SIZE"));
        this.signAlgorithm = params.get("CERT_SIGN_ALGORITHM");
        this.enableKeyReferenceCache = Boolean.parseBoolean(params.get("FLAG_KEY_REF_CACHE"));
        this.initKeystore();
    }

    private void initKeystore() {
        this.initKeyReferenceCache();
        this.keystorePwdCharArr = this.getKeystorePwd();
        this.provider = this.setupProvider(this.configPath);
        this.addProvider(this.provider);
        this.keyStore = this.getKeystoreInstance(this.keystoreType, this.provider);
        this.lastProviderLoadedTime = DateUtils.getUTCCurrentDateTime();
    }

    private char[] getKeystorePwd() {
        if (this.keystorePass.trim().length() == 0) {
            return null;
        }
        return this.keystorePass.toCharArray();
    }

    private synchronized Provider setupProvider(String configPath) {
        try {
            Provider sunPKCS11Provider = Security.getProvider("SunPKCS11");
            if (sunPKCS11Provider == null) {
                throw new ProviderException("SunPKCS11 provider not found");
            }
            return sunPKCS11Provider.configure(configPath);
        }
        catch (InvalidParameterException | ProviderException providerException) {
            throw new NoSuchSecurityProviderException(KeymanagerErrorCode.INVALID_CONFIG_FILE.getErrorCode(), KeymanagerErrorCode.INVALID_CONFIG_FILE.getErrorMessage(), (Throwable)providerException);
        }
    }

    private void addProvider(Provider provider) {
        Security.removeProvider(provider.getName());
        if (-1 == Security.addProvider(provider)) {
            throw new NoSuchSecurityProviderException(KeymanagerErrorCode.NO_SUCH_SECURITY_PROVIDER.getErrorCode(), KeymanagerErrorCode.NO_SUCH_SECURITY_PROVIDER.getErrorMessage());
        }
    }

    private KeyStore getKeystoreInstance(String keystoreType, Provider provider) {
        KeyStore mosipKeyStore = null;
        try {
            mosipKeyStore = KeyStore.getInstance(keystoreType, provider);
            mosipKeyStore.load(null, this.keystorePwdCharArr);
        }
        catch (IOException | KeyStoreException | java.security.NoSuchAlgorithmException | CertificateException e) {
            throw new KeystoreProcessingException(KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorCode(), KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorMessage() + e.getMessage(), (Throwable)e);
        }
        return mosipKeyStore;
    }

    public List<String> getAllAlias() {
        Enumeration<String> enumeration = null;
        try {
            enumeration = this.keyStore.aliases();
        }
        catch (KeyStoreException e) {
            throw new KeystoreProcessingException(KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorCode(), KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorMessage() + e.getMessage(), (Throwable)e);
        }
        return Collections.list(enumeration);
    }

    public Key getKey(String alias) {
        Key key = null;
        try {
            key = this.keyStore.getKey(alias, this.keystorePwdCharArr);
        }
        catch (KeyStoreException | java.security.NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new KeystoreProcessingException(KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorCode(), KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorMessage() + e.getMessage(), (Throwable)e);
        }
        return key;
    }

    public KeyStore.PrivateKeyEntry getAsymmetricKey(String alias) {
        KeyStore.PrivateKeyEntry privateKeyEntry = this.getPrivateKeyEntryFromCache(alias);
        if (privateKeyEntry != null) {
            return privateKeyEntry;
        }
        int i = 0;
        boolean isException = false;
        String expMessage = "";
        KeyStoreException exp = null;
        do {
            block8: {
                try {
                    if (this.keyStore.entryInstanceOf(alias, KeyStore.PrivateKeyEntry.class)) {
                        LOGGER.debug("sessionId", "KeyStoreImpl", "getAsymmetricKey", "alias is instanceof keystore");
                        KeyStore.PasswordProtection password = this.getPasswordProtection();
                        privateKeyEntry = (KeyStore.PrivateKeyEntry)this.keyStore.getEntry(alias, password);
                        if (privateKeyEntry != null) {
                            LOGGER.debug("sessionId", "KeyStoreImpl", "getAsymmetricKey", "privateKeyEntry is not null");
                            break;
                        }
                        break block8;
                    }
                    throw new NoSuchSecurityProviderException(KeymanagerErrorCode.NO_SUCH_ALIAS.getErrorCode(), KeymanagerErrorCode.NO_SUCH_ALIAS.getErrorMessage() + alias);
                }
                catch (java.security.NoSuchAlgorithmException | UnrecoverableEntryException e) {
                    throw new KeystoreProcessingException(KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorCode(), KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorMessage() + e.getMessage(), (Throwable)e);
                }
                catch (KeyStoreException kse) {
                    isException = true;
                    expMessage = kse.getMessage();
                    exp = kse;
                    LOGGER.debug("sessionId", "KeyStoreImpl", "getAsymmetricKey", expMessage);
                }
            }
            if (!isException) continue;
            this.reloadProvider();
            isException = false;
        } while (i++ < 3);
        if (Objects.isNull(privateKeyEntry)) {
            LOGGER.debug("sessionId", "KeyStoreImpl", "getAsymmetricKey", "privateKeyEntry is null");
            throw new KeystoreProcessingException(KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorCode(), KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorMessage() + expMessage, (Throwable)exp);
        }
        this.addPrivateKeyEntryToCache(alias, privateKeyEntry);
        return privateKeyEntry;
    }

    private synchronized void reloadProvider() {
        LOGGER.info("sessionId", "KeyStoreImpl", "KeyStoreImpl", "reloading provider");
        if (DateUtils.getUTCCurrentDateTime().isBefore(this.lastProviderLoadedTime.plusSeconds(60L))) {
            LOGGER.warn("sessionId", "KeyStoreImpl", "reloadProvider", "Last time successful reload done on " + this.lastProviderLoadedTime.toString() + ", so reloading not done before interval of 60 sec");
            return;
        }
        String existingProviderName = null;
        if (Objects.nonNull(this.provider)) {
            existingProviderName = this.provider.getName();
        }
        this.provider = this.setupProvider(this.configPath);
        if (existingProviderName != null) {
            Security.removeProvider(existingProviderName);
        }
        this.addProvider(this.provider);
        this.keyStore = this.getKeystoreInstance(this.keystoreType, this.provider);
        this.lastProviderLoadedTime = DateUtils.getUTCCurrentDateTime();
    }

    public PrivateKey getPrivateKey(String alias) {
        KeyStore.PrivateKeyEntry privateKeyEntry = this.getAsymmetricKey(alias);
        return privateKeyEntry.getPrivateKey();
    }

    public PublicKey getPublicKey(String alias) {
        KeyStore.PrivateKeyEntry privateKeyEntry = this.getAsymmetricKey(alias);
        Certificate[] certificates = privateKeyEntry.getCertificateChain();
        return certificates[0].getPublicKey();
    }

    public X509Certificate getCertificate(String alias) {
        KeyStore.PrivateKeyEntry privateKeyEntry = this.getAsymmetricKey(alias);
        X509Certificate[] certificates = (X509Certificate[])privateKeyEntry.getCertificateChain();
        return certificates[0];
    }

    public SecretKey getSymmetricKey(String alias) {
        SecretKey secretKey = this.getSecretKeyFromCache(alias);
        if (secretKey != null) {
            return secretKey;
        }
        int i = 0;
        boolean isException = false;
        String expMessage = "";
        KeyStoreException exp = null;
        do {
            block8: {
                try {
                    if (this.keyStore.entryInstanceOf(alias, KeyStore.SecretKeyEntry.class)) {
                        KeyStore.PasswordProtection password = this.getPasswordProtection();
                        KeyStore.SecretKeyEntry retrivedSecret = (KeyStore.SecretKeyEntry)this.keyStore.getEntry(alias, password);
                        secretKey = retrivedSecret.getSecretKey();
                        if (secretKey != null) {
                            LOGGER.debug("sessionId", "KeyStoreImpl", "getSymmetricKey", "secretKey is not null");
                            break;
                        }
                        break block8;
                    }
                    throw new NoSuchSecurityProviderException(KeymanagerErrorCode.NO_SUCH_ALIAS.getErrorCode(), KeymanagerErrorCode.NO_SUCH_ALIAS.getErrorMessage() + alias);
                }
                catch (java.security.NoSuchAlgorithmException | UnrecoverableEntryException e) {
                    throw new KeystoreProcessingException(KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorCode(), KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorMessage() + e.getMessage(), (Throwable)e);
                }
                catch (KeyStoreException kse) {
                    isException = true;
                    expMessage = kse.getMessage();
                    exp = kse;
                    LOGGER.debug("sessionId", "KeyStoreImpl", "getSymmetricKey", expMessage);
                }
            }
            if (!isException) continue;
            this.reloadProvider();
            isException = false;
        } while (i++ < 3);
        if (Objects.isNull(secretKey)) {
            LOGGER.debug("sessionId", "KeyStoreImpl", "getSymmetricKey", "secretKey is null");
            throw new KeystoreProcessingException(KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorCode(), KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorMessage() + expMessage, (Throwable)exp);
        }
        this.addSecretKeyToCache(alias, secretKey);
        return secretKey;
    }

    public void deleteKey(String alias) {
        try {
            this.keyStore.deleteEntry(alias);
        }
        catch (KeyStoreException e) {
            throw new KeystoreProcessingException(KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorCode(), KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorMessage() + e.getMessage(), (Throwable)e);
        }
    }

    private void storeCertificate(String alias, Certificate[] chain, PrivateKey privateKey) {
        KeyStore.PrivateKeyEntry privateKeyEntry = new KeyStore.PrivateKeyEntry(privateKey, chain);
        KeyStore.PasswordProtection password = this.getPasswordProtection();
        try {
            this.keyStore.setEntry(alias, privateKeyEntry, password);
            this.keyStore.store(null, this.keystorePwdCharArr);
        }
        catch (IOException | KeyStoreException | java.security.NoSuchAlgorithmException | CertificateException e) {
            throw new KeystoreProcessingException(KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorCode(), KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorMessage() + e.getMessage());
        }
    }

    public void generateAndStoreAsymmetricKey(String alias, String signKeyAlias, CertificateParameters certParams) {
        KeyPair keyPair = null;
        PrivateKey signPrivateKey = null;
        X500Principal signerPrincipal = null;
        if (Objects.nonNull(signKeyAlias)) {
            KeyStore.PrivateKeyEntry signKeyEntry = this.getAsymmetricKey(signKeyAlias);
            signPrivateKey = signKeyEntry.getPrivateKey();
            X509Certificate signCert = (X509Certificate)signKeyEntry.getCertificate();
            signerPrincipal = signCert.getSubjectX500Principal();
            keyPair = this.generateKeyPair();
        } else {
            keyPair = this.generateKeyPair();
            signPrivateKey = keyPair.getPrivate();
        }
        X509Certificate x509Cert = CertificateUtility.generateX509Certificate(signPrivateKey, keyPair.getPublic(), certParams, signerPrincipal, this.signAlgorithm, this.provider.getName());
        Certificate[] chain = new X509Certificate[]{x509Cert};
        this.storeCertificate(alias, chain, keyPair.getPrivate());
    }

    public void generateAndStoreSymmetricKey(String alias) {
        SecretKey secretKey = this.generateSymmetricKey();
        KeyStore.SecretKeyEntry secret = new KeyStore.SecretKeyEntry(secretKey);
        KeyStore.PasswordProtection password = this.getPasswordProtection();
        try {
            this.keyStore.setEntry(alias, secret, password);
            this.keyStore.store(null, this.keystorePwdCharArr);
        }
        catch (IOException | KeyStoreException | java.security.NoSuchAlgorithmException | CertificateException e) {
            throw new KeystoreProcessingException(KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorCode(), KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorMessage() + e.getMessage(), (Throwable)e);
        }
    }

    private KeyPair generateKeyPair() {
        try {
            KeyPairGenerator generator = KeyPairGenerator.getInstance(this.asymmetricKeyAlgorithm, this.provider);
            SecureRandom random = new SecureRandom();
            generator.initialize(this.asymmetricKeyLength, random);
            return generator.generateKeyPair();
        }
        catch (java.security.NoSuchAlgorithmException e) {
            throw new NoSuchAlgorithmException(KeyGeneratorExceptionConstant.MOSIP_NO_SUCH_ALGORITHM_EXCEPTION.getErrorCode(), KeyGeneratorExceptionConstant.MOSIP_NO_SUCH_ALGORITHM_EXCEPTION.getErrorMessage(), (Throwable)e);
        }
    }

    private SecretKey generateSymmetricKey() {
        try {
            KeyGenerator generator = KeyGenerator.getInstance(this.symmetricKeyAlgorithm, this.provider);
            SecureRandom random = new SecureRandom();
            generator.init(this.symmetricKeyLength, random);
            return generator.generateKey();
        }
        catch (java.security.NoSuchAlgorithmException e) {
            throw new NoSuchAlgorithmException(KeyGeneratorExceptionConstant.MOSIP_NO_SUCH_ALGORITHM_EXCEPTION.getErrorCode(), KeyGeneratorExceptionConstant.MOSIP_NO_SUCH_ALGORITHM_EXCEPTION.getErrorMessage(), (Throwable)e);
        }
    }

    public void storeCertificate(String alias, PrivateKey privateKey, Certificate certificate) {
        try {
            KeyStore.PrivateKeyEntry privateKeyEntry = new KeyStore.PrivateKeyEntry(privateKey, new Certificate[]{certificate});
            KeyStore.PasswordProtection password = this.getPasswordProtection();
            this.keyStore.setEntry(alias, privateKeyEntry, password);
            this.keyStore.store(null, this.keystorePwdCharArr);
        }
        catch (IOException | KeyStoreException | java.security.NoSuchAlgorithmException | CertificateException e) {
            throw new KeystoreProcessingException(KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorCode(), KeymanagerErrorCode.KEYSTORE_PROCESSING_ERROR.getErrorMessage() + e.getMessage(), (Throwable)e);
        }
    }

    public String getKeystoreProviderName() {
        if (Objects.nonNull(this.keyStore)) {
            return this.keyStore.getProvider().getName();
        }
        throw new KeystoreProcessingException(KeymanagerErrorCode.KEYSTORE_NOT_INSTANTIATED.getErrorCode(), KeymanagerErrorCode.KEYSTORE_NOT_INSTANTIATED.getErrorMessage());
    }

    private KeyStore.PasswordProtection getPasswordProtection() {
        if (this.keystorePwdCharArr == null) {
            return null;
        }
        return new KeyStore.PasswordProtection(this.keystorePwdCharArr);
    }

    private void initKeyReferenceCache() {
        if (!this.enableKeyReferenceCache) {
            return;
        }
        this.privateKeyReferenceCache = new ConcurrentHashMap<String, KeyStore.PrivateKeyEntry>();
        this.secretKeyReferenceCache = new ConcurrentHashMap<String, SecretKey>();
    }

    private void addPrivateKeyEntryToCache(String alias, KeyStore.PrivateKeyEntry privateKeyEntry) {
        if (!this.enableKeyReferenceCache) {
            return;
        }
        LOGGER.debug("sessionId", "KeyStoreImpl", "addPrivateKeyEntryToCache", "Adding private key reference to map for alias " + alias);
        this.privateKeyReferenceCache.put(alias, privateKeyEntry);
    }

    private KeyStore.PrivateKeyEntry getPrivateKeyEntryFromCache(String alias) {
        if (!this.enableKeyReferenceCache) {
            return null;
        }
        return this.privateKeyReferenceCache.get(alias);
    }

    private void addSecretKeyToCache(String alias, SecretKey secretKey) {
        if (!this.enableKeyReferenceCache) {
            return;
        }
        LOGGER.debug("sessionId", "KeyStoreImpl", "addSecretKeyToCache", "Adding secretKey reference to map for alias " + alias);
        this.secretKeyReferenceCache.put(alias, secretKey);
    }

    private SecretKey getSecretKeyFromCache(String alias) {
        if (!this.enableKeyReferenceCache) {
            return null;
        }
        return this.secretKeyReferenceCache.get(alias);
    }
}

