/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.cryptomanager.util;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.module.afterburner.AfterburnerModule;
import io.mosip.kernel.core.authmanager.authadapter.model.AuthUserDetails;
import io.mosip.kernel.core.exception.ParseException;
import io.mosip.kernel.core.logger.spi.Logger;
import io.mosip.kernel.core.util.CryptoUtil;
import io.mosip.kernel.cryptomanager.constant.CryptomanagerConstant;
import io.mosip.kernel.cryptomanager.constant.CryptomanagerErrorCode;
import io.mosip.kernel.cryptomanager.dto.CryptomanagerRequestDto;
import io.mosip.kernel.cryptomanager.exception.CryptoManagerSerivceException;
import io.mosip.kernel.keymanagerservice.dto.SymmetricKeyRequestDto;
import io.mosip.kernel.keymanagerservice.entity.KeyPolicy;
import io.mosip.kernel.keymanagerservice.exception.KeymanagerServiceException;
import io.mosip.kernel.keymanagerservice.helper.KeymanagerDBHelper;
import io.mosip.kernel.keymanagerservice.logger.KeymanagerLogger;
import io.mosip.kernel.keymanagerservice.service.KeymanagerService;
import io.mosip.kernel.keymanagerservice.util.KeymanagerUtil;
import java.io.IOException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.interfaces.RSAPublicKey;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.digest.DigestUtils;
import org.bouncycastle.util.encoders.Hex;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@RefreshScope
@Component
public class CryptomanagerUtils {
    private static final Logger LOGGER = KeymanagerLogger.getLogger(CryptomanagerUtils.class);
    private static ObjectMapper mapper = ((JsonMapper.Builder)JsonMapper.builder().addModule((Module)new AfterburnerModule())).build();
    private static final String UTC_DATETIME_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    @Value(value="${mosip.kernel.keygenerator.asymmetric-algorithm-name}")
    private String asymmetricAlgorithmName;
    @Value(value="${mosip.kernel.keygenerator.symmetric-algorithm-name}")
    private String symmetricAlgorithmName;
    @Value(value="${mosip.kernel.data-key-splitter}")
    private String keySplitter;
    @Value(value="${mosip.sign-certificate-refid:SIGN}")
    private String signRefId;
    @Value(value="${mosip.sign.applicationid:KERNEL}")
    private String signApplicationId;
    @Value(value="${mosip.kernel.keymanager.crypto.validate.keysize:true}")
    private boolean validateKeySize;
    @Value(value="${mosip.kernel.keymanager.jwtEncrypt.validate.json:true}")
    private boolean confValidateJson;
    @Autowired
    private KeymanagerService keyManager;
    @Autowired
    private KeymanagerUtil keymanagerUtil;
    @Autowired
    private KeymanagerDBHelper dbHelper;

    public Certificate getCertificate(CryptomanagerRequestDto cryptomanagerRequestDto) {
        String certData = this.getCertificateFromKeyManager(cryptomanagerRequestDto.getApplicationId(), cryptomanagerRequestDto.getReferenceId());
        return this.keymanagerUtil.convertToCertificate(certData);
    }

    private String getCertificateFromKeyManager(String appId, String refId) {
        return this.keyManager.getCertificate(appId, Optional.ofNullable(refId)).getCertificate();
    }

    public SecretKey getDecryptedSymmetricKey(CryptomanagerRequestDto cryptomanagerRequestDto) {
        byte[] symmetricKey = CryptoUtil.decodeURLSafeBase64((String)this.decryptSymmetricKeyUsingKeyManager(cryptomanagerRequestDto));
        return new SecretKeySpec(symmetricKey, 0, symmetricKey.length, this.symmetricAlgorithmName);
    }

    private String decryptSymmetricKeyUsingKeyManager(CryptomanagerRequestDto cryptomanagerRequestDto) {
        SymmetricKeyRequestDto symmetricKeyRequestDto = new SymmetricKeyRequestDto(cryptomanagerRequestDto.getApplicationId(), cryptomanagerRequestDto.getTimeStamp(), cryptomanagerRequestDto.getReferenceId(), cryptomanagerRequestDto.getData(), cryptomanagerRequestDto.getPrependThumbprint());
        return this.keyManager.decryptSymmetricKey(symmetricKeyRequestDto).getSymmetricKey();
    }

    public static String nullOrTrim(String parameter) {
        return parameter == null ? null : parameter.trim();
    }

    public boolean isValidSalt(String salt) {
        return salt != null && !salt.trim().isEmpty();
    }

    public LocalDateTime parseToLocalDateTime(String dateTime) {
        return LocalDateTime.parse(dateTime, DateTimeFormatter.ofPattern(UTC_DATETIME_PATTERN));
    }

    public byte[] hexDecode(String hexData) {
        char[] hexDataCharArr = hexData.toCharArray();
        int dataLength = hexDataCharArr.length;
        if ((dataLength & 1) != 0) {
            throw new ParseException(CryptomanagerErrorCode.HEX_DATA_PARSE_EXCEPTION.getErrorCode(), CryptomanagerErrorCode.HEX_DATA_PARSE_EXCEPTION.getErrorMessage());
        }
        byte[] decodedBytes = new byte[dataLength >> 1];
        int i = 0;
        int j = 0;
        while (j < dataLength) {
            int f = Character.digit(hexDataCharArr[j], 16) << 4;
            f |= Character.digit(hexDataCharArr[++j], 16);
            ++j;
            decodedBytes[i] = (byte)(f & 0xFF);
            ++i;
        }
        return decodedBytes;
    }

    public byte[] getCertificateThumbprint(Certificate cert) {
        try {
            return DigestUtils.sha256((byte[])cert.getEncoded());
        }
        catch (CertificateEncodingException e) {
            LOGGER.error("CryptoManagerSession", "CryptoManagerEncrypt", "", "Error generating certificate thumbprint.");
            throw new CryptoManagerSerivceException(CryptomanagerErrorCode.CERTIFICATE_THUMBPRINT_ERROR.getErrorCode(), CryptomanagerErrorCode.CERTIFICATE_THUMBPRINT_ERROR.getErrorMessage());
        }
    }

    public String getCertificateThumbprintInHex(Certificate cert) {
        return Hex.toHexString((byte[])this.getCertificateThumbprint(cert)).toUpperCase();
    }

    public byte[] concatCertThumbprint(byte[] certThumbprint, byte[] encryptedKey) {
        byte[] finalData = new byte[32 + encryptedKey.length];
        System.arraycopy(certThumbprint, 0, finalData, 0, certThumbprint.length);
        System.arraycopy(encryptedKey, 0, finalData, certThumbprint.length, encryptedKey.length);
        return finalData;
    }

    public byte[] generateRandomBytes(int size) {
        byte[] randomBytes = new byte[size];
        SecureRandom secureRandom = new SecureRandom();
        secureRandom.nextBytes(randomBytes);
        return randomBytes;
    }

    public byte[] concatByteArrays(byte[] array1, byte[] array2) {
        byte[] finalData = new byte[array1.length + array2.length];
        System.arraycopy(array1, 0, finalData, 0, array1.length);
        System.arraycopy(array2, 0, finalData, array1.length, array2.length);
        return finalData;
    }

    public byte[] parseEncryptKeyHeader(byte[] encryptedKey) {
        byte[] versionHeaderBytes = Arrays.copyOfRange(encryptedKey, 0, CryptomanagerConstant.VERSION_RSA_2048.length);
        if (!Arrays.equals(versionHeaderBytes, CryptomanagerConstant.VERSION_RSA_2048)) {
            return new byte[0];
        }
        return versionHeaderBytes;
    }

    public boolean isDataValid(String anyData) {
        return anyData != null && !anyData.trim().isEmpty();
    }

    public byte[] decodeBase64Data(String anyBase64EncodedData) {
        try {
            return CryptoUtil.decodeURLSafeBase64((String)anyBase64EncodedData);
        }
        catch (IllegalArgumentException argException) {
            LOGGER.debug("CryptoManagerSession", "CryptoManagerEncrypt", "", "Error Decoding Base64 URL Safe data, trying with Base64 normal decode.");
            try {
                return CryptoUtil.decodePlainBase64((String)anyBase64EncodedData);
            }
            catch (Exception exception) {
                LOGGER.error("CryptoManagerSession", new Object[]{"CryptoManagerEncrypt", "", "Error Decoding Base64 normal decode, throwing Exception.", exception});
                throw new CryptoManagerSerivceException(CryptomanagerErrorCode.INVALID_DATA.getErrorCode(), CryptomanagerErrorCode.INVALID_DATA.getErrorMessage());
            }
        }
    }

    public boolean hasKeyAccess(String applicationId) {
        if (Objects.isNull(applicationId) || applicationId.equals("")) {
            return true;
        }
        Optional<KeyPolicy> keyPolicy = this.dbHelper.getKeyPolicyFromCache(applicationId);
        if (!keyPolicy.isPresent()) {
            return false;
        }
        String accessAllowed = keyPolicy.get().getAccessAllowed();
        if (Objects.isNull(accessAllowed) || accessAllowed.isEmpty()) {
            return false;
        }
        if (accessAllowed.equals("NA")) {
            return true;
        }
        AuthUserDetails userDetail = (AuthUserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        List allowedList = Stream.of(accessAllowed.split(",")).map(allowed -> allowed.trim()).collect(Collectors.toList());
        String preferredUserName = userDetail.getUsername();
        return allowedList.stream().anyMatch(preferredUserName::equalsIgnoreCase);
    }

    public void validateKeyIdentifierIds(String applicationId, String referenceId) {
        if (!this.isDataValid(referenceId) || applicationId.equalsIgnoreCase(this.signApplicationId) && (referenceId.equalsIgnoreCase(this.signRefId) || referenceId.equalsIgnoreCase("IDENTITY_CACHE"))) {
            LOGGER.error("CryptoManagerSession", "CryptoManagerEncrypt", "CryptoManagerEncrypt", "Not Allowed to preform encryption with Master Key.");
            throw new CryptoManagerSerivceException(CryptomanagerErrorCode.ENCRYPT_NOT_ALLOWED_ERROR.getErrorCode(), CryptomanagerErrorCode.ENCRYPT_NOT_ALLOWED_ERROR.getErrorMessage());
        }
    }

    public Certificate getCertificate(String applicationId, String referenceId) {
        String certData = this.getCertificateFromKeyManager(applicationId, referenceId);
        return this.keymanagerUtil.convertToCertificate(certData);
    }

    public void validateEncKeySize(Certificate encCert) {
        RSAPublicKey rsaPublicKey;
        if (this.validateKeySize && (rsaPublicKey = (RSAPublicKey)encCert.getPublicKey()).getModulus().bitLength() != 2048) {
            LOGGER.error("CryptoManagerSession", this.getClass().getSimpleName(), "Crypto-Manager-JWEEncrypt", "Not Allowed to preform encryption with Key size not equal to 2048 bit.");
            throw new CryptoManagerSerivceException(CryptomanagerErrorCode.ENCRYPT_NOT_ALLOWED_ERROR.getErrorCode(), CryptomanagerErrorCode.ENCRYPT_NOT_ALLOWED_ERROR.getErrorMessage());
        }
    }

    public void validateEncryptData(String reqDataToEncrypt) {
        if (!this.isDataValid(reqDataToEncrypt)) {
            LOGGER.error("CryptoManagerSession", this.getClass().getSimpleName(), "Crypto-Manager-JWEEncrypt", "Provided Data to Encrypt is invalid.");
            throw new CryptoManagerSerivceException(CryptomanagerErrorCode.INVALID_REQUEST.getErrorCode(), CryptomanagerErrorCode.INVALID_REQUEST.getErrorMessage());
        }
    }

    public void checkForValidJsonData(String decodedDataToEncrypt) {
        if (this.confValidateJson && !this.isJsonValid(decodedDataToEncrypt)) {
            LOGGER.error("CryptoManagerSession", this.getClass().getSimpleName(), "Crypto-Manager-JWEEncrypt", "Provided Data to encrypt is not valid JSON.");
            throw new CryptoManagerSerivceException(CryptomanagerErrorCode.INVALID_JSON.getErrorCode(), CryptomanagerErrorCode.INVALID_JSON.getErrorMessage());
        }
    }

    public boolean isJsonValid(String jsonInString) {
        try {
            mapper.readTree(jsonInString);
            return true;
        }
        catch (IOException e) {
            LOGGER.error("CryptoManagerSession", this.getClass().getSimpleName(), "Crypto-Manager-JWEEncrypt", "Provided JSON Data to Encrypt is invalid.");
            return false;
        }
    }

    public boolean isIncludeAttrsValid(Boolean includes, Boolean defaultValue) {
        if (Objects.isNull(includes)) {
            return defaultValue;
        }
        return includes;
    }

    public Certificate convertToCertificate(String certData) {
        try {
            return this.keymanagerUtil.convertToCertificate(certData);
        }
        catch (KeymanagerServiceException exp) {
            LOGGER.warn("CryptoManagerSession", this.getClass().getSimpleName(), "Crypto-Manager-JWEEncrypt", "Unable to parse the input certificate.");
            return null;
        }
    }

    public void validateInputData(String reqDataToDigest) {
        if (!this.isDataValid(reqDataToDigest)) {
            LOGGER.error("CryptoManagerSession", this.getClass().getSimpleName(), "Crypto-Manager-Gen-Argon2-Hash", "Provided Data to generate Hash is invalid.");
            throw new CryptoManagerSerivceException(CryptomanagerErrorCode.INVALID_REQUEST.getErrorCode(), CryptomanagerErrorCode.INVALID_REQUEST.getErrorMessage());
        }
    }
}

