/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.cryptomanager.service.impl;

import de.mkammerer.argon2.Argon2Advanced;
import de.mkammerer.argon2.Argon2Factory;
import io.mosip.kernel.core.crypto.spi.CryptoCoreSpec;
import io.mosip.kernel.core.logger.spi.Logger;
import io.mosip.kernel.core.util.CryptoUtil;
import io.mosip.kernel.core.util.DateUtils;
import io.mosip.kernel.cryptomanager.constant.CryptomanagerConstant;
import io.mosip.kernel.cryptomanager.constant.CryptomanagerErrorCode;
import io.mosip.kernel.cryptomanager.dto.Argon2GenerateHashRequestDto;
import io.mosip.kernel.cryptomanager.dto.Argon2GenerateHashResponseDto;
import io.mosip.kernel.cryptomanager.dto.CryptoWithPinRequestDto;
import io.mosip.kernel.cryptomanager.dto.CryptoWithPinResponseDto;
import io.mosip.kernel.cryptomanager.dto.CryptomanagerRequestDto;
import io.mosip.kernel.cryptomanager.dto.CryptomanagerResponseDto;
import io.mosip.kernel.cryptomanager.dto.JWTCipherResponseDto;
import io.mosip.kernel.cryptomanager.dto.JWTDecryptRequestDto;
import io.mosip.kernel.cryptomanager.dto.JWTEncryptRequestDto;
import io.mosip.kernel.cryptomanager.exception.CryptoManagerSerivceException;
import io.mosip.kernel.cryptomanager.service.CryptomanagerService;
import io.mosip.kernel.cryptomanager.util.CryptomanagerUtils;
import io.mosip.kernel.keygenerator.bouncycastle.util.KeyGeneratorUtils;
import io.mosip.kernel.keymanagerservice.entity.KeyStore;
import io.mosip.kernel.keymanagerservice.helper.PrivateKeyDecryptorHelper;
import io.mosip.kernel.keymanagerservice.logger.KeymanagerLogger;
import io.mosip.kernel.keymanagerservice.util.KeymanagerUtil;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.PostConstruct;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.util.encoders.Hex;
import org.cache2k.Cache;
import org.cache2k.Cache2kBuilder;
import org.jose4j.jwe.JsonWebEncryption;
import org.jose4j.lang.JoseException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CryptomanagerServiceImpl
implements CryptomanagerService {
    private static final int GCM_NONCE_LENGTH = 12;
    private static final int PBE_SALT_LENGTH = 32;
    private static final String AES_KEY_TYPE = "AES";
    private static final int AES_KEY_SIZE = 128;
    private String AES_GCM_ALGO = "AES/GCM/NoPadding";
    private static final Logger LOGGER = KeymanagerLogger.getLogger(CryptomanagerServiceImpl.class);
    @Value(value="${mosip.kernel.data-key-splitter}")
    private String keySplitter;
    @Value(value="${mosip.kernel.keymanager.113nothumbprint.support:false}")
    private boolean noThumbprint;
    @Value(value="${mosip.sign-certificate-refid:SIGN}")
    private String signRefId;
    @Value(value="${mosip.sign.applicationid:KERNEL}")
    private String signApplicationId;
    @Value(value="${mosip.keymanager.salt.params.cache.expire.inMins:30}")
    private long cacheExpireInMins;
    @Value(value="${mosip.keymanager.argon2.hash.generate.iterations:10}")
    private int argon2Iterations;
    @Value(value="${mosip.keymanager.argon2.hash.generate.memory.inKiB:65536}")
    private int argon2Memory;
    @Value(value="${mosip.keymanager.argon2.hash.generate.parallelism:2}")
    private int argon2Parallelism;
    private static SecureRandom secureRandom = null;
    @Autowired
    io.mosip.kernel.keygenerator.bouncycastle.KeyGenerator keyGenerator;
    @Autowired
    CryptomanagerUtils cryptomanagerUtil;
    @Autowired
    private CryptoCoreSpec<byte[], byte[], SecretKey, PublicKey, PrivateKey, String> cryptoCore;
    @Autowired
    private PrivateKeyDecryptorHelper privateKeyDecryptorHelper;
    @Autowired
    KeymanagerUtil keymanagerUtil;
    private Cache<String, Object> saltGenParamsCache = null;

    @PostConstruct
    public void init() {
        this.saltGenParamsCache = new Cache2kBuilder<String, Object>(){}.name("saltGenParamsCache-" + this.hashCode()).expireAfterWrite(this.cacheExpireInMins, TimeUnit.MINUTES).entryCapacity(10L).refreshAhead(true).loaderThreadCount(1).loader(objectKey -> {
            LOGGER.info("CryptoManagerSession", this.getClass().getSimpleName(), "Crypto-Manager-Gen-Argon2-Hash", "Loading Creating Cache for Object Key: " + objectKey);
            if (objectKey.equals("cacheAESKey")) {
                KeyGenerator keyGenerator = KeyGeneratorUtils.getKeyGenerator(AES_KEY_TYPE, 128);
                return keyGenerator.generateKey();
            }
            if (objectKey.equals("cacheIntCounter")) {
                if (secureRandom == null) {
                    secureRandom = new SecureRandom();
                }
                return new AtomicLong(secureRandom.nextLong());
            }
            return null;
        }).build();
    }

    @Override
    public CryptomanagerResponseDto encrypt(CryptomanagerRequestDto cryptoRequestDto) {
        byte[] encryptedData;
        LOGGER.info("CryptoManagerSession", "CryptoManagerEncrypt", "CryptoManagerEncrypt", "Request for data encryption.");
        this.cryptomanagerUtil.validateKeyIdentifierIds(cryptoRequestDto.getApplicationId(), cryptoRequestDto.getReferenceId());
        SecretKey secretKey = this.keyGenerator.getSymmetricKey();
        byte[] headerBytes = new byte[]{};
        if (this.cryptomanagerUtil.isValidSalt(CryptomanagerUtils.nullOrTrim(cryptoRequestDto.getSalt()))) {
            encryptedData = (byte[])this.cryptoCore.symmetricEncrypt((Object)secretKey, (Object)this.cryptomanagerUtil.decodeBase64Data(cryptoRequestDto.getData()), (Object)this.cryptomanagerUtil.decodeBase64Data(CryptomanagerUtils.nullOrTrim(cryptoRequestDto.getSalt())), (Object)this.cryptomanagerUtil.decodeBase64Data(CryptomanagerUtils.nullOrTrim(cryptoRequestDto.getAad())));
        } else {
            byte[] aad = this.cryptomanagerUtil.decodeBase64Data(CryptomanagerUtils.nullOrTrim(cryptoRequestDto.getAad()));
            if (aad == null || aad.length == 0) {
                encryptedData = this.generateAadAndEncryptData(secretKey, cryptoRequestDto.getData());
                headerBytes = CryptomanagerConstant.VERSION_RSA_2048;
            } else {
                encryptedData = (byte[])this.cryptoCore.symmetricEncrypt((Object)secretKey, (Object)this.cryptomanagerUtil.decodeBase64Data(cryptoRequestDto.getData()), (Object)aad);
            }
        }
        Certificate certificate = this.cryptomanagerUtil.getCertificate(cryptoRequestDto);
        LOGGER.info("CryptoManagerSession", "CryptoManagerEncrypt", "CryptoManagerEncrypt", "Found the cerificate, proceeding with session key encryption.");
        PublicKey publicKey = certificate.getPublicKey();
        byte[] encryptedSymmetricKey = (byte[])this.cryptoCore.asymmetricEncrypt((Object)publicKey, (Object)secretKey.getEncoded());
        LOGGER.info("CryptoManagerSession", "CryptoManagerEncrypt", "CryptoManagerEncrypt", "Session key encryption completed.");
        CryptomanagerResponseDto cryptoResponseDto = new CryptomanagerResponseDto();
        byte[] certThumbprint = this.cryptomanagerUtil.getCertificateThumbprint(certificate);
        byte[] concatedData = this.cryptomanagerUtil.concatCertThumbprint(certThumbprint, encryptedSymmetricKey);
        byte[] finalEncKeyBytes = this.cryptomanagerUtil.concatByteArrays(headerBytes, concatedData);
        cryptoResponseDto.setData(CryptoUtil.encodeToURLSafeBase64((byte[])CryptoUtil.combineByteArray((byte[])encryptedData, (byte[])finalEncKeyBytes, (String)this.keySplitter)));
        return cryptoResponseDto;
    }

    private byte[] generateAadAndEncryptData(SecretKey secretKey, String data) {
        LOGGER.info("CryptoManagerSession", "CryptoManagerEncrypt", "CryptoManagerEncrypt", "Provided AAD value is null or empty byte array. So generating random 32 bytes for AAD.");
        byte[] aad = this.cryptomanagerUtil.generateRandomBytes(32);
        byte[] nonce = Arrays.copyOfRange(aad, 0, 12);
        byte[] encData = (byte[])this.cryptoCore.symmetricEncrypt((Object)secretKey, (Object)this.cryptomanagerUtil.decodeBase64Data(data), (Object)nonce, (Object)aad);
        return this.cryptomanagerUtil.concatByteArrays(aad, encData);
    }

    @Override
    public CryptomanagerResponseDto decrypt(CryptomanagerRequestDto cryptoRequestDto) {
        LOGGER.info("CryptoManagerSession", "CryptoManagerDecrypt", "CryptoManagerDecrypt", "Request for data decryption.");
        boolean hasAcccess = this.cryptomanagerUtil.hasKeyAccess(cryptoRequestDto.getApplicationId());
        if (!hasAcccess) {
            LOGGER.error("CryptoManagerSession", "CryptoManagerDecrypt", "CryptoManagerDecrypt", "Data Decryption is not allowed for the authenticated user for the provided application id.");
            throw new CryptoManagerSerivceException(CryptomanagerErrorCode.DECRYPT_NOT_ALLOWED_ERROR.getErrorCode(), CryptomanagerErrorCode.DECRYPT_NOT_ALLOWED_ERROR.getErrorMessage());
        }
        int keyDemiliterIndex = 0;
        byte[] encryptedHybridData = this.cryptomanagerUtil.decodeBase64Data(cryptoRequestDto.getData());
        keyDemiliterIndex = CryptoUtil.getSplitterIndex((byte[])encryptedHybridData, (int)keyDemiliterIndex, (String)this.keySplitter);
        byte[] encryptedKey = Arrays.copyOfRange(encryptedHybridData, 0, keyDemiliterIndex);
        byte[] encryptedData = Arrays.copyOfRange(encryptedHybridData, keyDemiliterIndex + this.keySplitter.length(), encryptedHybridData.length);
        byte[] headerBytes = this.cryptomanagerUtil.parseEncryptKeyHeader(encryptedKey);
        cryptoRequestDto.setData(CryptoUtil.encodeToURLSafeBase64((byte[])Arrays.copyOfRange(encryptedKey, headerBytes.length, encryptedKey.length)));
        SecretKey decryptedSymmetricKey = this.cryptomanagerUtil.getDecryptedSymmetricKey(cryptoRequestDto);
        LOGGER.info("CryptoManagerSession", "CryptoManagerDecrypt", "CryptoManagerDecrypt", "Session Key Decryption completed.");
        byte[] decryptedData = this.cryptomanagerUtil.isValidSalt(CryptomanagerUtils.nullOrTrim(cryptoRequestDto.getSalt())) ? (byte[])this.cryptoCore.symmetricDecrypt((Object)decryptedSymmetricKey, (Object)encryptedData, (Object)this.cryptomanagerUtil.decodeBase64Data(CryptomanagerUtils.nullOrTrim(cryptoRequestDto.getSalt())), (Object)this.cryptomanagerUtil.decodeBase64Data(CryptomanagerUtils.nullOrTrim(cryptoRequestDto.getAad()))) : (Arrays.equals(headerBytes, CryptomanagerConstant.VERSION_RSA_2048) ? this.splitAadAndDecryptData(decryptedSymmetricKey, encryptedData) : (byte[])this.cryptoCore.symmetricDecrypt((Object)decryptedSymmetricKey, (Object)encryptedData, (Object)this.cryptomanagerUtil.decodeBase64Data(CryptomanagerUtils.nullOrTrim(cryptoRequestDto.getAad()))));
        LOGGER.info("CryptoManagerSession", "CryptoManagerDecrypt", "CryptoManagerDecrypt", "Data decryption completed.");
        CryptomanagerResponseDto cryptoResponseDto = new CryptomanagerResponseDto();
        cryptoResponseDto.setData(CryptoUtil.encodeToURLSafeBase64((byte[])decryptedData));
        return cryptoResponseDto;
    }

    private byte[] splitAadAndDecryptData(SecretKey symmetricKey, byte[] encryptedData) {
        byte[] aad = Arrays.copyOfRange(encryptedData, 0, 32);
        byte[] nonce = Arrays.copyOfRange(aad, 0, 12);
        byte[] finalEncData = Arrays.copyOfRange(encryptedData, 32, encryptedData.length);
        return (byte[])this.cryptoCore.symmetricDecrypt((Object)symmetricKey, (Object)finalEncData, (Object)nonce, (Object)aad);
    }

    @Override
    public CryptoWithPinResponseDto encryptWithPin(CryptoWithPinRequestDto requestDto) {
        LOGGER.info("CryptoManagerSession", "CryptoManagerEncryptWithPin", "CryptoManagerEncryptWithPin", "Request for data encryption with Pin.");
        String dataToEnc = requestDto.getData();
        String userPin = requestDto.getUserPin();
        if (!this.cryptomanagerUtil.isDataValid(dataToEnc) || !this.cryptomanagerUtil.isDataValid(userPin)) {
            LOGGER.error("CryptoManagerSession", "CryptoManagerEncryptWithPin", "CryptoManagerEncryptWithPin", "Either Data to encrypt or user pin is blank.");
            throw new CryptoManagerSerivceException(CryptomanagerErrorCode.INVALID_REQUEST.getErrorCode(), CryptomanagerErrorCode.INVALID_REQUEST.getErrorMessage());
        }
        SecureRandom sRandom = new SecureRandom();
        byte[] pbeSalt = new byte[32];
        sRandom.nextBytes(pbeSalt);
        SecretKey derivedKey = this.getDerivedKey(userPin, pbeSalt);
        byte[] gcmNonce = new byte[12];
        sRandom.nextBytes(gcmNonce);
        byte[] encryptedData = (byte[])this.cryptoCore.symmetricEncrypt((Object)derivedKey, (Object)dataToEnc.getBytes(), (Object)gcmNonce, (Object)pbeSalt);
        byte[] finalEncryptedData = new byte[encryptedData.length + 32 + 12];
        System.arraycopy(pbeSalt, 0, finalEncryptedData, 0, pbeSalt.length);
        System.arraycopy(gcmNonce, 0, finalEncryptedData, pbeSalt.length, gcmNonce.length);
        System.arraycopy(encryptedData, 0, finalEncryptedData, pbeSalt.length + gcmNonce.length, encryptedData.length);
        CryptoWithPinResponseDto responseDto = new CryptoWithPinResponseDto();
        responseDto.setData(CryptoUtil.encodeToURLSafeBase64((byte[])finalEncryptedData));
        return responseDto;
    }

    @Override
    public CryptoWithPinResponseDto decryptWithPin(CryptoWithPinRequestDto requestDto) {
        LOGGER.info("CryptoManagerSession", "CryptoManagerEncryptWithPin", "CryptoManagerEncryptWithPin", "Request for data decryption with Pin.");
        String dataToDec = requestDto.getData();
        String userPin = requestDto.getUserPin();
        if (!this.cryptomanagerUtil.isDataValid(dataToDec) || !this.cryptomanagerUtil.isDataValid(userPin)) {
            LOGGER.error("CryptoManagerSession", "CryptoManagerEncryptWithPin", "CryptoManagerEncryptWithPin", "Either Data to decrypt or user pin is blank.");
            throw new CryptoManagerSerivceException(CryptomanagerErrorCode.INVALID_REQUEST.getErrorCode(), CryptomanagerErrorCode.INVALID_REQUEST.getErrorMessage());
        }
        byte[] decodedEncryptedData = CryptoUtil.decodeURLSafeBase64((String)dataToDec);
        byte[] pbeSalt = Arrays.copyOfRange(decodedEncryptedData, 0, 32);
        byte[] gcmNonce = Arrays.copyOfRange(decodedEncryptedData, 32, 44);
        byte[] encryptedData = Arrays.copyOfRange(decodedEncryptedData, 44, decodedEncryptedData.length);
        SecretKey derivedKey = this.getDerivedKey(userPin, pbeSalt);
        byte[] decryptedData = (byte[])this.cryptoCore.symmetricDecrypt((Object)derivedKey, (Object)encryptedData, (Object)gcmNonce, (Object)pbeSalt);
        CryptoWithPinResponseDto responseDto = new CryptoWithPinResponseDto();
        responseDto.setData(new String(decryptedData));
        return responseDto;
    }

    private SecretKey getDerivedKey(String userPin, byte[] salt) {
        String derivedKeyHex = (String)this.cryptoCore.hash((Object)userPin.getBytes(), (Object)salt);
        byte[] derivedKey = this.cryptomanagerUtil.hexDecode(derivedKeyHex);
        return new SecretKeySpec(derivedKey, AES_KEY_TYPE);
    }

    @Override
    public JWTCipherResponseDto jwtEncrypt(JWTEncryptRequestDto jwtEncryptRequestDto) {
        LOGGER.info("CryptoManagerSession", this.getClass().getSimpleName(), "Crypto-Manager-JWEEncrypt", "Request for JWE Encryption. Input Application Id:" + jwtEncryptRequestDto.getApplicationId() + ", Reference Id: " + jwtEncryptRequestDto.getReferenceId());
        Certificate encCertificate = null;
        if (this.cryptomanagerUtil.isDataValid(jwtEncryptRequestDto.getX509Certificate())) {
            encCertificate = this.cryptomanagerUtil.convertToCertificate(jwtEncryptRequestDto.getX509Certificate());
        }
        if (Objects.isNull(encCertificate)) {
            this.cryptomanagerUtil.validateKeyIdentifierIds(jwtEncryptRequestDto.getApplicationId(), jwtEncryptRequestDto.getReferenceId());
            encCertificate = this.cryptomanagerUtil.getCertificate(jwtEncryptRequestDto.getApplicationId(), jwtEncryptRequestDto.getReferenceId());
        }
        LOGGER.info("CryptoManagerSession", this.getClass().getSimpleName(), "Crypto-Manager-JWEEncrypt", "Found the cerificate, Validating Encryption Certificate key size.");
        this.cryptomanagerUtil.validateEncKeySize(encCertificate);
        LOGGER.info("CryptoManagerSession", this.getClass().getSimpleName(), "Crypto-Manager-JWEEncrypt", "Key Size validated, validing input data.");
        String dataToEncrypt = jwtEncryptRequestDto.getData();
        this.cryptomanagerUtil.validateEncryptData(dataToEncrypt);
        String decodedDataToEncrypt = new String(CryptoUtil.decodeURLSafeBase64((String)dataToEncrypt));
        this.cryptomanagerUtil.checkForValidJsonData(decodedDataToEncrypt);
        LOGGER.info("CryptoManagerSession", this.getClass().getSimpleName(), "Crypto-Manager-JWEEncrypt", "Input Data validated, proceeding with JWE Encryption.");
        boolean enableDefCompression = this.cryptomanagerUtil.isIncludeAttrsValid(jwtEncryptRequestDto.getEnableDefCompression(), CryptomanagerConstant.DEFAULT_INCLUDES_TRUE);
        boolean includeCertificate = this.cryptomanagerUtil.isIncludeAttrsValid(jwtEncryptRequestDto.getIncludeCertificate(), CryptomanagerConstant.DEFAULT_INCLUDES_FALSE);
        boolean includeCertHash = this.cryptomanagerUtil.isIncludeAttrsValid(jwtEncryptRequestDto.getIncludeCertHash(), CryptomanagerConstant.DEFAULT_INCLUDES_FALSE);
        String certificateUrl = this.cryptomanagerUtil.isDataValid(jwtEncryptRequestDto.getJwkSetUrl()) ? jwtEncryptRequestDto.getJwkSetUrl() : null;
        String jweEncryptedData = this.jwtRsaOaep256AesGcmEncrypt(decodedDataToEncrypt, encCertificate, enableDefCompression, includeCertificate, includeCertHash, certificateUrl);
        JWTCipherResponseDto jwtCipherResponseDto = new JWTCipherResponseDto();
        jwtCipherResponseDto.setData(jweEncryptedData);
        jwtCipherResponseDto.setTimestamp(DateUtils.getUTCCurrentDateTime());
        return jwtCipherResponseDto;
    }

    private String jwtRsaOaep256AesGcmEncrypt(String dataToEncrypt, Certificate certificate, boolean enableDefCompression, boolean includeCertificate, boolean includeCertHash, String certificateUrl) {
        LOGGER.info("CryptoManagerSession", this.getClass().getSimpleName(), "Crypto-Manager-JWEEncrypt", "JWE Encryption Started.");
        JsonWebEncryption jsonWebEncrypt = new JsonWebEncryption();
        jsonWebEncrypt.setHeader("cty", "JWT");
        jsonWebEncrypt.setHeader("typ", "JWT");
        jsonWebEncrypt.setAlgorithmHeaderValue("RSA-OAEP-256");
        jsonWebEncrypt.setEncryptionMethodHeaderParameter("A256GCM");
        jsonWebEncrypt.setKey((Key)certificate.getPublicKey());
        String certThumbprint = CryptoUtil.encodeToURLSafeBase64((byte[])this.cryptomanagerUtil.getCertificateThumbprint(certificate));
        jsonWebEncrypt.setKeyIdHeaderValue(certThumbprint);
        byte[] nonce = this.cryptomanagerUtil.generateRandomBytes(12);
        jsonWebEncrypt.setIv(nonce);
        if (enableDefCompression) {
            jsonWebEncrypt.enableDefaultCompression();
        }
        if (includeCertificate) {
            jsonWebEncrypt.setCertificateChainHeaderValue(new X509Certificate[]{(X509Certificate)certificate});
        }
        if (includeCertHash) {
            jsonWebEncrypt.setX509CertSha256ThumbprintHeaderValue(certThumbprint);
        }
        if (Objects.nonNull(certificateUrl) && !certificateUrl.isEmpty()) {
            jsonWebEncrypt.setHeader("jku", certificateUrl);
        }
        jsonWebEncrypt.setPayload(dataToEncrypt);
        try {
            String encryptedData = jsonWebEncrypt.getCompactSerialization();
            LOGGER.info("CryptoManagerSession", this.getClass().getSimpleName(), "Crypto-Manager-JWEEncrypt", "JWE Encryption Completed.");
            return encryptedData;
        }
        catch (JoseException e) {
            LOGGER.error("CryptoManagerSession", this.getClass().getSimpleName(), "Crypto-Manager-JWEEncrypt", "Error occurred while Json Web Encryption Data.");
            throw new CryptoManagerSerivceException(CryptomanagerErrorCode.JWE_ENCRYPTION_INTERNAL_ERROR.getErrorCode(), CryptomanagerErrorCode.JWE_ENCRYPTION_INTERNAL_ERROR.getErrorMessage(), e);
        }
    }

    @Override
    public JWTCipherResponseDto jwtDecrypt(JWTDecryptRequestDto jwtDecryptRequestDto) {
        LOGGER.info("CryptoManagerSession", this.getClass().getSimpleName(), "Crypto-Manager-JWEDecrypt", "Request for JWE Decryption. Input Application Id:" + jwtDecryptRequestDto.getApplicationId() + ", Reference Id: " + jwtDecryptRequestDto.getReferenceId());
        this.cryptomanagerUtil.validateKeyIdentifierIds(jwtDecryptRequestDto.getApplicationId(), jwtDecryptRequestDto.getReferenceId());
        LOGGER.info("CryptoManagerSession", this.getClass().getSimpleName(), "Crypto-Manager-JWEDecrypt", "Application Id and Reference Id validation completed, Validating Input Enc Data.");
        String dataToDecrypt = jwtDecryptRequestDto.getEncData();
        if (!this.cryptomanagerUtil.isDataValid(dataToDecrypt)) {
            LOGGER.error("CryptoManagerSession", this.getClass().getSimpleName(), "Crypto-Manager-JWEDecrypt", "Provided Data to Decrypt is invalid.");
            throw new CryptoManagerSerivceException(CryptomanagerErrorCode.INVALID_REQUEST.getErrorCode(), CryptomanagerErrorCode.INVALID_REQUEST.getErrorMessage());
        }
        LOGGER.info("CryptoManagerSession", this.getClass().getSimpleName(), "Crypto-Manager-JWEDecrypt", "Input Enc Data validated, proceeding with JWE Decryption.");
        JsonWebEncryption jsonWebDecrypt = new JsonWebEncryption();
        this.setEncryptedData(jsonWebDecrypt, dataToDecrypt);
        String keyId = jsonWebDecrypt.getKeyIdHeaderValue();
        String certThumbprintHex = Hex.toHexString((byte[])CryptoUtil.decodeURLSafeBase64((String)keyId)).toUpperCase();
        LOGGER.info("CryptoManagerSession", this.getClass().getSimpleName(), "Crypto-Manager-JWEDecrypt", "Fetched KeyId(CertificateThumbprint) from JWT Header, TP Value: " + certThumbprintHex);
        String applicationId = jwtDecryptRequestDto.getApplicationId();
        String referenceId = jwtDecryptRequestDto.getReferenceId();
        KeyStore dbKeyStoreObj = this.privateKeyDecryptorHelper.getDBKeyStoreData(certThumbprintHex, applicationId, referenceId);
        Object[] keys = this.privateKeyDecryptorHelper.getKeyObjects(dbKeyStoreObj, false);
        PrivateKey privateKey = (PrivateKey)keys[0];
        LOGGER.info("CryptoManagerSession", this.getClass().getSimpleName(), "Crypto-Manager-JWEDecrypt", "Private Key Retrival completed, processing with JWE Decryption.");
        String decryptedData = this.getDecryptedData(jsonWebDecrypt, privateKey);
        JWTCipherResponseDto jwtCipherResponseDto = new JWTCipherResponseDto();
        jwtCipherResponseDto.setData(CryptoUtil.encodeToURLSafeBase64((byte[])decryptedData.getBytes()));
        jwtCipherResponseDto.setTimestamp(DateUtils.getUTCCurrentDateTime());
        return jwtCipherResponseDto;
    }

    private void setEncryptedData(JsonWebEncryption jsonWebDecrypt, String dataToDecrypt) {
        try {
            LOGGER.info("CryptoManagerSession", this.getClass().getSimpleName(), "Crypto-Manager-JWEDecrypt", "Setting Encrypted Data for decryption.");
            jsonWebDecrypt.setCompactSerialization(dataToDecrypt);
        }
        catch (JoseException e) {
            LOGGER.error("CryptoManagerSession", this.getClass().getSimpleName(), "Crypto-Manager-JWEEncrypt", "Error occurred while Json Web Decryption Data.");
            throw new CryptoManagerSerivceException(CryptomanagerErrorCode.JWE_DECRYPTION_INTERNAL_ERROR.getErrorCode(), CryptomanagerErrorCode.JWE_DECRYPTION_INTERNAL_ERROR.getErrorMessage(), e);
        }
    }

    private String getDecryptedData(JsonWebEncryption jsonWebDecrypt, PrivateKey privateKey) {
        try {
            jsonWebDecrypt.setKey((Key)privateKey);
            LOGGER.info("CryptoManagerSession", this.getClass().getSimpleName(), "Crypto-Manager-JWEDecrypt", "Decrypting input encrypted Data.");
            String decryptedData = jsonWebDecrypt.getPlaintextString();
            this.keymanagerUtil.destoryKey(privateKey);
            return decryptedData;
        }
        catch (JoseException e) {
            LOGGER.error("CryptoManagerSession", this.getClass().getSimpleName(), "Crypto-Manager-JWEEncrypt", "Error occurred while Json Web Decryption Data.");
            throw new CryptoManagerSerivceException(CryptomanagerErrorCode.JWE_DECRYPTION_INTERNAL_ERROR.getErrorCode(), CryptomanagerErrorCode.JWE_DECRYPTION_INTERNAL_ERROR.getErrorMessage(), e);
        }
    }

    @Override
    public Argon2GenerateHashResponseDto generateArgon2Hash(Argon2GenerateHashRequestDto argon2GenHashRequestDto) {
        LOGGER.info("CryptoManagerSession", this.getClass().getSimpleName(), "Crypto-Manager-Gen-Argon2-Hash", "Request for Argon2 Hash Geneation.");
        this.cryptomanagerUtil.validateInputData(argon2GenHashRequestDto.getInputData());
        String inputData = argon2GenHashRequestDto.getInputData();
        String saltData = argon2GenHashRequestDto.getSalt();
        byte[] saltBytes = null;
        if (!this.cryptomanagerUtil.isDataValid(saltData)) {
            SecretKey aesKey = (SecretKey)this.saltGenParamsCache.get((Object)"cacheAESKey");
            AtomicLong intCounter = (AtomicLong)this.saltGenParamsCache.get((Object)"cacheIntCounter");
            long saltInput = intCounter.getAndIncrement();
            this.saltGenParamsCache.put((Object)"cacheIntCounter", (Object)intCounter);
            saltBytes = this.getSaltBytes(this.getLongBytes(saltInput), aesKey);
            saltData = CryptoUtil.encodeToURLSafeBase64((byte[])saltBytes);
        } else {
            saltBytes = CryptoUtil.decodeURLSafeBase64((String)saltData);
        }
        LOGGER.info("CryptoManagerSession", this.getClass().getSimpleName(), "Crypto-Manager-Gen-Argon2-Hash", "InputData is valid and salt bytes generated.");
        Argon2Advanced argon2Advanced = Argon2Factory.createAdvanced((Argon2Factory.Argon2Types)Argon2Factory.Argon2Types.ARGON2id);
        char[] inputDataCharArr = inputData.toCharArray();
        byte[] argon2Hash = argon2Advanced.rawHash(this.argon2Iterations, this.argon2Memory, this.argon2Parallelism, inputDataCharArr, saltBytes);
        String argon2HashStr = CryptoUtil.encodeToURLSafeBase64((byte[])argon2Hash);
        inputDataCharArr = null;
        LOGGER.info("CryptoManagerSession", this.getClass().getSimpleName(), "Crypto-Manager-Gen-Argon2-Hash", "Argon to hash generation done.");
        Argon2GenerateHashResponseDto hashResponseDto = new Argon2GenerateHashResponseDto();
        hashResponseDto.setHashValue(argon2HashStr);
        hashResponseDto.setSalt(saltData);
        return hashResponseDto;
    }

    private byte[] getLongBytes(long value) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(value);
        return buffer.array();
    }

    private byte[] getSaltBytes(byte[] randomBytes, SecretKey aesKey) {
        try {
            Cipher cipher = Cipher.getInstance(this.AES_GCM_ALGO);
            cipher.init(1, aesKey);
            return cipher.doFinal(randomBytes, 0, randomBytes.length);
        }
        catch (IllegalArgumentException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            LOGGER.error("CryptoManagerSession", new Object[]{this.getClass().getSimpleName(), "Crypto-Manager-Gen-Argon2-Hash", "Error generation of random salt.", e});
            LOGGER.info("CryptoManagerSession", this.getClass().getSimpleName(), "Crypto-Manager-Gen-Argon2-Hash", "Generating Random Salt using Secure Random because encrypted random bytes failed.");
            if (secureRandom == null) {
                secureRandom = new SecureRandom();
            }
            byte[] bytes = new byte[32];
            secureRandom.nextBytes(bytes);
            return bytes;
        }
    }
}

