/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.cryptomanager.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotBlank;
import lombok.Generated;

@ApiModel(description="Model representing a Crypto-Manager-JWT Encrypt Request")
public class JWTEncryptRequestDto {
    @ApiModelProperty(notes="Application id of component", example="REGISTRATION", required=true)
    private String applicationId;
    @ApiModelProperty(notes="Refrence Id", example="REF01")
    private String referenceId;
    @ApiModelProperty(notes="Data in BASE64 encoding to encrypt/decrypt", required=true)
    @NotBlank(message="should not be null or empty")
    private @NotBlank(message="should not be null or empty") String data;
    @ApiModelProperty(notes="flag to enable data compression before encryption.", example="false", required=false)
    private Boolean enableDefCompression;
    @ApiModelProperty(notes="Flag to include certificate in JWT Encryption Header.", example="false", required=false)
    private Boolean includeCertificate;
    @ApiModelProperty(notes="Flag to include certificate hash(sha256) in JWT Encryption Header.", example="false", required=false)
    private Boolean includeCertHash;
    @ApiModelProperty(notes="JWK Set URL to include in JWT Encryption Header.", example="false", required=false)
    private String jwkSetUrl;
    @ApiModelProperty(notes="Certificate to be used for JWT Encryption.", example="false", required=false)
    private String x509Certificate;

    public String toString() {
        return "JWTEncryptRequestDto [applicationId=" + this.applicationId + ", referenceId=" + this.referenceId + ", enableCompression=" + this.enableDefCompression + "]";
    }

    @Generated
    public String getApplicationId() {
        return this.applicationId;
    }

    @Generated
    public String getReferenceId() {
        return this.referenceId;
    }

    @Generated
    public String getData() {
        return this.data;
    }

    @Generated
    public Boolean getEnableDefCompression() {
        return this.enableDefCompression;
    }

    @Generated
    public Boolean getIncludeCertificate() {
        return this.includeCertificate;
    }

    @Generated
    public Boolean getIncludeCertHash() {
        return this.includeCertHash;
    }

    @Generated
    public String getJwkSetUrl() {
        return this.jwkSetUrl;
    }

    @Generated
    public String getX509Certificate() {
        return this.x509Certificate;
    }

    @Generated
    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    @Generated
    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    @Generated
    public void setData(String data) {
        this.data = data;
    }

    @Generated
    public void setEnableDefCompression(Boolean enableDefCompression) {
        this.enableDefCompression = enableDefCompression;
    }

    @Generated
    public void setIncludeCertificate(Boolean includeCertificate) {
        this.includeCertificate = includeCertificate;
    }

    @Generated
    public void setIncludeCertHash(Boolean includeCertHash) {
        this.includeCertHash = includeCertHash;
    }

    @Generated
    public void setJwkSetUrl(String jwkSetUrl) {
        this.jwkSetUrl = jwkSetUrl;
    }

    @Generated
    public void setX509Certificate(String x509Certificate) {
        this.x509Certificate = x509Certificate;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JWTEncryptRequestDto)) {
            return false;
        }
        JWTEncryptRequestDto other = (JWTEncryptRequestDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$applicationId = this.getApplicationId();
        String other$applicationId = other.getApplicationId();
        if (this$applicationId == null ? other$applicationId != null : !this$applicationId.equals(other$applicationId)) {
            return false;
        }
        String this$referenceId = this.getReferenceId();
        String other$referenceId = other.getReferenceId();
        if (this$referenceId == null ? other$referenceId != null : !this$referenceId.equals(other$referenceId)) {
            return false;
        }
        String this$data = this.getData();
        String other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        Boolean this$enableDefCompression = this.getEnableDefCompression();
        Boolean other$enableDefCompression = other.getEnableDefCompression();
        if (this$enableDefCompression == null ? other$enableDefCompression != null : !((Object)this$enableDefCompression).equals(other$enableDefCompression)) {
            return false;
        }
        Boolean this$includeCertificate = this.getIncludeCertificate();
        Boolean other$includeCertificate = other.getIncludeCertificate();
        if (this$includeCertificate == null ? other$includeCertificate != null : !((Object)this$includeCertificate).equals(other$includeCertificate)) {
            return false;
        }
        Boolean this$includeCertHash = this.getIncludeCertHash();
        Boolean other$includeCertHash = other.getIncludeCertHash();
        if (this$includeCertHash == null ? other$includeCertHash != null : !((Object)this$includeCertHash).equals(other$includeCertHash)) {
            return false;
        }
        String this$jwkSetUrl = this.getJwkSetUrl();
        String other$jwkSetUrl = other.getJwkSetUrl();
        if (this$jwkSetUrl == null ? other$jwkSetUrl != null : !this$jwkSetUrl.equals(other$jwkSetUrl)) {
            return false;
        }
        String this$x509Certificate = this.getX509Certificate();
        String other$x509Certificate = other.getX509Certificate();
        return !(this$x509Certificate == null ? other$x509Certificate != null : !this$x509Certificate.equals(other$x509Certificate));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof JWTEncryptRequestDto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $applicationId = this.getApplicationId();
        result = result * 59 + ($applicationId == null ? 43 : $applicationId.hashCode());
        String $referenceId = this.getReferenceId();
        result = result * 59 + ($referenceId == null ? 43 : $referenceId.hashCode());
        String $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        Boolean $enableDefCompression = this.getEnableDefCompression();
        result = result * 59 + ($enableDefCompression == null ? 43 : ((Object)$enableDefCompression).hashCode());
        Boolean $includeCertificate = this.getIncludeCertificate();
        result = result * 59 + ($includeCertificate == null ? 43 : ((Object)$includeCertificate).hashCode());
        Boolean $includeCertHash = this.getIncludeCertHash();
        result = result * 59 + ($includeCertHash == null ? 43 : ((Object)$includeCertHash).hashCode());
        String $jwkSetUrl = this.getJwkSetUrl();
        result = result * 59 + ($jwkSetUrl == null ? 43 : $jwkSetUrl.hashCode());
        String $x509Certificate = this.getX509Certificate();
        result = result * 59 + ($x509Certificate == null ? 43 : $x509Certificate.hashCode());
        return result;
    }

    @Generated
    public JWTEncryptRequestDto(String applicationId, String referenceId, String data, Boolean enableDefCompression, Boolean includeCertificate, Boolean includeCertHash, String jwkSetUrl, String x509Certificate) {
        this.applicationId = applicationId;
        this.referenceId = referenceId;
        this.data = data;
        this.enableDefCompression = enableDefCompression;
        this.includeCertificate = includeCertificate;
        this.includeCertHash = includeCertHash;
        this.jwkSetUrl = jwkSetUrl;
        this.x509Certificate = x509Certificate;
    }

    @Generated
    public JWTEncryptRequestDto() {
    }
}

