/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.kernel.cryptomanager.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotBlank;
import lombok.Generated;

@ApiModel(description="Model representing a to generate Argon2 Hash Request")
public class Argon2GenerateHashRequestDto {
    @ApiModelProperty(notes="Input data for hash generation.", example="SOME-BASE64-ENCODED-STRING", required=true)
    @NotBlank(message="should not be null or empty")
    private @NotBlank(message="should not be null or empty") String inputData;
    @ApiModelProperty(notes="Salt value to be included in hash generation", example="RANDOM-BYTES-DATA")
    private String salt;

    @Generated
    public String getInputData() {
        return this.inputData;
    }

    @Generated
    public String getSalt() {
        return this.salt;
    }

    @Generated
    public void setInputData(String inputData) {
        this.inputData = inputData;
    }

    @Generated
    public void setSalt(String salt) {
        this.salt = salt;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Argon2GenerateHashRequestDto)) {
            return false;
        }
        Argon2GenerateHashRequestDto other = (Argon2GenerateHashRequestDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$inputData = this.getInputData();
        String other$inputData = other.getInputData();
        if (this$inputData == null ? other$inputData != null : !this$inputData.equals(other$inputData)) {
            return false;
        }
        String this$salt = this.getSalt();
        String other$salt = other.getSalt();
        return !(this$salt == null ? other$salt != null : !this$salt.equals(other$salt));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Argon2GenerateHashRequestDto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $inputData = this.getInputData();
        result = result * 59 + ($inputData == null ? 43 : $inputData.hashCode());
        String $salt = this.getSalt();
        result = result * 59 + ($salt == null ? 43 : $salt.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Argon2GenerateHashRequestDto(inputData=" + this.getInputData() + ", salt=" + this.getSalt() + ")";
    }

    @Generated
    public Argon2GenerateHashRequestDto(String inputData, String salt) {
        this.inputData = inputData;
        this.salt = salt;
    }

    @Generated
    public Argon2GenerateHashRequestDto() {
    }
}

